/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Payroll;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;

public class Doc_HRProcess
extends Doc {
    public MHRProcess process = null;
    public static final String DOCTYPE_Payroll = "HRP";

    public Doc_HRProcess(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MHRProcess.class, rs, DOCTYPE_Payroll, trxName);
    }

    protected String loadDocumentDetails() {
        this.process = (MHRProcess)this.getPO();
        this.setDateDoc(this.getDateAcct());
        this.p_lines = this.loadLines(this.process);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MHRProcess process) {
        ArrayList<DocLine_Payroll> list = new ArrayList<DocLine_Payroll>();
        MHRMovement[] lines = process.getLines(true);
        int i = 0;
        while (i < lines.length) {
            MHRMovement line = lines[i];
            DocLine_Payroll docLine = new DocLine_Payroll(line, this);
            this.log.fine(docLine.toString());
            list.add(docLine);
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact((Doc)this, as, "A");
        String sql = "SELECT m.HR_Concept_id, MAX(c.Name) As Name, SUM(m.Amount) As Amount, MAX(c.AccountSign) As AccountSign,  MAX(CA.IsBalancing) As IsBalancing, e.AD_Org_ID As AD_Org_ID, COALESCE(m.C_Activity_ID, d.C_Activity_ID) As C_Activity_ID, bp.C_BPartner_ID FROM HR_Movement m INNER JOIN HR_Concept_Acct ca ON (ca.HR_Concept_ID=m.HR_Concept_ID AND ca.IsActive = 'Y') INNER JOIN HR_Concept      c  ON (c.HR_Concept_ID=m.HR_Concept_ID AND c.IsActive = 'Y') INNER JOIN C_BPartner      bp ON (bp.C_BPartner_ID = m.C_BPartner_ID) INNER JOIN HR_Employee\t e  ON (bp.C_BPartner_ID=e.C_BPartner_ID) INNER JOIN HR_Department   d  ON (d.HR_Department_ID=e.HR_Department_ID) WHERE m.HR_Process_ID=? AND (m.Qty <> 0 OR m.Amount <> 0) AND c.AccountSign != 'N' GROUP BY m.HR_Concept_ID,e.AD_Org_ID,COALESCE(m.C_Activity_ID, d.C_Activity_ID),bp.C_BPartner_ID ORDER BY e.AD_Org_ID,COALESCE(m.C_Activity_ID, d.C_Activity_ID),bp.C_BPartner_ID";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            try {
                int C_Charge_ID;
                BigDecimal totalamt = Env.ZERO;
                pstmt = DB.prepareStatement((String)"SELECT m.HR_Concept_id, MAX(c.Name) As Name, SUM(m.Amount) As Amount, MAX(c.AccountSign) As AccountSign,  MAX(CA.IsBalancing) As IsBalancing, e.AD_Org_ID As AD_Org_ID, COALESCE(m.C_Activity_ID, d.C_Activity_ID) As C_Activity_ID, bp.C_BPartner_ID FROM HR_Movement m INNER JOIN HR_Concept_Acct ca ON (ca.HR_Concept_ID=m.HR_Concept_ID AND ca.IsActive = 'Y') INNER JOIN HR_Concept      c  ON (c.HR_Concept_ID=m.HR_Concept_ID AND c.IsActive = 'Y') INNER JOIN C_BPartner      bp ON (bp.C_BPartner_ID = m.C_BPartner_ID) INNER JOIN HR_Employee\t e  ON (bp.C_BPartner_ID=e.C_BPartner_ID) INNER JOIN HR_Department   d  ON (d.HR_Department_ID=e.HR_Department_ID) WHERE m.HR_Process_ID=? AND (m.Qty <> 0 OR m.Amount <> 0) AND c.AccountSign != 'N' GROUP BY m.HR_Concept_ID,e.AD_Org_ID,COALESCE(m.C_Activity_ID, d.C_Activity_ID),bp.C_BPartner_ID ORDER BY e.AD_Org_ID,COALESCE(m.C_Activity_ID, d.C_Activity_ID),bp.C_BPartner_ID", (String)this.getTrxName());
                pstmt.setInt(1, this.process.getHR_Process_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    FactLine debit;
                    MAccount accountBPD;
                    int HR_Concept_ID = rs.getInt("HR_Concept_ID");
                    BigDecimal sumAmount = rs.getBigDecimal("Amount");
                    sumAmount = sumAmount.setScale(as.getStdPrecision(), 4);
                    String AccountSign = rs.getString("AccountSign");
                    boolean isBalancing = "Y".equals(rs.getString("IsBalancing"));
                    int AD_OrgTrx_ID = rs.getInt("AD_Org_ID");
                    int C_Activity_ID = rs.getInt("C_Activity_ID");
                    int C_BPartner_ID = rs.getInt("C_BPartner_ID");
                    if (AccountSign == null || AccountSign.length() <= 0 || !"D".equals(AccountSign) && !"C".equals(AccountSign)) continue;
                    if (isBalancing) {
                        accountBPD = MAccount.get((Properties)this.getCtx(), (int)this.getAccountBalancing(as.getC_AcctSchema_ID(), HR_Concept_ID, "D"));
                        debit = fact.createLine(null, accountBPD, as.getC_Currency_ID(), sumAmount, null);
                        debit.setAD_OrgTrx_ID(AD_OrgTrx_ID);
                        debit.setC_Activity_ID(C_Activity_ID);
                        debit.setC_BPartner_ID(C_BPartner_ID);
                        debit.saveEx();
                        MAccount accountBPC = MAccount.get((Properties)this.getCtx(), (int)this.getAccountBalancing(as.getC_AcctSchema_ID(), HR_Concept_ID, "C"));
                        FactLine credit = fact.createLine(null, accountBPC, as.getC_Currency_ID(), null, sumAmount);
                        credit.setAD_OrgTrx_ID(AD_OrgTrx_ID);
                        credit.setC_Activity_ID(C_Activity_ID);
                        credit.setC_BPartner_ID(C_BPartner_ID);
                        credit.saveEx();
                        continue;
                    }
                    if ("D".equals(AccountSign)) {
                        accountBPD = MAccount.get((Properties)this.getCtx(), (int)this.getAccountBalancing(as.getC_AcctSchema_ID(), HR_Concept_ID, "D"));
                        debit = fact.createLine(null, accountBPD, as.getC_Currency_ID(), sumAmount, null);
                        debit.setAD_OrgTrx_ID(AD_OrgTrx_ID);
                        debit.setC_Activity_ID(C_Activity_ID);
                        debit.setC_BPartner_ID(C_BPartner_ID);
                        debit.saveEx();
                        sumAmount = sumAmount.abs();
                    } else if ("C".equals(AccountSign)) {
                        MAccount accountBPC = MAccount.get((Properties)this.getCtx(), (int)this.getAccountBalancing(as.getC_AcctSchema_ID(), HR_Concept_ID, "C"));
                        FactLine credit = fact.createLine(null, accountBPC, as.getC_Currency_ID(), null, sumAmount);
                        credit.setAD_OrgTrx_ID(AD_OrgTrx_ID);
                        credit.setC_Activity_ID(C_Activity_ID);
                        credit.setC_BPartner_ID(C_BPartner_ID);
                        credit.saveEx();
                        sumAmount = sumAmount.abs().negate();
                    }
                    totalamt = totalamt.add(sumAmount);
                }
                if (totalamt.signum() != 0 && (C_Charge_ID = this.process.getHR_Payroll().getC_Charge_ID()) > 0) {
                    MAccount acct = MCharge.getAccount((int)C_Charge_ID, (MAcctSchema)as, (BigDecimal)totalamt);
                    FactLine regTotal = null;
                    regTotal = totalamt.signum() > 0 ? fact.createLine(null, acct, as.getC_Currency_ID(), null, totalamt) : fact.createLine(null, acct, as.getC_Currency_ID(), totalamt, null);
                    regTotal.setAD_Org_ID(this.getAD_Org_ID());
                    regTotal.saveEx();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "SELECT m.HR_Concept_id, MAX(c.Name) As Name, SUM(m.Amount) As Amount, MAX(c.AccountSign) As AccountSign,  MAX(CA.IsBalancing) As IsBalancing, e.AD_Org_ID As AD_Org_ID, COALESCE(m.C_Activity_ID, d.C_Activity_ID) As C_Activity_ID, bp.C_BPartner_ID FROM HR_Movement m INNER JOIN HR_Concept_Acct ca ON (ca.HR_Concept_ID=m.HR_Concept_ID AND ca.IsActive = 'Y') INNER JOIN HR_Concept      c  ON (c.HR_Concept_ID=m.HR_Concept_ID AND c.IsActive = 'Y') INNER JOIN C_BPartner      bp ON (bp.C_BPartner_ID = m.C_BPartner_ID) INNER JOIN HR_Employee\t e  ON (bp.C_BPartner_ID=e.C_BPartner_ID) INNER JOIN HR_Department   d  ON (d.HR_Department_ID=e.HR_Department_ID) WHERE m.HR_Process_ID=? AND (m.Qty <> 0 OR m.Amount <> 0) AND c.AccountSign != 'N' GROUP BY m.HR_Concept_ID,e.AD_Org_ID,COALESCE(m.C_Activity_ID, d.C_Activity_ID),bp.C_BPartner_ID ORDER BY e.AD_Org_ID,COALESCE(m.C_Activity_ID, d.C_Activity_ID),bp.C_BPartner_ID", (Throwable)e);
                this.p_Error = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                pstmt = null;
                rs = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        pstmt = null;
        rs = null;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private int getAccountBalancing(int AcctSchema_ID, int HR_Concept_ID, String AccountSign) {
        String field;
        if ("D".equals(AccountSign)) {
            field = "HR_Expense_Acct";
        } else if ("C".equals(AccountSign)) {
            field = "HR_Revenue_Acct";
        } else {
            throw new IllegalArgumentException("Invalid value for AccountSign=" + AccountSign);
        }
        String sqlAccount = "SELECT " + field + " FROM HR_Concept_Acct" + " WHERE HR_Concept_ID=? AND C_AcctSchema_ID=?";
        int Account_ID = DB.getSQLValueEx((String)this.getTrxName(), (String)sqlAccount, (Object[])new Object[]{HR_Concept_ID, AcctSchema_ID});
        return Account_ID;
    }
}

