/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.data.JRHibernateAbstractDataSource;
import net.sf.jasperreports.engine.data.JRHibernateIterateDataSource;
import net.sf.jasperreports.engine.data.JRHibernateListDataSource;
import net.sf.jasperreports.engine.data.JRHibernateScrollDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class JRHibernateQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRHibernateQueryExecuter.class);
    private static final Map hibernateTypeMap = new HashMap();
    private final Integer reportMaxCount;
    private Session session = (Session)this.getParameterValue("HIBERNATE_SESSION");
    private Query query;
    private boolean queryRunning;
    private ScrollableResults scrollableResults;
    private boolean isClearCache;

    public JRHibernateQueryExecuter(JRDataset dataset, Map parameters) {
        super(dataset, parameters);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        this.isClearCache = JRProperties.getBooleanProperty(dataset, "net.sf.jasperreports.hql.clear.cache", false);
        if (this.session == null) {
            log.warn((Object)"The supplied org.hibernate.Session object is null.");
        }
        this.parseQuery();
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource datasource = null;
        String queryString = this.getQueryString();
        if (this.session != null && queryString != null && queryString.trim().length() > 0) {
            this.createQuery(queryString);
            datasource = this.createResultDatasource();
        }
        return datasource;
    }

    protected JRDataSource createResultDatasource() {
        JRHibernateAbstractDataSource resDatasource;
        String runType = JRProperties.getProperty(this.dataset, "net.sf.jasperreports.hql.query.run.type");
        boolean useFieldDescriptions = JRProperties.getBooleanProperty(this.dataset, "net.sf.jasperreports.hql.field.mapping.descriptions", true);
        if (runType == null || runType.equals("list")) {
            try {
                int pageSize = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.hql.query.list.page.size", 0);
                resDatasource = new JRHibernateListDataSource(this, useFieldDescriptions, pageSize);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("The net.sf.jasperreports.hql.query.list.page.size property must be numerical.", e);
            }
        } else if (runType.equals("iterate")) {
            resDatasource = new JRHibernateIterateDataSource(this, useFieldDescriptions);
        } else if (runType.equals("scroll")) {
            resDatasource = new JRHibernateScrollDataSource(this, useFieldDescriptions);
        } else {
            throw new JRRuntimeException("Unknown value for the net.sf.jasperreports.hql.query.run.type property.  Possible values are list, iterate and scroll.");
        }
        return resDatasource;
    }

    protected synchronized void createQuery(String queryString) {
        Object filterCollection;
        if (log.isDebugEnabled()) {
            log.debug((Object)("HQL query: " + queryString));
        }
        this.query = (filterCollection = this.getParameterValue("HIBERNATE_FILTER_COLLECTION")) == null ? this.session.createQuery(queryString) : this.session.createFilter(filterCollection, queryString);
        this.query.setReadOnly(true);
        int fetchSize = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
        if (fetchSize != 0) {
            this.query.setFetchSize(fetchSize);
        }
        this.setParameters();
    }

    protected void setParameters() {
        List parameterNames = this.getCollectedParameterNames();
        if (!parameterNames.isEmpty()) {
            HashSet<String> namesSet = new HashSet<String>();
            for (String parameterName : parameterNames) {
                if (!namesSet.add(parameterName)) continue;
                JRValueParameter parameter = this.getValueParameter(parameterName);
                this.setParameter(parameter);
            }
        }
    }

    protected void setParameter(JRValueParameter parameter) {
        Type type;
        String hqlParamName = this.getHqlParameterName(parameter.getName());
        Class clazz = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameter " + hqlParamName + " of type " + clazz.getName() + ": " + parameterValue));
        }
        if ((type = (Type)hibernateTypeMap.get(clazz)) != null) {
            this.query.setParameter(hqlParamName, parameterValue, type);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.query.setParameterList(hqlParamName, (Collection)parameterValue);
        } else if (this.session.getSessionFactory().getClassMetadata(clazz) != null) {
            this.query.setEntity(hqlParamName, parameterValue);
        } else {
            this.query.setParameter(hqlParamName, parameterValue);
        }
    }

    public synchronized void close() {
        this.closeScrollableResults();
        this.query = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeScrollableResults() {
        if (this.scrollableResults != null) {
            try {
                this.scrollableResults.close();
            }
            finally {
                this.scrollableResults = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.queryRunning) {
            this.session.cancelQuery();
            return true;
        }
        return false;
    }

    protected String getParameterReplacement(String parameterName) {
        return ':' + this.getHqlParameterName(parameterName);
    }

    protected String getHqlParameterName(String parameterName) {
        return '_' + JRStringUtil.getJavaIdentifier(parameterName);
    }

    public Type[] getReturnTypes() {
        return this.query.getReturnTypes();
    }

    public String[] getReturnAliases() {
        return this.query.getReturnAliases();
    }

    public JRDataset getDataset() {
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            List list = this.query.list();
            return list;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    protected synchronized void setQueryRunning(boolean queryRunning) {
        this.queryRunning = queryRunning;
    }

    private void setMaxCount() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
    }

    public List list(int firstIndex, int resultCount) {
        if (this.reportMaxCount != null && firstIndex + resultCount > this.reportMaxCount) {
            resultCount = this.reportMaxCount - firstIndex;
        }
        this.query.setFirstResult(firstIndex);
        this.query.setMaxResults(resultCount);
        if (this.isClearCache) {
            this.clearCache();
        }
        return this.query.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            Iterator iterator = this.query.iterate();
            return iterator;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            this.scrollableResults = this.query.scroll(ScrollMode.FORWARD_ONLY);
        }
        finally {
            this.setQueryRunning(false);
        }
        return this.scrollableResults;
    }

    public void clearCache() {
        this.session.flush();
        this.session.clear();
    }

    static {
        hibernateTypeMap.put(Boolean.class, Hibernate.BOOLEAN);
        hibernateTypeMap.put(Byte.class, Hibernate.BYTE);
        hibernateTypeMap.put(Double.class, Hibernate.DOUBLE);
        hibernateTypeMap.put(Float.class, Hibernate.FLOAT);
        hibernateTypeMap.put(Integer.class, Hibernate.INTEGER);
        hibernateTypeMap.put(Long.class, Hibernate.LONG);
        hibernateTypeMap.put(Short.class, Hibernate.SHORT);
        hibernateTypeMap.put(BigDecimal.class, Hibernate.BIG_DECIMAL);
        hibernateTypeMap.put(BigInteger.class, Hibernate.BIG_INTEGER);
        hibernateTypeMap.put(Character.class, Hibernate.CHARACTER);
        hibernateTypeMap.put(String.class, Hibernate.STRING);
        hibernateTypeMap.put(Date.class, Hibernate.DATE);
        hibernateTypeMap.put(Timestamp.class, Hibernate.TIMESTAMP);
        hibernateTypeMap.put(Time.class, Hibernate.TIME);
    }
}

