/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.components.list.BaseListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardListComponent
implements Serializable,
ListComponent,
JRChangeEventsSupport {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PRINT_ORDER = "printOrder";
    public static final String PROPERTY_IGNORE_WIDTH = "ignoreWidth";
    private JRDatasetRun datasetRun;
    private ListContents contents;
    private PrintOrderEnum printOrderValue;
    private Boolean ignoreWidth;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private Byte printOrder;

    public StandardListComponent() {
    }

    public StandardListComponent(ListComponent list, JRBaseObjectFactory baseFactory) {
        this.datasetRun = baseFactory.getDatasetRun(list.getDatasetRun());
        this.contents = new BaseListContents(list.getContents(), baseFactory);
        this.printOrderValue = list.getPrintOrderValue();
        this.ignoreWidth = list.getIgnoreWidth();
    }

    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void setDatasetRun(JRDatasetRun datasetRun) {
        this.datasetRun = datasetRun;
    }

    public ListContents getContents() {
        return this.contents;
    }

    public void setContents(ListContents contents) {
        this.contents = contents;
    }

    public Object clone() {
        try {
            StandardListComponent clone = (StandardListComponent)super.clone();
            clone.datasetRun = (JRDatasetRun)JRCloneUtils.nullSafeClone(this.datasetRun);
            clone.contents = (ListContents)JRCloneUtils.nullSafeClone(this.contents);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    public Byte getPrintOrder() {
        return this.getPrintOrderValue().getValueByte();
    }

    public PrintOrderEnum getPrintOrderValue() {
        return this.printOrderValue;
    }

    public void setPrintOrder(Byte printOrder) {
        this.setPrintOrderValue(PrintOrderEnum.getByValue(printOrder));
    }

    public void setPrintOrder(byte printOrder) {
        this.setPrintOrderValue(PrintOrderEnum.getByValue(printOrder));
    }

    public void setPrintOrderValue(PrintOrderEnum printOrderValue) {
        PrintOrderEnum old = this.printOrderValue;
        this.printOrderValue = printOrderValue;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_ORDER, old, this.printOrderValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        StandardListComponent standardListComponent = this;
        synchronized (standardListComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public Boolean getIgnoreWidth() {
        return this.ignoreWidth;
    }

    public void setIgnoreWidth(Boolean ignoreWidth) {
        Boolean old = this.ignoreWidth;
        this.ignoreWidth = ignoreWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_IGNORE_WIDTH, old, this.ignoreWidth);
    }

    public void setIgnoreWidth(boolean ignoreWidth) {
        this.setIgnoreWidth((Boolean)ignoreWidth);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.printOrderValue = PrintOrderEnum.getByValue(this.printOrder);
        }
    }
}

