/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ejb.LocalHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulLocalHomeProxy;
import org.jboss.ejb3.stateful.StatefulLocalProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulLocalProxyFactory
extends BaseStatefulProxyFactory {
    private static final Logger log = Logger.getLogger(StatefulLocalProxyFactory.class);
    private VMID vmid = Ejb3Registry.getVMID();

    protected Class<?>[] getInterfaces() {
        StatefulContainer statefulContainer = (StatefulContainer)this.getContainer();
        LocalHome localHome = (LocalHome)statefulContainer.resolveAnnotation(LocalHome.class);
        boolean bindTogether = false;
        if (localHome != null && this.bindHomeAndBusinessTogether(statefulContainer)) {
            bindTogether = true;
        }
        ArrayList<Class> localInterfaces = new ArrayList<Class>();
        localInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getLocalInterfaces(statefulContainer)));
        localInterfaces.add(JBossProxy.class);
        if (bindTogether) {
            localInterfaces.add(localHome.value());
        }
        return localInterfaces.toArray(new Class[0]);
    }

    protected boolean bindHomeAndBusinessTogether(StatefulContainer container) {
        return ProxyFactoryHelper.getLocalHomeJndiName(container).equals(ProxyFactoryHelper.getLocalJndiName(container));
    }

    @Override
    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getLocalJndiName(this.getContainer());
    }

    public VMID getVMID() {
        return this.vmid;
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"), (Object)this);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful local proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        StatefulContainer statefulContainer = (StatefulContainer)this.getContainer();
        LocalHome localHome = (LocalHome)((EJBContainer)this.getContainer()).resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), interfaces, (InvocationHandler)new StatefulLocalHomeProxy(this.getContainer()));
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()), (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"));
        StatefulContainer statefulContainer = (StatefulContainer)this.getContainer();
        LocalHome localHome = (LocalHome)((EJBContainer)this.getContainer()).resolveAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether(statefulContainer)) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()));
        }
    }

    @Override
    public Object createProxy() {
        try {
            StatefulContainer sfsb = (StatefulContainer)this.getContainer();
            StatefulBeanContext ctx = sfsb.getCache().create();
            ctx.setInUse(false);
            Object id = ctx.getId();
            Object[] args = new Object[]{new StatefulLocalProxy(this.getContainer(), id, this.vmid)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    @Override
    public Object createProxy(Object id) {
        try {
            StatefulContainer sfsb = (StatefulContainer)this.getContainer();
            Object[] args = new Object[]{new StatefulLocalProxy(this.getContainer(), id, this.vmid)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    public Object createProxy(Class[] initTypes, Object[] initValues) {
        try {
            StatefulContainer sfsb = (StatefulContainer)this.getContainer();
            Object id = sfsb.createSession(initTypes, initValues);
            Object[] args = new Object[]{new StatefulLocalProxy(this.getContainer(), id, this.vmid)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    @Override
    protected StatefulHandleImpl getHandle() {
        StatefulHandleImpl handle = new StatefulHandleImpl();
        LocalBinding remoteBinding = (LocalBinding)((Advisor)this.getContainer()).resolveAnnotation(LocalBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.vmid = (VMID)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.vmid);
    }
}

