/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.enc;

import java.util.LinkedHashMap;
import java.util.List;
import javax.naming.NameNotFoundException;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPersistenceUnitResolver {
    protected List<PersistenceUnitDeployment> persistenceUnitDeployments;
    protected DeploymentScope deploymentScope;
    protected LinkedHashMap ejbContainers;

    public DeploymentPersistenceUnitResolver(List<PersistenceUnitDeployment> persistenceUnitDeployments, DeploymentScope deploymentScope, LinkedHashMap ejbContainers) {
        this.persistenceUnitDeployments = persistenceUnitDeployments;
        this.deploymentScope = deploymentScope;
        this.ejbContainers = ejbContainers;
    }

    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        if ("".equals(unitName)) {
            if (this.persistenceUnitDeployments == null) {
                throw new NameNotFoundException("EMPTY STRING unitName but there is no deployments in scope");
            }
            if (this.persistenceUnitDeployments.size() == 1 && this.ejbContainers.size() > 0) {
                return this.persistenceUnitDeployments.get(0);
            }
            if (this.persistenceUnitDeployments.size() > 1) {
                throw new NameNotFoundException("EMPTY STRING unitName and there is more than one scoped persistence unit");
            }
            throw new NameNotFoundException("There is no default persistence unit in this deployment.");
        }
        int hashIndex = unitName.indexOf(35);
        if (hashIndex != -1) {
            String relativePath = unitName.substring(0, hashIndex);
            String name = unitName.substring(hashIndex + 1);
            if (this.deploymentScope == null) {
                String relativeJarName = relativePath.substring(3);
                for (PersistenceUnitDeployment pud : PersistenceUnitRegistry.getPersistenceUnits()) {
                    String jarName = pud.getDeployment().getDeploymentUnit().getShortName() + ".jar";
                    if (pud.getDeployment().getEar() != null || !jarName.equals(relativeJarName) || !pud.getEntityManagerName().equals(name) || !pud.isScoped()) continue;
                    return pud;
                }
                return null;
            }
            Ejb3Deployment dep = this.deploymentScope.findRelativeDeployment(relativePath);
            if (dep == null) {
                return null;
            }
            PersistenceUnitDeployment rtn = dep.getPersistenceUnitDeploymentInternal(name);
            return rtn;
        }
        PersistenceUnitDeployment rtn = this.getPersistenceUnitDeploymentInternal(unitName);
        if (rtn != null) {
            return rtn;
        }
        for (PersistenceUnitDeployment deployment : PersistenceUnitRegistry.getPersistenceUnits()) {
            if (deployment.isScoped() || !deployment.getEntityManagerName().equals(unitName)) continue;
            return deployment;
        }
        return rtn;
    }

    public PersistenceUnitDeployment getPersistenceUnitDeploymentInternal(String unitName) {
        if (this.persistenceUnitDeployments != null) {
            for (PersistenceUnitDeployment deployment : this.persistenceUnitDeployments) {
                if (!deployment.getEntityManagerName().equals(unitName)) continue;
                return deployment;
            }
        }
        return null;
    }
}

