/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.export;

import it.businesslogic.ireport.export.FlashExporterExecuter;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.io.IOException;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.export.flex.JRSwfExporter;
import net.sf.jasperreports.export.flex.JRSwfExporterParameter;

public class FlashExporter
extends JRAbstractExporter {
    public static void main(String[] args) {
        String sourceName = args[0];
        String fileName = args[1];
        try {
            File sourceFile = new File(sourceName);
            JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
            JRSwfExporter exporter = new JRSwfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)new File(fileName).getAbsolutePath());
            exporter.setParameter((JRExporterParameter)JRSwfExporterParameter.SUPPRESS_COMPILER_MESSAGES, (Object)false);
            System.out.println("Exporting to file " + fileName);
            System.out.flush();
            exporter.exportReport();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportReport() throws JRException {
        try {
            JasperPrint jasperPrint = (JasperPrint)this.getParameter(JRExporterParameter.JASPER_PRINT);
            String outputFileName = (String)this.getParameter(JRExporterParameter.OUTPUT_FILE_NAME);
            outputFileName = Misc.changeFileExtension(outputFileName, ".jrprint");
            String swfOutputFileName = (String)this.getParameter(JRExporterParameter.OUTPUT_FILE_NAME);
            File swfOutputFile = new File(swfOutputFileName);
            if (swfOutputFile.exists()) {
                swfOutputFile.delete();
            }
            JRSaver.saveObject((Object)jasperPrint, (String)outputFileName);
            FlashExporterExecuter executer = new FlashExporterExecuter();
            executer.setJrprintFile(outputFileName);
            executer.setOutputFile(swfOutputFileName);
            executer.execute();
            File f = new File(outputFileName);
            if (f.exists()) {
                f.delete();
            }
            if (!swfOutputFile.exists()) {
                throw new JRException("Exception occurred. Unable to create the SWF file.");
            }
        }
        catch (IOException ex) {
            throw new JRException((Throwable)ex);
        }
    }
}

