/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.compiler;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.chart.AreaChart;
import it.businesslogic.ireport.chart.Bar3DChart;
import it.businesslogic.ireport.chart.BarChart;
import it.businesslogic.ireport.chart.BubbleChart;
import it.businesslogic.ireport.chart.CandlestickChart;
import it.businesslogic.ireport.chart.Chart;
import it.businesslogic.ireport.chart.HighLowChart;
import it.businesslogic.ireport.chart.LineChart;
import it.businesslogic.ireport.chart.MeterChart;
import it.businesslogic.ireport.chart.MultiAxisChart;
import it.businesslogic.ireport.chart.Pie3DChart;
import it.businesslogic.ireport.chart.PieChart;
import it.businesslogic.ireport.chart.ScatterChart;
import it.businesslogic.ireport.chart.StackedAreaChart;
import it.businesslogic.ireport.chart.StackedBar3DChart;
import it.businesslogic.ireport.chart.StackedBarChart;
import it.businesslogic.ireport.chart.ThermometerChart;
import it.businesslogic.ireport.chart.TimeSeriesChart;
import it.businesslogic.ireport.chart.XYAreaChart;
import it.businesslogic.ireport.chart.XYBarChart;
import it.businesslogic.ireport.chart.XYLineChart;
import it.businesslogic.ireport.chart.gui.ChartPropertiesDialog;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.gui.CrosstabEditor;
import it.businesslogic.ireport.crosstab.gui.CrosstabPropertiesDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.style.StyleDialog;
import it.businesslogic.ireport.gui.subdataset.GroupsDialog;
import it.businesslogic.ireport.gui.subdataset.SubDatasetDialog;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;

public class ErrorLocator {
    private String errorString = "";
    static final String[] ELEMENTS = new String[]{"break", "line", "rectangle", "ellipse", "image", "staticText", "textField", "subreport", "pieChart", "pie3DChart", "barChart", "bar3DChart", "xyBarChart", "stackedBarChart", "stackedBar3DChart", "lineChart", "xyLineChart", "areaChart", "xyAreaChart", "scatterChart", "bubbleChart", "timeSeriesChart", "highLowChart", "candlestickChart", "meterChart", "thermometerChart", "multiAxisChart", "stackedAreaChart", "crosstab", "frame"};
    static final String[] ELEMENTS_CLASS = new String[]{"BreakReportElement", "LineReportElement", "RectangleReportElement", "EllipseReportElement", "ImageReportElement", "StaticTextReportElement", "TextFieldReportElement", "SubReportElement", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "ChartReportElement2", "CrosstabReportElement", "FrameReportElement"};
    static final String[] BANDS = new String[]{"background", "title", "pageHeader", "pageFooter", "columnHeader", "columnFooter", "detail", "lastPageFooter", "summary"};
    private JReportFrame jReportFrame = null;

    public final int getNodeIndex(String exp) {
        if (exp == null || exp.length() == 0) {
            return 0;
        }
        if (exp.startsWith("/")) {
            return this.getNodeIndex(exp.substring(1));
        }
        int index = 0;
        if (exp.indexOf("/") > 0) {
            return this.getNodeIndex(exp.substring(0, exp.indexOf("/")));
        }
        if (exp.indexOf("[") < 0) {
            return 0;
        }
        try {
            index = Integer.parseInt(exp.substring(exp.indexOf("[") + 1, exp.lastIndexOf("]")));
            if (index > 0) {
                --index;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    public final String childNode(String exp) {
        if (exp == null || exp.length() == 0) {
            return "";
        }
        if (exp.startsWith("/")) {
            return this.childNode(exp.substring(1));
        }
        if (exp.indexOf("/") > 0) {
            return exp.substring(exp.indexOf("/"));
        }
        return "";
    }

    public void parseError(String xpath, String errormsg) {
        String string = this.errorString = errormsg == null ? "" : errormsg;
        if (this.getJReportFrame() == null || xpath == null) {
            return;
        }
        Report report = this.getJReportFrame().getReport();
        if (ErrorLocator.isNode(xpath, "jasperReport")) {
            this.parseError(this.childNode(xpath), errormsg);
            return;
        }
        if (ErrorLocator.isNode(xpath, "field")) {
            int itemIndex = this.getNodeIndex(xpath);
            JRField field = (JRField)report.getFields().get(itemIndex);
            if (field != null) {
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(field);
                MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyField(field, report);
            }
        } else if (ErrorLocator.isNode(xpath, "variable")) {
            int itemIndex = this.getNodeIndex(xpath);
            JRVariable var = this.getVariableAt(report, itemIndex);
            if (var != null) {
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(var);
                this.parseVariable(report, var, this.childNode(xpath));
            }
        } else if (ErrorLocator.isNode(xpath, "parameter")) {
            int itemIndex = this.getNodeIndex(xpath);
            JRParameter param = this.getParameterAt(report, itemIndex);
            if (param != null) {
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(param);
                this.parseParameter(report, param, this.childNode(xpath));
            }
        } else if (ErrorLocator.isNode(xpath, "filterExpression")) {
            MainFrame.getMainInstance().getReportQueryDialog().setVisible(true);
            MainFrame.getMainInstance().getReportQueryDialog().openFilterExpressionDialog(true);
        } else if (ErrorLocator.isNode(xpath, "style")) {
            int itemIndex = this.getNodeIndex(xpath);
            Style style = (Style)report.getStyles().get(itemIndex);
            StyleDialog cd = new StyleDialog((Frame)MainFrame.getMainInstance(), true);
            cd.setStyle(style);
            xpath = this.childNode(xpath);
            if (ErrorLocator.isNode(xpath, "conditionalStyle")) {
                itemIndex = this.getNodeIndex(xpath);
                String subPath = this.childNode(xpath);
                if (ErrorLocator.isNode(subPath, "conditionExpression")) {
                    cd.setOpenCondition(itemIndex);
                }
            }
            cd.setVisible(true);
        } else if (ErrorLocator.isNode(xpath, "group")) {
            int itemIndex = this.getNodeIndex(xpath);
            Group group = (Group)report.getGroups().get(itemIndex);
            if (ErrorLocator.isNode(xpath = this.childNode(xpath), "groupExpression")) {
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(group.getGroupHeader());
                MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("groupExpression", this.errorString);
            } else if (ErrorLocator.isNode(xpath, "groupHeader") || ErrorLocator.isNode(xpath, "groupFooter")) {
                boolean isHeader = ErrorLocator.isNode(xpath, "groupHeader");
                xpath = this.childNode(xpath);
                xpath = this.childNode(xpath);
                this.parseBand(report, isHeader ? group.getGroupHeader() : group.getGroupFooter(), xpath);
            }
        } else if (ErrorLocator.isNode(xpath, "subDataset")) {
            int itemIndex = this.getNodeIndex(xpath);
            SubDataset subdataset = (SubDataset)report.getSubDatasets().get(itemIndex);
            xpath = this.childNode(xpath);
            this.parseSubDataset(subdataset, this.childNode(xpath));
        } else if (ErrorLocator.isNode(xpath, BANDS) && xpath.indexOf("[1]") > 0) {
            String bandName = xpath.substring(1, xpath.indexOf("[1]"));
            xpath = this.childNode(xpath);
            xpath = this.childNode(xpath);
            this.parseBand(report, report.getBandByName(bandName), xpath);
        }
    }

    private JRVariable getVariableAt(SubDataset ds, int number) {
        Enumeration var_enum = ds.getVariables().elements();
        int count = 0;
        while (var_enum.hasMoreElements()) {
            JRVariable var = (JRVariable)var_enum.nextElement();
            if (var.isBuiltin()) continue;
            if (number == count) {
                return var;
            }
            ++count;
        }
        return null;
    }

    private JRParameter getParameterAt(SubDataset ds, int number) {
        Enumeration par_enum = ds.getParameters().elements();
        int count = 0;
        while (par_enum.hasMoreElements()) {
            JRParameter par = (JRParameter)par_enum.nextElement();
            if (par.isBuiltin()) continue;
            if (number == count) {
                return par;
            }
            ++count;
        }
        return null;
    }

    public void parseVariable(SubDataset subDataset, JRVariable variable, String xpath) {
        if (ErrorLocator.isNode(xpath, "variableExpression")) {
            MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyVariable(variable, subDataset, 1);
        } else if (ErrorLocator.isNode(xpath, "initialValueExpression")) {
            MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyVariable(variable, subDataset, 2);
        }
    }

    public void parseParameter(SubDataset subDataset, JRParameter param, String xpath) {
        if (ErrorLocator.isNode(xpath, "defaultValueExpression")) {
            MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyParameter(param, subDataset, 1);
        } else {
            MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyParameter(param, subDataset);
        }
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
    }

    private void parseSubDataset(SubDataset subdataset, String xpath) {
        if (ErrorLocator.isNode(xpath, "filterExpression")) {
            SubDatasetDialog sdd = new SubDatasetDialog((Frame)MainFrame.getMainInstance(), true);
            sdd.setSubDataset(subdataset);
            MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(subdataset);
            sdd.setFocusedExpression(1);
            sdd.setVisible(true);
        } else if (ErrorLocator.isNode(xpath, "group")) {
            int itemIndex = this.getNodeIndex(xpath);
            Group grp = (Group)subdataset.getGroups().get(itemIndex);
            if (ErrorLocator.isNode(xpath, "groupExpression")) {
                GroupsDialog.modifyGroup(subdataset, grp, MainFrame.getMainInstance(), 1);
            }
        }
    }

    private void parseBand(Report report, Band band, String xpath) {
        if (ErrorLocator.isNode(xpath, "printWhenExpression")) {
            if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                this.getJReportFrame().setSelectedCrosstabEditor(null);
            }
            MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(band);
            MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("printWhenExpression", this.errorString);
        } else if (ErrorLocator.isNode(xpath, ELEMENTS)) {
            Vector<ReportElement> bandElements = new Vector<ReportElement>();
            for (int i = 0; i < report.getElements().size(); ++i) {
                ReportElement bElement = (ReportElement)report.getElements().get(i);
                if (bElement.getBand() == null || bElement.getBand() != band) continue;
                bandElements.add(bElement);
            }
            ReportElement re = this.findElement(bandElements, xpath);
            if (re == null) {
                return;
            }
            String subXpath = this.childNode(xpath);
            if (ErrorLocator.isNode(subXpath, "reportElement")) {
                subXpath = this.childNode(subXpath);
                this.parseReportElement(re, subXpath, null);
            } else if (ErrorLocator.isNode(subXpath, "chart")) {
                if (ErrorLocator.isNode(subXpath = this.childNode(subXpath), "reportElement")) {
                    subXpath = this.childNode(subXpath);
                    this.parseReportElement(re, subXpath, null);
                } else {
                    this.parseElement(re, subXpath, null);
                }
            } else {
                this.parseElement(re, subXpath, null);
            }
        } else if (ErrorLocator.isNode(xpath, "elementGroup")) {
            this.parseBand(report, band, this.childNode(xpath));
        }
    }

    public void parseElement(ReportElement re, String xpath, CrosstabReportElement cre) {
        int subexpressionID;
        int elementID;
        int expressionID;
        if (xpath.length() == 0) {
            System.out.println("No sub path for xpath " + xpath);
            if (cre == null) {
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                    this.getJReportFrame().setSelectedCrosstabEditor(null);
                }
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
            } else {
                CrosstabEditor ceditor = this.getJReportFrame().getCrosstabEditor(cre);
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() == null || this.getJReportFrame().getSelectedCrosstabEditorPanel() != ceditor.getPanelEditor()) {
                    this.getJReportFrame().setSelectedCrosstabEditor(cre);
                }
                ceditor.getPanelEditor().setSelectedElement(re);
            }
            return;
        }
        if (re instanceof HyperLinkableReportElement) {
            expressionID = -1;
            elementID = -1;
            subexpressionID = -1;
            if (ErrorLocator.isNode(xpath, "anchorNameExpression")) {
                expressionID = 1;
            } else if (ErrorLocator.isNode(xpath, "hyperlinkReferenceExpression")) {
                expressionID = 2;
            } else if (ErrorLocator.isNode(xpath, "hyperlinkAnchorExpression")) {
                expressionID = 3;
            } else if (ErrorLocator.isNode(xpath, "hyperlinkPageExpression")) {
                expressionID = 4;
            } else if (ErrorLocator.isNode(xpath, "hyperlinkTooltipExpression")) {
                expressionID = 5;
            } else if (ErrorLocator.isNode(xpath, "hyperlinkParameter")) {
                expressionID = 6;
                elementID = this.getNodeIndex(xpath);
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "hyperlinkParameterExpression")) {
                    subexpressionID = 2;
                }
            }
            if (expressionID > 0) {
                if (cre == null) {
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                        this.getJReportFrame().setSelectedCrosstabEditor(null);
                    }
                    MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                } else {
                    CrosstabEditor ceditor = this.getJReportFrame().getCrosstabEditor(cre);
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() == null || this.getJReportFrame().getSelectedCrosstabEditorPanel() != ceditor.getPanelEditor()) {
                        this.getJReportFrame().setSelectedCrosstabEditor(cre);
                    }
                    ceditor.getPanelEditor().setSelectedElement(re);
                }
                MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
                MainFrame.getMainInstance().getElementPropertiesDialog().setFocusedExpression(expressionID, elementID);
                if (subexpressionID > 0) {
                    MainFrame.getMainInstance().getElementPropertiesDialog().modifyLinkParameter(subexpressionID);
                }
                return;
            }
        }
        if (re instanceof ImageReportElement) {
            if (ErrorLocator.isNode(xpath, "imageExpression")) {
                if (cre == null) {
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                        this.getJReportFrame().setSelectedCrosstabEditor(null);
                    }
                    MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                    MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("imageExpression", this.errorString);
                } else {
                    CrosstabEditor ceditor = this.getJReportFrame().getCrosstabEditor(cre);
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() == null || this.getJReportFrame().getSelectedCrosstabEditorPanel() != ceditor.getPanelEditor()) {
                        this.getJReportFrame().setSelectedCrosstabEditor(cre);
                    }
                    ceditor.getPanelEditor().setSelectedElement(re);
                    MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("imageExpression", this.errorString);
                }
            }
        } else if (re instanceof TextFieldReportElement) {
            if (ErrorLocator.isNode(xpath, "textFieldExpression")) {
                if (cre == null) {
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                        this.getJReportFrame().setSelectedCrosstabEditor(null);
                    }
                    MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                    MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("textfieldExpression", this.errorString);
                } else {
                    CrosstabEditor ceditor = this.getJReportFrame().getCrosstabEditor(cre);
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() == null || this.getJReportFrame().getSelectedCrosstabEditorPanel() != ceditor.getPanelEditor()) {
                        this.getJReportFrame().setSelectedCrosstabEditor(cre);
                    }
                    ceditor.getPanelEditor().setSelectedElement(re);
                    MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("textfieldExpression", this.errorString);
                }
            }
        } else if (re instanceof ChartReportElement2) {
            if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                this.getJReportFrame().setSelectedCrosstabEditor(null);
            }
            MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
            boolean openChartFrame = false;
            String errorLabel = null;
            Object[] expressionInfo = null;
            if (ErrorLocator.isNode(xpath, "chartTitle")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "titleExpression")) {
                    openChartFrame = true;
                    errorLabel = "chartTitle";
                }
            } else if (ErrorLocator.isNode(xpath, "chartSubtitle")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "subtitleExpression")) {
                    openChartFrame = true;
                    errorLabel = "chartSubTitle";
                }
            } else if (ErrorLocator.isNode(xpath, "barPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "categoryAxisLabelExpression")) {
                    errorLabel = "categoryAxisLabelExpressionBarPlot";
                } else if (ErrorLocator.isNode(xpath, "valueAxisLabelExpression")) {
                    errorLabel = "valueAxisLabelExpressionBarPlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "bar3DPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "categoryAxisLabelExpression")) {
                    errorLabel = "categoryAxisLabelExpressionBar3DPlot";
                } else if (ErrorLocator.isNode(xpath, "valueAxisLabelExpression")) {
                    errorLabel = "valueAxisLabelExpressionBar3DPlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "linePlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "categoryAxisLabelExpression")) {
                    errorLabel = "categoryAxisLabelExpressionLinePlot";
                } else if (ErrorLocator.isNode(xpath, "valueAxisLabelExpression")) {
                    errorLabel = "valueAxisLabelExpressionLinePlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "areaPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "categoryAxisLabelExpression")) {
                    errorLabel = "categoryAxisLabelExpressionAreaPlot";
                } else if (ErrorLocator.isNode(xpath, "valueAxisLabelExpression")) {
                    errorLabel = "valueAxisLabelExpressionAreaPlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "scatterPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "xAxisLabelExpression")) {
                    errorLabel = "xAxisLabelExpressionScatterPlot";
                } else if (ErrorLocator.isNode(xpath, "yAxisLabelExpression")) {
                    errorLabel = "yAxisLabelExpressionScatterPlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "bubblePlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "xAxisLabelExpression")) {
                    errorLabel = "xAxisLabelExpressionBubblePlot";
                } else if (ErrorLocator.isNode(xpath, "yAxisLabelExpression")) {
                    errorLabel = "yAxisLabelExpressionBubblePlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "timeSeriesPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "timeAxisLabelExpression")) {
                    errorLabel = "timeAxisLabelExpressionTimeSeriesPlot";
                } else if (ErrorLocator.isNode(xpath, "valueAxisLabelExpression")) {
                    errorLabel = "valueAxisLabelExpressionTimeSeriesPlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "highLowPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "timeAxisLabelExpression")) {
                    errorLabel = "timeAxisLabelExpressionHighLowPlot";
                } else if (ErrorLocator.isNode(xpath, "valueAxisLabelExpression")) {
                    errorLabel = "valueAxisLabelExpressionHighLowPlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "candlestickPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "timeAxisLabelExpression")) {
                    errorLabel = "timeAxisLabelExpressionCandlestickPlot";
                } else if (ErrorLocator.isNode(xpath, "valueAxisLabelExpression")) {
                    errorLabel = "valueAxisLabelExpressionCandlestickPlot";
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "meterPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "dataRange")) {
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "lowExpression")) {
                        errorLabel = "dataRangeLowExpressionMeterPlot";
                    } else if (ErrorLocator.isNode(xpath, "highExpression")) {
                        errorLabel = "dataRangeHighExpressionMeterPlot";
                    }
                } else if (ErrorLocator.isNode(xpath, "meterInterval")) {
                    int intervalIndex = this.getNodeIndex(xpath);
                    expressionInfo = new Object[]{new Integer(2), this.errorString, new Integer(1), new Integer(intervalIndex)};
                    expressionInfo = ErrorLocator.isNode(xpath = this.childNode(xpath), "dataRange") ? (ErrorLocator.isNode(xpath = this.childNode(xpath), "lowExpression") ? ErrorLocator.appendToArray(expressionInfo, new Integer(1)) : (ErrorLocator.isNode(xpath, "highExpression") ? ErrorLocator.appendToArray(expressionInfo, new Integer(2)) : ErrorLocator.appendToArray(expressionInfo, new Integer(0)))) : ErrorLocator.appendToArray(expressionInfo, new Integer(0));
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "thermometerPlot")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "dataRange")) {
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "lowExpression")) {
                        errorLabel = "dataRangeLowExpressionThermometerPlot";
                    } else if (ErrorLocator.isNode(xpath, "highExpression")) {
                        errorLabel = "dataRangeHighExpressionThermometerPlot";
                    }
                } else if (ErrorLocator.isNode(xpath, "lowRange")) {
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "dataRange")) {
                        if (ErrorLocator.isNode(xpath = this.childNode(xpath), "lowExpression")) {
                            errorLabel = "lowRangeLowExpressionThermometerPlot";
                        } else if (ErrorLocator.isNode(xpath, "highExpression")) {
                            errorLabel = "lowRangeHighExpressionThermometerPlot";
                        }
                    }
                } else if (ErrorLocator.isNode(xpath, "mediumRange")) {
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "dataRange")) {
                        if (ErrorLocator.isNode(xpath = this.childNode(xpath), "lowExpression")) {
                            errorLabel = "mediumRangeLowExpressionThermometerPlot";
                        } else if (ErrorLocator.isNode(xpath, "highExpression")) {
                            errorLabel = "mediumRangeHighExpressionThermometerPlot";
                        }
                    }
                } else if (ErrorLocator.isNode(xpath, "highRange") && ErrorLocator.isNode(xpath = this.childNode(xpath), "dataRange")) {
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "lowExpression")) {
                        errorLabel = "highRangeLowExpressionThermometerPlot";
                    } else if (ErrorLocator.isNode(xpath, "highExpression")) {
                        errorLabel = "highRangeHighExpressionThermometerPlot";
                    }
                }
                openChartFrame = true;
            } else if (ErrorLocator.isNode(xpath, "pieDataset")) {
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "keyExpression")) {
                    expressionInfo = new Object[]{new Integer(1), new Integer(1)};
                } else if (ErrorLocator.isNode(xpath, "valueExpression")) {
                    expressionInfo = new Object[]{new Integer(1), new Integer(2)};
                } else if (ErrorLocator.isNode(xpath, "labelExpression")) {
                    expressionInfo = new Object[]{new Integer(1), new Integer(3)};
                } else if (ErrorLocator.isNode(xpath, "sectionHyperlink")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = new Object[]{new Integer(1), new Integer(100)};
                    expressionInfo = this.addSectionHyperlinkExpressionsInfo(expressionInfo, xpath);
                }
            } else if (ErrorLocator.isNode(xpath, "categoryDataset")) {
                xpath = this.childNode(xpath);
                expressionInfo = new Object[]{new Integer(1)};
                if (ErrorLocator.isNode(xpath, "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "categorySeries")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(this.getNodeIndex(xpath)));
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "seriesExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(2));
                    } else if (ErrorLocator.isNode(xpath, "categoryExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    } else if (ErrorLocator.isNode(xpath, "valueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(3));
                    } else if (ErrorLocator.isNode(xpath, "labelExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(4));
                    } else if (ErrorLocator.isNode(xpath, "itemHyperlink")) {
                        xpath = this.childNode(xpath);
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(100));
                        expressionInfo = this.addSectionHyperlinkExpressionsInfo(expressionInfo, xpath);
                    }
                }
            } else if (ErrorLocator.isNode(xpath, "timePeriodDataset")) {
                xpath = this.childNode(xpath);
                expressionInfo = new Object[]{new Integer(1)};
                if (ErrorLocator.isNode(xpath, "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "timePeriodSeries")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(this.getNodeIndex(xpath)));
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "seriesExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    } else if (ErrorLocator.isNode(xpath, "startDateExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(2));
                    } else if (ErrorLocator.isNode(xpath, "endDateExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(3));
                    } else if (ErrorLocator.isNode(xpath, "valueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(4));
                    } else if (ErrorLocator.isNode(xpath, "labelExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(5));
                    } else if (ErrorLocator.isNode(xpath, "itemHyperlink")) {
                        xpath = this.childNode(xpath);
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(100));
                        expressionInfo = this.addSectionHyperlinkExpressionsInfo(expressionInfo, xpath);
                    }
                }
            } else if (ErrorLocator.isNode(xpath, "xyDataset")) {
                xpath = this.childNode(xpath);
                expressionInfo = new Object[]{new Integer(1)};
                if (ErrorLocator.isNode(xpath, "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "xySeries")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(this.getNodeIndex(xpath)));
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "seriesExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    } else if (ErrorLocator.isNode(xpath, "xValueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(2));
                    } else if (ErrorLocator.isNode(xpath, "yValueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(3));
                    } else if (ErrorLocator.isNode(xpath, "labelExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(4));
                    } else if (ErrorLocator.isNode(xpath, "itemHyperlink")) {
                        xpath = this.childNode(xpath);
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(100));
                        expressionInfo = this.addSectionHyperlinkExpressionsInfo(expressionInfo, xpath);
                    }
                }
            } else if (ErrorLocator.isNode(xpath, "xyzDataset")) {
                xpath = this.childNode(xpath);
                expressionInfo = new Object[]{new Integer(1)};
                if (ErrorLocator.isNode(xpath, "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "xyzSeries")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(this.getNodeIndex(xpath)));
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "seriesExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    } else if (ErrorLocator.isNode(xpath, "xValueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(2));
                    } else if (ErrorLocator.isNode(xpath, "yValueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(3));
                    } else if (ErrorLocator.isNode(xpath, "zValueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(4));
                    } else if (ErrorLocator.isNode(xpath, "itemHyperlink")) {
                        xpath = this.childNode(xpath);
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(100));
                        expressionInfo = this.addSectionHyperlinkExpressionsInfo(expressionInfo, xpath);
                    }
                }
            } else if (ErrorLocator.isNode(xpath, "timeSeriesDataset")) {
                xpath = this.childNode(xpath);
                expressionInfo = new Object[]{new Integer(1)};
                if (ErrorLocator.isNode(xpath, "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "timeSeries")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(this.getNodeIndex(xpath)));
                    if (ErrorLocator.isNode(xpath = this.childNode(xpath), "seriesExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                    } else if (ErrorLocator.isNode(xpath, "timePeriodExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(2));
                    } else if (ErrorLocator.isNode(xpath, "valueExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(3));
                    } else if (ErrorLocator.isNode(xpath, "labelExpression")) {
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(4));
                    } else if (ErrorLocator.isNode(xpath, "itemHyperlink")) {
                        xpath = this.childNode(xpath);
                        expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(100));
                        expressionInfo = this.addSectionHyperlinkExpressionsInfo(expressionInfo, xpath);
                    }
                }
            } else if (ErrorLocator.isNode(xpath, "highLowDataset")) {
                xpath = this.childNode(xpath);
                expressionInfo = new Object[]{new Integer(1)};
                if (ErrorLocator.isNode(xpath, "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "seriesExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                } else if (ErrorLocator.isNode(xpath, "seriesExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                } else if (ErrorLocator.isNode(xpath, "dateExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(2));
                } else if (ErrorLocator.isNode(xpath, "highExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(3));
                } else if (ErrorLocator.isNode(xpath, "lowExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(4));
                } else if (ErrorLocator.isNode(xpath, "openExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(5));
                } else if (ErrorLocator.isNode(xpath, "closeExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(6));
                } else if (ErrorLocator.isNode(xpath, "volumeExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(7));
                } else if (ErrorLocator.isNode(xpath, "itemHyperlink")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(100));
                    expressionInfo = this.addSectionHyperlinkExpressionsInfo(expressionInfo, xpath);
                }
            } else if (ErrorLocator.isNode(xpath, "valueDataset")) {
                xpath = this.childNode(xpath);
                expressionInfo = new Object[]{new Integer(1)};
                if (ErrorLocator.isNode(xpath, "dataset")) {
                    xpath = this.childNode(xpath);
                    expressionInfo = this.parseDataset(xpath);
                } else if (ErrorLocator.isNode(xpath, "valueExpression")) {
                    expressionInfo = ErrorLocator.appendToArray(expressionInfo, new Integer(1));
                }
            }
            if (openChartFrame || expressionInfo != null) {
                ChartPropertiesDialog cpd = new ChartPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                try {
                    cpd.setJReportFrame(this.getJReportFrame());
                    cpd.setChartElement((ChartReportElement2)re);
                    if (errorLabel != null) {
                        cpd.setPropertyLabelError(errorLabel, this.errorString);
                    } else if (expressionInfo != null) {
                        cpd.setFocusedExpression(expressionInfo);
                    }
                    cpd.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (re instanceof SubReportElement) {
            expressionID = -1;
            elementID = -1;
            subexpressionID = -1;
            if (ErrorLocator.isNode(xpath, "parametersMapExpression")) {
                expressionID = 7;
            } else if (ErrorLocator.isNode(xpath, "connectionExpression")) {
                expressionID = 8;
            } else if (ErrorLocator.isNode(xpath, "dataSourceExpression")) {
                expressionID = 8;
            } else if (ErrorLocator.isNode(xpath, "subreportExpression")) {
                expressionID = 9;
            } else if (ErrorLocator.isNode(xpath, "subreportParameter")) {
                expressionID = 10;
                elementID = this.getNodeIndex(xpath);
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "subreportParameterExpression")) {
                    subexpressionID = 2;
                }
            } else if (ErrorLocator.isNode(xpath, "returnValue")) {
                expressionID = 11;
                elementID = this.getNodeIndex(xpath);
            }
            if (expressionID > 0) {
                if (cre == null) {
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                        this.getJReportFrame().setSelectedCrosstabEditor(null);
                    }
                    MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                } else {
                    CrosstabEditor ceditor = this.getJReportFrame().getCrosstabEditor(cre);
                    if (this.getJReportFrame().getSelectedCrosstabEditorPanel() == null || this.getJReportFrame().getSelectedCrosstabEditorPanel() != ceditor.getPanelEditor()) {
                        this.getJReportFrame().setSelectedCrosstabEditor(cre);
                    }
                    ceditor.getPanelEditor().setSelectedElement(re);
                }
                MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
                MainFrame.getMainInstance().getElementPropertiesDialog().setFocusedExpression(expressionID, elementID);
                if (subexpressionID > 0) {
                    MainFrame.getMainInstance().getElementPropertiesDialog().modifySubreportParameter(subexpressionID);
                }
            }
        } else if (re instanceof CrosstabReportElement) {
            expressionID = -1;
            elementID = -1;
            subexpressionID = -1;
            if (ErrorLocator.isNode(xpath, "parametersMapExpression")) {
                expressionID = 13;
            } else if (ErrorLocator.isNode(xpath, "crosstabParameter")) {
                expressionID = 12;
                elementID = this.getNodeIndex(xpath);
                if (ErrorLocator.isNode(xpath = this.childNode(xpath), "parameterValueExpression")) {
                    subexpressionID = 2;
                }
            } else if (xpath.indexOf("/cellContents") >= 0) {
                String cellContentPath = xpath.substring(xpath.indexOf("/cellContents"));
                cellContentPath = this.childNode(cellContentPath);
                CrosstabCell cell = this.findCell((CrosstabReportElement)re, xpath);
                ReportElement sre = this.findElement(((CrosstabReportElement)re).getElements(), cellContentPath, cell);
                if (sre != null) {
                    String elementPath = this.childNode(cellContentPath);
                    if (ErrorLocator.isNode(elementPath, "reportElement")) {
                        elementPath = this.childNode(elementPath);
                        this.parseReportElement(sre, elementPath, (CrosstabReportElement)re);
                    } else {
                        this.parseElement(sre, elementPath, (CrosstabReportElement)re);
                    }
                }
            } else if (ErrorLocator.isNode(xpath, "rowGroup")) {
                int groupIndex = this.getNodeIndex(xpath);
                xpath = this.childNode(xpath);
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                    this.getJReportFrame().setSelectedCrosstabEditor(null);
                }
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                if (ErrorLocator.isNode(xpath, "bucket")) {
                    xpath = this.childNode(xpath);
                    int groupExp = 0;
                    if (ErrorLocator.isNode(xpath, "bucketExpression")) {
                        groupExp = 1;
                    } else if (ErrorLocator.isNode(xpath, "comparatorExpression")) {
                        groupExp = 2;
                    }
                    CrosstabPropertiesDialog cpd = new CrosstabPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                    cpd.setCurrentCrosstabReportElement((CrosstabReportElement)re);
                    cpd.openRowBucket(groupIndex, groupExp);
                    cpd.setVisible(true);
                }
            } else if (ErrorLocator.isNode(xpath, "columnGroup")) {
                int groupIndex = this.getNodeIndex(xpath);
                xpath = this.childNode(xpath);
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                    this.getJReportFrame().setSelectedCrosstabEditor(null);
                }
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                if (ErrorLocator.isNode(xpath, "bucket")) {
                    xpath = this.childNode(xpath);
                    int groupExp = 0;
                    if (ErrorLocator.isNode(xpath, "bucketExpression")) {
                        groupExp = 1;
                    } else if (ErrorLocator.isNode(xpath, "comparatorExpression")) {
                        groupExp = 2;
                    }
                    CrosstabPropertiesDialog cpd = new CrosstabPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                    cpd.setCurrentCrosstabReportElement((CrosstabReportElement)re);
                    cpd.openColumnBucket(groupIndex, groupExp);
                    cpd.setVisible(true);
                }
            } else if (ErrorLocator.isNode(xpath, "measure")) {
                int groupIndex = this.getNodeIndex(xpath);
                xpath = this.childNode(xpath);
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                    this.getJReportFrame().setSelectedCrosstabEditor(null);
                }
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                int measureExp = 0;
                if (ErrorLocator.isNode(xpath, "measureExpression")) {
                    measureExp = 1;
                }
                CrosstabPropertiesDialog cpd = new CrosstabPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                cpd.setCurrentCrosstabReportElement((CrosstabReportElement)re);
                cpd.openMeasure(groupIndex, measureExp);
                cpd.setVisible(true);
            } else if (ErrorLocator.isNode(xpath, "crosstabDataset") && ErrorLocator.isNode(xpath = this.childNode(xpath), "dataset")) {
                xpath = this.childNode(xpath);
                Object[] expressionInfo = this.parseDataset(xpath);
                CrosstabPropertiesDialog cpd = new CrosstabPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                cpd.setCurrentCrosstabReportElement((CrosstabReportElement)re);
                cpd.setFocusedExpression(expressionInfo);
                cpd.setVisible(true);
            }
            if (expressionID > 0) {
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                    this.getJReportFrame().setSelectedCrosstabEditor(null);
                }
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
                MainFrame.getMainInstance().getElementPropertiesDialog().setFocusedExpression(expressionID, elementID);
                if (subexpressionID > 0) {
                    MainFrame.getMainInstance().getElementPropertiesDialog().modifyCrosstabParameter(subexpressionID);
                }
            }
        }
    }

    private static final boolean isNode(String xpath, String[] keys) {
        if (xpath == null || keys == null) {
            return false;
        }
        if (xpath.startsWith("/")) {
            xpath = xpath.substring(1);
        }
        for (int i = 0; i < keys.length; ++i) {
            if (!ErrorLocator.isNode(xpath, keys[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isNode(String xpath, String nodeName) {
        if (xpath == null || nodeName == null || nodeName.length() == 0) {
            return false;
        }
        if (xpath.startsWith("/")) {
            xpath = xpath.substring(1);
        }
        return xpath.startsWith(nodeName) && ((xpath = xpath.substring(nodeName.length())).length() == 0 || xpath.startsWith("/") || xpath.startsWith("["));
    }

    public ReportElement findElement(Vector elements, String xpath) {
        return this.findElement(elements, xpath, null);
    }

    public ReportElement findElement(Vector elements, String xpath, CrosstabCell cell) {
        if (elements == null || xpath == null) {
            return null;
        }
        int index = this.getNodeIndex(xpath);
        if (xpath.startsWith("/")) {
            xpath = xpath.substring(1);
        }
        String class_name = null;
        String element_type = null;
        for (int i = 0; i < ELEMENTS.length; ++i) {
            if (!ErrorLocator.isNode(xpath, ELEMENTS[i])) continue;
            class_name = "it.businesslogic.ireport." + ELEMENTS_CLASS[i];
            element_type = ELEMENTS[i];
            break;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(class_name);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        for (int i = 0; i < elements.size(); ++i) {
            ReportElement re = (ReportElement)elements.get(i);
            if (cell != null && re.getCell() != cell || !clazz.isInstance(re)) continue;
            if (re instanceof ChartReportElement2) {
                Chart chart = ((ChartReportElement2)re).getChart();
                if (!(element_type.equals("pie3DChart") && chart instanceof Pie3DChart || element_type.equals("pieChart") && chart instanceof PieChart || element_type.equals("barChart") && chart instanceof BarChart || element_type.equals("bar3DChart") && chart instanceof Bar3DChart || element_type.equals("xyBarChart") && chart instanceof XYBarChart || element_type.equals("stackedBarChart") && chart instanceof StackedBarChart || element_type.equals("stackedBar3DChart") && chart instanceof StackedBar3DChart || element_type.equals("lineChart") && chart instanceof LineChart || element_type.equals("xyLineChart") && chart instanceof XYLineChart || element_type.equals("areaChart") && chart instanceof AreaChart || element_type.equals("xyAreaChart") && chart instanceof XYAreaChart || element_type.equals("scatterChart") && chart instanceof ScatterChart || element_type.equals("bubbleChart") && chart instanceof BubbleChart || element_type.equals("timeSeriesChart") && chart instanceof TimeSeriesChart || element_type.equals("highLowChart") && chart instanceof HighLowChart || element_type.equals("candlestickChart") && chart instanceof CandlestickChart || element_type.equals("meterChart") && chart instanceof MeterChart || element_type.equals("thermometerChart") && chart instanceof ThermometerChart || element_type.equals("multiAxisChart") && chart instanceof MultiAxisChart) && (!element_type.equals("stackedAreaChart") || !(chart instanceof StackedAreaChart))) continue;
                if (index == 0) {
                    return re;
                }
                --index;
                continue;
            }
            if (index == 0) {
                return re;
            }
            --index;
        }
        return null;
    }

    private void parseReportElement(ReportElement re, String xpath, CrosstabReportElement cre) {
        if (ErrorLocator.isNode(xpath, "printWhenExpression")) {
            if (cre == null) {
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() != null) {
                    this.getJReportFrame().setSelectedCrosstabEditor(null);
                }
                MainFrame.getMainInstance().getDocumentStructurePanel().setSelectedObject(re);
                MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("printWhenExpression", this.errorString);
            } else {
                CrosstabEditor ceditor = this.getJReportFrame().getCrosstabEditor(cre);
                if (this.getJReportFrame().getSelectedCrosstabEditorPanel() == null || this.getJReportFrame().getSelectedCrosstabEditorPanel() != ceditor.getPanelEditor()) {
                    this.getJReportFrame().setSelectedCrosstabEditor(cre);
                }
                ceditor.getPanelEditor().setSelectedElement(re);
                MainFrame.getMainInstance().getReportSheetPanel().setPropertyLabelError("printWhenExpression", this.errorString);
            }
        }
    }

    private CrosstabCell findCell(CrosstabReportElement re, String xpath) {
        if (ErrorLocator.isNode(xpath, "crosstabHeaderCell")) {
            for (int i = 0; i < re.getCells().size(); ++i) {
                CrosstabCell cc = (CrosstabCell)re.getCells().get(i);
                if (cc.getType() != 3) continue;
                return cc;
            }
            return null;
        }
        if (ErrorLocator.isNode(xpath, "rowGroup")) {
            int itemIndex = this.getNodeIndex(xpath);
            CrosstabGroup cg = (CrosstabGroup)re.getRowGroups().get(itemIndex);
            if (ErrorLocator.isNode(xpath = this.childNode(xpath), "crosstabRowHeader")) {
                return cg.getHeaderCell();
            }
            if (ErrorLocator.isNode(xpath, "crosstabTotalRowHeader")) {
                return cg.getTotalCell();
            }
        } else if (ErrorLocator.isNode(xpath, "columnGroup")) {
            int itemIndex = this.getNodeIndex(xpath);
            CrosstabGroup cg = (CrosstabGroup)re.getColumnGroups().get(itemIndex);
            if (ErrorLocator.isNode(xpath = this.childNode(xpath), "crosstabColumnHeader")) {
                return cg.getHeaderCell();
            }
            if (ErrorLocator.isNode(xpath, "crosstabTotalColumnHeader")) {
                return cg.getTotalCell();
            }
        } else {
            if (ErrorLocator.isNode(xpath, "crosstabCell")) {
                int cellIndex = this.getNodeIndex(xpath);
                for (int i = 0; i < re.getCells().size(); ++i) {
                    CrosstabCell cc = (CrosstabCell)re.getCells().get(i);
                    if (cc.getType() != 0) continue;
                    if (cellIndex == 0) {
                        return cc;
                    }
                    --cellIndex;
                }
                return null;
            }
            if (ErrorLocator.isNode(xpath, "whenNoDataCell")) {
                for (int i = 0; i < re.getCells().size(); ++i) {
                    CrosstabCell cc = (CrosstabCell)re.getCells().get(i);
                    if (cc.getType() != 2) continue;
                    return cc;
                }
                return null;
            }
        }
        return null;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public Object[] addSectionHyperlinkExpressionsInfo(Object[] startingExpressionInfo, String xpath) {
        int itemToAppend = 0;
        if (ErrorLocator.isNode(xpath, "hyperlinkReferenceExpression")) {
            itemToAppend = 2;
        } else if (ErrorLocator.isNode(xpath, "hyperlinkPageExpression")) {
            itemToAppend = 4;
        } else if (ErrorLocator.isNode(xpath, "hyperlinkAnchorExpression")) {
            itemToAppend = 3;
        } else if (ErrorLocator.isNode(xpath, "hyperlinkTooltipExpression")) {
            itemToAppend = 5;
        } else if (ErrorLocator.isNode(xpath, "hyperlinkParameter")) {
            int paramIndex = this.getNodeIndex(xpath);
            itemToAppend = 6;
            startingExpressionInfo = ErrorLocator.appendToArray(startingExpressionInfo, new Integer(itemToAppend));
            startingExpressionInfo = ErrorLocator.appendToArray(startingExpressionInfo, new Integer(paramIndex));
            xpath = this.childNode(xpath);
            itemToAppend = 0;
            if (ErrorLocator.isNode(xpath, "hyperlinkParameterExpression")) {
                itemToAppend = 2;
            }
        }
        return ErrorLocator.appendToArray(startingExpressionInfo, new Integer(itemToAppend));
    }

    public static final Object[] appendToArray(Object[] array, Object element) {
        Object[] newArray = new Object[array.length + 1];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        newArray[array.length] = element;
        return newArray;
    }

    public Object[] parseDataset(String xpath) {
        Object[] expressionInfo = null;
        if (ErrorLocator.isNode(xpath, "incrementWhenExpression")) {
            expressionInfo = new Object[]{new Integer(70)};
        } else if (ErrorLocator.isNode(xpath, "datasetRun")) {
            if (ErrorLocator.isNode(xpath = this.childNode(xpath), "parametersMapExpression")) {
                expressionInfo = new Object[]{new Integer(72)};
            } else if (ErrorLocator.isNode(xpath, new String[]{"connectionExpression", "dataSourceExpression"})) {
                expressionInfo = new Object[]{new Integer(73)};
            } else if (ErrorLocator.isNode(xpath, "datasetParameter")) {
                int paramIndex = this.getNodeIndex(xpath);
                expressionInfo = new Object[]{new Integer(71), new Integer(paramIndex)};
                expressionInfo = ErrorLocator.isNode(xpath = this.childNode(xpath), "datasetParameterExpression") ? ErrorLocator.appendToArray(expressionInfo, new Integer(2)) : ErrorLocator.appendToArray(expressionInfo, new Integer(0));
            }
        }
        return expressionInfo;
    }
}

