/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BreakReportElement;
import it.businesslogic.ireport.ChartReportElement;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.CompatibilitySupport;
import it.businesslogic.ireport.ConditionedStyle;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.EllipseReportElement;
import it.businesslogic.ireport.FrameReportElement;
import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRLinkParameter;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.JRSubreportParameter;
import it.businesslogic.ireport.JRSubreportReturnValue;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.LineReportElement;
import it.businesslogic.ireport.Pen;
import it.businesslogic.ireport.RectangleReportElement;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.SortField;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.Template;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.UndefinedStyle;
import it.businesslogic.ireport.chart.AreaChart;
import it.businesslogic.ireport.chart.AreaPlot;
import it.businesslogic.ireport.chart.Axis;
import it.businesslogic.ireport.chart.AxisFormat;
import it.businesslogic.ireport.chart.Bar3DChart;
import it.businesslogic.ireport.chart.Bar3DPlot;
import it.businesslogic.ireport.chart.BarChart;
import it.businesslogic.ireport.chart.BarPlot;
import it.businesslogic.ireport.chart.BubbleChart;
import it.businesslogic.ireport.chart.BubblePlot;
import it.businesslogic.ireport.chart.CandlestickChart;
import it.businesslogic.ireport.chart.CandlestickPlot;
import it.businesslogic.ireport.chart.CategoryDataset;
import it.businesslogic.ireport.chart.CategorySeries;
import it.businesslogic.ireport.chart.DataRange;
import it.businesslogic.ireport.chart.Dataset;
import it.businesslogic.ireport.chart.HighLowChart;
import it.businesslogic.ireport.chart.HighLowDataset;
import it.businesslogic.ireport.chart.HighLowPlot;
import it.businesslogic.ireport.chart.LineChart;
import it.businesslogic.ireport.chart.LinePlot;
import it.businesslogic.ireport.chart.MeterChart;
import it.businesslogic.ireport.chart.MeterInterval;
import it.businesslogic.ireport.chart.MeterPlot;
import it.businesslogic.ireport.chart.MultiAxisChart;
import it.businesslogic.ireport.chart.MultiAxisPlot;
import it.businesslogic.ireport.chart.Pie3DChart;
import it.businesslogic.ireport.chart.Pie3DPlot;
import it.businesslogic.ireport.chart.PieChart;
import it.businesslogic.ireport.chart.PieDataset;
import it.businesslogic.ireport.chart.PiePlot;
import it.businesslogic.ireport.chart.ScatterChart;
import it.businesslogic.ireport.chart.ScatterPlot;
import it.businesslogic.ireport.chart.SectionItemHyperlink;
import it.businesslogic.ireport.chart.SeriesColor;
import it.businesslogic.ireport.chart.StackedAreaChart;
import it.businesslogic.ireport.chart.StackedBar3DChart;
import it.businesslogic.ireport.chart.StackedBarChart;
import it.businesslogic.ireport.chart.ThermometerChart;
import it.businesslogic.ireport.chart.ThermometerPlot;
import it.businesslogic.ireport.chart.TimePeriodDataset;
import it.businesslogic.ireport.chart.TimePeriodSeries;
import it.businesslogic.ireport.chart.TimeSeries;
import it.businesslogic.ireport.chart.TimeSeriesChart;
import it.businesslogic.ireport.chart.TimeSeriesDataset;
import it.businesslogic.ireport.chart.TimeSeriesPlot;
import it.businesslogic.ireport.chart.ValueDataset;
import it.businesslogic.ireport.chart.ValueDisplay;
import it.businesslogic.ireport.chart.XYAreaChart;
import it.businesslogic.ireport.chart.XYBarChart;
import it.businesslogic.ireport.chart.XYDataset;
import it.businesslogic.ireport.chart.XYLineChart;
import it.businesslogic.ireport.chart.XYSeries;
import it.businesslogic.ireport.chart.XYZDataset;
import it.businesslogic.ireport.chart.XYZSeries;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.CrosstabRowGroup;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ReportWriter {
    private Report report = null;

    public ReportWriter(Report report) {
        this.setReport(report);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveXMLFile(String aFilename) {
        String scriptletFileName = this.getReport().getScriptletFileName(aFilename);
        String className = "";
        File classFile = new File(scriptletFileName);
        className = classFile.getName().substring(0, classFile.getName().length() - 5);
        int n = this.getReport().getScriptletHandling();
        this.getReport();
        if (n == Report.SCRIPTLET_IREPORT_INTERNAL_HANDLING) {
            this.getReport().setScriptletClass(className);
        }
        for (int pk = 0; pk < this.getReport().getJRproperties().size(); ++pk) {
            JRProperty prop = (JRProperty)this.getReport().getJRproperties().elementAt(pk);
            if (!prop.getName().equals("ireport.scriptlethandling") && !prop.getName().equals("ireport.encoding")) continue;
            this.getReport().getJRproperties().remove(prop);
            --pk;
        }
        JRProperty prop = new JRProperty();
        prop.setName("ireport.scriptlethandling");
        prop.setValue("" + this.getReport().getScriptletHandling());
        this.getReport().getJRproperties().add(prop);
        prop = new JRProperty();
        prop.setName("ireport.encoding");
        prop.setValue("" + this.getReport().getEncoding());
        this.getReport().getJRproperties().add(prop);
        try {
            String fileencoding = "UTF-8";
            if (this.getReport().getEncoding() != null && !this.getReport().getEncoding().trim().equals("")) {
                fileencoding = this.getReport().getEncoding();
                if (fileencoding.equalsIgnoreCase("UTF-8")) {
                    fileencoding = "UTF8";
                }
            } else {
                this.getReport().setEncoding("UTF-8");
            }
            this.writeToOutputStream(new FileOutputStream(aFilename), fileencoding);
            this.getReport().setLoadTime(Misc.getLastWriteTime(this.getReport().getFilename()));
            this.getReport().setReportChanges(0);
            int n2 = this.getReport().getScriptletHandling();
            this.getReport();
            if (n2 == Report.SCRIPTLET_IREPORT_INTERNAL_HANDLING) {
                try {
                    String allcode = new String(this.getReport().getScripletCode().getAll() + "");
                    allcode = Misc.string_replace(className, "<ScriptletClassName>", allcode);
                    FileOutputStream fos = new FileOutputStream(scriptletFileName);
                    fos.write(allcode.getBytes());
                    fos.close();
                }
                catch (Exception ex) {
                    StringWriter s = new StringWriter();
                    ex.printStackTrace(new PrintWriter(s));
                    JOptionPane.showMessageDialog(this.getReport().getReportFrame().getMainFrame(), ex.getMessage() + " " + s, I18n.getString("message.title.exception", "Exception"), 0);
                }
            }
            if (aFilename == null) return;
        }
        catch (Exception ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            JOptionPane.showMessageDialog(this.getReport().getReportFrame().getMainFrame(), ex.getMessage() + " " + s, I18n.getString("message.title.exception", "Exception"), 0);
        }
    }

    public void writeToOutputStream(OutputStream outputStream) {
        this.writeToOutputStream(outputStream, "UTF-8");
    }

    public void writeToOutputStream(OutputStream outputStream, String fileencoding) {
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, fileencoding));
            pw.print("<?xml version=\"1.0\"");
            if (this.getReport().getEncoding() != null && this.getReport().getEncoding().length() > 0) {
                pw.print(" encoding=\"" + this.getReport().getEncoding() + "\" ");
            }
            pw.println(" ?>");
            pw.println("<!-- Created with iReport - A designer for JasperReports -->");
            pw.println("<!DOCTYPE jasperReport PUBLIC \"//JasperReports//DTD Report Design//EN\" \"http://jasperreports.sourceforge.net/dtds/jasperreport.dtd\">");
            pw.println("<jasperReport");
            pw.println("\t\t name=\"" + this.getReport().getName() + "\"");
            if (CompatibilitySupport.version >= 66 && this.getReport().getLanguage() != null && !this.getReport().getLanguage().trim().equals("") && !this.getReport().getLanguage().equals("java")) {
                pw.print("\n\t\t language=\"" + this.getReport().getLanguage().trim() + "\"");
            }
            pw.println("\t\t columnCount=\"" + this.getReport().getColumnCount() + "\"");
            pw.println("\t\t printOrder=\"" + this.getReport().getPrintOrder() + "\"");
            pw.println("\t\t orientation=\"" + this.getReport().getOrientation() + "\"");
            pw.println("\t\t pageWidth=\"" + this.getReport().getWidth() + "\"");
            pw.println("\t\t pageHeight=\"" + this.getReport().getHeight() + "\"");
            pw.println("\t\t columnWidth=\"" + this.getReport().getColumnWidth() + "\"");
            pw.println("\t\t columnSpacing=\"" + this.getReport().getColumnSpacing() + "\"");
            pw.println("\t\t leftMargin=\"" + this.getReport().getLeftMargin() + "\"");
            pw.println("\t\t rightMargin=\"" + this.getReport().getRightMargin() + "\"");
            pw.println("\t\t topMargin=\"" + this.getReport().getTopMargin() + "\"");
            pw.println("\t\t bottomMargin=\"" + this.getReport().getBottomMargin() + "\"");
            pw.println("\t\t whenNoDataType=\"" + this.getReport().getWhenNoDataType() + "\"");
            if (CompatibilitySupport.version >= 63 && this.getReport().isFloatColumnFooter()) {
                pw.println("\t\t isFloatColumnFooter=\"true\"");
            }
            if (this.getReport().getScriptletHandling() != Report.SCRIPTLET_NOT_USED && this.getReport().getScriptletClass() != null && this.getReport().getScriptletClass().length() > 0) {
                pw.println("\t\t scriptletClass=\"" + this.getReport().getScriptletClass() + "\"");
            }
            pw.println("\t\t isTitleNewPage=\"" + this.getReport().isIsTitleNewPage() + "\"");
            pw.print("\t\t isSummaryNewPage=\"" + this.getReport().isIsSummaryNewPage() + "\"");
            if (CompatibilitySupport.version >= 62 && this.getReport().getResourceBundleBaseName() != null && !this.getReport().getResourceBundleBaseName().trim().equals("")) {
                pw.print("\n\t\t resourceBundle=\"" + this.getReport().getResourceBundleBaseName().trim() + "\"");
            }
            if (CompatibilitySupport.version >= 100 && this.getReport().getWhenResourceMissingType() != null && !this.getReport().getWhenResourceMissingType().trim().equals("Null")) {
                pw.print("\n\t\t whenResourceMissingType=\"" + this.getReport().getWhenResourceMissingType().trim() + "\"");
            }
            if (CompatibilitySupport.version >= 111 && this.getReport().isIgnorePagination()) {
                pw.print("\n\t\t isIgnorePagination=\"true\"");
            }
            if (CompatibilitySupport.version >= 128 && this.getReport().getFormatFactoryClass() != null && this.getReport().getFormatFactoryClass().trim().length() > 0) {
                pw.print("\n\t\t formatFactoryClass=\"" + Misc.xmlEscape(this.getReport().getFormatFactoryClass().trim()) + "\"");
            }
            pw.println(">");
            Enumeration e = null;
            this.writeXMLProperties(this.getReport().getJRproperties(), true, pw, "\t");
            Enumeration enum_chartElements = this.getReport().getElements().elements();
            while (enum_chartElements.hasMoreElements()) {
                ReportElement re = (ReportElement)enum_chartElements.nextElement();
                if (!(re instanceof ChartReportElement)) continue;
                Properties props = ((ChartReportElement)re).getProps();
                String name = re.getName();
                Iterator<Object> keys = props.keySet().iterator();
                boolean i = false;
                while (keys.hasNext()) {
                    String key = "" + keys.next();
                    String val = props.getProperty(key);
                    pw.print("\t<property name=\"chart." + name + "." + key + "\" ");
                    pw.println("value=\"" + Misc.xmlEscape(val) + "\" />");
                }
            }
            if (CompatibilitySupport.version >= 62) {
                e = this.getReport().getImports().elements();
                while (e.hasMoreElements()) {
                    String _import = (String)e.nextElement();
                    pw.print("\t<import ");
                    pw.println("value=\"" + _import + "\" />");
                }
            }
            if (CompatibilitySupport.version >= 200) {
                e = this.getReport().getTemplates().elements();
                while (e.hasMoreElements()) {
                    Template template = (Template)e.nextElement();
                    pw.print("\t<template");
                    if (template.getExpressionClass() != null && !template.getExpressionClass().equals("java.lang.String")) {
                        pw.print(" class=\"" + template.getExpressionClass() + "\"");
                    }
                    pw.print(">");
                    pw.println("<![CDATA[" + template.getExpression() + "]]></template>");
                }
            }
            e = this.getReport().getFonts().elements();
            while (e.hasMoreElements()) {
                IReportFont font = (IReportFont)e.nextElement();
                pw.print("\t<reportFont name=\"" + font.getReportFont() + "\" ");
                pw.print("isDefault=\"" + font.isDefaultFont() + "\" ");
                pw.print("fontName=\"" + font.getFontName() + "\" ");
                pw.print("size=\"" + font.getFontSize() + "\" ");
                pw.print("isBold=\"" + font.isBold() + "\" ");
                pw.print("isItalic=\"" + font.isItalic() + "\" ");
                pw.print("isUnderline=\"" + font.isUnderline() + "\" ");
                pw.print("isStrikeThrough=\"" + font.isStrikeTrought() + "\" ");
                if (Misc.nvl(font.getPDFFontName(), "").indexOf("TTF") > 0) {
                    pw.print("pdfFontName=\"" + font.getTTFFont() + "\" ");
                } else {
                    pw.print("pdfFontName=\"" + font.getPDFFontName() + "\" ");
                }
                pw.print("pdfEncoding=\"" + font.getPdfEncoding() + "\" ");
                pw.println("isPdfEmbedded=\"" + font.isPdfEmbedded() + "\"/>");
            }
            if (CompatibilitySupport.version >= 111) {
                this.writeXMLStyles(this.getReport().getStyles(), pw, "\t");
            }
            if (CompatibilitySupport.version >= 110) {
                this.writeXMLSubDatasets(this.getReport().getSubDatasets(), pw, "\t");
            }
            this.writeXMLParameters(this.getReport().getParameters(), pw, "\t");
            if (this.getReport().getQuery() != null && this.getReport().getQuery().trim().length() > 0) {
                pw.print("\t<queryString");
                if (CompatibilitySupport.version >= 120 && !this.getReport().getQueryLanguage().equals("sql")) {
                    pw.print(" language=\"" + this.getReport().getQueryLanguage() + "\"");
                }
                pw.println(">" + ReportWriter.getCDATAString(this.getReport().getQuery(), 1) + "</queryString>");
            }
            this.writeXMLFields(this.getReport().getFields(), pw, "\t");
            if (CompatibilitySupport.version >= 128) {
                this.writeXMLSortFields(this.getReport().getSortFields(), pw, "\t");
            }
            this.writeXMLVariables(this.getReport().getVariables(), pw, "\t");
            if (CompatibilitySupport.version >= 125 && this.getReport().getFilterExpression() != null && this.getReport().getFilterExpression().trim().length() > 0) {
                pw.println("\t<filterExpression>" + ReportWriter.getCDATAString(this.getReport().getFilterExpression(), 1) + "</filterExpression>");
            }
            this.writeXMLGroups(this.getReport().getGroups(), pw, true, 2);
            this.writeXMLSection("background", pw);
            this.writeXMLSection("title", pw);
            this.writeXMLSection("pageHeader", pw);
            this.writeXMLSection("columnHeader", pw);
            this.writeXMLSection("detail", pw);
            this.writeXMLSection("columnFooter", pw);
            this.writeXMLSection("pageFooter", pw);
            if (CompatibilitySupport.version >= 61) {
                this.writeXMLSection("lastPageFooter", pw);
            }
            this.writeXMLSection("summary", pw);
            if (CompatibilitySupport.version >= 200) {
                this.writeXMLSection("noData", pw);
            }
            pw.println("</jasperReport>");
            pw.close();
        }
        catch (Exception ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            JOptionPane.showMessageDialog(this.getReport().getReportFrame().getMainFrame(), ex.getMessage() + " " + s, I18n.getString("message.title.exception", "Exception"), 0);
        }
    }

    void writeXMLSection(String section, PrintWriter pw) {
        Band band = null;
        Iterator i = this.getReport().getBands().iterator();
        while (i.hasNext() && !(band = (Band)i.next()).getName().equalsIgnoreCase(section)) {
        }
        if (band == null) {
            return;
        }
        if (section.equals("lastPageFooter") && band.getHeight() == 0) {
            return;
        }
        if (section.equals("noData") && band.getHeight() == 0) {
            return;
        }
        pw.println("\t\t<" + section + ">");
        this.writeXMLBand(band, pw);
        pw.println("\t\t</" + section + ">");
    }

    void writeXMLSubDatasets(Vector subDatasets, PrintWriter pw, String tabs) {
        Enumeration e = subDatasets.elements();
        while (e.hasMoreElements()) {
            pw.println("");
            SubDataset subDataset = (SubDataset)e.nextElement();
            pw.print(tabs + "<subDataset name=\"" + subDataset.getName() + "\" ");
            if (subDataset.getScriptletClass() != null && subDataset.getScriptletClass().length() > 0) {
                pw.println(tabs + "\t scriptletClass=\"" + subDataset.getScriptletClass() + "\"");
            }
            if (subDataset.getResourceBundleBaseName() != null && !subDataset.getResourceBundleBaseName().trim().equals("")) {
                pw.print("\n" + tabs + "\t resourceBundle=\"" + this.getReport().getResourceBundleBaseName().trim() + "\"");
            }
            if (subDataset.getWhenResourceMissingType() != null && !subDataset.getWhenResourceMissingType().trim().equals("Null")) {
                pw.print("\n" + tabs + "\t whenResourceMissingType=\"" + this.getReport().getWhenResourceMissingType().trim() + "\"");
            }
            pw.println(">");
            if (CompatibilitySupport.version >= 120) {
                this.writeXMLProperties(subDataset.getJRproperties(), false, pw, tabs + "\t");
            }
            this.writeXMLParameters(subDataset.getParameters(), pw, "\t\t");
            if (subDataset.getQuery() != null && subDataset.getQuery().trim().length() > 0) {
                pw.print(tabs + "\t<queryString");
                if (CompatibilitySupport.version >= 120 && !subDataset.getQueryLanguage().equals("sql")) {
                    pw.print(" language=\"" + subDataset.getQueryLanguage() + "\"");
                }
                pw.println(">" + ReportWriter.getCDATAString(subDataset.getQuery(), 1) + "</queryString>");
            }
            if (CompatibilitySupport.version >= 110) {
                this.writeXMLFields(subDataset.getFields(), pw, "\t\t");
            }
            this.writeXMLSortFields(subDataset.getSortFields(), pw, "\t\t");
            this.writeXMLVariables(subDataset.getVariables(), pw, "\t\t");
            if (CompatibilitySupport.version >= 125 && subDataset.getFilterExpression() != null && subDataset.getFilterExpression().trim().length() > 0) {
                pw.println("\t\t<filterExpression>" + ReportWriter.getCDATAString(subDataset.getFilterExpression(), 2) + "</filterExpression>");
            }
            this.writeXMLGroups(subDataset.getGroups(), pw, false, 2);
            pw.println(tabs + "</subDataset>");
        }
    }

    void writeXMLParameters(Vector parameters, PrintWriter pw, String tabs) {
        Enumeration e = parameters.elements();
        if (parameters.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            JRParameter p = (JRParameter)e.nextElement();
            if (p.isBuiltin()) continue;
            pw.print(tabs + "<parameter name=\"" + p.getName() + "\" ");
            if (p.getClassType() == null) {
                p.setClassType("java.lang.String");
            }
            pw.print("isForPrompting=\"" + p.isIsForPrompting() + "\" ");
            pw.print("class=\"" + p.getClassType() + "\"");
            if (p.getDefaultValueExpression().trim().length() > 0 || p.getDescription().trim().length() > 0 || p.getProperties().size() > 0) {
                pw.println(">");
                if (p.getProperties().size() > 0 && CompatibilitySupport.version >= 132) {
                    this.writeXMLProperties(p.getProperties(), false, pw, tabs + "\t");
                }
                if (p.getDescription().trim().length() > 0) {
                    pw.println(tabs + "\t<parameterDescription>" + ReportWriter.getCDATAString(p.getDescription(), 2) + "</parameterDescription>");
                }
                if (p.getDefaultValueExpression().trim().length() > 0) {
                    pw.print(tabs + "\t<defaultValueExpression ");
                    pw.println(">" + ReportWriter.getCDATAString(p.getDefaultValueExpression(), 2) + "</defaultValueExpression>");
                }
                pw.println(tabs + "</parameter>");
                continue;
            }
            pw.println("/>");
        }
    }

    void writeXMLFields(Vector fields, PrintWriter pw, String tabs) {
        Enumeration e = fields.elements();
        if (fields.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof JRField)) continue;
            JRField f = (JRField)o;
            pw.print(tabs + "<field name=\"" + f.getName() + "\" ");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print("class=\"" + f.getClassType() + "\"");
            if (f.getDescription() != null && f.getDescription().trim().length() > 0 || f.getProperties().size() > 0) {
                pw.println(">");
                if (f.getProperties().size() > 0 && CompatibilitySupport.version >= 132) {
                    this.writeXMLProperties(f.getProperties(), false, pw, tabs + "\t");
                }
                if (f.getDescription().trim().length() > 0) {
                    pw.println(tabs + "\t<fieldDescription>" + ReportWriter.getCDATAString(f.getDescription(), 2) + "</fieldDescription>");
                }
                pw.println(tabs + "</field>");
                continue;
            }
            pw.println("/>");
        }
    }

    void writeXMLSortFields(Vector fields, PrintWriter pw, String tabs) {
        Enumeration e = fields.elements();
        if (fields.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            SortField f = (SortField)e.nextElement();
            pw.print(tabs + "<sortField name=\"" + Misc.xmlEscape(f.getFieldName()) + "\" ");
            if (f.isDesc()) {
                pw.print("order=\"Descending\" ");
            }
            pw.println("/>");
        }
    }

    void writeXMLVariables(Vector variables, PrintWriter pw, String tabs) {
        Enumeration e = variables.elements();
        if (variables.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            JRVariable f = (JRVariable)e.nextElement();
            if (f.isBuiltin()) continue;
            pw.print(tabs + "<variable name=\"" + f.getName() + "\" ");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print("class=\"" + f.getClassType() + "\" ");
            pw.print("resetType=\"" + f.getResetType() + "\" ");
            if (f.getIncrementerFactoryClass() != null && f.getIncrementerFactoryClass().trim().length() > 0) {
                pw.print("incrementerFactoryClass=\"" + f.getIncrementerFactoryClass() + "\" ");
            }
            if (CompatibilitySupport.version >= 66 && f.getIncrementType() != null && !f.getIncrementType().trim().equals("None")) {
                pw.print("incrementType=\"" + f.getIncrementType().trim() + "\" ");
                if (f.getIncrementType().equals("Group")) {
                    pw.print("incrementGroup=\"" + f.getIncrementGroup().trim() + "\" ");
                }
            }
            if (f.getResetGroup().length() > 0) {
                pw.print("resetGroup=\"" + f.getResetGroup() + "\" ");
            }
            pw.println("calculation=\"" + f.getCalculation() + "\">");
            if (f.getExpression().length() > 0) {
                pw.print(tabs + "\t<variableExpression");
                pw.println(">" + ReportWriter.getCDATAString(f.getExpression(), 2) + "</variableExpression>");
            }
            if (f.getInitialValueExpression().length() > 0) {
                pw.print(tabs + "\t<initialValueExpression");
                pw.println(">" + ReportWriter.getCDATAString(f.getInitialValueExpression(), 2) + "</initialValueExpression>");
            }
            pw.println(tabs + "</variable>");
        }
    }

    void writeXMLMeasures(Vector measures, PrintWriter pw, String tabs) {
        Enumeration e = measures.elements();
        if (measures.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            Measure f = (Measure)e.nextElement();
            pw.print(tabs + "<measure name=\"" + f.getName() + "\"");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print(" class=\"" + f.getClassType() + "\"");
            if (!f.getCalculation().equals("Nothing")) {
                pw.print(" calculation=\"" + f.getCalculation() + "\"");
            }
            if (f.getIncrementerFactoryClass().trim().length() > 0) {
                pw.print(" incrementerFactoryClass=\"" + f.getIncrementerFactoryClass() + "\"");
            }
            if (!f.getPercentageOf().equals("None")) {
                pw.print(" percentageOf=\"" + f.getPercentageOf() + "\"");
            }
            if (f.getPercentageCalculatorClass().trim().length() > 0) {
                pw.print(" percentageCalculatorClass=\"" + f.getPercentageCalculatorClass() + "\"");
            }
            pw.println(">");
            if (f.getExpression().length() > 0) {
                pw.print(tabs + "\t<measureExpression>");
                pw.println(ReportWriter.getCDATAString(f.getExpression(), 2) + "</measureExpression>");
            }
            pw.println(tabs + "</measure>");
        }
    }

    void writeXMLCrosstabParameters(Vector parameters, PrintWriter pw, String tabs) {
        Enumeration e = parameters.elements();
        if (parameters.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            CrosstabParameter f = (CrosstabParameter)e.nextElement();
            pw.print(tabs + "<crosstabParameter name=\"" + f.getName() + "\" ");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print("class=\"" + f.getClassType() + "\" ");
            pw.print(">");
            if (f.getParameterValueExpression().length() > 0) {
                pw.print(tabs + "\t<parameterValueExpression>");
                pw.println("" + ReportWriter.getCDATAString(f.getParameterValueExpression(), tabs.length() + 1) + "</parameterValueExpression>");
            }
            pw.println(tabs + "</crosstabParameter>");
        }
    }

    void writeXMLHyperlinkParameters(List parameters, PrintWriter pw, String tabs) {
        Iterator e = parameters.iterator();
        if (parameters.size() > 0) {
            pw.println("");
        }
        while (e.hasNext()) {
            JRLinkParameter f = (JRLinkParameter)e.next();
            pw.println(tabs + "<hyperlinkParameter name=\"" + f.getName() + "\">");
            pw.print(tabs + "\t<hyperlinkParameterExpression");
            if (f.getType() != null && !f.getType().equals("java.lang.String")) {
                pw.print(" class=\"" + f.getType() + "\"");
            }
            pw.print(">");
            pw.println("" + ReportWriter.getCDATAString(f.getExpression(), tabs.length() + 1) + "</hyperlinkParameterExpression>");
            pw.println(tabs + "</hyperlinkParameter>");
        }
    }

    void writeXMLGroups(Vector groups, PrintWriter pw, boolean writeAll, int tabCount) {
        if (groups.size() > 0) {
            pw.println("");
        }
        for (int i = 0; i < groups.size(); ++i) {
            int t;
            Group grp = (Group)groups.elementAt(i);
            for (t = 0; t < tabCount; ++t) {
                pw.print("\t");
            }
            pw.print("<group ");
            pw.print(" name=\"" + grp.getName() + "\"");
            if (grp.isIsStartNewColumn()) {
                pw.print(" isStartNewColumn=\"" + grp.isIsStartNewColumn() + "\"");
            }
            if (grp.isIsStartNewPage()) {
                pw.print(" isStartNewPage=\"" + grp.isIsStartNewPage() + "\"");
            }
            if (grp.isIsResetPageNumber()) {
                pw.print(" isResetPageNumber=\"" + grp.isIsResetPageNumber() + "\"");
            }
            if (grp.isIsReprintHeaderOnEachPage()) {
                pw.print(" isReprintHeaderOnEachPage=\"" + grp.isIsReprintHeaderOnEachPage() + "\"");
            }
            if (grp.getMinHeightToStartNewPage() != 0) {
                pw.print(" minHeightToStartNewPage=\"" + grp.getMinHeightToStartNewPage() + "\"");
            }
            pw.println(" >");
            pw.print("\t\t\t<groupExpression");
            pw.println(">" + ReportWriter.getCDATAString(grp.getGroupExpression(), tabCount + 1) + "</groupExpression>");
            if (writeAll) {
                pw.println("\t\t\t<groupHeader>");
                this.writeXMLBand(grp.getGroupHeader(), pw);
                pw.println("\t\t\t</groupHeader>");
                pw.println("\t\t\t<groupFooter>");
                this.writeXMLBand(grp.getGroupFooter(), pw);
                pw.println("\t\t\t</groupFooter>");
            }
            for (t = 0; t < tabCount; ++t) {
                pw.print("\t");
            }
            pw.println("</group>");
        }
    }

    void writeXMLStyles(Vector styles, PrintWriter pw, String tabs) {
        Enumeration e = styles.elements();
        if (styles.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            Style style = (Style)e.nextElement();
            if (style instanceof UndefinedStyle) continue;
            String tabs2 = tabs;
            if (CompatibilitySupport.version >= 120 && style instanceof ConditionedStyle) {
                pw.println(tabs2 + "<conditionalStyle>");
                tabs = tabs + "\t";
                pw.print(tabs + "<conditionExpression");
                pw.println(">" + ReportWriter.getCDATAString(((ConditionedStyle)style).getCondition(), tabs2.length() + 1) + "</conditionExpression>");
            }
            pw.println(tabs + "<style ");
            for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
                if (!style.getAttributes().containsKey(Style.JRXMLStyleAttributes[i]) || style.getAttributes().get(Style.JRXMLStyleAttributes[i]) == null || Style.JRXMLStyleAttributes[i].equals("markup") && CompatibilitySupport.version < 205 || CompatibilitySupport.version < 204 && (Style.JRXMLStyleAttributes[i].equals("border") || Style.JRXMLStyleAttributes[i].equals("borderColor") || Style.JRXMLStyleAttributes[i].equals("padding") || Style.JRXMLStyleAttributes[i].equals("topBorder") || Style.JRXMLStyleAttributes[i].equals("topBorderColor") || Style.JRXMLStyleAttributes[i].equals("topPadding") || Style.JRXMLStyleAttributes[i].equals("leftBorder") || Style.JRXMLStyleAttributes[i].equals("leftBorderColor") || Style.JRXMLStyleAttributes[i].equals("leftPadding") || Style.JRXMLStyleAttributes[i].equals("bottomBorder") || Style.JRXMLStyleAttributes[i].equals("bottomBorderColor") || Style.JRXMLStyleAttributes[i].equals("bottomPadding") || Style.JRXMLStyleAttributes[i].equals("rightBorder") || Style.JRXMLStyleAttributes[i].equals("rightBorderColor") || Style.JRXMLStyleAttributes[i].equals("rightPadding"))) continue;
                Object obj = style.getAttributes().get(Style.JRXMLStyleAttributes[i]);
                String value = "" + obj;
                if (obj instanceof Color) {
                    value = ReportWriter.writeEncodedColor((Color)obj);
                }
                if (Style.JRXMLStyleAttributes[i].toLowerCase().endsWith("color") && value.startsWith("[")) {
                    try {
                        value = ReportWriter.writeEncodedColor(ColorSelectorPanel.parseColorString(value));
                    }
                    catch (Exception ex) {
                        value = "black";
                    }
                }
                if (Style.JRXMLStyleAttributes[i].equals("style") && (value == null || value.trim().length() == 0) || Style.JRXMLStyleAttributes[i].equals("markup") && (value == null || value.trim().length() == 0)) continue;
                pw.println(tabs + "\t" + Style.JRXMLStyleAttributes[i] + "=\"" + value + "\"");
            }
            if (CompatibilitySupport.version < 120) {
                pw.println(tabs + "/>");
            } else {
                pw.println(tabs + ">");
                if (CompatibilitySupport.version >= 204) {
                    if (style.getPen() != null) {
                        this.writeXMLPen(style.getPen(), pw);
                    }
                    if (style.getBox() != null) {
                        this.writeXMLBox(style.getBox(), pw);
                    }
                }
                if (style.getConditionedStyles().size() > 0) {
                    this.writeXMLStyles(style.getConditionedStyles(), pw, tabs + "\t");
                }
                pw.println(tabs + "</style>");
            }
            if (CompatibilitySupport.version < 120 || !(style instanceof ConditionedStyle)) continue;
            pw.println(tabs2 + "</conditionalStyle>");
        }
    }

    void writeXMLBand(Band band, PrintWriter pw) {
        pw.print("\t\t\t<band height=\"" + band.getHeight() + "\" ");
        pw.print(" isSplitAllowed=\"" + band.isSplitAllowed() + "\" ");
        pw.println(">");
        if (band.getPrintWhenExpression().trim().length() > 0) {
            pw.print("\t\t\t\t<printWhenExpression");
            pw.println(">" + ReportWriter.getCDATAString(band.getPrintWhenExpression(), 4) + "</printWhenExpression>");
        }
        this.writeBandElements(pw, band, null);
        pw.println("\t\t\t</band>");
    }

    public void writeBandElements(PrintWriter pw, Band band, ReportElement parent) {
        String actualElementGroup = "";
        for (ReportElement re : this.getReport().getElements()) {
            if (re.band != band || re.getParentElement() != parent) continue;
            actualElementGroup = this.writeOpenCloseGroup(pw, re.getElementGroup(), actualElementGroup);
            this.writeXMLReportElement(re, pw);
        }
        this.writeOpenCloseGroup(pw, "", actualElementGroup);
    }

    public String writeOpenCloseGroup(PrintWriter pw, String newGroup, String oldGroup) {
        if (oldGroup.equals(newGroup)) {
            return newGroup;
        }
        while (!newGroup.startsWith(oldGroup) && oldGroup.length() > 0) {
            pw.println("\t\t\t\t</elementGroup><!-- End " + oldGroup + " !-->");
            if (oldGroup.lastIndexOf(".") >= 0) {
                oldGroup = oldGroup.substring(0, oldGroup.lastIndexOf("."));
                continue;
            }
            oldGroup = "";
        }
        String remainNewGroup = newGroup;
        if (oldGroup.length() > 0 && newGroup.startsWith(oldGroup)) {
            remainNewGroup = newGroup.substring(oldGroup.length());
            while (remainNewGroup.startsWith(".")) {
                remainNewGroup = remainNewGroup.substring(1);
            }
        }
        String groupName = remainNewGroup;
        while (remainNewGroup.length() > 0) {
            pw.print("\t\t\t\t<elementGroup>");
            if (remainNewGroup.indexOf(".") >= 0) {
                groupName = (oldGroup.length() > 0 ? oldGroup + "." : "") + remainNewGroup.substring(0, remainNewGroup.indexOf("."));
                oldGroup = remainNewGroup.substring(0, remainNewGroup.indexOf("."));
                remainNewGroup = remainNewGroup.substring(remainNewGroup.indexOf(".") + 1);
            } else {
                groupName = (oldGroup.length() > 0 ? oldGroup + "." : "") + remainNewGroup;
                remainNewGroup = "";
            }
            pw.println("<!--  Start: " + groupName + " !-->");
        }
        return newGroup;
    }

    void writeXMLReportElement(ReportElement re, PrintWriter pw) {
        if (re instanceof StaticTextReportElement) {
            pw.println("\t\t\t\t<staticText>");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLBox(((TextReportElement)re).getBox(), pw);
            this.writeXMLTextElementElement((TextReportElement)re, pw);
            pw.println("\t\t\t\t<text>" + ReportWriter.getCDATAString(((StaticTextReportElement)re).getText(), 4) + "</text>");
            pw.println("\t\t\t\t</staticText>");
        } else if (re instanceof FrameReportElement) {
            FrameReportElement fre = (FrameReportElement)re;
            pw.print("\t\t\t\t<frame>");
            this.writeXMLReportElementElement(fre, pw);
            this.writeXMLBox(fre.getBox(), pw);
            if (re instanceof FrameReportElement) {
                this.writeBandElements(pw, re.getBand(), re);
            }
            pw.print("\t\t\t\t</frame>");
        } else if (re instanceof TextFieldReportElement) {
            TextFieldReportElement tfre = (TextFieldReportElement)re;
            pw.print("\t\t\t\t<textField");
            pw.print(" isStretchWithOverflow=\"" + tfre.isStretchWithOverflow() + "\"");
            if (tfre.getPropertyValue("PATTERN") != null) {
                pw.print(" pattern=\"" + tfre.getPattern() + "\"");
            }
            pw.print(" isBlankWhenNull=\"" + tfre.isBlankWhenNull() + "\"");
            pw.print(" evaluationTime=\"" + tfre.getEvaluationTime() + "\"");
            if (tfre.getEvaluationTime().equals("Group")) {
                pw.print(" evaluationGroup=\"" + tfre.getGroup() + "\" ");
            }
            pw.print(" hyperlinkType=\"" + tfre.getHyperlinkType() + "\" ");
            if (CompatibilitySupport.version >= 62) {
                pw.print(" hyperlinkTarget=\"" + tfre.getHyperlinkTarget() + "\" ");
            }
            if (CompatibilitySupport.version >= 100 && tfre.getBookmarkLevel() != 0) {
                pw.print(" bookmarkLevel=\"" + tfre.getBookmarkLevel() + "\" ");
            }
            pw.println(">");
            this.writeXMLReportElementElement(tfre, pw);
            this.writeXMLBox(((TextReportElement)re).getBox(), pw);
            this.writeXMLTextElementElement(tfre, pw);
            pw.print("\t\t\t\t<textFieldExpression ");
            if (tfre.getClassExpression().length() > 0) {
                pw.print("  class=\"" + tfre.getClassExpression() + "\"");
            }
            pw.println(">" + ReportWriter.getCDATAString(((TextFieldReportElement)re).getText(), 4) + "</textFieldExpression>");
            this.writeHyperLinkExpressions(tfre, pw);
            pw.println("\t\t\t\t</textField>");
        } else if (re instanceof ImageReportElement) {
            ImageReportElement ire = (ImageReportElement)re;
            pw.print("\t\t\t\t<image ");
            if (ire.getPropertyValue("SCALE") != null) {
                pw.print(" scaleImage=\"" + ire.getScaleImage() + "\"");
            }
            if (ire.getPropertyValue("VERTICAL_ALIGN") != null) {
                pw.print(" vAlign=\"" + ire.getVerticalAlignment() + "\"");
            }
            if (ire.getPropertyValue("HORIZONTAL_ALIGN") != null) {
                pw.print(" hAlign=\"" + ire.getHorizontalAlignment() + "\"");
            }
            if (CompatibilitySupport.version >= 65 && ire.isIsLazy()) {
                pw.print(" isLazy=\"" + ire.isIsLazy() + "\"");
            }
            if (CompatibilitySupport.version >= 103 && !ire.getOnErrorType().equals("Error")) {
                pw.print(" onErrorType=\"" + ire.getOnErrorType() + "\"");
            }
            if (ire.getPropertyValue("USING_CACHE") != null) {
                pw.print(" isUsingCache=\"" + ire.isIsUsingCache() + "\"");
            }
            pw.print(" evaluationTime=\"" + ire.getEvaluationTime() + "\"");
            if (((ImageReportElement)re).getEvaluationTime().equals("Group")) {
                pw.print(" evaluationGroup=\"" + ire.getEvaluationGroup() + "\" ");
            }
            pw.print(" hyperlinkType=\"" + ire.getHyperlinkType() + "\" ");
            if (CompatibilitySupport.version >= 62) {
                pw.print(" hyperlinkTarget=\"" + ire.getHyperlinkTarget() + "\" ");
            }
            if (CompatibilitySupport.version >= 100 && ire.getBookmarkLevel() != 0) {
                pw.print(" bookmarkLevel=\"" + ire.getBookmarkLevel() + "\" ");
            }
            pw.println(">");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLBox(((ImageReportElement)re).getBox(), pw);
            this.writeXMLGraphicElement(ire, pw);
            if (re instanceof ChartReportElement) {
                pw.print("\t\t\t\t\t<imageExpression class=\"java.awt.Image\"");
                pw.print(">" + ReportWriter.getCDATAString(this.writeChartExpression((ChartReportElement)re), 5) + "</imageExpression>\n");
            } else {
                pw.print("\t\t\t\t\t<imageExpression class=\"" + ire.getImageClass() + "\"");
                pw.println(">" + ReportWriter.getCDATAString(ire.getImageExpression(), 5) + "</imageExpression>");
            }
            this.writeHyperLinkExpressions(ire, pw);
            pw.println("\t\t\t\t</image>");
        } else if (re instanceof LineReportElement) {
            LineReportElement lre = (LineReportElement)re;
            pw.println("\t\t\t\t<line direction=\"" + lre.getDirection() + "\">");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLGraphicElement(lre, pw);
            pw.println("\t\t\t\t</line>");
        } else if (re instanceof BreakReportElement) {
            if (CompatibilitySupport.version >= 129) {
                BreakReportElement lre = (BreakReportElement)re;
                pw.print("\t\t\t\t<break");
                if (!lre.getType().equals("Page")) {
                    pw.print(" type=\"" + lre.getType() + "\"");
                }
                pw.println(">");
                this.writeXMLReportElementElement(re, pw);
                pw.println("\t\t\t\t</break>");
            }
        } else if (re instanceof RectangleReportElement) {
            RectangleReportElement rre = (RectangleReportElement)re;
            pw.print("\t\t\t\t<rectangle");
            if (rre.getPropertyValue("RADIUS") != null) {
                pw.print(" radius=\"" + rre.getRadius() + "\" ");
            }
            pw.println(">");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLGraphicElement(rre, pw);
            pw.println("\t\t\t\t</rectangle>");
        } else if (re instanceof EllipseReportElement) {
            EllipseReportElement ere = (EllipseReportElement)re;
            pw.println("\t\t\t\t<ellipse>");
            this.writeXMLReportElementElement(ere, pw);
            this.writeXMLGraphicElement(ere, pw);
            pw.println("\t\t\t\t</ellipse>");
        } else if (re instanceof SubReportElement) {
            SubReportElement sre = (SubReportElement)re;
            pw.println("\t\t\t\t<subreport  isUsingCache=\"" + sre.isIsUsingCache() + "\">");
            this.writeXMLReportElementElement(re, pw);
            if (sre.getParametersMapExpression() != null && sre.getParametersMapExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t<parametersMapExpression");
                pw.println(">" + ReportWriter.getCDATAString(sre.getParametersMapExpression(), 5) + "</parametersMapExpression>");
            }
            Enumeration e = sre.getSubreportParameters().elements();
            while (e.hasMoreElements()) {
                JRSubreportParameter je = (JRSubreportParameter)e.nextElement();
                pw.println("\t\t\t\t\t<subreportParameter  name=\"" + je.getName() + "\">");
                pw.print("\t\t\t\t\t\t<subreportParameterExpression");
                pw.println(">" + ReportWriter.getCDATAString(je.getExpression(), 6) + "</subreportParameterExpression>");
                pw.println("\t\t\t\t\t</subreportParameter>");
            }
            if (sre.isUseConnection() && sre.getConnectionExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t<connectionExpression");
                pw.println(">" + ReportWriter.getCDATAString(sre.getConnectionExpression(), 5) + "</connectionExpression>");
            } else if (!sre.isUseConnection() && sre.getDataSourceExpression().length() > 0) {
                pw.print("\t\t\t\t\t<dataSourceExpression");
                pw.println(">" + ReportWriter.getCDATAString(sre.getDataSourceExpression(), 5) + "</dataSourceExpression>");
            }
            if (CompatibilitySupport.version >= 100) {
                Enumeration e_sr = sre.getReturnValues().elements();
                while (e_sr.hasMoreElements()) {
                    JRSubreportReturnValue jerv = (JRSubreportReturnValue)e_sr.nextElement();
                    pw.print("\t\t\t\t\t<returnValue");
                    if (jerv.getSubreportVariable() != null && jerv.getSubreportVariable().length() > 0) {
                        pw.print(" subreportVariable=\"" + jerv.getSubreportVariable() + "\"");
                    }
                    if (jerv.getToVariable() != null && jerv.getToVariable().length() > 0) {
                        pw.print(" toVariable=\"" + jerv.getToVariable() + "\"");
                    }
                    if (jerv.getCalculation() != null && !jerv.getCalculation().equals("Nothing")) {
                        pw.print(" calculation=\"" + jerv.getCalculation() + "\"");
                    }
                    if (jerv.getIncrementFactoryClass() != null && jerv.getIncrementFactoryClass().length() > 0) {
                        pw.print(" incrementerFactoryClass=\"" + jerv.getIncrementFactoryClass() + "\"");
                    }
                    pw.println("/>");
                }
            }
            if (sre.getSubreportExpression() != null && sre.getSubreportExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t<subreportExpression  class=\"" + sre.getSubreportExpressionClass() + "\"");
                pw.println(">" + ReportWriter.getCDATAString(sre.getSubreportExpression(), 5) + "</subreportExpression>");
            }
            pw.println("\t\t\t\t</subreport>");
        } else if (re instanceof ChartReportElement2) {
            this.writeChartElement((ChartReportElement2)re, pw);
        } else if (re instanceof CrosstabReportElement) {
            CrosstabReportElement cre = (CrosstabReportElement)re;
            if (CompatibilitySupport.version >= 111) {
                CrosstabCell cell;
                int i;
                pw.print("\t\t\t\t<crosstab ");
                if (!cre.isRepeatColumnHeaders()) {
                    pw.print("isRepeatColumnHeaders=\"" + cre.isRepeatColumnHeaders() + "\" ");
                }
                if (!cre.isRepeatRowHeaders()) {
                    pw.print("isRepeatRowHeaders=\"" + cre.isRepeatRowHeaders() + "\" ");
                }
                if (cre.getColumnBreakOffset() != 10) {
                    pw.print("columnBreakOffset=\"" + cre.getColumnBreakOffset() + "\" ");
                }
                if (CompatibilitySupport.version >= 132 && cre.getRunDirection() != null && !cre.getRunDirection().trim().equals("LTR")) {
                    pw.print("runDirection=\"" + cre.getRunDirection().trim() + "\" ");
                }
                pw.println(">");
                this.writeXMLReportElementElement(re, pw);
                this.writeXMLCrosstabParameters(cre.getCrosstabParameters(), pw, "\t\t\t\t\t");
                if (cre.getParametersMapExpression() != null && cre.getParametersMapExpression().trim().length() > 0) {
                    pw.print("\t\t\t\t\t<parametersMapExpression>");
                    pw.println(ReportWriter.getCDATAString(cre.getParametersMapExpression(), 5) + "</parametersMapExpression>");
                }
                if (cre.isUseDataset()) {
                    pw.print("\t\t\t\t\t<crosstabDataset");
                    if (cre.isPreSorted()) {
                        pw.print(" isDataPreSorted=\"" + cre.isPreSorted() + "\" ");
                    }
                    pw.println(">");
                    if (cre.getDataset() != null) {
                        this.writeDatasetDataset(cre.getDataset(), pw);
                    }
                    pw.println("\t\t\t\t\t</crosstabDataset>");
                }
                if (CompatibilitySupport.version >= 120) {
                    for (i = 0; i < cre.getCells().size(); ++i) {
                        cell = (CrosstabCell)cre.getCells().elementAt(i);
                        if (cell.getType() != 3) continue;
                        pw.print("\t\t\t\t\t<crosstabHeaderCell>");
                        this.writeXMLCrosstabCellcontents(cell, cre.getElements(), pw, "\t\t\t\t\t\t");
                        pw.print("\t\t\t\t\t</crosstabHeaderCell>");
                    }
                }
                this.writeXMLCrosstabRowGroups(cre.getRowGroups(), cre.getElements(), pw);
                this.writeXMLCrosstabColumnGroups(cre.getColumnGroups(), cre.getElements(), pw);
                this.writeXMLMeasures(cre.getMeasures(), pw, "\t\t\t\t\t");
                this.writeXMLCrosstabCells(cre.getCells(), cre.getElements(), pw, "\t\t\t\t\t");
                for (i = 0; i < cre.getCells().size(); ++i) {
                    cell = (CrosstabCell)cre.getCells().elementAt(i);
                    if (cell.getType() != 2) continue;
                    pw.print("\t\t\t\t\t<whenNoDataCell>");
                    this.writeXMLCrosstabCellcontents(cell, cre.getElements(), pw, "\t\t\t\t\t\t");
                    pw.print("\t\t\t\t\t</whenNoDataCell>");
                }
                pw.println("\t\t\t\t\t</crosstab>");
            }
        }
    }

    void writeXMLBox(Box box, PrintWriter pw) {
        if (CompatibilitySupport.version >= 63) {
            if (box == null) {
                return;
            }
            pw.print("\t\t\t\t\t<box");
            if (box.getLeftPadding() > 0) {
                pw.print(" leftPadding=\"" + box.getLeftPadding() + "\"");
            }
            if (box.getRightPadding() > 0) {
                pw.print(" rightPadding=\"" + box.getRightPadding() + "\"");
            }
            if (box.getTopPadding() > 0) {
                pw.print(" topPadding=\"" + box.getTopPadding() + "\"");
            }
            if (box.getBottomPadding() > 0) {
                pw.print(" bottomPadding=\"" + box.getBottomPadding() + "\"");
            }
            if (CompatibilitySupport.version < 204) {
                if (box.getTopBorder() != null) {
                    pw.print(" topBorder=\"" + box.getTopBorder() + "\"");
                }
                if (box.getTopBorderColor() != null) {
                    pw.print(" topBorderColor=\"" + ReportWriter.writeEncodedColor(box.getTopBorderColor()) + "\"");
                }
                if (box.getLeftBorder() != null) {
                    pw.print(" leftBorder=\"" + box.getLeftBorder() + "\"");
                }
                if (box.getLeftBorderColor() != null) {
                    pw.print(" leftBorderColor=\"" + ReportWriter.writeEncodedColor(box.getLeftBorderColor()) + "\"");
                }
                if (box.getRightBorder() != null) {
                    pw.print(" rightBorder=\"" + box.getRightBorder() + "\"");
                }
                if (box.getRightBorderColor() != null) {
                    pw.print(" rightBorderColor=\"" + ReportWriter.writeEncodedColor(box.getRightBorderColor()) + "\"");
                }
                if (box.getBottomBorder() != null) {
                    pw.print(" bottomBorder=\"" + box.getBottomBorder() + "\"");
                }
                if (box.getBottomBorderColor() != null) {
                    pw.print(" bottomBorderColor=\"" + ReportWriter.writeEncodedColor(box.getBottomBorderColor()) + "\"");
                }
            }
            if (CompatibilitySupport.version >= 204) {
                pw.print(">");
                if (box.getPen() != null) {
                    this.writeXMLPen(box.getPen(), pw);
                }
                if (box.getTopPen() != null) {
                    this.writeXMLPen(box.getTopPen(), pw, "topPen");
                }
                if (box.getLeftPen() != null) {
                    this.writeXMLPen(box.getLeftPen(), pw, "leftPen");
                }
                if (box.getBottomPen() != null) {
                    this.writeXMLPen(box.getBottomPen(), pw, "bottomPen");
                }
                if (box.getRightPen() != null) {
                    this.writeXMLPen(box.getRightPen(), pw, "rightPen");
                }
                pw.println("</box>");
            } else {
                pw.println("/>");
            }
        }
    }

    void writeFontElement(IReportFont font, PrintWriter pw) {
        if (font == null) {
            return;
        }
        pw.print("\t\t\t\t\t<font");
        IReportFont base = this.getReport().getReportFontByName(font.getReportFont());
        if (font.getReportFont() != null && font.getReportFont().length() > 0) {
            pw.print(" reportFont=\"" + font.getReportFont() + "\"");
        }
        if (!(base != null && base.getFontName().equals(font.getFontName()) || font.getFontName() == null || font.getFontName().length() <= 0)) {
            pw.print(" fontName=\"" + font.getFontName() + "\"");
        }
        if (!(base != null && base.getPDFFontName().equals(font.getPDFFontName()) || font.getPDFFontName() == null || font.getPDFFontName().length() <= 0)) {
            pw.print(" pdfFontName=\"" + font.getPDFFontName() + "\"");
        }
        if (base == null || base.getFontSize() != font.getFontSize()) {
            pw.print(" size=\"" + font.getFontSize() + "\"");
        }
        if (base == null || base.isBold() != font.isBold()) {
            pw.print(" isBold=\"" + (font.isBold() ? "true" : "false") + "\"");
        }
        if (base == null || base.isItalic() != font.isItalic()) {
            pw.print(" isItalic=\"" + (font.isItalic() ? "true" : "false") + "\"");
        }
        if (base == null || base.isUnderline() != font.isUnderline()) {
            pw.print(" isUnderline=\"" + (font.isUnderline() ? "true" : "false") + "\"");
        }
        if (base == null || base.isStrikeTrought() != font.isStrikeTrought()) {
            pw.print(" isStrikeThrough=\"" + (font.isStrikeTrought() ? "true" : "false") + "\"");
        }
        if (base == null || base.isPdfEmbedded() != font.isPdfEmbedded()) {
            pw.print(" isPdfEmbedded=\"" + (font.isPdfEmbedded() ? "true" : "false") + "\"");
        }
        if (!(base != null && base.getPdfEncoding().equals(font.getPdfEncoding()) || font.getPdfEncoding() == null || font.getPdfEncoding().length() <= 0)) {
            pw.print(" pdfEncoding=\"" + font.getPdfEncoding() + "\"");
        }
        pw.println("/>");
    }

    void writeXMLReportElementElement(ReportElement re, PrintWriter pw) {
        pw.print("\t\t\t\t\t<reportElement");
        if (CompatibilitySupport.version >= 111 && re.getStyle() != null) {
            pw.print("\n\t\t\t\t\t\tstyle=\"" + re.getStyle() + "\"");
        }
        if (re.getPropertyValue("MODE") != null) {
            pw.print("\n\t\t\t\t\t\tmode=\"" + re.getTransparent() + "\"");
        }
        int position_x = re.getPosition().x;
        position_x = re.getParentElement() != null ? (position_x -= re.getParentElement().getPosition().x) : (re.getCell() != null ? position_x - re.getCell().getLeft() - 10 : position_x - this.getReport().getLeftMargin() - 10);
        pw.print("\n\t\t\t\t\t\tx=\"" + position_x + "\"");
        int position_y = re.getPosition().y;
        position_y = re.getParentElement() != null ? (position_y -= re.getParentElement().getPosition().y) : (re.getCell() != null ? position_y - re.getCell().getTop() - 10 : position_y - 10 - this.getReport().getBandYLocation(re.getBand()));
        pw.print("\n\t\t\t\t\t\ty=\"" + position_y + "\"");
        pw.print("\n\t\t\t\t\t\twidth=\"" + re.getWidth() + "\"");
        pw.print("\n\t\t\t\t\t\theight=\"" + re.getHeight() + "\"");
        if (re.getColorValue("FGCOLOR", null) != null) {
            pw.print("\n\t\t\t\t\t\tforecolor=\"" + ReportWriter.writeEncodedColor(re.getColorValue("FGCOLOR", null)) + "\"");
        }
        if (re.getColorValue("BGCOLOR", null) != null) {
            pw.print("\n\t\t\t\t\t\tbackcolor=\"" + ReportWriter.writeEncodedColor(re.getColorValue("BGCOLOR", null)) + "\"");
        }
        if (!re.getKey().equals("")) {
            pw.print("\n\t\t\t\t\t\tkey=\"" + re.getKey() + "\"");
        }
        if (!re.getStretchType().equals("NoStretch")) {
            pw.print("\n\t\t\t\t\t\tstretchType=\"" + re.getStretchType() + "\"");
        }
        if (!re.getPositionType().equals("FixRelativeToTop")) {
            pw.print("\n\t\t\t\t\t\tpositionType=\"" + re.getPositionType() + "\"");
        }
        if (!re.isIsPrintRepeatedValues()) {
            pw.print("\n\t\t\t\t\t\tisPrintRepeatedValues=\"" + re.isIsPrintRepeatedValues() + "\"");
        }
        if (re.isIsRemoveLineWhenBlank()) {
            pw.print("\n\t\t\t\t\t\tisRemoveLineWhenBlank=\"" + re.isIsRemoveLineWhenBlank() + "\"");
        }
        if (re.isIsPrintInFirstWholeBand()) {
            pw.print("\n\t\t\t\t\t\tisPrintInFirstWholeBand=\"" + re.isIsPrintInFirstWholeBand() + "\"");
        }
        if (re.getPrintWhenGroupChanges() != null && re.getPrintWhenGroupChanges().trim().length() > 0) {
            pw.print("\n\t\t\t\t\t\tprintWhenGroupChanges=\"" + re.getPrintWhenGroupChanges() + "\"");
        }
        if (re.isIsPrintWhenDetailOverflows()) {
            pw.print("\n\t\t\t\t\t\tisPrintWhenDetailOverflows=\"" + re.isIsPrintWhenDetailOverflows() + "\"");
        }
        boolean closeTag = false;
        if (re.getPrintWhenExpression().length() > 0) {
            pw.println(">");
            pw.print("\t\t\t\t\t\t\t<printWhenExpression");
            pw.println(">" + ReportWriter.getCDATAString(re.getPrintWhenExpression(), 7) + "</printWhenExpression>");
            closeTag = true;
        }
        if (CompatibilitySupport.version >= 203 && re.getElementProperties() != null && re.getElementProperties().size() > 0) {
            if (!closeTag) {
                pw.println(">");
            }
            this.writeXMLProperties(re.getElementProperties(), false, pw, "\t\t\t\t\t\t\t");
            closeTag = true;
        }
        if (closeTag) {
            pw.println("\t\t\t\t\t\t</reportElement>");
        } else {
            pw.println("/>");
        }
    }

    public static String getCDATAString(String string, int tabCount) {
        String CRLF = System.getProperty("line.separator");
        String tab = "";
        for (int i = 0; i < tabCount; ++i) {
            tab = tab + "\t";
        }
        return "<![CDATA[" + string + "]]>";
    }

    void writeXMLGraphicElement(GraphicReportElement re, PrintWriter pw) {
        pw.print("\t\t\t\t\t<graphicElement");
        pw.print(" stretchType=\"" + re.getStretchType() + "\"");
        if (CompatibilitySupport.version < 204) {
            if (re.getPropertyValue("PEN") != null) {
                pw.print(" pen=\"" + re.getGraphicElementPen() + "\"");
            }
        }
        if (re.getPropertyValue("FILL") != null) {
            pw.print(" fill=\"" + re.getFill() + "\" ");
        }
        if (CompatibilitySupport.version >= 204) {
            if (re.getPen() != null) {
                pw.println(">");
                this.writeXMLPen(re.getPen(), pw);
                pw.println("</graphicElement>");
            } else {
                pw.println("/>");
            }
        } else {
            pw.println("/>");
        }
    }

    public void writeXMLPen(Pen pen, PrintWriter pw) {
        this.writeXMLPen(pen, pw, "pen");
    }

    public void writeXMLPen(Pen pen, PrintWriter pw, String tagName) {
        pw.print("\t\t\t\t\t<" + tagName);
        pw.print(" lineWidth=\"" + pen.getLineWidth() + "\"");
        if (pen.getLineStyle() != null && !pen.getLineStyle().equals("null")) {
            pw.print(" lineStyle=\"" + pen.getLineStyle() + "\"");
        }
        if (pen.getLineColor() != null) {
            pw.print(" lineColor=\"" + ReportWriter.writeEncodedColor(pen.getLineColor()) + "\"");
        }
        pw.println("/>");
    }

    void writeXMLCrosstabRowGroups(Vector crosstabRowGroups, Vector crosstabElements, PrintWriter pw) {
        for (int i = 0; i < crosstabRowGroups.size(); ++i) {
            CrosstabRowGroup group = (CrosstabRowGroup)crosstabRowGroups.elementAt(i);
            pw.print("\t\t\t\t\t<rowGroup");
            pw.print(" name=\"" + group.getName() + "\"");
            pw.print(" width=\"" + group.getWidth() + "\"");
            if (!group.getTotalPosition().equals("None")) {
                pw.print(" totalPosition=\"" + group.getTotalPosition() + "\"");
            }
            if (!group.getHeaderPosition().equals("Top")) {
                pw.print(" headerPosition=\"" + group.getHeaderPosition() + "\"");
            }
            pw.println(">");
            this.writeXMLBucket(group, pw);
            if (group.getHeaderCell().getHeight() > 0 && group.getHeaderCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabRowHeader>");
                this.writeXMLCrosstabCellcontents(group.getHeaderCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabRowHeader>");
            }
            if (group.getTotalCell().getHeight() > 0 && group.getTotalCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabTotalRowHeader>");
                this.writeXMLCrosstabCellcontents(group.getTotalCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabTotalRowHeader>");
            }
            pw.println("\t\t\t\t\t</rowGroup>");
        }
    }

    void writeXMLCrosstabColumnGroups(Vector crosstabColumnGroups, Vector crosstabElements, PrintWriter pw) {
        for (int i = 0; i < crosstabColumnGroups.size(); ++i) {
            CrosstabColumnGroup group = (CrosstabColumnGroup)crosstabColumnGroups.elementAt(i);
            pw.print("\t\t\t\t\t<columnGroup");
            pw.print(" name=\"" + group.getName() + "\"");
            pw.print(" height=\"" + group.getHeight() + "\"");
            if (!group.getTotalPosition().equals("None")) {
                pw.print(" totalPosition=\"" + group.getTotalPosition() + "\"");
            }
            if (!group.getHeaderPosition().equals("Left")) {
                pw.print(" headerPosition=\"" + group.getHeaderPosition() + "\"");
            }
            pw.println(">");
            this.writeXMLBucket(group, pw);
            if (group.getHeaderCell().getHeight() > 0 && group.getHeaderCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabColumnHeader>");
                this.writeXMLCrosstabCellcontents(group.getHeaderCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabColumnHeader>");
            }
            if (group.getTotalCell().getHeight() > 0 && group.getTotalCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabTotalColumnHeader>");
                this.writeXMLCrosstabCellcontents(group.getTotalCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabTotalColumnHeader>");
            }
            pw.println("\t\t\t\t\t</columnGroup>");
        }
    }

    void writeXMLCrosstabCellcontents(CrosstabCell cell, Vector elements, PrintWriter pw, String tabs) {
        pw.print("\t\t\t\t\t\t<cellContents");
        if (cell.getBackcolor() != null) {
            pw.print(" backcolor=\"" + ReportWriter.writeEncodedColor(cell.getBackcolor()) + "\"");
        }
        if (CompatibilitySupport.version >= 120) {
            pw.print(" mode=\"" + cell.getMode() + "\"");
        }
        if (CompatibilitySupport.version >= 120 && cell.getStyle() != null) {
            pw.print(" style=\"" + cell.getStyle() + "\"");
        }
        pw.println(">");
        if (cell.getBox() != null) {
            this.writeXMLBox(cell.getBox(), pw);
        }
        for (int i = 0; i < elements.size(); ++i) {
            ReportElement re = (ReportElement)elements.elementAt(i);
            if (re.getCell() != cell) continue;
            this.writeXMLReportElement(re, pw);
        }
        pw.println("\t\t\t\t\t\t</cellContents>");
    }

    void writeXMLCrosstabCells(Vector cells, Vector elements, PrintWriter pw, String tabs) {
        for (int i = 0; i < cells.size(); ++i) {
            CrosstabCell cell = (CrosstabCell)cells.elementAt(i);
            if (cell.getType() != 0) continue;
            pw.print(tabs + "<crosstabCell");
            pw.print(" width=\"" + cell.getWidth() + "\"");
            pw.print(" height=\"" + cell.getHeight() + "\"");
            if (cell.getRowTotalGroup().trim().length() > 0) {
                pw.print(" rowTotalGroup=\"" + cell.getRowTotalGroup() + "\"");
            }
            if (cell.getColumnTotalGroup().trim().length() > 0) {
                pw.print(" columnTotalGroup=\"" + cell.getColumnTotalGroup() + "\"");
            }
            pw.println(">");
            this.writeXMLCrosstabCellcontents(cell, elements, pw, tabs + "\t");
            pw.println(tabs + "</crosstabCell>");
        }
    }

    void writeXMLBucket(CrosstabGroup group, PrintWriter pw) {
        pw.print("\t\t\t\t\t\t<bucket");
        if (!group.getBucketOrder().equals("Ascending")) {
            pw.print(" order=\"" + group.getBucketOrder() + "\"");
        }
        pw.println(">");
        pw.print("\t\t\t\t\t\t\t<bucketExpression");
        pw.print(" class=\"" + group.getBucketExpressionClass() + "\"");
        pw.print(">");
        pw.print(ReportWriter.getCDATAString(group.getBucketExpression(), 8));
        pw.println("</bucketExpression>");
        if (group.getBucketComparatorExpression().trim().length() > 0) {
            pw.print("\t\t\t\t\t\t\t<comparatorExpression>");
            pw.print(ReportWriter.getCDATAString(group.getBucketComparatorExpression(), 8));
            pw.println("</comparatorExpression>");
        }
        pw.println("\t\t\t\t\t\t</bucket>");
    }

    void writeXMLTextElementElement(TextReportElement re, PrintWriter pw) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(0);
        pw.print("\t\t\t\t\t<textElement");
        if (re.getPropertyValue(TextReportElement.ALIGN) != null) {
            pw.print(" textAlignment=\"" + re.getAlign() + "\"");
        }
        if (re.getPropertyValue(TextReportElement.VERTICAL_ALIGN) != null) {
            pw.print(" verticalAlignment=\"" + re.getVerticalAlign() + "\"");
        }
        if (re.getPropertyValue(TextReportElement.ROTATE) != null) {
            pw.print(" rotation=\"" + re.getRotate() + "\"");
        }
        if (re.getPropertyValue(TextReportElement.IS_STYLED_TEXT) != null && re.isIsStyledText()) {
            pw.print(" isStyledText=\"true\"");
        }
        if (CompatibilitySupport.version >= 205 && re.getMarkup() != null && !re.getMarkup().equals("")) {
            pw.print(" markup=\"" + re.getMarkup() + "\"");
        }
        if (re.getPropertyValue(TextReportElement.LINE_SPACING) != null) {
            pw.print(" lineSpacing=\"" + re.getLineSpacing() + "\"");
        }
        pw.println(">");
        pw.print("\t\t\t\t\t\t<font");
        IReportFont font = null;
        if (re.getReportFont() != null && re.getReportFont().length() > 0) {
            for (int fn = 0; !(fn >= this.getReport().getFonts().size() || (font = (IReportFont)this.getReport().getFonts().elementAt(fn)) != null && font.getReportFont().equals(re.getReportFont())); ++fn) {
                font = null;
            }
            pw.print(" reportFont=\"" + re.getReportFont() + "\"");
        }
        if (!(font != null && font.getFontName().equals(re.getFontName()) || re.getIReportFont().getPropertyValue("fontName") == null)) {
            pw.print(" fontName=\"" + re.getFontName() + "\"");
        }
        if (!(font != null && font.getPDFFontName().equalsIgnoreCase(re.getPDFFontName()) || re.getIReportFont().getPropertyValue("PDFFontName") == null)) {
            pw.print(" pdfFontName=\"" + re.getPDFFontName() + "\"");
        }
        if ((font == null || font.getFontSize() != re.getFontSize()) && re.getIReportFont().getPropertyValue("fontSize") != null) {
            pw.print(" size=\"" + re.getFontSize() + "\"");
        }
        if ((font == null || font.isBold() != re.isBold()) && re.getIReportFont().getPropertyValue("bold") != null) {
            pw.print(" isBold=\"" + (re.isBold() ? "true" : "false") + "\"");
        }
        if ((font == null || font.isItalic() != re.isItalic()) && re.getIReportFont().getPropertyValue("italic") != null) {
            pw.print(" isItalic=\"" + (re.isItalic() ? "true" : "false") + "\"");
        }
        if ((font == null || font.isUnderline() != re.isUnderline()) && re.getIReportFont().getPropertyValue("underline") != null) {
            pw.print(" isUnderline=\"" + (re.isUnderline() ? "true" : "false") + "\"");
        }
        if ((font == null || font.isPdfEmbedded() != re.isPdfEmbedded()) && re.getIReportFont().getPropertyValue("pdfEmbedded") != null) {
            pw.print(" isPdfEmbedded =\"" + (re.isPdfEmbedded() ? "true" : "false") + "\"");
        }
        if ((font == null || font.getPdfEncoding() == null || font.getPdfEncoding().length() == 0) && re.getIReportFont().getPropertyValue("pdfEncoding") != null && re.getPdfEncoding().length() > 0) {
            pw.print(" pdfEncoding =\"" + re.getPdfEncoding() + "\"");
        }
        if ((font == null || font.isStrikeTrought() != re.isStrikeTrought()) && re.getIReportFont().getPropertyValue("strikeTrought") != null) {
            pw.print(" isStrikeThrough=\"" + (re.isStrikeTrought() ? "true" : "false") + "\" ");
        }
        pw.println("/>");
        pw.println("\t\t\t\t\t</textElement>");
    }

    public static String writeEncodedColor(Color c) {
        String nums = "0123456789ABCDEF";
        String s = "#";
        s = s + nums.charAt(c.getRed() / 16);
        s = s + nums.charAt(c.getRed() % 16);
        s = s + nums.charAt(c.getGreen() / 16);
        s = s + nums.charAt(c.getGreen() % 16);
        s = s + nums.charAt(c.getBlue() / 16);
        s = s + nums.charAt(c.getBlue() % 16);
        return s;
    }

    private String writeChartExpression(ChartReportElement chartElement) {
        String expression = "";
        expression = "(java.awt.Image)it.businesslogic.ireport.chart.DefaultChartFactory.drawChart(new String[]{";
        Properties props = chartElement.getProps();
        Iterator<Object> keys = props.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String key = "" + keys.next();
            String val = props.getProperty(key);
            if (i > 0) {
                expression = expression + ",";
            }
            val = Misc.string_replace("\\\"", "\"", val);
            expression = expression + "\"" + key + "=" + val + "\"";
            ++i;
        }
        expression = expression + "}, (it.businesslogic.ireport.IReportScriptlet)$P{REPORT_SCRIPTLET})";
        return expression;
    }

    private void writeChartElement(ChartReportElement2 chartElement, PrintWriter pw) {
        if (CompatibilitySupport.version >= 100) {
            String chartType = "";
            if (chartElement.getChart() instanceof PieChart) {
                chartType = "pieChart";
            } else if (chartElement.getChart() instanceof Pie3DChart) {
                chartType = "pie3DChart";
            } else if (chartElement.getChart() instanceof BarChart) {
                chartType = "barChart";
            } else if (chartElement.getChart() instanceof Bar3DChart) {
                chartType = "bar3DChart";
            } else if (chartElement.getChart() instanceof XYBarChart) {
                chartType = "xyBarChart";
            } else if (chartElement.getChart() instanceof StackedBarChart) {
                chartType = "stackedBarChart";
            } else if (chartElement.getChart() instanceof StackedBar3DChart) {
                chartType = "stackedBar3DChart";
            } else if (chartElement.getChart() instanceof LineChart) {
                chartType = "lineChart";
            } else if (chartElement.getChart() instanceof XYLineChart) {
                chartType = "xyLineChart";
            } else if (chartElement.getChart() instanceof AreaChart) {
                chartType = "areaChart";
            } else if (chartElement.getChart() instanceof StackedAreaChart) {
                chartType = "stackedAreaChart";
            } else if (chartElement.getChart() instanceof XYAreaChart) {
                chartType = "xyAreaChart";
            } else if (chartElement.getChart() instanceof ScatterChart) {
                chartType = "scatterChart";
            } else if (chartElement.getChart() instanceof BubbleChart) {
                chartType = "bubbleChart";
            } else if (chartElement.getChart() instanceof TimeSeriesChart) {
                chartType = "timeSeriesChart";
            } else if (chartElement.getChart() instanceof HighLowChart) {
                chartType = "highLowChart";
            } else if (chartElement.getChart() instanceof CandlestickChart) {
                chartType = "candlestickChart";
            } else if (chartElement.getChart() instanceof MeterChart) {
                chartType = "meterChart";
            } else if (chartElement.getChart() instanceof ThermometerChart) {
                chartType = "thermometerChart";
            } else if (chartElement.getChart() instanceof MultiAxisChart) {
                chartType = "multiAxisChart";
            }
            if (chartElement.getChart() instanceof StackedAreaChart && CompatibilitySupport.version < 131) {
                return;
            }
            pw.println("\t\t\t\t<" + chartType + ">");
            this.writeChartNode(chartElement, pw);
            this.writeDataset(chartElement, pw);
            this.writePlot(chartElement, pw);
            pw.println("\t\t\t\t</" + chartType + ">");
        }
    }

    private void writeChartNode(ChartReportElement2 chartElement, PrintWriter pw) {
        pw.print("\t\t\t\t\t<chart ");
        if (!chartElement.getChart().isShowLegend()) {
            pw.print("isShowLegend=\"false\" ");
        }
        if (!chartElement.getEvaluationTime().equals("Now")) {
            pw.print("evaluationTime=\"" + chartElement.getEvaluationTime() + "\" ");
        }
        if (!chartElement.getEvaluationGroup().equals("")) {
            pw.print("evaluationGroup=\"" + chartElement.getEvaluationGroup() + "\" ");
        }
        if (!chartElement.getChart().getHyperlinkType().equals("None")) {
            pw.print(" hyperlinkType=\"" + chartElement.getChart().getHyperlinkType() + "\" ");
        }
        if (!chartElement.getChart().getHyperlinkTarget().equals("None")) {
            pw.print(" hyperlinkTarget=\"" + chartElement.getChart().getHyperlinkTarget() + "\" ");
        }
        if (chartElement.getChart().getBookmarkLevel() != 0) {
            pw.print(" bookmarkLevel=\"" + chartElement.getChart().getBookmarkLevel() + "\" ");
        }
        if (chartElement.getChart().getCustomizerClass().length() != 0) {
            pw.print(" customizerClass=\"" + chartElement.getChart().getCustomizerClass() + "\" ");
        }
        if (CompatibilitySupport.version >= 205 && chartElement.getRenderType() != null && chartElement.getRenderType().length() != 0) {
            pw.print(" renderType=\"" + chartElement.getRenderType() + "\" ");
        }
        pw.println(">");
        this.writeXMLReportElementElement(chartElement, pw);
        this.writeXMLBox(chartElement.getBox(), pw);
        this.writeChartTitleNode(chartElement, pw);
        this.writeChartSubTitleNode(chartElement, pw);
        if (CompatibilitySupport.version >= 127) {
            this.writeChartLegendNode(chartElement, pw);
        }
        this.writeHyperLinkExpressions(chartElement.getChart(), pw);
        pw.println("\t\t\t\t\t</chart>");
    }

    private void writeSectionItemHyperLinkExpressions(SectionItemHyperlink hlink, boolean isItem, PrintWriter pw) {
        String tag = "sectionHyperlink";
        if (isItem) {
            tag = "itemHyperlink";
        }
        if (CompatibilitySupport.version >= 126) {
            pw.print("\t\t\t\t<" + tag + " ");
            if (hlink.getHyperlinkType() != null && !hlink.getHyperlinkType().equals("None") && hlink.getHyperlinkType().length() > 0) {
                pw.print("  hyperlinkType=\"" + hlink.getHyperlinkType() + "\"");
            }
            if (hlink.getHyperlinkTarget() != null && !hlink.getHyperlinkTarget().equals("Self")) {
                pw.print("  hyperlinkTarget=\"" + hlink.getHyperlinkTarget() + "\"");
            }
            pw.println(">");
            if (hlink.getHyperlinkType() != null && hlink.getHyperlinkType().length() > 0) {
                if (hlink.getHyperlinkReferenceExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkReferenceExpression>" + ReportWriter.getCDATAString(hlink.getHyperlinkReferenceExpression(), 6) + "</hyperlinkReferenceExpression>");
                }
                if (hlink.getHyperlinkAnchorExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkAnchorExpression>" + ReportWriter.getCDATAString(hlink.getHyperlinkAnchorExpression(), 6) + "</hyperlinkAnchorExpression>");
                }
                if (hlink.getHyperlinkPageExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkPageExpression>" + ReportWriter.getCDATAString(hlink.getHyperlinkPageExpression(), 6) + "</hyperlinkPageExpression>");
                }
                if (hlink.getHyperlinkTooltipExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkTooltipExpression>" + ReportWriter.getCDATAString(hlink.getHyperlinkTooltipExpression(), 6) + "</hyperlinkTooltipExpression>");
                }
                this.writeXMLHyperlinkParameters(hlink.getHyperlinkParameters(), pw, "\t\t\t\t\t\t");
            }
            pw.println("\t\t\t\t</" + tag + ">");
        }
    }

    private void writeHyperLinkExpressions(HyperLinkableReportElement hlink, PrintWriter pw) {
        if (hlink.getAnchorNameExpression() != null && hlink.getAnchorNameExpression().length() > 0) {
            pw.println("\t\t\t\t\t\t<anchorNameExpression>" + ReportWriter.getCDATAString(hlink.getAnchorNameExpression(), 6) + "</anchorNameExpression>");
        }
        if (hlink.getHyperlinkType() != null && hlink.getHyperlinkType().length() > 0) {
            if (hlink.getHyperlinkReferenceExpression().length() > 0) {
                pw.println("\t\t\t\t\t\t<hyperlinkReferenceExpression>" + ReportWriter.getCDATAString(hlink.getHyperlinkReferenceExpression(), 6) + "</hyperlinkReferenceExpression>");
            }
            if (hlink.getHyperlinkAnchorExpression().length() > 0) {
                pw.println("\t\t\t\t\t\t<hyperlinkAnchorExpression>" + ReportWriter.getCDATAString(hlink.getHyperlinkAnchorExpression(), 6) + "</hyperlinkAnchorExpression>");
            }
            if (hlink.getHyperlinkPageExpression().length() > 0) {
                pw.println("\t\t\t\t\t\t<hyperlinkPageExpression>" + ReportWriter.getCDATAString(hlink.getHyperlinkPageExpression(), 6) + "</hyperlinkPageExpression>");
            }
            if (CompatibilitySupport.version >= 126) {
                if (hlink.getTooltipExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkTooltipExpression>" + ReportWriter.getCDATAString(hlink.getTooltipExpression(), 6) + "</hyperlinkTooltipExpression>");
                }
                this.writeXMLHyperlinkParameters(hlink.getLinkParameters(), pw, "\t\t\t\t\t\t");
            }
        }
    }

    private void writeChartTitleNode(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getTitle().getTitleExpression().trim().length() > 0) {
            pw.print("\t\t\t\t\t\t<chartTitle ");
            if (!chartElement.getChart().getTitle().getPosition().equals("Top")) {
                pw.print("position=\"" + chartElement.getChart().getTitle().getPosition() + "\" ");
            }
            if (chartElement.getChart().getTitle().getColor() != null) {
                pw.print("color=\"" + ReportWriter.writeEncodedColor(chartElement.getChart().getTitle().getColor()) + "\" ");
            }
            pw.println(">");
            this.writeFontElement(chartElement.getChart().getTitle().getFont(), pw);
            pw.println("\t\t\t\t\t\t\t\t<titleExpression>" + ReportWriter.getCDATAString(chartElement.getChart().getTitle().getTitleExpression(), 8) + "</titleExpression>");
            pw.println("\t\t\t\t\t</chartTitle>");
        }
    }

    private void writeChartSubTitleNode(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getSubTitle().getTitleExpression().trim().length() > 0) {
            pw.print("\t\t\t\t\t\t<chartSubtitle ");
            if (chartElement.getChart().getSubTitle().getColor() != null) {
                pw.print("color=\"" + ReportWriter.writeEncodedColor(chartElement.getChart().getSubTitle().getColor()) + "\" ");
            }
            pw.println(">");
            this.writeFontElement(chartElement.getChart().getSubTitle().getFont(), pw);
            pw.println("\t\t\t\t\t\t\t\t<subtitleExpression>" + ReportWriter.getCDATAString(chartElement.getChart().getSubTitle().getTitleExpression(), 8) + "</subtitleExpression>");
            pw.println("\t\t\t\t\t</chartSubtitle>");
        }
    }

    private void writeChartLegendNode(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().isShowLegend()) {
            pw.print("\t\t\t\t\t\t<chartLegend ");
            if (chartElement.getChart().getLegend().getTextColor() != null) {
                pw.print("textColor=\"" + ReportWriter.writeEncodedColor(chartElement.getChart().getLegend().getTextColor()) + "\" ");
            }
            if (chartElement.getChart().getLegend().getBackgroundColor() != null) {
                pw.print("backgroundColor=\"" + ReportWriter.writeEncodedColor(chartElement.getChart().getLegend().getBackgroundColor()) + "\" ");
            }
            pw.println(">");
            this.writeFontElement(chartElement.getChart().getLegend().getFont(), pw);
            pw.println("\t\t\t\t\t</chartLegend>");
        }
    }

    private void writeDataset(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getDataset() instanceof PieDataset) {
            PieDataset pdataset = (PieDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<pieDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            pw.println("\t\t\t\t\t\t<keyExpression>" + ReportWriter.getCDATAString(pdataset.getKeyExpression(), 6) + "</keyExpression>");
            pw.println("\t\t\t\t\t\t<valueExpression>" + ReportWriter.getCDATAString(pdataset.getValueExpression(), 6) + "</valueExpression>");
            if (pdataset.getLabelExpression().trim().length() > 0) {
                pw.println("\t\t\t\t\t\t<labelExpression>" + ReportWriter.getCDATAString(pdataset.getLabelExpression(), 6) + "</labelExpression>");
            }
            this.writeSectionItemHyperLinkExpressions(pdataset.getSectionHyperLink(), false, pw);
            pw.println("\t\t\t\t\t</pieDataset>");
        } else if (chartElement.getChart().getDataset() instanceof CategoryDataset) {
            CategoryDataset pdataset = (CategoryDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<categoryDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getCategorySeries().size(); ++i) {
                this.writeCategorySeries((CategorySeries)pdataset.getCategorySeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</categoryDataset>");
        } else if (chartElement.getChart().getDataset() instanceof TimePeriodDataset) {
            TimePeriodDataset pdataset = (TimePeriodDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<timePeriodDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getTimePeriodSeries().size(); ++i) {
                this.writeTimePeriodSeries((TimePeriodSeries)pdataset.getTimePeriodSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</timePeriodDataset>");
        } else if (chartElement.getChart().getDataset() instanceof TimeSeriesDataset) {
            TimeSeriesDataset pdataset = (TimeSeriesDataset)chartElement.getChart().getDataset();
            pw.print("\t\t\t\t\t<timeSeriesDataset");
            if (!pdataset.getTimePeriod().equals("Day")) {
                pw.println(" timePeriod=\"" + pdataset.getTimePeriod() + "\"");
            }
            pw.println(">");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getTimeSeries().size(); ++i) {
                this.writeTimeSeries((TimeSeries)pdataset.getTimeSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</timeSeriesDataset>");
        } else if (chartElement.getChart().getDataset() instanceof XYDataset) {
            XYDataset pdataset = (XYDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<xyDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getXYSeries().size(); ++i) {
                this.writeXYSeries((XYSeries)pdataset.getXYSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</xyDataset>");
        } else if (chartElement.getChart().getDataset() instanceof XYZDataset) {
            XYZDataset pdataset = (XYZDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<xyzDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getXYZSeries().size(); ++i) {
                this.writeXYZSeries((XYZSeries)pdataset.getXYZSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</xyzDataset>");
        } else if (chartElement.getChart().getDataset() instanceof HighLowDataset) {
            HighLowDataset pdataset = (HighLowDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<highLowDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            pw.println("\t\t\t\t\t\t<seriesExpression>" + ReportWriter.getCDATAString(pdataset.getSeriesExpression(), 6) + "</seriesExpression>");
            pw.println("\t\t\t\t\t\t<dateExpression>" + ReportWriter.getCDATAString(pdataset.getDateExpression(), 6) + "</dateExpression>");
            pw.println("\t\t\t\t\t\t<highExpression>" + ReportWriter.getCDATAString(pdataset.getHighExpression(), 6) + "</highExpression>");
            pw.println("\t\t\t\t\t\t<lowExpression>" + ReportWriter.getCDATAString(pdataset.getLowExpression(), 6) + "</lowExpression>");
            pw.println("\t\t\t\t\t\t<openExpression>" + ReportWriter.getCDATAString(pdataset.getOpenExpression(), 6) + "</openExpression>");
            pw.println("\t\t\t\t\t\t<closeExpression>" + ReportWriter.getCDATAString(pdataset.getCloseExpression(), 6) + "</closeExpression>");
            pw.println("\t\t\t\t\t\t<volumeExpression>" + ReportWriter.getCDATAString(pdataset.getVolumeExpression(), 6) + "</volumeExpression>");
            this.writeSectionItemHyperLinkExpressions(pdataset.getItemHyperLink(), true, pw);
            pw.println("\t\t\t\t\t</highLowDataset>");
        } else if (chartElement.getChart().getDataset() instanceof ValueDataset) {
            ValueDataset pdataset = (ValueDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<valueDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            pw.println("\t\t\t\t\t\t<valueExpression>" + ReportWriter.getCDATAString(pdataset.getValueExpression(), 6) + "</valueExpression>");
            pw.println("\t\t\t\t\t</valueDataset>");
        }
    }

    private void writeCategorySeries(CategorySeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<categorySeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + ReportWriter.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<categoryExpression>" + ReportWriter.getCDATAString(cs.getCategoryExpression(), 7) + "</categoryExpression>");
        pw.println("\t\t\t\t\t\t\t<valueExpression>" + ReportWriter.getCDATAString(cs.getValueExpression(), 7) + "</valueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + ReportWriter.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</categorySeries>");
    }

    private void writeXYSeries(XYSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<xySeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + ReportWriter.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<xValueExpression>" + ReportWriter.getCDATAString(cs.getXValueExpression(), 7) + "</xValueExpression>");
        pw.println("\t\t\t\t\t\t\t<yValueExpression>" + ReportWriter.getCDATAString(cs.getYValueExpression(), 7) + "</yValueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + ReportWriter.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</xySeries>");
    }

    private void writeXYZSeries(XYZSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<xyzSeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + ReportWriter.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<xValueExpression>" + ReportWriter.getCDATAString(cs.getXValueExpression(), 7) + "</xValueExpression>");
        pw.println("\t\t\t\t\t\t\t<yValueExpression>" + ReportWriter.getCDATAString(cs.getYValueExpression(), 7) + "</yValueExpression>");
        if (cs.getZValueExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<zValueExpression>" + ReportWriter.getCDATAString(cs.getZValueExpression(), 7) + "</zValueExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</xyzSeries>");
    }

    private void writeTimePeriodSeries(TimePeriodSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<timePeriodSeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + ReportWriter.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<startDateExpression>" + ReportWriter.getCDATAString(cs.getStartDateExpression(), 7) + "</startDateExpression>");
        pw.println("\t\t\t\t\t\t\t<endDateExpression>" + ReportWriter.getCDATAString(cs.getEndDateExpression(), 7) + "</endDateExpression>");
        pw.println("\t\t\t\t\t\t\t<valueExpression>" + ReportWriter.getCDATAString(cs.getValueExpression(), 7) + "</valueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + ReportWriter.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</timePeriodSeries>");
    }

    private void writeTimeSeries(TimeSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<timeSeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + ReportWriter.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<timePeriodExpression>" + ReportWriter.getCDATAString(cs.getTimePeriodExpression(), 7) + "</timePeriodExpression>");
        pw.println("\t\t\t\t\t\t\t<valueExpression>" + ReportWriter.getCDATAString(cs.getValueExpression(), 7) + "</valueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + ReportWriter.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</timeSeries>");
    }

    private void writeDatasetDataset(Dataset dataset, PrintWriter pw) {
        pw.print("\t\t\t\t\t\t<dataset ");
        if (!dataset.getResetType().equals("Report")) {
            pw.print("resetType=\"" + dataset.getResetType() + "\" ");
        }
        if (!dataset.getResetGroup().equals("")) {
            pw.print("resetGroup=\"" + dataset.getResetGroup() + "\" ");
        }
        if (!dataset.getIncrementType().equals("None")) {
            pw.print("incrementType=\"" + dataset.getIncrementType() + "\" ");
        }
        if (!dataset.getIncrementGroup().equals("")) {
            pw.print("incrementGroup=\"" + dataset.getIncrementGroup() + "\" ");
        }
        pw.println(">");
        if (CompatibilitySupport.version >= 125 && dataset.getIncrementWhenExpression().length() > 0) {
            pw.println("\t\t\t\t\t\t\t<incrementWhenExpression>" + ReportWriter.getCDATAString(dataset.getIncrementWhenExpression().trim(), 9) + "</incrementWhenExpression>");
        }
        if (CompatibilitySupport.version >= 110 && dataset.getSubDataset() != null) {
            pw.println("\t\t\t\t\t\t\t<datasetRun subDataset=\"" + dataset.getSubDataset().getName() + "\">");
            if (dataset.getParametersMapExpression() != null && dataset.getParametersMapExpression().trim().length() > 0) {
                pw.println("\t\t\t\t\t\t\t\t<parametersMapExpression>" + ReportWriter.getCDATAString(dataset.getParametersMapExpression().trim(), 9) + "</parametersMapExpression>");
            }
            Enumeration e = dataset.getSubreportParameters().elements();
            while (e.hasMoreElements()) {
                JRSubreportParameter je = (JRSubreportParameter)e.nextElement();
                pw.println("\t\t\t\t\t\t\t\t<datasetParameter  name=\"" + je.getName() + "\">");
                pw.print("\t\t\t\t\t\t\t\t\t<datasetParameterExpression");
                pw.println(">" + ReportWriter.getCDATAString(je.getExpression(), 9) + "</datasetParameterExpression>");
                pw.println("\t\t\t\t\t\t\t\t</datasetParameter>");
            }
            if (dataset.isUseConnection() && dataset.getConnectionExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t\t\t\t<connectionExpression");
                pw.println(">" + ReportWriter.getCDATAString(dataset.getConnectionExpression(), 8) + "</connectionExpression>");
            } else if (!dataset.isUseConnection() && dataset.getDataSourceExpression().length() > 0) {
                pw.print("\t\t\t\t\t<dataSourceExpression");
                pw.println(">" + ReportWriter.getCDATAString(dataset.getDataSourceExpression(), 8) + "</dataSourceExpression>");
            }
            pw.println("\t\t\t\t\t\t\t</datasetRun>");
        }
        pw.println("\t\t\t\t\t\t</dataset>");
    }

    private void writePlot(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getPlot() instanceof PiePlot) {
            PiePlot plot = (PiePlot)chartElement.getChart().getPlot();
            pw.println("\t\t\t\t\t<piePlot ");
            if (CompatibilitySupport.version >= 200 && plot.isCircular()) {
                pw.print("isCircular=\"" + plot.isCircular() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            pw.println("\t\t\t\t\t</piePlot>");
        } else if (chartElement.getChart().getPlot() instanceof Pie3DPlot) {
            Pie3DPlot plot = (Pie3DPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<pie3DPlot ");
            if (CompatibilitySupport.version >= 200 && plot.isCircular()) {
                pw.print("isCircular=\"" + plot.isCircular() + "\" ");
            }
            if (plot.getDepthFactor() != 0.2) {
                pw.print("depthFactor=\"" + plot.getDepthFactor() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            pw.println("\t\t\t\t\t</pie3DPlot>");
        } else if (chartElement.getChart().getPlot() instanceof BarPlot) {
            BarPlot plot = (BarPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<barPlot ");
            if (plot.isShowLabels()) {
                pw.print("isShowLabels=\"" + plot.isShowLabels() + "\" ");
            }
            if (!plot.isShowTickMarks()) {
                pw.print("isShowTickMarks=\"" + plot.isShowTickMarks() + "\" ");
            }
            if (!plot.isShowTickLabels()) {
                pw.print("isShowTickLabels=\"" + plot.isShowTickLabels() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisFormat(), pw);
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("valueAxisFormat", plot.getValueAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</barPlot>");
        } else if (chartElement.getChart().getPlot() instanceof Bar3DPlot) {
            Bar3DPlot plot = (Bar3DPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<bar3DPlot ");
            if (plot.isShowLabels()) {
                pw.print("isShowLabels=\"" + plot.isShowLabels() + "\" ");
            }
            if (plot.getXOffset() != 12.0) {
                pw.print("xOffset=\"" + plot.getXOffset() + "\" ");
            }
            if (plot.getYOffset() != 8.0) {
                pw.print("yOffset=\"" + plot.getYOffset() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisFormat(), pw);
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("valueAxisFormat", plot.getValueAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</bar3DPlot>");
        } else if (chartElement.getChart().getPlot() instanceof LinePlot) {
            LinePlot plot = (LinePlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<linePlot ");
            if (!plot.isShowLines()) {
                pw.print("isShowLines=\"" + plot.isShowLines() + "\" ");
            }
            if (!plot.isShowShapes()) {
                pw.print("isShowShapes=\"" + plot.isShowShapes() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisFormat(), pw);
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("valueAxisFormat", plot.getValueAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</linePlot>");
        } else if (chartElement.getChart().getPlot() instanceof AreaPlot) {
            AreaPlot plot = (AreaPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<areaPlot>");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("categoryAxisFormat", plot.getCategoryAxisFormat(), pw);
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("valueAxisFormat", plot.getValueAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</areaPlot>");
        } else if (chartElement.getChart().getPlot() instanceof ScatterPlot) {
            ScatterPlot plot = (ScatterPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<scatterPlot ");
            if (!plot.isShowLines()) {
                pw.print("isShowLines=\"" + plot.isShowLines() + "\" ");
            }
            if (!plot.isShowShapes()) {
                pw.print("isShowShapes=\"" + plot.isShowShapes() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getXAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<xAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getXAxisLabelExpression(), 6) + "</xAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("xAxisFormat", plot.getXAxisFormat(), pw);
            }
            if (plot.getYAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<yAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getYAxisLabelExpression(), 6) + "</yAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("yAxisFormat", plot.getYAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</scatterPlot>");
        } else if (chartElement.getChart().getPlot() instanceof BubblePlot) {
            BubblePlot plot = (BubblePlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<bubblePlot ");
            if (!plot.getScaleType().equals("RangeAxis")) {
                pw.print("scaleType=\"" + plot.getScaleType() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getXAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<xAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getXAxisLabelExpression(), 6) + "</xAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("xAxisFormat", plot.getXAxisFormat(), pw);
            }
            if (plot.getYAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<yAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getYAxisLabelExpression(), 6) + "</yAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("yAxisFormat", plot.getYAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</bubblePlot>");
        } else if (chartElement.getChart().getPlot() instanceof TimeSeriesPlot) {
            TimeSeriesPlot plot = (TimeSeriesPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<timeSeriesPlot ");
            if (!plot.isShowLines()) {
                pw.print("isShowLines=\"" + plot.isShowLines() + "\" ");
            }
            if (!plot.isShowShapes()) {
                pw.print("isShowShapes=\"" + plot.isShowShapes() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getTimeAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<timeAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getTimeAxisLabelExpression(), 6) + "</timeAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisFormat(), pw);
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("valueAxisFormat", plot.getValueAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</timeSeriesPlot>");
        } else if (chartElement.getChart().getPlot() instanceof HighLowPlot) {
            HighLowPlot plot = (HighLowPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<highLowPlot ");
            if (!plot.isShowCloseTicks()) {
                pw.print("isShowCloseTicks=\"" + plot.isShowCloseTicks() + "\" ");
            }
            if (!plot.isShowOpenTicks()) {
                pw.print("isShowOpenTicks=\"" + plot.isShowOpenTicks() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getTimeAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<timeAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getTimeAxisLabelExpression(), 6) + "</timeAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisFormat(), pw);
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("valueAxisFormat", plot.getValueAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</highLowPlot>");
        } else if (chartElement.getChart().getPlot() instanceof CandlestickPlot) {
            CandlestickPlot plot = (CandlestickPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<candlestickPlot ");
            if (!plot.isShowVolume()) {
                pw.print("isShowVolume=\"" + plot.isShowVolume() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getTimeAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<timeAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getTimeAxisLabelExpression(), 6) + "</timeAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("timeAxisFormat", plot.getTimeAxisFormat(), pw);
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + ReportWriter.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            if (CompatibilitySupport.version >= 127) {
                this.writeAxisFormat("valueAxisFormat", plot.getValueAxisFormat(), pw);
            }
            pw.println("\t\t\t\t\t</candlestickPlot>");
        } else if (chartElement.getChart().getPlot() instanceof MeterPlot && CompatibilitySupport.version >= 127) {
            MeterPlot plot = (MeterPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<meterPlot ");
            if (plot.getShape() != null && !plot.getShape().equals("pie")) {
                pw.print("shape=\"" + plot.getShape() + "\" ");
            }
            if (plot.getAngle() != 180) {
                pw.print("angle=\"" + plot.getAngle() + "\" ");
            }
            if (plot.getUnits() != null && plot.getUnits().trim().length() > 0) {
                pw.print("units=\"" + Misc.xmlEscape(plot.getUnits()) + "\" ");
            }
            if (plot.getTickInterval() != 10.0) {
                pw.print("tickInterval=\"" + plot.getTickInterval() + "\" ");
            }
            if (plot.getMeterColor() != null) {
                pw.print("meterColor=\"" + ReportWriter.writeEncodedColor(plot.getMeterColor()) + "\" ");
            }
            if (plot.getNeedleColor() != null) {
                pw.print("needleColor=\"" + ReportWriter.writeEncodedColor(plot.getNeedleColor()) + "\" ");
            }
            if (plot.getTickColor() != null) {
                pw.print("tickColor=\"" + ReportWriter.writeEncodedColor(plot.getTickColor()) + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            this.writeValueDisplay(plot.getValueDisplay(), pw);
            this.writeDataRange(plot.getDataRange(), pw);
            for (int interval_c = 0; interval_c < plot.getMeterIntervals().size(); ++interval_c) {
                this.writeMeterInterval((MeterInterval)plot.getMeterIntervals().get(interval_c), pw);
            }
            pw.println("\t\t\t\t\t</meterPlot>");
        } else if (chartElement.getChart().getPlot() instanceof ThermometerPlot && CompatibilitySupport.version >= 127) {
            ThermometerPlot plot = (ThermometerPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<thermometerPlot ");
            if (plot.getValueLocation() != null && !plot.getValueLocation().equals("bulb")) {
                pw.print("valueLocation=\"" + plot.getValueLocation() + "\" ");
            }
            if (plot.isShowValueLines()) {
                pw.print("isShowValueLines=\"" + plot.isShowValueLines() + "\" ");
            }
            if (plot.getMercuryColor() != null) {
                pw.print("mercuryColor=\"" + ReportWriter.writeEncodedColor(plot.getMercuryColor()) + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            this.writeValueDisplay(plot.getValueDisplay(), pw);
            this.writeDataRange(plot.getDataRange(), pw);
            this.writeDataRange("lowRange", plot.getLowRange(), pw);
            this.writeDataRange("mediumRange", plot.getMediumRange(), pw);
            this.writeDataRange("highRange", plot.getHighRange(), pw);
            pw.println("\t\t\t\t\t</thermometerPlot>");
        } else if (chartElement.getChart().getPlot() instanceof MultiAxisPlot && CompatibilitySupport.version >= 127) {
            MultiAxisPlot plot = (MultiAxisPlot)chartElement.getChart().getPlot();
            pw.println("\t\t\t\t\t<multiAxisPlot>");
            this.writePlotPlot(chartElement, pw);
            for (int axis_c = 0; axis_c < plot.getAxis().size(); ++axis_c) {
                this.writeAxis((Axis)plot.getAxis().get(axis_c), pw);
            }
            pw.println("\t\t\t\t\t</multiAxisPlot>");
        }
    }

    private void writePlotPlot(ChartReportElement2 chartElement, PrintWriter pw) {
        pw.print("\t\t\t\t\t\t<plot ");
        if (chartElement.getChart().getPlot().getBackcolor() != null) {
            pw.print("backcolor=\"" + ReportWriter.writeEncodedColor(chartElement.getChart().getPlot().getBackcolor()) + "\" ");
        }
        if (!chartElement.getChart().getPlot().getOrientation().equals("Vertical")) {
            pw.print("orientation=\"" + chartElement.getChart().getPlot().getOrientation() + "\" ");
        }
        if (chartElement.getChart().getPlot().getBackgroundAlpha() != 1.0) {
            pw.print("backgroundAlpha=\"" + chartElement.getChart().getPlot().getBackgroundAlpha() + "\" ");
        }
        if (chartElement.getChart().getPlot().getForegroundAlpha() != 1.0) {
            pw.print("foregroundAlpha=\"" + chartElement.getChart().getPlot().getForegroundAlpha() + "\" ");
        }
        if (chartElement.getChart().getPlot().getLabelRotation() != 0.0 && CompatibilitySupport.version >= 127) {
            pw.print("labelRotation=\"" + chartElement.getChart().getPlot().getLabelRotation() + "\" ");
        }
        if (chartElement.getChart().getPlot().getSeriesColors().size() > 0 && CompatibilitySupport.version >= 127) {
            pw.println(">");
            for (int i = 0; i < chartElement.getChart().getPlot().getSeriesColors().size(); ++i) {
                SeriesColor sc = (SeriesColor)chartElement.getChart().getPlot().getSeriesColors().get(i);
                pw.println("\t\t\t\t\t\t\t<seriesColor seriesOrder=\"" + sc.getSeriesOrder() + "\" color=\"" + ReportWriter.writeEncodedColor(sc.getColor()) + "\"/>");
            }
            pw.println("</plot>");
        } else {
            pw.println("/>");
        }
    }

    private void writeAxisFormat(String axisName, AxisFormat axisFormat, PrintWriter pw) {
        if (axisFormat == null) {
            return;
        }
        pw.println("\t\t\t\t\t\t<" + axisName + ">");
        pw.print("\t\t\t\t\t\t\t<axisFormat ");
        if (axisFormat.getLabelColor() != null) {
            pw.print("labelColor=\"" + ReportWriter.writeEncodedColor(axisFormat.getLabelColor()) + "\" ");
        }
        if (axisFormat.getTickLabelColor() != null) {
            pw.print("tickLabelColor=\"" + ReportWriter.writeEncodedColor(axisFormat.getTickLabelColor()) + "\" ");
        }
        if (axisFormat.getTickLabelMask().trim().length() > 0) {
            pw.print("tickLabelMask=\"" + Misc.xmlEscape(axisFormat.getTickLabelMask()) + "\" ");
        }
        if (axisFormat.getAxisLineColor() != null) {
            pw.print("axisLineColor=\"" + ReportWriter.writeEncodedColor(axisFormat.getAxisLineColor()) + "\" ");
        }
        pw.println(">");
        if (axisFormat.getLabelFont() != null) {
            pw.println("\t\t\t\t\t\t\t\t<labelFont>");
            this.writeFontElement(axisFormat.getLabelFont(), pw);
            pw.println("\t\t\t\t\t\t\t\t</labelFont>");
        }
        if (axisFormat.getLabelFont() != null) {
            pw.println("\t\t\t\t\t\t\t\t<tickLabelFont>");
            this.writeFontElement(axisFormat.getTickLabelFont(), pw);
            pw.println("\t\t\t\t\t\t\t\t</tickLabelFont>");
        }
        pw.println("\t\t\t\t\t\t\t</axisFormat>");
        pw.println("\t\t\t\t\t\t</" + axisName + ">");
    }

    private void writeValueDisplay(ValueDisplay valueDisplay, PrintWriter pw) {
        if (valueDisplay == null) {
            return;
        }
        pw.print("\t\t\t\t\t\t\t<valueDisplay ");
        if (valueDisplay.getColor() != null) {
            pw.print("color=\"" + ReportWriter.writeEncodedColor(valueDisplay.getColor()) + "\" ");
        }
        if (valueDisplay.getMask().trim().length() > 0) {
            pw.print("mask=\"" + Misc.xmlEscape(valueDisplay.getMask()) + "\" ");
        }
        pw.println(">");
        this.writeFontElement(valueDisplay.getFont(), pw);
        pw.println("\t\t\t\t\t\t\t</valueDisplay>");
    }

    private void writeDataRange(DataRange dataRange, PrintWriter pw) {
        this.writeDataRange(null, dataRange, pw);
    }

    private void writeDataRange(String outTagName, DataRange dataRange, PrintWriter pw) {
        if (dataRange == null) {
            return;
        }
        if (outTagName != null) {
            pw.println("\t\t\t\t\t\t<" + outTagName + ">");
        }
        pw.println("\t\t\t\t\t\t\t<dataRange>");
        pw.println("\t\t\t\t\t\t\t\t<lowExpression>" + ReportWriter.getCDATAString(dataRange.getLowExpression(), 8) + "</lowExpression>");
        pw.println("\t\t\t\t\t\t\t\t<highExpression>" + ReportWriter.getCDATAString(dataRange.getHighExpression(), 8) + "</highExpression>");
        pw.println("\t\t\t\t\t\t\t</dataRange>");
        if (outTagName != null) {
            pw.println("\t\t\t\t\t\t</" + outTagName + ">");
        }
    }

    private void writeMeterInterval(MeterInterval meterInterval, PrintWriter pw) {
        if (meterInterval == null) {
            return;
        }
        pw.print("\t\t\t\t\t\t\t<meterInterval ");
        if (meterInterval.getLabel().trim().length() > 0) {
            pw.print("label=\"" + Misc.xmlEscape(meterInterval.getLabel()) + "\" ");
        }
        if (meterInterval.getColor() != null) {
            pw.print("color=\"" + ReportWriter.writeEncodedColor(meterInterval.getColor()) + "\" ");
        }
        if (meterInterval.getAlpha() != 1.0) {
            pw.print("alpha=\"" + meterInterval.getAlpha() + "\" ");
        }
        pw.println(">");
        this.writeDataRange(meterInterval.getDataRange(), pw);
        pw.println("\t\t\t\t\t\t\t</meterInterval>");
    }

    private void writeAxis(Axis axis, PrintWriter pw) {
        if (axis == null) {
            return;
        }
        pw.print("\t\t\t\t\t\t\t<axis ");
        if (!axis.getPosition().equals("leftOrTop")) {
            pw.print("position=\"" + Misc.xmlEscape(axis.getPosition()) + "\" ");
        }
        pw.println(">");
        this.writeChartElement(axis.getChartReportElement(), pw);
        pw.println("\t\t\t\t\t\t\t</axis>");
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void writeXMLProperties(Collection collection, boolean filter, PrintWriter pw, String tabs) {
        for (JRProperty property : collection) {
            if (property.isExpression() || filter && property.getName().startsWith("chart.")) continue;
            pw.print(tabs + "<property name=\"" + Misc.xmlEscape(property.getName()) + "\" ");
            pw.println("value=\"" + Misc.xmlEscape(property.getValue()) + "\" />");
        }
        for (JRProperty property : collection) {
            if (!property.isExpression()) continue;
            pw.print(tabs + "<propertyExpression name=\"" + Misc.xmlEscape(property.getName()) + "\">");
            pw.print(ReportWriter.getCDATAString(property.getValue(), 0));
            pw.println(tabs + "</propertyExpression>");
        }
    }
}

