/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BoxElement;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.chart.Chart;
import it.businesslogic.ireport.gui.MainFrame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.util.List;

public class ChartReportElement2
extends ReportElement
implements BoxElement,
ImageObserver,
HyperLinkableReportElement {
    private Box box = null;
    private Chart chart = null;
    private String evaluationTime = "Now";
    private String evaluationGroup = "";
    private String tooltipExpression = "";
    private String renderType = null;

    public ChartReportElement2(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setBox(new Box());
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        this.box = box;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x += -10 + this.box.getLeftPadding();
        this.position.y += -10 + this.box.getTopPadding();
        this.width = this.width - this.box.getLeftPadding() - this.box.getRightPadding();
        this.height = this.height - this.box.getTopPadding() - this.box.getBottomPadding();
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        this.zoom_factor = zoom_factor;
        Image imgx = this.getChart().getChartImage();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        if (imgx != null) {
            int imageWidth = imgx.getWidth(this);
            int imageHeight = imgx.getHeight(this);
            g.drawImage(imgx, this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.position.x + this.width) - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin, 0, 0, imageWidth, imageHeight, null, this);
        }
        if (MainFrame.getMainInstance().getProperties().getProperty("Antialias", "true").equals("false")) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        }
        this.position.x += 10 - this.box.getLeftPadding();
        this.position.y += 10 - this.box.getTopPadding();
        this.width = this.width + this.box.getLeftPadding() + this.box.getRightPadding();
        this.height = this.height + this.box.getTopPadding() + this.box.getBottomPadding();
        super.drawBorder(g, zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
        this.drawBorder(g, zoom_factor, x_shift_origin, y_shift_origin, this.getBox());
    }

    public String getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(String evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        this.evaluationGroup = evaluationGroup;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public ReportElement cloneMe() {
        ChartReportElement2 newReportElement = new ChartReportElement2(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof ChartReportElement2 && source instanceof ChartReportElement2) {
            ((ChartReportElement2)destination).setBox(((ChartReportElement2)source).getBox().cloneMe());
            ((ChartReportElement2)destination).setChart(((ChartReportElement2)source).getChart().cloneMe());
            ((ChartReportElement2)destination).setEvaluationGroup(((ChartReportElement2)source).getEvaluationGroup());
            ((ChartReportElement2)destination).setEvaluationTime(((ChartReportElement2)source).getEvaluationTime());
        }
    }

    public String getAnchorNameExpression() {
        return this.getChart().getAnchorNameExpression();
    }

    public String getHyperlinkAnchorExpression() {
        return this.getChart().getHyperlinkAnchorExpression();
    }

    public String getHyperlinkPageExpression() {
        return this.getChart().getHyperlinkPageExpression();
    }

    public String getHyperlinkReferenceExpression() {
        return this.getChart().getHyperlinkReferenceExpression();
    }

    public String getHyperlinkTarget() {
        return this.getChart().getHyperlinkTarget();
    }

    public String getHyperlinkType() {
        return this.getChart().getHyperlinkType();
    }

    public void setAnchorNameExpression(String anchorNameExpression) {
        this.getChart().setAnchorNameExpression(anchorNameExpression);
    }

    public void setHyperlinkAnchorExpression(String hyperlinkAnchorExpression) {
        this.getChart().setHyperlinkAnchorExpression(hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(String hyperlinkPageExpression) {
        this.getChart().setHyperlinkPageExpression(hyperlinkPageExpression);
    }

    public void setHyperlinkReferenceExpression(String hyperlinkReferenceExpression) {
        this.getChart().setHyperlinkReferenceExpression(hyperlinkReferenceExpression);
    }

    public void setHyperlinkTarget(String hyperlinkTarget) {
        this.getChart().setHyperlinkTarget(hyperlinkTarget);
    }

    public void setHyperlinkType(String hyperlinkType) {
        this.getChart().setHyperlinkType(hyperlinkType);
    }

    public int getBookmarkLevel() {
        return this.getChart().getBookmarkLevel();
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.getChart().setBookmarkLevel(bookmarkLevel);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (style != null) {
            if (style.getAttributeString("border", null, true) != null) {
                this.getBox().setBorder(style.getAttributeString("border", null, true));
            }
            if (style.getAttributeColor("borderColor", null, true) != null) {
                this.getBox().setBorderColor(style.getAttributeColor("borderColor", null, true));
            }
            if (style.getAttributeString("padding", null, true) != null) {
                this.getBox().setPadding(Integer.parseInt(style.getAttributeString("padding", null, true)));
            }
            if (style.getAttributeString("topBorder", null, true) != null) {
                this.getBox().setTopBorder(style.getAttributeString("topBorder", null, true));
            }
            if (style.getAttributeColor("topBorderColor", null, true) != null) {
                this.getBox().setTopBorderColor(style.getAttributeColor("topBorderColor", null, true));
            }
            if (style.getAttributeString("topPadding", null, true) != null) {
                this.getBox().setTopPadding(Integer.parseInt(style.getAttributeString("topPadding", null, true)));
            }
            if (style.getAttributeString("leftBorder", null, true) != null) {
                this.getBox().setLeftBorder(style.getAttributeString("leftBorder", null, true));
            }
            if (style.getAttributeColor("leftBorderColor", null, true) != null) {
                this.getBox().setLeftBorderColor(style.getAttributeColor("leftBorderColor", null, true));
            }
            if (style.getAttributeString("leftPadding", null, true) != null) {
                this.getBox().setLeftPadding(Integer.parseInt(style.getAttributeString("leftPadding", null, true)));
            }
            if (style.getAttributeString("rightBorder", null, true) != null) {
                this.getBox().setRightBorder(style.getAttributeString("rightBorder", null, true));
            }
            if (style.getAttributeColor("rightBorderColor", null, true) != null) {
                this.getBox().setRightBorderColor(style.getAttributeColor("rightBorderColor", null, true));
            }
            if (style.getAttributeString("rightPadding", null, true) != null) {
                this.getBox().setRightPadding(Integer.parseInt(style.getAttributeString("rightPadding", null, true)));
            }
            if (style.getAttributeString("bottomBorder", null, true) != null) {
                this.getBox().setBottomBorder(style.getAttributeString("bottomBorder", null, true));
            }
            if (style.getAttributeColor("bottomBorderColor", null, true) != null) {
                this.getBox().setBottomBorderColor(style.getAttributeColor("bottomBorderColor", null, true));
            }
            if (style.getAttributeString("bottomPadding", null, true) != null) {
                this.getBox().setBottomPadding(Integer.parseInt(style.getAttributeString("bottomPadding", null, true)));
            }
        }
    }

    public List getLinkParameters() {
        return this.getChart().getLinkParameters();
    }

    public void setLinkParameters(List linkParameters) {
        this.getChart().setLinkParameters(linkParameters);
    }

    public String getTooltipExpression() {
        return this.tooltipExpression;
    }

    public void setTooltipExpression(String tooltipExpression) {
        this.tooltipExpression = tooltipExpression;
    }

    public String getRenderType() {
        return this.renderType;
    }

    public void setRenderType(String renderType) {
        this.renderType = renderType;
    }
}

