/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Byte;;
import [Ljava.lang.Character;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Short;;
import [Ljava.math.BigDecimal;;
import groovy.lang.GString;
import groovy.lang.MetaMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class CachedClass {
    private CachedClass cachedSuperClass;
    private static final MetaMethod[] EMPTY = new MetaMethod[0];
    int hashCode;
    private Reflector reflector;
    private CachedField[] fields;
    private CachedConstructor[] constructors;
    private CachedMethod[] methods;
    private final Class cachedClass;
    private MetaMethod[] newMetaMethods = EMPTY;
    public CachedMethod[] mopMethods;
    public static final CachedClass[] EMPTY_ARRAY = new CachedClass[0];
    private Set ownInterfaces;
    private Set interfaces;
    public final boolean isArray;
    public final boolean isPrimitive;
    public final int modifiers;
    int distance = -1;
    public final boolean isInterface;
    public final boolean isNumber;

    public Set getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new HashSet(0);
            if (this.getCachedClass().isInterface()) {
                this.interfaces.add(this);
            }
            Class<?>[] classes = this.getCachedClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                CachedClass aClass = ReflectionCache.getCachedClass(classes[i]);
                if (this.interfaces.contains(aClass)) continue;
                this.interfaces.addAll(aClass.getInterfaces());
            }
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                this.interfaces.addAll(superClass.getInterfaces());
            }
        }
        return this.interfaces;
    }

    public Set getOwnInterfaces() {
        if (this.ownInterfaces == null) {
            this.ownInterfaces = new HashSet(0);
            if (this.getCachedClass().isInterface()) {
                this.ownInterfaces.add(this);
            }
            Class<?>[] classes = this.getCachedClass().getInterfaces();
            for (int i = 0; i < classes.length; ++i) {
                CachedClass aClass = ReflectionCache.getCachedClass(classes[i]);
                if (this.ownInterfaces.contains(aClass)) continue;
                this.ownInterfaces.addAll(aClass.getInterfaces());
            }
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                this.ownInterfaces.addAll(superClass.getInterfaces());
            }
        }
        return this.ownInterfaces;
    }

    CachedClass(Class klazz) {
        this.cachedClass = klazz;
        this.isArray = klazz.isArray();
        this.isPrimitive = klazz.isPrimitive();
        this.modifiers = klazz.getModifiers();
        this.isInterface = klazz.isInterface();
        this.isNumber = Number.class.isAssignableFrom(klazz);
    }

    public synchronized CachedClass getCachedSuperClass() {
        if (this.cachedSuperClass == null) {
            this.cachedSuperClass = !this.isArray ? ReflectionCache.getCachedClass(this.getCachedClass().getSuperclass()) : (this.cachedClass.getComponentType().isPrimitive() || this.cachedClass.getComponentType() == Object.class ? ReflectionCache.OBJECT_CLASS : ReflectionCache.OBJECT_ARRAY_CLASS);
        }
        return this.cachedSuperClass;
    }

    public synchronized CachedMethod[] getMethods() {
        if (this.methods == null) {
            Method[] declaredMethods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getCachedClass().getDeclaredMethods();
                }
            });
            ArrayList<CachedMethod> methods = new ArrayList<CachedMethod>(declaredMethods.length);
            ArrayList<CachedMethod> mopMethods = new ArrayList<CachedMethod>(declaredMethods.length);
            for (int i = 0; i != declaredMethods.length; ++i) {
                CachedMethod cachedMethod = new CachedMethod(this, declaredMethods[i]);
                String name = cachedMethod.getName();
                if (name.indexOf(43) >= 0) continue;
                if (name.startsWith("this$") || name.startsWith("super$")) {
                    mopMethods.add(cachedMethod);
                    continue;
                }
                methods.add(cachedMethod);
            }
            this.methods = methods.toArray(new CachedMethod[methods.size()]);
            Arrays.sort(this.methods);
            CachedClass superClass = this.getCachedSuperClass();
            if (superClass != null) {
                superClass.getMethods();
                CachedMethod[] superMopMethods = superClass.mopMethods;
                for (int i = 0; i != superMopMethods.length; ++i) {
                    mopMethods.add(superMopMethods[i]);
                }
            }
            this.mopMethods = mopMethods.toArray(new CachedMethod[mopMethods.size()]);
            Arrays.sort(this.mopMethods, CachedMethodComparatorByName.INSTANCE);
        }
        return this.methods;
    }

    public synchronized CachedField[] getFields() {
        if (this.fields == null) {
            Field[] declaredFields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getCachedClass().getDeclaredFields();
                }
            });
            this.fields = new CachedField[declaredFields.length];
            for (int i = 0; i != this.fields.length; ++i) {
                this.fields[i] = new CachedField(this, declaredFields[i]);
            }
        }
        return this.fields;
    }

    public synchronized CachedConstructor[] getConstructors() {
        if (this.constructors == null) {
            Constructor[] declaredConstructors = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CachedClass.this.getCachedClass().getDeclaredConstructors();
                }
            });
            this.constructors = new CachedConstructor[declaredConstructors.length];
            for (int i = 0; i != this.constructors.length; ++i) {
                this.constructors[i] = new CachedConstructor(this, declaredConstructors[i]);
            }
        }
        return this.constructors;
    }

    public CachedMethod searchMethods(String name, CachedClass[] parameterTypes) {
        CachedMethod[] methods = this.getMethods();
        CachedMethod res = null;
        for (int i = 0; i < methods.length; ++i) {
            CachedMethod m = methods[i];
            if (!m.getName().equals(name) || !ReflectionCache.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            res = m;
        }
        return res;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    protected Object coerceGString(Object argument) {
        if (this.getCachedClass() != String.class) {
            return argument;
        }
        if (!(argument instanceof GString)) {
            return argument;
        }
        return argument.toString();
    }

    protected Object coerceNumber(Object argument) {
        if (argument instanceof Number && (this.isNumber || this.isPrimitive)) {
            Object oldArgument = argument;
            boolean wasDouble = false;
            boolean wasFloat = false;
            Class param = this.getCachedClass();
            if (param == Byte.class || param == Byte.TYPE) {
                argument = new Byte(((Number)argument).byteValue());
            } else if (param == Double.class || param == Double.TYPE) {
                wasDouble = true;
                argument = new Double(((Number)argument).doubleValue());
            } else if (param == Float.class || param == Float.TYPE) {
                wasFloat = true;
                argument = new Float(((Number)argument).floatValue());
            } else if (param == Integer.class || param == Integer.TYPE) {
                argument = new Integer(((Number)argument).intValue());
            } else if (param == Long.class || param == Long.TYPE) {
                argument = new Long(((Number)argument).longValue());
            } else if (param == Short.class || param == Short.TYPE) {
                argument = new Short(((Number)argument).shortValue());
            } else if (param == BigDecimal.class) {
                argument = new BigDecimal(String.valueOf((Number)argument));
            } else if (param == BigInteger.class) {
                argument = new BigInteger(String.valueOf((Number)argument));
            }
            if (oldArgument instanceof BigDecimal) {
                BigDecimal oldbd = (BigDecimal)oldArgument;
                boolean throwException = false;
                if (wasDouble) {
                    Double d = (Double)argument;
                    if (d.isInfinite()) {
                        throwException = true;
                    }
                } else if (wasFloat) {
                    Float f = (Float)argument;
                    if (f.isInfinite()) {
                        throwException = true;
                    }
                } else {
                    BigDecimal newbd = new BigDecimal(String.valueOf((Number)argument));
                    boolean bl = throwException = !oldArgument.equals(newbd);
                }
                if (throwException) {
                    throw new IllegalArgumentException(param + " out of range while converting from BigDecimal");
                }
            }
        }
        return argument;
    }

    protected Object coerceArray(Object argument) {
        if (!this.isArray) {
            return argument;
        }
        Class<?> argumentClass = argument.getClass();
        if (!argumentClass.isArray()) {
            return argument;
        }
        Class<?> argumentComponent = argumentClass.getComponentType();
        Class<?> paramComponent = this.getCachedClass().getComponentType();
        if (paramComponent.isPrimitive()) {
            if (paramComponent == Boolean.TYPE && argumentClass == Boolean;.class) {
                argument = DefaultTypeTransformation.convertToBooleanArray(argument);
            } else if (paramComponent == Byte.TYPE && argumentClass == Byte;.class) {
                argument = DefaultTypeTransformation.convertToByteArray(argument);
            } else if (paramComponent == Character.TYPE && argumentClass == Character;.class) {
                argument = DefaultTypeTransformation.convertToCharArray(argument);
            } else if (paramComponent == Short.TYPE && argumentClass == Short;.class) {
                argument = DefaultTypeTransformation.convertToShortArray(argument);
            } else if (paramComponent == Integer.TYPE && argumentClass == Integer;.class) {
                argument = DefaultTypeTransformation.convertToIntArray(argument);
            } else if (paramComponent == Long.TYPE && (argumentClass == Long;.class || argumentClass == Integer;.class)) {
                argument = DefaultTypeTransformation.convertToLongArray(argument);
            } else if (paramComponent == Float.TYPE && (argumentClass == Float;.class || argumentClass == Integer;.class)) {
                argument = DefaultTypeTransformation.convertToFloatArray(argument);
            } else if (paramComponent == Double.TYPE && (argumentClass == Double;.class || argumentClass == Float;.class || BigDecimal;.class.isAssignableFrom(argumentClass))) {
                argument = DefaultTypeTransformation.convertToDoubleArray(argument);
            }
        } else if (paramComponent == String.class && argument instanceof GString[]) {
            GString[] strings = (GString[])argument;
            String[] ret = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ret[i] = strings[i].toString();
            }
            argument = ret;
        } else if (paramComponent == Object.class && argumentComponent.isPrimitive()) {
            argument = DefaultTypeTransformation.primitiveArrayBox(argument);
        }
        return argument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuperClassDistance() {
        Class clazz = this.getCachedClass();
        synchronized (clazz) {
            if (this.distance == -1) {
                int distance = 0;
                for (Class klazz = this.getCachedClass(); klazz != null; klazz = klazz.getSuperclass()) {
                    ++distance;
                }
                this.distance = distance;
            }
            return this.distance;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isVoid() {
        return this.getCachedClass() == Void.TYPE;
    }

    public void box(BytecodeHelper helper) {
        helper.box(this.getCachedClass());
    }

    public void unbox(BytecodeHelper helper) {
        helper.unbox(this.getCachedClass());
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void doCast(BytecodeHelper helper) {
        helper.doCast(this.getCachedClass());
    }

    public String getName() {
        return this.getCachedClass().getName();
    }

    public String getTypeDescription() {
        return BytecodeHelper.getTypeDescription(this.getCachedClass());
    }

    public synchronized Reflector getReflector() {
        return this.reflector;
    }

    public final Class getCachedClass() {
        return this.cachedClass;
    }

    public MetaMethod[] getNewMetaMethods() {
        return this.newMetaMethods;
    }

    public void setNewMopMethods(ArrayList arr) {
        this.newMetaMethods = arr.toArray(new MetaMethod[arr.size()]);
    }

    public String toString() {
        return this.cachedClass.toString();
    }

    public static class CachedMethodComparatorWithString
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorWithString();

        public int compare(Object o1, Object o2) {
            return ((CachedMethod)o1).getName().compareTo((String)o2);
        }
    }

    public static class CachedMethodComparatorByName
    implements Comparator {
        public static final Comparator INSTANCE = new CachedMethodComparatorByName();

        public int compare(Object o1, Object o2) {
            return ((CachedMethod)o1).getName().compareTo(((CachedMethod)o2).getName());
        }
    }
}

