/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ZlibInflate {
    private final Ruby runtime;
    private Inflater flater = new Inflater(false);
    private ByteList collected = new ByteList(100);
    public static final int BASE_SIZE = 100;

    public ZlibInflate(IRubyObject caller2) {
        this.runtime = caller2.getRuntime();
    }

    public static IRubyObject s_inflate(IRubyObject caller2, ByteList str) throws DataFormatException {
        ZlibInflate zstream = new ZlibInflate(caller2);
        IRubyObject result = zstream.inflate(str);
        zstream.finish();
        zstream.close();
        return result;
    }

    public Inflater getInflater() {
        return this.flater;
    }

    public void append(IRubyObject obj) {
        this.append(obj.convertToString().getByteList());
    }

    public void append(ByteList obj) {
        this.collected.append(obj);
    }

    public IRubyObject sync_point() {
        return this.runtime.getFalse();
    }

    public IRubyObject set_dictionary(IRubyObject str) throws UnsupportedEncodingException {
        this.flater.setDictionary(str.convertToString().getBytes());
        return str;
    }

    public IRubyObject inflate(ByteList str) throws DataFormatException {
        if (null != str) {
            this.append(str);
        }
        ByteList result = new ByteList(this.collected.realSize);
        byte[] outp = new byte[65536];
        ByteList buf = this.collected;
        this.collected = new ByteList(100);
        int resultLength = -1;
        try {
            this.flater.setInput(buf.bytes, buf.begin, buf.realSize);
            while (!this.flater.finished() && resultLength != 0) {
                resultLength = this.flater.inflate(outp);
                result.append(outp, 0, resultLength);
                if (resultLength != outp.length) continue;
                outp = new byte[outp.length * 2];
            }
        }
        catch (DataFormatException e) {
            this.flater = new Inflater(true);
            this.flater.setInput(buf.bytes, buf.begin, buf.realSize);
            while (!this.flater.finished() && resultLength != 0) {
                resultLength = this.flater.inflate(outp);
                result.append(outp, 0, resultLength);
                if (resultLength != outp.length) continue;
                outp = new byte[outp.length * 2];
            }
        }
        return RubyString.newString(this.runtime, result);
    }

    public IRubyObject sync(IRubyObject str) {
        this.append(str);
        return this.runtime.getFalse();
    }

    public void finish() {
        this.flater.end();
    }

    public void close() {
    }
}

