/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaMethod"})
public class JavaMethod
extends JavaCallable {
    private final Method method;
    private final Class<?>[] parameterTypes;
    private final JavaUtil.JavaConverter returnConverter;

    public Object getValue() {
        return this.method;
    }

    public static RubyClass createJavaMethodClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaMethod", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(runtime2, result);
        JavaCallable.registerRubyMethods(runtime2, result);
        result.defineAnnotatedMethods(JavaMethod.class);
        return result;
    }

    public JavaMethod(Ruby runtime2, Method method2) {
        super(runtime2, runtime2.getJavaSupport().getJavaMethodClass());
        this.method = method2;
        this.parameterTypes = method2.getParameterTypes();
        if (Modifier.isPublic(method2.getModifiers()) && Modifier.isPublic(method2.getClass().getModifiers()) && !Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
            this.accessibleObject().setAccessible(true);
        }
        this.returnConverter = JavaUtil.getJavaConverter(method2.getReturnType());
    }

    public static JavaMethod create(Ruby runtime2, Method method2) {
        return new JavaMethod(runtime2, method2);
    }

    public static JavaMethod create(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            Method method2 = javaClass.getMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime2, method2);
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod createDeclared(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw runtime2.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod getMatchingDeclaredMethod(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            block2: for (Method method2 : javaClass.getDeclaredMethods()) {
                if (!method2.getName().equals(methodName)) continue;
                Class<?>[] targetTypes = method2.getParameterTypes();
                if (targetTypes.length == 0 && argumentTypes.length == 0) {
                    return JavaMethod.create(runtime2, method2);
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (i >= targetTypes.length || !targetTypes[i].isAssignableFrom(argumentTypes[i])) continue block2;
                }
                return JavaMethod.create(runtime2, method2);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaMethod && this.method == ((JavaMethod)other).method;
    }

    @Override
    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyString name() {
        return this.getRuntime().newString(this.method.getName());
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.method.getModifiers()));
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.method.getModifiers()));
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke(IRubyObject[] args2) {
        JavaProxyClass jpc;
        JavaProxyMethod jpm;
        if (args2.length != 1 + this.getArity()) {
            throw this.getRuntime().newArgumentError(args2.length, 1 + this.getArity());
        }
        Object[] arguments = new Object[args2.length - 1];
        this.convertArguments(this.getRuntime(), arguments, args2, 1);
        IRubyObject invokee = args2[0];
        if (invokee.isNil()) {
            return this.invokeWithExceptionHandling(this.method, null, arguments);
        }
        Object javaInvokee = JavaUtil.unwrapJavaObject(this.getRuntime(), invokee, "invokee not a java object").getValue();
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        if (javaInvokee instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers()) && (jpm = (jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && jpm.hasSuperImplementation()) {
            return this.invokeWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arguments);
        }
        return this.invokeWithExceptionHandling(this.method, javaInvokee, arguments);
    }

    public IRubyObject invoke(IRubyObject self, Object[] args2) {
        JavaProxyClass jpc;
        JavaProxyMethod jpm;
        if (args2.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args2.length, this.getArity());
        }
        if (!(self instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("invokee not a java object");
        }
        Object javaInvokee = ((JavaObject)self).getValue();
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        if (javaInvokee instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers()) && (jpm = (jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && jpm.hasSuperImplementation()) {
            return this.invokeWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, args2);
        }
        return this.invokeWithExceptionHandling(this.method, javaInvokee, args2);
    }

    @JRubyMethod(rest=true)
    public IRubyObject invoke_static(IRubyObject[] args2) {
        if (args2.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args2.length, this.getArity());
        }
        Object[] arguments = new Object[args2.length];
        System.arraycopy(args2, 0, arguments, 0, arguments.length);
        this.convertArguments(this.getRuntime(), arguments, args2, 0);
        return this.invokeWithExceptionHandling(this.method, null, arguments);
    }

    public IRubyObject invoke_static(Object[] args2) {
        if (args2.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args2.length, this.getArity());
        }
        return this.invokeWithExceptionHandling(this.method, null, args2);
    }

    @JRubyMethod
    public IRubyObject return_type() {
        Class<?> klass = this.method.getReturnType();
        if (klass.equals(Void.TYPE)) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), klass);
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.method.getTypeParameters());
    }

    private IRubyObject invokeWithExceptionHandling(Method method2, Object javaInvokee, Object[] arguments) {
        try {
            Object result = method2.invoke(javaInvokee, arguments);
            return this.returnConverter.convert(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("for method " + method2.getName() + " expected " + this.argument_types().inspect() + "; got: " + this.dumpArgTypes(arguments) + "; error: " + iae.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on '" + method2.getName() + "': " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
            return this.getRuntime().getNil();
        }
    }

    private String dumpArgTypes(Object[] arguments) {
        StringBuilder str = new StringBuilder("[");
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            if (arguments[i] == null) {
                str.append("null");
                continue;
            }
            str.append(arguments[i].getClass().getName());
        }
        str.append("]");
        return str.toString();
    }

    private void convertArguments(Ruby runtime2, Object[] arguments, Object[] args2, int from) {
        Class<?>[] types = this.parameterTypes;
        int i = arguments.length;
        while (--i >= 0) {
            arguments[i] = JavaUtil.convertArgument(runtime2, args2[i + from], types[i]);
        }
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    protected String nameOnInspection() {
        return "#<" + this.getType().toString() + "/" + this.method.getName() + "(";
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(this.isStatic());
    }

    public RubyBoolean bridge_p() {
        return this.getRuntime().newBoolean(this.method.isBridge());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.method.toGenericString();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.method;
    }
}

