/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaMethod
extends DynamicMethod
implements JumpTarget,
Cloneable {
    protected int arityValue;
    protected Arity arity;
    private Class[] argumentTypes;
    private String javaName;
    private boolean isSingleton;
    protected StaticScope staticScope;

    public JavaMethod(RubyModule implementationClass, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FRAME_ONLY);
        this.staticScope = null;
    }

    public JavaMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
        super(implementationClass, visibility, callConfig);
        this.staticScope = staticScope;
        this.arity = arity2;
        this.arityValue = arity2.getValue();
    }

    public JavaMethod(RubyModule implementationClass, Visibility visibility, int methodIndex) {
        super(implementationClass, visibility, CallConfiguration.FRAME_ONLY);
        this.staticScope = null;
    }

    protected JavaMethod() {
    }

    public void init(RubyModule implementationClass, Arity arity2, Visibility visibility, StaticScope staticScope, CallConfiguration callConfig) {
        this.staticScope = staticScope;
        this.arity = arity2;
        this.arityValue = arity2.getValue();
        super.init(implementationClass, visibility, callConfig);
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public DynamicMethod dup() {
        try {
            JavaMethod msm = (JavaMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    protected final void preFrameAndScope(ThreadContext context, IRubyObject self, String name2, Block block) {
        context.preMethodFrameAndScope(this.implementationClass, name2, self, block, this.staticScope);
    }

    protected final void preFrameAndDummyScope(ThreadContext context, IRubyObject self, String name2, Block block) {
        context.preMethodFrameAndDummyScope(this.implementationClass, name2, self, block, this.staticScope);
    }

    protected final void preFrameOnly(ThreadContext context, IRubyObject self, String name2, Block block) {
        context.preMethodFrameOnly(this.implementationClass, name2, self, block);
    }

    protected final void preScopeOnly(ThreadContext context) {
        context.preMethodScopeOnly(this.implementationClass, this.staticScope);
    }

    protected final void preBacktraceOnly(ThreadContext context, String name2) {
        context.preMethodBacktraceOnly(name2);
    }

    protected final void preBacktraceAndScope(ThreadContext context, String name2) {
        context.preMethodBacktraceAndScope(name2, this.implementationClass, this.staticScope);
    }

    protected final void postFrameAndScope(ThreadContext context) {
        context.postMethodFrameAndScope();
    }

    protected final void postFrameOnly(ThreadContext context) {
        context.postMethodFrameOnly();
    }

    protected final void postScopeOnly(ThreadContext context) {
        context.postMethodScopeOnly();
    }

    protected final void postBacktraceOnly(ThreadContext context) {
        context.postMethodBacktraceOnly();
    }

    protected final void postBacktraceAndScope(ThreadContext context) {
        context.postMethodBacktraceAndScope();
    }

    protected final void callTrace(ThreadContext context, String name2) {
        context.trace(RubyEvent.C_CALL, name2, this.getImplementationClass());
    }

    protected final void returnTrace(ThreadContext context, String name2) {
        context.trace(RubyEvent.C_CALL, name2, this.getImplementationClass());
    }

    public void setArity(Arity arity2) {
        this.arity = arity2;
        this.arityValue = arity2.getValue();
    }

    public Arity getArity() {
        return this.arity;
    }

    @Deprecated
    public void setArgumentTypes(Class[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    @Deprecated
    public Class[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isNative() {
        return true;
    }

    public static abstract class JavaMethodThreeBlock
    extends JavaMethod {
        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 3) {
                throw context.getRuntime().newArgumentError(args2.length, 3);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], block);
        }

        public Arity getArity() {
            return Arity.THREE_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodThree
    extends JavaMethod {
        public JavaMethodThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 3) {
                throw context.getRuntime().newArgumentError(args2.length, 3);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
        }

        public Arity getArity() {
            return Arity.THREE_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodTwoBlock
    extends JavaMethod {
        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 2) {
                throw context.getRuntime().newArgumentError(args2.length, 2);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1], block);
        }

        public Arity getArity() {
            return Arity.TWO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodTwoOrThree
    extends JavaMethod {
        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 2, 3);
            return null;
        }
    }

    public static abstract class JavaMethodTwo
    extends JavaMethod {
        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 2) {
                throw context.getRuntime().newArgumentError(args2.length, 2);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1]);
        }

        public Arity getArity() {
            return Arity.TWO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThreeBlock
    extends JavaMethod {
        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    throw context.getRuntime().newArgumentError(0, 1);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], block);
                }
            }
            throw context.getRuntime().newArgumentError(args2.length, 3);
        }
    }

    public static abstract class JavaMethodOneOrTwoBlock
    extends JavaMethod {
        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
            return null;
        }
    }

    public static abstract class JavaMethodOneBlock
    extends JavaMethod {
        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 1) {
                throw context.getRuntime().newArgumentError(args2.length, 1);
            }
            return this.call(context, self, clazz, name2, args2[0], block);
        }

        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThree
    extends JavaMethod {
        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 3);
            return null;
        }
    }

    public static abstract class JavaMethodOneOrTwo
    extends JavaMethod {
        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
            return null;
        }
    }

    public static abstract class JavaMethodOne
    extends JavaMethod {
        public JavaMethodOne(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOne(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodOne(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 1) {
                throw context.getRuntime().newArgumentError(args2.length, 1);
            }
            return this.call(context, self, clazz, name2, args2[0]);
        }

        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    public static abstract class JavaMethodZeroBlock
    extends JavaMethod {
        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 0) {
                throw context.getRuntime().newArgumentError(args2.length, 0);
            }
            return this.call(context, self, clazz, name2, block);
        }

        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 3);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
                }
            }
            return this.call(context, self, clazz, name2, args2);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThree
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 3);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 2);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1, arg2});
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
            }
            return this.call(context, self, clazz, name2, args2);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwo
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 2);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
    }

    public static abstract class JavaMethodZeroOrOneBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 1);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1});
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1, arg2});
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
            }
            return this.call(context, self, clazz, name2, args2);
        }
    }

    public static abstract class JavaMethodZeroOrOne
    extends JavaMethod {
        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 1);
            return null;
        }
    }

    public static abstract class JavaMethodZero
    extends JavaMethod {
        public JavaMethodZero(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZero(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodZero(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 0) {
                throw context.getRuntime().newArgumentError(args2.length, 0);
            }
            return this.call(context, self, clazz, name2);
        }

        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodNoBlock
    extends JavaMethod {
        public JavaMethodNoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodNoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, StaticScope staticScope, Arity arity2) {
            super(implementationClass, visibility, callConfig, staticScope, arity2);
        }

        public JavaMethodNoBlock(RubyModule implementationClass, Visibility visibility, int methodIndex) {
            super(implementationClass, visibility, methodIndex);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return this.call(context, self, clazz, name2, args2);
        }
    }
}

