/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.AbstractMemoryPointer;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"StructLayoutBuilder"}, parent="Object")
public final class StructLayoutBuilder
extends RubyObject {
    public static final String CLASS_NAME = "StructLayoutBuilder";
    static final int LONG_SIZE = Platform.getPlatform().longSize();
    static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
    static final int LONG_ALIGN = StructLayoutBuilder.isSparc() ? 64 : LONG_SIZE;
    static final int ADDRESS_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    static final int DOUBLE_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    static final int FLOAT_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    private final Map<IRubyObject, StructLayout.Member> fields = new LinkedHashMap<IRubyObject, StructLayout.Member>();
    private int size = 0;

    private static final boolean isSparc() {
        return false;
    }

    public static RubyClass createStructLayoutBuilderClass(Ruby runtime2) {
        RubyModule parent = FFIProvider.getModule(runtime2);
        RubyClass result = runtime2.defineClassUnder(CLASS_NAME, runtime2.getObject(), Allocator.INSTANCE, parent);
        result.defineAnnotatedMethods(StructLayoutBuilder.class);
        result.defineAnnotatedConstants(StructLayoutBuilder.class);
        return result;
    }

    StructLayoutBuilder(Ruby runtime2) {
        this(runtime2, FFIProvider.getModule(runtime2).fastGetClass(CLASS_NAME));
    }

    StructLayoutBuilder(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static StructLayoutBuilder newInstance(ThreadContext context, IRubyObject recv2) {
        return new StructLayoutBuilder(context.getRuntime());
    }

    @JRubyMethod(name={"build"})
    public StructLayout build(ThreadContext context) {
        return new StructLayout(context.getRuntime(), this.fields, this.size);
    }

    private static int alignMember(int offset2, int alignBits) {
        int off = offset2;
        int alignBytes = alignBits >> 3;
        int mask = alignBytes - 1;
        if ((off & mask) != 0) {
            off = (off & ~mask) + alignBytes;
        }
        return off;
    }

    @JRubyMethod(name={"add_field"}, required=2, optional=1)
    public IRubyObject add(ThreadContext context, IRubyObject[] args2) {
        StructLayout.Member field2;
        Ruby runtime2 = context.getRuntime();
        IRubyObject name2 = args2[0];
        NativeType type2 = NativeType.valueOf(Util.int32Value(args2[1]));
        int offset2 = args2.length > 2 ? Util.int32Value(args2[2]) : -1;
        int align = 8;
        int sizeBits = 8;
        switch (type2) {
            case INT8: 
            case UINT8: {
                align = 8;
                sizeBits = 8;
                break;
            }
            case INT16: 
            case UINT16: {
                align = 16;
                sizeBits = 16;
                break;
            }
            case INT32: 
            case UINT32: {
                align = 32;
                sizeBits = 32;
                break;
            }
            case INT64: 
            case UINT64: {
                align = LONG_ALIGN;
                sizeBits = 64;
                break;
            }
            case LONG: 
            case ULONG: {
                align = LONG_ALIGN;
                sizeBits = LONG_SIZE;
                break;
            }
            case FLOAT32: {
                align = FLOAT_ALIGN;
                sizeBits = 32;
                break;
            }
            case FLOAT64: {
                align = DOUBLE_ALIGN;
                sizeBits = 64;
                break;
            }
            case POINTER: {
                align = Platform.getPlatform().addressSize();
                sizeBits = LONG_ALIGN;
                break;
            }
            case STRING: 
            case RBXSTRING: {
                align = ADDRESS_ALIGN;
                sizeBits = ADDRESS_SIZE;
            }
        }
        if (offset2 < 0) {
            offset2 = StructLayoutBuilder.alignMember(this.size, align);
        }
        if ((field2 = this.createMember(type2, offset2)) == null) {
            throw runtime2.newArgumentError("Unknown field type: " + type2);
        }
        this.fields.put(StructLayoutBuilder.createKey(runtime2, name2), field2);
        this.size = offset2 + sizeBits / 8;
        return runtime2.getNil();
    }

    @JRubyMethod(name={"add_char_array"}, required=2, optional=1)
    public IRubyObject add_char_array(ThreadContext context, IRubyObject[] args2) {
        long offset2;
        Ruby runtime2 = context.getRuntime();
        IRubyObject name2 = args2[0];
        int strlen = Util.int32Value(args2[1]);
        long l = offset2 = args2.length > 2 ? Util.int64Value(args2[2]) : -1L;
        if (offset2 < 0L) {
            offset2 = StructLayoutBuilder.alignMember(this.size, 8);
        }
        StructLayout.Member field2 = CharArrayMember.create(offset2, strlen);
        this.fields.put(StructLayoutBuilder.createKey(runtime2, name2), field2);
        this.size += strlen;
        return runtime2.getNil();
    }

    private static IRubyObject createKey(Ruby runtime2, IRubyObject key) {
        if (key instanceof RubySymbol) {
            return key;
        }
        return runtime2.getSymbolTable().getSymbol(key.asJavaString());
    }

    StructLayout.Member createMember(NativeType type2, long offset2) {
        switch (type2) {
            case INT8: {
                return Signed8Member.create(offset2);
            }
            case UINT8: {
                return Unsigned8Member.create(offset2);
            }
            case INT16: {
                return Signed16Member.create(offset2);
            }
            case UINT16: {
                return Unsigned16Member.create(offset2);
            }
            case INT32: {
                return Signed32Member.create(offset2);
            }
            case UINT32: {
                return Unsigned32Member.create(offset2);
            }
            case INT64: 
            case UINT64: {
                return Signed64Member.create(offset2);
            }
            case LONG: {
                return LONG_SIZE == 32 ? Signed32Member.create(offset2) : Signed64Member.create(offset2);
            }
            case ULONG: {
                return LONG_SIZE == 32 ? Unsigned32Member.create(offset2) : Signed64Member.create(offset2);
            }
            case FLOAT32: {
                return Float32Member.create(offset2);
            }
            case FLOAT64: {
                return Float64Member.create(offset2);
            }
            case POINTER: {
                return PointerMember.create(offset2);
            }
            case STRING: 
            case RBXSTRING: {
                return StringMember.create(offset2);
            }
        }
        return null;
    }

    static final class CharArrayMember
    extends StructLayout.Member {
        private final int size;

        CharArrayMember(long offset2, int size2) {
            super(offset2);
            this.size = size2;
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            MemoryIO io2 = CharArrayMember.getMemoryIO(ptr);
            ByteList bl = value2.convertToString().getByteList();
            int len = Math.min(bl.length(), this.size - 1);
            io2.put(this.offset, bl.unsafeBytes(), bl.begin(), len);
            io2.putByte(this.offset + (long)len, (byte)0);
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            MemoryIO io2 = CharArrayMember.getMemoryIO(ptr);
            int len = io2.indexOf(this.offset, (byte)0, this.size);
            if (len < 0) {
                len = this.size;
            }
            ByteList bl = new ByteList(len);
            bl.length(len);
            io2.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime2.newString(bl);
        }

        static StructLayout.Member create(long offset2, int size2) {
            return new CharArrayMember(offset2, size2);
        }
    }

    static final class StringMember
    extends StructLayout.Member {
        StringMember(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            MemoryIO io2 = StringMember.getMemoryIO(ptr).getMemoryIO(this.offset);
            if (!io2.isNull()) {
                ByteList bl = value2.convertToString().getByteList();
                io2.put(0L, bl.unsafeBytes(), bl.begin(), bl.length());
                io2.putByte(bl.length(), (byte)0);
            }
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            MemoryIO io2 = StringMember.getMemoryIO(ptr).getMemoryIO(this.offset);
            if (io2.isNull()) {
                return runtime2.getNil();
            }
            int len = io2.indexOf(0L, (byte)0, Integer.MAX_VALUE);
            ByteList bl = new ByteList(len);
            bl.length(len);
            io2.get(0L, bl.unsafeBytes(), bl.begin(), len);
            return runtime2.newString(bl);
        }

        static StructLayout.Member create(long offset2) {
            return new StringMember(offset2);
        }
    }

    static final class Float64Member
    extends StructLayout.Member {
        Float64Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Float64Member.getMemoryIO(ptr).putDouble(this.offset, Util.doubleValue(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFloat.newFloat(runtime2, Float64Member.getMemoryIO(ptr).getDouble(this.offset));
        }

        static StructLayout.Member create(long offset2) {
            return new Float64Member(offset2);
        }
    }

    static final class Float32Member
    extends StructLayout.Member {
        Float32Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Float32Member.getMemoryIO(ptr).putFloat(this.offset, Util.floatValue(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFloat.newFloat(runtime2, Float32Member.getMemoryIO(ptr).getFloat(this.offset));
        }

        static StructLayout.Member create(long offset2) {
            return new Float32Member(offset2);
        }
    }

    static final class PointerMember
    extends StructLayout.Member {
        PointerMember(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            if (value2 instanceof AbstractMemoryPointer) {
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.offset, ((AbstractMemoryPointer)value2).getMemoryIO());
            } else if (Platform.getPlatform().addressSize() == 32) {
                PointerMember.getMemoryIO(ptr).putInt(this.offset, Util.int32Value(value2));
            } else if (Platform.getPlatform().addressSize() == 64) {
                PointerMember.getMemoryIO(ptr).putLong(this.offset, Util.int64Value(value2));
            }
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return ((AbstractMemory)ptr).getMemoryPointer(runtime2, this.offset);
        }

        static StructLayout.Member create(long offset2) {
            return new PointerMember(offset2);
        }
    }

    static final class Signed64Member
    extends StructLayout.Member {
        Signed64Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed64Member.getMemoryIO(ptr).putLong(this.offset, Util.int64Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime2, Signed64Member.getMemoryIO(ptr).getLong(this.offset));
        }

        static StructLayout.Member create(long offset2) {
            return new Signed64Member(offset2);
        }
    }

    static final class Unsigned32Member
    extends StructLayout.Member {
        Unsigned32Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Unsigned32Member.getMemoryIO(ptr).putInt(this.offset, (int)Util.uint32Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            long value2 = Unsigned32Member.getMemoryIO(ptr).getInt(this.offset);
            return RubyFixnum.newFixnum(runtime2, value2 < 0L ? (value2 & Integer.MAX_VALUE) + 0x80000000L : value2);
        }

        static StructLayout.Member create(long offset2) {
            return new Unsigned32Member(offset2);
        }
    }

    static final class Signed32Member
    extends StructLayout.Member {
        Signed32Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed32Member.getMemoryIO(ptr).putInt(this.offset, Util.int32Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime2, Signed32Member.getMemoryIO(ptr).getInt(this.offset));
        }

        static StructLayout.Member create(long offset2) {
            return new Signed32Member(offset2);
        }
    }

    static final class Unsigned16Member
    extends StructLayout.Member {
        Unsigned16Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Unsigned16Member.getMemoryIO(ptr).putShort(this.offset, (short)Util.uint16Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            short value2 = Unsigned16Member.getMemoryIO(ptr).getShort(this.offset);
            return RubyFixnum.newFixnum(runtime2, value2 < 0 ? (long)((value2 & Short.MAX_VALUE) + 32768) : (long)value2);
        }

        static StructLayout.Member create(long offset2) {
            return new Unsigned16Member(offset2);
        }
    }

    static final class Signed16Member
    extends StructLayout.Member {
        Signed16Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed16Member.getMemoryIO(ptr).putShort(this.offset, Util.int16Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime2, Signed16Member.getMemoryIO(ptr).getShort(this.offset));
        }

        static StructLayout.Member create(long offset2) {
            return new Signed16Member(offset2);
        }
    }

    static final class Unsigned8Member
    extends StructLayout.Member {
        Unsigned8Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Unsigned8Member.getMemoryIO(ptr).putByte(this.offset, (byte)Util.uint8Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            byte value2 = Unsigned8Member.getMemoryIO(ptr).getByte(this.offset);
            return RubyFixnum.newFixnum(runtime2, value2 < 0 ? (long)((short)((value2 & 0x7F) + 128)) : (long)value2);
        }

        static StructLayout.Member create(long offset2) {
            return new Unsigned8Member(offset2);
        }
    }

    static final class Signed8Member
    extends StructLayout.Member {
        Signed8Member(long offset2) {
            super(offset2);
        }

        public void put(Ruby runtime2, IRubyObject ptr, IRubyObject value2) {
            Signed8Member.getMemoryIO(ptr).putByte(this.offset, Util.int8Value(value2));
        }

        public IRubyObject get(Ruby runtime2, IRubyObject ptr) {
            return RubyFixnum.newFixnum(runtime2, Signed8Member.getMemoryIO(ptr).getByte(this.offset));
        }

        static StructLayout.Member create(long offset2) {
            return new Signed8Member(offset2);
        }
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StructLayoutBuilder(runtime2, klass);
        }
    }
}

