/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsCatNode
extends Node {
    private final Node firstNode;
    private final Node secondNode;

    public ArgsCatNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position, NodeType.ARGSCATNODE);
        assert (firstNode != null) : "ArgsCatNode.first == null";
        assert (secondNode != null) : "ArgsCatNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public Instruction accept(NodeVisitor visitor) {
        return visitor.visitArgsCatNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject args2 = this.firstNode.interpret(runtime2, context, self, aBlock);
        RubyArray secondArgs = RuntimeHelpers.splatValue(this.secondNode.interpret(runtime2, context, self, aBlock));
        return RuntimeHelpers.ensureRubyArray(runtime2, args2).concat(secondArgs);
    }
}

