/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.dynalang.mop.BaseMetaobjectProtocol;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.beans.DynamicInstanceMethod;
import org.dynalang.mop.beans.DynamicMethod;
import org.dynalang.mop.beans.OverloadedDynamicMethod;
import org.dynalang.mop.beans.SimpleDynamicMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassMetaobjectProtocol {
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
    private final Map<String, DynamicMethod> methods = new HashMap<String, DynamicMethod>();
    private final Collection<String> names;

    ClassMetaobjectProtocol(Class clazz, boolean methodsEnumerable) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        Map<MethodSignature, Method> accessibleMethods = ClassMetaobjectProtocol.discoverAccessibleMethods(clazz);
        PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propDescs.length; ++i) {
            Method writeMethod;
            PropertyDescriptor descriptor = propDescs[i];
            Method readMethod = descriptor.getReadMethod();
            if (readMethod != null) {
                descriptor.setReadMethod(ClassMetaobjectProtocol.getAccessibleMethod(readMethod, accessibleMethods));
            }
            if ((writeMethod = descriptor.getWriteMethod()) != null) {
                descriptor.setWriteMethod(ClassMetaobjectProtocol.getAccessibleMethod(writeMethod, accessibleMethods));
            }
            if (descriptor.getReadMethod() == null && descriptor.getWriteMethod() == null) continue;
            this.properties.put(descriptor.getName(), descriptor);
        }
        MethodDescriptor[] methodDescs = beanInfo.getMethodDescriptors();
        for (int i = 0; i < methodDescs.length; ++i) {
            MethodDescriptor descriptor = methodDescs[i];
            Method method2 = ClassMetaobjectProtocol.getAccessibleMethod(descriptor.getMethod(), accessibleMethods);
            if (method2 == null) continue;
            String name2 = descriptor.getName();
            DynamicMethod dynaMethod = this.methods.get(name2);
            if (dynaMethod == null) {
                this.methods.put(name2, new SimpleDynamicMethod(method2));
                continue;
            }
            if (dynaMethod instanceof SimpleDynamicMethod) {
                OverloadedDynamicMethod<Method> odm = new OverloadedDynamicMethod<Method>(name2);
                odm.addMember(((SimpleDynamicMethod)dynaMethod).getMethod());
                odm.addMember(method2);
                this.methods.put(name2, odm);
                continue;
            }
            if (!(dynaMethod instanceof OverloadedDynamicMethod)) continue;
            ((OverloadedDynamicMethod)dynaMethod).addMember(method2);
        }
        if (methodsEnumerable) {
            HashSet<String> cnames = new HashSet<String>(this.properties.size() + this.methods.size() * 4 / 3, 0.75f);
            cnames.addAll(this.properties.keySet());
            cnames.addAll(this.methods.keySet());
            ArrayList lnames = new ArrayList(cnames);
            Collections.sort(lnames);
            lnames.trimToSize();
            this.names = Collections.unmodifiableCollection(lnames);
        } else {
            this.names = Collections.emptySet();
        }
    }

    Object call(Object target, Object callableId, CallProtocol callProtocol, Object[] args2) {
        String name2 = String.valueOf(callableId);
        DynamicMethod dynaMethod = this.methods.get(name2);
        if (dynaMethod == null) {
            return BaseMetaobjectProtocol.Results.noAuthority;
        }
        return dynaMethod.call(target, args2, callProtocol);
    }

    Object get(Object target, long propertyId) {
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    Object get(Object target, Object propertyId) {
        String name2 = String.valueOf(propertyId);
        PropertyDescriptor desc = this.properties.get(name2);
        if (desc == null) {
            DynamicMethod dynaMethod = this.methods.get(name2);
            if (dynaMethod == null) {
                return BaseMetaobjectProtocol.Results.noAuthority;
            }
            return new DynamicInstanceMethod(target, dynaMethod);
        }
        Method method2 = desc.getReadMethod();
        if (method2 == null) {
            return BaseMetaobjectProtocol.Results.notReadable;
        }
        try {
            return method2.invoke(target, (Object[])null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    Boolean has(Object target, long propertyId) {
        return null;
    }

    Boolean has(Object target, Object propertyId) {
        String name2 = String.valueOf(propertyId);
        if (this.properties.containsKey(name2) || this.methods.containsKey(name2)) {
            return Boolean.TRUE;
        }
        return null;
    }

    Iterator<? extends Object> getPropertyIds(Object target) {
        return this.names.iterator();
    }

    BaseMetaobjectProtocol.Results put(Object target, long propertyId, Object value2, CallProtocol callProtocol) {
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    BaseMetaobjectProtocol.Results put(Object target, Object propertyId, Object value2, CallProtocol callProtocol) {
        PropertyDescriptor desc = this.properties.get(String.valueOf(propertyId));
        if (desc == null) {
            return BaseMetaobjectProtocol.Results.noAuthority;
        }
        Method writeMethod = desc.getWriteMethod();
        if (writeMethod == null) {
            return BaseMetaobjectProtocol.Results.notWritable;
        }
        try {
            Class<?> propType = desc.getPropertyType();
            if (propType == null) {
                return BaseMetaobjectProtocol.Results.notWritable;
            }
            if ((value2 = callProtocol.representAs(value2, propType)) == BaseMetaobjectProtocol.Results.noAuthority || value2 == BaseMetaobjectProtocol.Results.noRepresentation) {
                return BaseMetaobjectProtocol.Results.noRepresentation;
            }
            writeMethod.invoke(target, value2);
            return BaseMetaobjectProtocol.Results.ok;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static Map<MethodSignature, Method> discoverAccessibleMethods(Class clazz) {
        HashMap<MethodSignature, Method> map = new HashMap<MethodSignature, Method>();
        ClassMetaobjectProtocol.discoverAccessibleMethods(clazz, map);
        return map;
    }

    private static void discoverAccessibleMethods(Class clazz, Map<MethodSignature, Method> map) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methods2 = clazz.getMethods();
                for (int i = 0; i < methods2.length; ++i) {
                    Method method2 = methods2[i];
                    MethodSignature sig = new MethodSignature(method2);
                    map.put(sig, method2);
                }
                return;
            }
            catch (SecurityException e) {
                System.err.println("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.");
                e.printStackTrace();
            }
        }
        Class<?>[] interfaces2 = clazz.getInterfaces();
        for (int i = 0; i < interfaces2.length; ++i) {
            ClassMetaobjectProtocol.discoverAccessibleMethods(interfaces2[i], map);
        }
        Class superclass2 = clazz.getSuperclass();
        if (superclass2 != null) {
            ClassMetaobjectProtocol.discoverAccessibleMethods(superclass2, map);
        }
    }

    private static Method getAccessibleMethod(Method m, Map<MethodSignature, Method> accessibles) {
        return m == null ? null : accessibles.get(new MethodSignature(m));
    }

    private static final class MethodSignature {
        private final String name;
        private final Class[] args;

        private MethodSignature(String name2, Class[] args2) {
            this.name = name2;
            this.args = args2;
        }

        MethodSignature(Method method2) {
            this(method2.getName(), method2.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ Arrays.hashCode(this.args);
        }
    }
}

