/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel.fn;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.mesg.Messages;
import org.zkoss.text.MessageFormats;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Labels;

public class CommonFns {
    private static final Log log = Log.lookup(CommonFns.class);

    protected CommonFns() {
    }

    public static boolean toBoolean(Object val) {
        return (Boolean)Classes.coerce(Boolean.TYPE, val);
    }

    public static String toString(Object val) {
        return (String)Classes.coerce(String.class, val);
    }

    public static Number toNumber(Object val) {
        return (Number)Classes.coerce(Number.class, val);
    }

    public static int toInt(Object val) {
        return (Integer)Classes.coerce(Integer.TYPE, val);
    }

    public static BigDecimal toDecimal(Object val) {
        return (BigDecimal)Classes.coerce(BigDecimal.class, val);
    }

    public static char toChar(Object val) {
        return ((Character)Classes.coerce(Character.TYPE, val)).charValue();
    }

    public static boolean isInstance(Object c, Object o) {
        if (c instanceof Class) {
            return ((Class)c).isInstance(o);
        }
        if (c instanceof String) {
            try {
                return Classes.forNameByThread((String)c).isInstance(o);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Class not found: " + c);
            }
        }
        throw new IllegalArgumentException("Unknown class: " + c);
    }

    public static final String getLabel(String key) {
        if (key == null) {
            return "";
        }
        if (key.startsWith("mesg:")) {
            int j = key.lastIndexOf(58);
            if (j > 5) {
                String clsnm = key.substring(5, j);
                String fldnm = key.substring(j + 1);
                try {
                    Class cls = Classes.forNameByThread(clsnm);
                    Field fld = cls.getField(fldnm);
                    return Messages.get((Integer)fld.get(null));
                }
                catch (ClassNotFoundException ex) {
                    log.warning("Class not found: " + clsnm, (Throwable)ex);
                }
                catch (NoSuchFieldException ex) {
                    log.warning("Field not found: " + fldnm, (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    log.warning("Field not accessible: " + fldnm, (Throwable)ex);
                }
            } else if (log.debugable()) {
                log.debug("Not a valid format: " + key);
            }
        }
        return Labels.getLabel(key);
    }

    public static final String getLabel(String key, Object[] args) {
        String s = CommonFns.getLabel(key);
        return s != null ? MessageFormats.format(s, args, null) : null;
    }

    public static final int length(Object o) {
        if (o instanceof String) {
            return ((String)o).length();
        }
        if (o == null) {
            return 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length;
        }
        if (o instanceof int[]) {
            return ((int[])o).length;
        }
        if (o instanceof long[]) {
            return ((long[])o).length;
        }
        if (o instanceof short[]) {
            return ((short[])o).length;
        }
        if (o instanceof byte[]) {
            return ((byte[])o).length;
        }
        if (o instanceof char[]) {
            return ((char[])o).length;
        }
        if (o instanceof double[]) {
            return ((double[])o).length;
        }
        if (o instanceof float[]) {
            return ((float[])o).length;
        }
        throw new IllegalArgumentException("Unknown object for length: " + o.getClass());
    }

    public static final Object new_(Object o) throws Exception {
        if (o instanceof String) {
            return Classes.newInstanceByThread((String)o);
        }
        if (o instanceof Class) {
            return ((Class)o).newInstance();
        }
        throw new IllegalArgumentException("Unknow object for new: " + o);
    }
}

