/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class DualCollection
extends AbstractCollection
implements Serializable {
    private final Collection _first;
    private final Collection _second;

    public static final Collection combine(Collection first, Collection second) {
        if (first == second) {
            return first;
        }
        if (first != null) {
            if (second != null) {
                return new DualCollection(first, second);
            }
            return first;
        }
        return second;
    }

    public DualCollection(Collection first, Collection second) {
        this._first = first != null ? first : Collections.EMPTY_LIST;
        this._second = second != null ? second : Collections.EMPTY_LIST;
    }

    public int size() {
        return this._first.size() + this._second.size();
    }

    public Iterator iterator() {
        return new Iter();
    }

    private class Iter
    implements Iterator {
        private Iterator _it;
        private boolean _bSecond;

        private Iter() {
            this._it = DualCollection.this._first.iterator();
        }

        public boolean hasNext() {
            return this._it.hasNext() || !this._bSecond && !DualCollection.this._second.isEmpty();
        }

        public Object next() {
            if (!this._bSecond && !this._it.hasNext()) {
                this._it = DualCollection.this._second.iterator();
                this._bSecond = true;
            }
            return this._it.next();
        }

        public void remove() {
            this._it.remove();
        }
    }
}

