/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.image.encoder;

import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.zkoss.image.encoder.ImageEncoder;

public class JPEGEncoder
implements ImageEncoder {
    private float _quality = 0.95f;

    public byte[] encode(RenderedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageWriter iw = ImageIO.getImageWritersByFormatName("jpeg").next();
        ImageWriteParam iwp = iw.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(this._quality);
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        iw.setOutput(ios);
        iw.write(null, new IIOImage(image, null, null), iwp);
        ios.flush();
        iw.dispose();
        ios.close();
        return os.toByteArray();
    }

    public float getQuality() {
        return this._quality;
    }

    public void setQuality(float quality) {
        if (quality < 0.0f || quality > 1.0f) {
            throw new IllegalArgumentException("out of range: " + quality);
        }
        this._quality = quality;
    }

    public boolean isEncodingAlpha() {
        return false;
    }

    public void setEncodingAlpha(boolean encodeAlpha) {
    }
}

