/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.wireformat.WireFormat;

public class SslTransport
extends TcpTransport {
    public SslTransport(WireFormat wireFormat, SSLSocketFactory socketFactory, URI remoteLocation, URI localLocation, boolean needClientAuth) throws IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
        if (this.socket != null) {
            ((SSLSocket)this.socket).setNeedClientAuth(needClientAuth);
        }
    }

    public SslTransport(WireFormat wireFormat, SSLSocket socket) throws IOException {
        super(wireFormat, socket);
    }

    public void doConsume(Command command) {
        if (command instanceof ConnectionInfo) {
            X509Certificate[] clientCertChain;
            ConnectionInfo connectionInfo = (ConnectionInfo)command;
            SSLSocket sslSocket = (SSLSocket)this.socket;
            SSLSession sslSession = sslSocket.getSession();
            try {
                clientCertChain = (X509Certificate[])sslSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                clientCertChain = null;
            }
            connectionInfo.setTransportContext(clientCertChain);
        }
        super.doConsume(command);
    }

    public String toString() {
        return "ssl://" + this.socket.getInetAddress() + ":" + this.socket.getPort();
    }
}

