/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InactivityMonitor
extends TransportFilter {
    private static final Log LOG = LogFactory.getLog(InactivityMonitor.class);
    private WireFormatInfo localWireFormatInfo;
    private WireFormatInfo remoteWireFormatInfo;
    private final AtomicBoolean monitorStarted = new AtomicBoolean(false);
    private final AtomicBoolean commandSent = new AtomicBoolean(false);
    private final AtomicBoolean inSend = new AtomicBoolean(false);
    private final AtomicBoolean commandReceived = new AtomicBoolean(true);
    private final AtomicBoolean inReceive = new AtomicBoolean(false);
    private final Runnable readChecker = new Runnable(){

        public void run() {
            InactivityMonitor.this.readCheck();
        }
    };
    private final Runnable writeChecker = new Runnable(){

        public void run() {
            InactivityMonitor.this.writeCheck();
        }
    };

    public InactivityMonitor(Transport next) {
        super(next);
    }

    public void stop() throws Exception {
        this.stopMonitorThreads();
        this.next.stop();
    }

    final void writeCheck() {
        if (this.inSend.get()) {
            LOG.trace((Object)"A send is in progress");
            return;
        }
        if (!this.commandSent.get()) {
            LOG.trace((Object)"No message sent since last write check, sending a KeepAliveInfo");
            Thread thread = new Thread("ActiveMQ: Activity Generator: " + this.next.getRemoteAddress()){

                public void run() {
                    try {
                        InactivityMonitor.this.oneway(new KeepAliveInfo());
                    }
                    catch (IOException e) {
                        InactivityMonitor.this.onException(e);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        } else {
            LOG.trace((Object)"Message sent since last write check, resetting flag");
        }
        this.commandSent.set(false);
    }

    final void readCheck() {
        if (this.inReceive.get()) {
            LOG.trace((Object)"A receive is in progress");
            return;
        }
        if (!this.commandReceived.get()) {
            LOG.debug((Object)("No message received since last read check for " + this.toString() + "! Throwing InactivityIOException."));
            Thread thread = new Thread("ActiveMQ: Inactivity Handler: " + this.next.getRemoteAddress()){

                public void run() {
                    InactivityMonitor.this.onException(new InactivityIOException("Channel was inactive for too long: " + InactivityMonitor.this.next.getRemoteAddress()));
                }
            };
            thread.setDaemon(true);
            thread.start();
        } else {
            LOG.trace((Object)"Message received since last read check, resetting flag: ");
        }
        this.commandReceived.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Object command) {
        this.inReceive.set(true);
        try {
            Object object;
            if (command.getClass() == WireFormatInfo.class) {
                object = this;
                synchronized (object) {
                    IOException error = null;
                    this.remoteWireFormatInfo = (WireFormatInfo)command;
                    try {
                        this.startMonitorThreads();
                    }
                    catch (IOException e) {
                        error = e;
                    }
                    if (error != null) {
                        this.onException(error);
                    }
                }
            }
            object = this.readChecker;
            synchronized (object) {
                this.transportListener.onCommand(command);
            }
        }
        finally {
            this.commandReceived.set(true);
            this.inReceive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Object o) throws IOException {
        this.inSend.set(true);
        try {
            Object object;
            if (o.getClass() == WireFormatInfo.class) {
                object = this;
                synchronized (object) {
                    this.localWireFormatInfo = (WireFormatInfo)o;
                    this.startMonitorThreads();
                }
            }
            object = this.writeChecker;
            synchronized (object) {
                this.next.oneway(o);
            }
        }
        finally {
            this.commandSent.set(true);
            this.inSend.set(false);
        }
    }

    public void onException(IOException error) {
        if (this.monitorStarted.get()) {
            this.stopMonitorThreads();
        }
        this.transportListener.onException(error);
    }

    private synchronized void startMonitorThreads() throws IOException {
        if (this.monitorStarted.get()) {
            return;
        }
        if (this.localWireFormatInfo == null) {
            return;
        }
        if (this.remoteWireFormatInfo == null) {
            return;
        }
        long l = Math.min(this.localWireFormatInfo.getMaxInactivityDuration(), this.remoteWireFormatInfo.getMaxInactivityDuration());
        if (l > 0L) {
            this.monitorStarted.set(true);
            Scheduler.executePeriodically(this.writeChecker, l / 2L);
            Scheduler.executePeriodically(this.readChecker, l);
        }
    }

    private synchronized void stopMonitorThreads() {
        if (this.monitorStarted.compareAndSet(true, false)) {
            Scheduler.cancel(this.readChecker);
            Scheduler.cancel(this.writeChecker);
        }
    }
}

