/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.memory;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;

class MemoryTopicSub {
    private Map<MessageId, Message> map = new LinkedHashMap<MessageId, Message>();
    private MessageId lastBatch;

    MemoryTopicSub() {
    }

    void addMessage(MessageId id, Message message) {
        this.map.put(id, message);
    }

    void removeMessage(MessageId id) {
        this.map.remove(id);
        if (this.map.isEmpty()) {
            this.lastBatch = null;
        }
    }

    int size() {
        return this.map.size();
    }

    void recoverSubscription(MessageRecoveryListener listener) throws Exception {
        for (Map.Entry<MessageId, Message> entry : this.map.entrySet()) {
            Message msg = entry.getValue();
            if (msg.getClass() == MessageId.class) {
                listener.recoverMessageReference((MessageId)((Object)msg));
                continue;
            }
            listener.recoverMessage(msg);
        }
    }

    void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        boolean pastLackBatch = this.lastBatch == null;
        MessageId lastId = null;
        int count = 0;
        Iterator<Map.Entry<MessageId, Message>> iter = this.map.entrySet().iterator();
        while (iter.hasNext() && count < maxReturned) {
            Map.Entry<MessageId, Message> entry = iter.next();
            if (pastLackBatch) {
                ++count;
                Message msg = entry.getValue();
                lastId = entry.getKey();
                if (msg.getClass() == MessageId.class) {
                    listener.recoverMessageReference((MessageId)((Object)msg));
                    continue;
                }
                listener.recoverMessage(msg);
                continue;
            }
            pastLackBatch = ((Object)entry.getKey()).equals(this.lastBatch);
        }
        if (lastId != null) {
            this.lastBatch = lastId;
        }
    }

    void resetBatching() {
        this.lastBatch = null;
    }
}

