/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.hash;

import java.io.IOException;
import org.apache.activemq.kaha.impl.index.hash.HashEntry;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.kaha.impl.index.hash.HashPage;

class HashPageInfo {
    private HashIndex hashIndex;
    private long id;
    private int size;
    private HashPage page;
    private boolean dirty;

    HashPageInfo(HashIndex index) {
        this.hashIndex = index;
    }

    long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    int size() {
        return this.size;
    }

    void setSize(int size) {
        this.size = size;
    }

    void addHashEntry(int index, HashEntry entry) throws IOException {
        this.page.addHashEntry(index, entry);
        ++this.size;
        this.dirty = true;
    }

    HashEntry getHashEntry(int index) throws IOException {
        return this.page.getHashEntry(index);
    }

    HashEntry removeHashEntry(int index) throws IOException {
        HashEntry result = this.page.removeHashEntry(index);
        if (result != null) {
            --this.size;
            this.dirty = true;
        }
        return result;
    }

    void dump() {
        this.page.dump();
    }

    void begin() throws IOException {
        if (this.page == null) {
            this.page = this.hashIndex.getFullPage(this.id);
        }
    }

    void end() throws IOException {
        if (this.page != null && this.dirty) {
            this.hashIndex.writeFullPage(this.page);
        }
        this.page = null;
        this.dirty = false;
    }

    HashPage getPage() {
        return this.page;
    }

    void setPage(HashPage page) {
        this.page = page;
    }
}

