/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.util.CommandMessageListener;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class CommandAgent
implements Service,
InitializingBean,
DisposableBean,
FactoryBean {
    private static final Log LOG = LogFactory.getLog(CommandAgent.class);
    private String brokerUrl = "vm://localhost";
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Destination commandDestination;
    private CommandMessageListener listener;
    private Session session;
    private MessageConsumer consumer;

    public void start() throws Exception {
        this.session = this.getConnection().createSession(false, 1);
        this.listener = new CommandMessageListener(this.session);
        Destination destination = this.getCommandDestination();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Agent subscribing to control destination: " + destination));
        }
        this.consumer = this.session.createConsumer(destination);
        this.consumer.setMessageListener((MessageListener)this.listener);
    }

    public void stop() throws Exception {
        ServiceStopper stopper = new ServiceStopper();
        if (this.consumer != null) {
            try {
                this.consumer.close();
                this.consumer = null;
            }
            catch (JMSException e) {
                stopper.onException(this, e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
                this.session = null;
            }
            catch (JMSException e) {
                stopper.onException(this, e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (JMSException e) {
                stopper.onException(this, e);
            }
        }
        stopper.throwFirstException();
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public Object getObject() throws Exception {
        return this;
    }

    public Class getObjectType() {
        return this.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ActiveMQConnectionFactory(this.brokerUrl);
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = this.createConnection();
            this.connection.start();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Destination getCommandDestination() {
        if (this.commandDestination == null) {
            this.commandDestination = this.createCommandDestination();
        }
        return this.commandDestination;
    }

    public void setCommandDestination(Destination commandDestination) {
        this.commandDestination = commandDestination;
    }

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    protected Destination createCommandDestination() {
        return AdvisorySupport.getAgentDestination();
    }
}

