/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.Set;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.usage.MemoryUsage;

public class DestinationFilter
implements Destination {
    private Destination next;

    public DestinationFilter(Destination next) {
        this.next = next;
    }

    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        this.next.acknowledge(context, sub, ack, node);
    }

    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        this.next.addSubscription(context, sub);
    }

    public Message[] browse() {
        return this.next.browse();
    }

    public void dispose(ConnectionContext context) throws IOException {
        this.next.dispose(context);
    }

    public void gc() {
        this.next.gc();
    }

    public ActiveMQDestination getActiveMQDestination() {
        return this.next.getActiveMQDestination();
    }

    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.next.getDeadLetterStrategy();
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.next.getDestinationStatistics();
    }

    public String getName() {
        return this.next.getName();
    }

    public MemoryUsage getBrokerMemoryUsage() {
        return this.next.getBrokerMemoryUsage();
    }

    public boolean lock(MessageReference node, LockOwner lockOwner) {
        return this.next.lock(node, lockOwner);
    }

    public void removeSubscription(ConnectionContext context, Subscription sub) throws Exception {
        this.next.removeSubscription(context, sub);
    }

    public void send(ProducerBrokerExchange context, Message messageSend) throws Exception {
        this.next.send(context, messageSend);
    }

    public void start() throws Exception {
        this.next.start();
    }

    public void stop() throws Exception {
        this.next.stop();
    }

    protected void send(ProducerBrokerExchange context, Message message, ActiveMQDestination destination) throws Exception {
        Broker broker = context.getConnectionContext().getBroker();
        Set destinations = broker.getDestinations(destination);
        for (Destination dest : destinations) {
            dest.send(context, message);
        }
    }

    public MessageStore getMessageStore() {
        return this.next.getMessageStore();
    }

    public boolean isProducerFlowControl() {
        return this.next.isProducerFlowControl();
    }

    public void setProducerFlowControl(boolean value) {
        this.next.setProducerFlowControl(value);
    }
}

