/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.Closeable;

public abstract class ActiveMQMessageProducerSupport
implements MessageProducer,
Closeable {
    protected ActiveMQSession session;
    protected boolean disableMessageID;
    protected boolean disableMessageTimestamp;
    protected int defaultDeliveryMode;
    protected int defaultPriority;
    protected long defaultTimeToLive;

    public ActiveMQMessageProducerSupport(ActiveMQSession session) {
        this.session = session;
        this.disableMessageTimestamp = session.connection.isDisableTimeStampsByDefault();
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int newDeliveryMode) throws JMSException {
        if (newDeliveryMode != 2 && newDeliveryMode != 1) {
            throw new IllegalStateException("unkown delivery mode: " + newDeliveryMode);
        }
        this.checkClosed();
        this.defaultDeliveryMode = newDeliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public void setPriority(int newDefaultPriority) throws JMSException {
        if (newDefaultPriority < 0 || newDefaultPriority > 9) {
            throw new IllegalStateException("default priority must be a value between 0 and 9");
        }
        this.checkClosed();
        this.defaultPriority = newDefaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new IllegalStateException("cannot set a negative timeToLive");
        }
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    public void send(Message message) throws JMSException {
        this.send(this.getDestination(), message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.getDestination(), message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    protected abstract void checkClosed() throws IllegalStateException;
}

