/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.collections;

import com.sun.org.apache.commons.collections.Buffer;
import com.sun.org.apache.commons.collections.BufferUnderflowException;
import com.sun.org.apache.commons.collections.CollectionUtils;
import com.sun.org.apache.commons.collections.Predicate;
import java.util.Collection;

public class BufferUtils {
    private BufferUtils() {
    }

    public static Buffer synchronizedBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer){

            public synchronized boolean add(Object object) {
                boolean bl = this.collection.add(object);
                this.notify();
                return bl;
            }

            public synchronized boolean addAll(Collection collection) {
                boolean bl = this.collection.addAll(collection);
                this.notifyAll();
                return bl;
            }

            public synchronized Object get() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).get();
            }

            public synchronized Object remove() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).remove();
            }
        };
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return new UnmodifiableBuffer(buffer);
    }

    public static Buffer predicatedBuffer(Buffer buffer, Predicate predicate) {
        return new PredicatedBuffer(buffer, predicate);
    }

    static class PredicatedBuffer
    extends CollectionUtils.PredicatedCollection
    implements Buffer {
        public PredicatedBuffer(Buffer buffer, Predicate predicate) {
            super(buffer, predicate);
        }

        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            return ((Buffer)this.collection).remove();
        }
    }

    static class SynchronizedBuffer
    extends CollectionUtils.SynchronizedCollection
    implements Buffer {
        public SynchronizedBuffer(Buffer buffer) {
            super(buffer);
        }

        public synchronized Object get() {
            return ((Buffer)this.collection).get();
        }

        public synchronized Object remove() {
            return ((Buffer)this.collection).remove();
        }
    }

    static class UnmodifiableBuffer
    extends CollectionUtils.UnmodifiableCollection
    implements Buffer {
        public UnmodifiableBuffer(Buffer buffer) {
            super(buffer);
        }

        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            throw new UnsupportedOperationException();
        }
    }
}

