/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JarClassLoader
extends EJBClassLoader {
    static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final boolean debug = true;

    public JarClassLoader() {
        super(ConnectorClassLoader.getInstance());
    }

    public JarClassLoader(String jarName) throws IOException {
        super(ConnectorClassLoader.getInstance());
        this.addJar(jarName);
    }

    public synchronized void addJar(String jarName) throws IOException {
        File file = new File(FileUtil.getAbsolutePath(jarName));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JarClassLoader.addJar: url=" + file.toURL());
        }
        this.appendURL(file);
    }

    public void addDir(URL url) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.INFO, "JarClassLoader.addDir: url=" + url);
        }
        this.appendURL(url);
    }

    public String getClassPath() {
        return this.getClasspath();
    }

    public final String getClasspath() {
        String cpath = "";
        URL[] urls = this.getURLs();
        String sep = File.pathSeparator;
        for (int i = 0; i < urls.length; ++i) {
            cpath = cpath + sep + urls[i].getFile();
        }
        return cpath;
    }
}

