/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.TestInformation;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.dd.ParseDD;
import com.sun.enterprise.tools.verifier.web.FacesConfigDescriptor;
import com.sun.enterprise.tools.verifier.web.TagLibFactory;
import com.sun.enterprise.tools.verifier.wsclient.WebServiceClientCheckMgrImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesWeb.xml";
    private static final String sunONETestsListFileName = WebCheckMgrImpl.getSunPrefix().concat("TestNamesWeb.xml");
    private static TagLibDescriptor[] tlds;

    public WebCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(Descriptor descriptor) throws Exception {
        this.checkPersistenceUnits((RootDeploymentDescriptor)WebBundleDescriptor.class.cast(descriptor));
        this.checkWebServices(descriptor);
        this.checkWebServicesClient(descriptor);
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isWeb()) {
            return;
        }
        this.createTaglibDescriptors(descriptor);
        this.createFacesConfigDescriptor(descriptor);
        if (this.getSchemaVersion(descriptor).compareTo("2.4") < 0) {
            WebDeploymentDescriptorFile ddf = new WebDeploymentDescriptorFile();
            File file = new File(this.getAbstractArchiveUri(descriptor), ddf.getDeploymentDescriptorPath());
            FileInputStream is = new FileInputStream(file);
            try {
                if (is != null) {
                    Result result = new ParseDD().validateWebDescriptor(is);
                    result.setComponentName(this.getArchiveUri(descriptor));
                    this.setModuleName(result);
                    this.frameworkContext.getResultManager().add(result);
                    is.close();
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        super.check(descriptor);
    }

    @Override
    protected String getTestsListFileName() {
        return testsListFileName;
    }

    @Override
    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected void createTaglibDescriptors(Descriptor descriptor) {
        TagLibFactory tlf = new TagLibFactory(this.context, this.frameworkContext);
        tlds = tlf.getTagLibDescriptors((WebBundleDescriptor)descriptor);
        if (tlds != null) {
            this.context.setTagLibDescriptors(tlds);
            this.setVerifierContext(this.context);
        }
    }

    protected void createFacesConfigDescriptor(Descriptor descriptor) {
        FacesConfigDescriptor d = new FacesConfigDescriptor(this.context, (WebBundleDescriptor)descriptor);
        this.context.setFacesConfigDescriptor(d);
    }

    protected void checkWebServicesClient(Descriptor descriptor) throws Exception {
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isWebServicesClient()) {
            return;
        }
        WebBundleDescriptor desc = (WebBundleDescriptor)descriptor;
        WebServiceClientCheckMgrImpl webServiceClientCheckMgr = new WebServiceClientCheckMgrImpl(this.frameworkContext);
        if (desc.hasWebServiceClients()) {
            Set serviceRefDescriptors = desc.getServiceReferenceDescriptors();
            Iterator it = serviceRefDescriptors.iterator();
            while (it.hasNext()) {
                webServiceClientCheckMgr.setVerifierContext(this.context);
                webServiceClientCheckMgr.check((ServiceReferenceDescriptor)it.next());
            }
        }
    }

    @Override
    protected String getSchemaVersion(Descriptor descriptor) {
        return ((WebBundleDescriptor)descriptor).getSpecVersion();
    }

    @Override
    protected void setModuleName(Result r) {
        r.setModuleName("web");
    }

    @Override
    protected Vector<TestInformation> getTestFromExcludeList() throws ParserConfigurationException, SAXException, IOException {
        Vector<TestInformation> tests = super.getTestFromExcludeList();
        if (this.frameworkContext.getJspOutDir() != null) {
            TestInformation ti = new TestInformation();
            ti.setClassName("com.sun.enterprise.tools.verifier.tests.web.AllJSPsMustBeCompilable");
            tests.addElement(ti);
        }
        return tests;
    }

    @Override
    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((WebBundleDescriptor)descriptor);
    }
}

