/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.lang.reflect.Method;

public abstract class WSTest
extends VerifierTest
implements VerifierCheck,
WSCheck {
    public Result check(Descriptor descriptor) {
        return this.check((WebServiceEndpoint)descriptor);
    }

    public abstract Result check(WebServiceEndpoint var1);

    protected Class loadSEIClass(WebServiceEndpoint descriptor, Result result) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> cl = Class.forName(descriptor.getServiceEndpointInterface(), false, this.getVerifierContext().getClassLoader());
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.clpassed", "The [{0}] Class [{1}] exists and was loaded successfully.", new Object[]{"SEI", descriptor.getServiceEndpointInterface()}));
            return cl;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.WSTest.SEIClassExists", "Error: Service Endpoint Interface class [ {0} ]  not found.", new Object[]{descriptor.getServiceEndpointInterface()}));
            return null;
        }
    }

    protected Class loadImplBeanClass(WebServiceEndpoint descriptor, Result result) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String beanClassName = null;
        if (descriptor.implementedByEjbComponent()) {
            beanClassName = descriptor.getEjbComponentImpl().getEjbClassName();
        } else if (descriptor.implementedByWebComponent()) {
            WebComponentDescriptor wcd = descriptor.getWebComponentImpl();
            if (wcd != null) {
                beanClassName = wcd.getWebComponentImplementation();
            }
        } else {
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"The WebService is neither implemented by an EJB nor a Servlet"}));
        }
        if (beanClassName != null) {
            try {
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                return Class.forName(beanClassName, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.WSTest.BeanClassExists", "Error: Service Endpoint Implementation Bean class [ {0} ]  not found.", new Object[]{beanClassName}));
                return null;
            }
        }
        result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"The Servlet Impl Bean class name could not be resolved"}));
        return null;
    }

    public boolean isSEIMethod(MethodDescriptor mdesc, EjbDescriptor desc, Class sei, ClassLoader cl) {
        Method[] seiMeths = sei.getMethods();
        Method methToBeTested = null;
        try {
            methToBeTested = mdesc.getMethod(desc);
        }
        catch (Exception e) {
            return false;
        }
        for (int i = 0; i < seiMeths.length; ++i) {
            if (!WSTest.matchesSignatureAndReturn(seiMeths[i], methToBeTested)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesSignatureAndReturn(Method meth1, Method meth2) {
        Class<?>[] param2;
        Class<?> ret2;
        if (!meth1.getName().equals(meth2.getName())) {
            return false;
        }
        Class<?> ret1 = meth1.getReturnType();
        if (ret1 != (ret2 = meth2.getReturnType())) {
            return false;
        }
        Class<?>[] param1 = meth1.getParameterTypes();
        if (param1.length != (param2 = meth2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < param1.length; ++i) {
            if (param1[i] == param2[i]) continue;
            return false;
        }
        Class[] excep1 = meth1.getExceptionTypes();
        Class<?>[] excep2 = meth2.getExceptionTypes();
        for (int i = 0; i < excep2.length; ++i) {
            if (WSTest.isMatching(excep2[i], excep1)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMatching(Class cl, Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].equals(cl)) continue;
            return true;
        }
        return false;
    }

    protected String getAbstractArchiveUri(WebServiceEndpoint desc) {
        String archBase = this.getVerifierContext().getAbstractArchive().getArchiveUri();
        ModuleDescriptor moduleDescriptor = desc.getBundleDescriptor().getModuleDescriptor();
        if (moduleDescriptor.isStandalone()) {
            return archBase;
        }
        return archBase + File.separator + FileUtils.makeFriendlyFileName(moduleDescriptor.getArchiveUri());
    }
}

