/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import sun.security.action.GetPropertyAction;

public class SystemOutandErrHandler {
    private static final String SYSTEMERR_LOGGER = "javax.enterprise.system.stream.err";
    private static final String SYSTEMOUT_LOGGER = "javax.enterprise.system.stream.out";
    private static PrintStream originalSystemErr;
    private static Logger soLogger;
    private static Logger seLogger;
    private static Level errLogLevel;
    private static Level outLogLevel;
    private static String lineSeparator;
    private static int lineSeparatorSize;
    private LoggingPrintStream lout;
    private LoggingPrintStream lerr;

    public SystemOutandErrHandler() {
        if (originalSystemErr != null) {
            RuntimeException e = new RuntimeException("recursivecall");
            originalSystemErr.println("recursive call into SystemOutandErrhandler");
            e.printStackTrace(originalSystemErr);
            return;
        }
        LoggingByteArrayOutputStream buf = new LoggingByteArrayOutputStream();
        seLogger = Logger.getLogger(SYSTEMERR_LOGGER);
        buf.setLogger(seLogger, errLogLevel);
        originalSystemErr = System.err;
        this.lerr = new LoggingPrintStream(buf);
        this.lerr.setLogger(seLogger);
        System.setErr(this.lerr);
        buf = new LoggingByteArrayOutputStream();
        soLogger = Logger.getLogger(SYSTEMOUT_LOGGER);
        buf.setLogger(soLogger, outLogLevel);
        this.lout = new LoggingPrintStream(buf);
        this.lout.setLogger(soLogger);
        System.setOut(this.lout);
        lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        lineSeparatorSize = lineSeparator.length();
    }

    static {
        soLogger = null;
        seLogger = null;
        errLogLevel = Level.WARNING;
        outLogLevel = Level.INFO;
    }

    private class LoggingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private Level logLevel;
        private Logger logger;
        private boolean recursiveWarnIssued = false;
        private boolean inFlush = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            if (super.size() == 0) {
                return;
            }
            if (super.size() == lineSeparatorSize && super.toString().equals(lineSeparator)) {
                return;
            }
            LoggingByteArrayOutputStream loggingByteArrayOutputStream = this;
            synchronized (loggingByteArrayOutputStream) {
                if (this.inFlush) {
                    if (!this.recursiveWarnIssued) {
                        RuntimeException e = new RuntimeException("recursivecall");
                        originalSystemErr.println("recursive call into SystemOutandErrhandler");
                        e.printStackTrace(originalSystemErr);
                        this.recursiveWarnIssued = true;
                    }
                    return;
                }
                this.inFlush = true;
                super.flush();
                this.logger.log(this.logLevel, this.toString());
                this.inFlush = false;
                super.reset();
            }
        }

        public void setLogger(Logger systemlogger, Level loglevel) {
            this.logger = systemlogger;
            this.logLevel = loglevel;
        }
    }

    private class LoggingPrintStream
    extends PrintStream {
        private ByteArrayOutputStream bufOut;
        private Logger logger;
        LogManager logManager;
        private ThreadLocal perThreadStObjects;

        public LoggingPrintStream(LoggingByteArrayOutputStream buf) {
            super(buf, true);
            this.logger = null;
            this.logManager = null;
            this.perThreadStObjects = new ThreadLocal();
            this.bufOut = buf;
            this.logManager = LogManager.getLogManager();
        }

        public void setLogger(Logger l) {
            this.logger = l;
        }

        public void println(Object x) {
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects sTO = (StackTraceObjects)this.perThreadStObjects.get();
            if (sTO != null) {
                this.perThreadStObjects.set(null);
            }
            if (!(x instanceof Throwable)) {
                super.println(x);
                return;
            }
            sTO = new StackTraceObjects((Throwable)x);
            this.perThreadStObjects.set(sTO);
            super.println(sTO.toString());
        }

        public void println(String str) {
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects sTO = (StackTraceObjects)this.perThreadStObjects.get();
            if (sTO == null) {
                super.println(str);
                return;
            }
            if (!sTO.ignorePrintln(str)) {
                this.perThreadStObjects.set(null);
                super.println(str);
                return;
            }
            if (sTO.checkCompletion()) {
                this.perThreadStObjects.set(null);
                return;
            }
        }

        public void print(String x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void print(Object x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void print(boolean x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(boolean x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(char x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(char x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(int x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(int x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(long x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(long x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(float x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(float x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(double x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(double x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void print(char[] x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        public void println(char[] x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        public void println() {
            if (this.checkLocks()) {
                super.println();
            }
        }

        public void write(byte[] buf, int off, int len) {
            if (this.checkLocks()) {
                super.write(buf, off, len);
            }
        }

        public void write(int b) {
            if (this.checkLocks()) {
                super.write(b);
            }
        }

        private boolean checkLocks() {
            Thread t = Thread.currentThread();
            if (!Thread.holdsLock(this.logger)) {
                if (!Thread.holdsLock(this.logManager)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class StackTraceObjects {
        private ByteArrayOutputStream stackTraceBuf = new ByteArrayOutputStream();
        private PrintStream stStream = new PrintStream(this.stackTraceBuf, true);
        private String stString;
        private ByteArrayOutputStream comparisonBuf = new ByteArrayOutputStream();
        private int comparisonBufIndex = 0;
        private PrintStream cbStream = new PrintStream(this.comparisonBuf, true);
        private int stackTraceBufBytes = 0;
        private int charsIgnored = 0;

        private StackTraceObjects(Throwable x) {
            x.printStackTrace(this.stStream);
            this.stString = this.stackTraceBuf.toString();
            this.stackTraceBufBytes = this.stackTraceBuf.size();
            this.cbStream.println(x);
        }

        public String toString() {
            return this.stString;
        }

        boolean ignorePrintln(String str) {
            this.cbStream.println(str);
            String cbString = this.comparisonBuf.toString();
            int cbLen = cbString.length();
            if (this.stString.regionMatches(this.charsIgnored, cbString, 0, cbLen)) {
                this.charsIgnored += cbLen;
                this.comparisonBuf.reset();
                return true;
            }
            return false;
        }

        boolean checkCompletion() {
            return this.charsIgnored >= this.stackTraceBufBytes;
        }
    }
}

