/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.server.ApplicationLoader;
import com.sun.enterprise.web.PEWebContainer;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class TomcatApplicationLoader
extends ApplicationLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private AppsManager appsManager = null;
    private PEWebContainer webContainer = null;

    public TomcatApplicationLoader(String appID, ClassLoader parentClassLoader, AppsManager appsManager) {
        super(appID, parentClassLoader, appsManager);
        _logger.log(Level.FINEST, "[TomcatApplicationLoader] " + appID);
        this.appsManager = appsManager;
        this.webContainer = PEWebContainer.getPEWebContainer();
        _logger.log(Level.FINEST, "PEWebContainer " + this.webContainer);
    }

    protected boolean doLoad(boolean jsr77) {
        J2eeApplication[] j2eeAppBeans;
        _logger.log(Level.FINEST, "[TomcatApplicationLoader] load " + jsr77);
        boolean deployed = super.doLoad(jsr77);
        if (this.loadUnloadAction == 2 || !deployed) {
            return deployed;
        }
        _logger.log(Level.FINEST, "deployed " + deployed);
        if (this.webContainer == null) {
            this.webContainer = PEWebContainer.getPEWebContainer();
        }
        if (deployed && (j2eeAppBeans = this.appsManager.getAllApps()) != null) {
            for (int i = 0; i < j2eeAppBeans.length; ++i) {
                if (!j2eeAppBeans[i].getName().equals(this.id) || this.webContainer == null) continue;
                _logger.log(Level.FINEST, "[TomcatApplicationLoader] loadJ2EEAppWebModule with " + j2eeAppBeans[i]);
                this.webContainer.loadJ2EEApplicationWebModules(j2eeAppBeans[i]);
            }
        }
        return deployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unload(boolean jsr77) {
        if (this.loadUnloadAction == 5) {
            return super.unload(jsr77);
        }
        super.unloadWebserviceEndpoints(jsr77);
        Set wbds = null;
        J2eeApplication[] j2eeAppBeans = this.appsManager.getAllApps();
        if (j2eeAppBeans != null) {
            for (int i = 0; i < j2eeAppBeans.length; ++i) {
                if (!j2eeAppBeans[i].getName().equals(this.id)) continue;
                String virtualServers = null;
                try {
                    virtualServers = this.appsManager.getVirtualServersByAppName(j2eeAppBeans[i].getName());
                }
                catch (ConfigException ce) {
                    _logger.log(Level.FINEST, "[TomcatApplicationLoader] unload " + this.id + ". error getting virtualServers", ce);
                }
                _logger.log(Level.FINEST, "[TomcatApplicationLoader] unload " + this.id);
                wbds = this.application.getWebBundleDescriptors();
                WebBundleDescriptor wbd2 = null;
                if (wbds == null) continue;
                for (WebBundleDescriptor wbd2 : wbds) {
                    NamingException nameEx2;
                    Object var10_10;
                    String appName = wbd2.getApplication().getRegistrationName();
                    try {
                        this.webContainer.unloadWebModule(wbd2.getContextRoot(), appName, virtualServers, wbd2);
                        var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        try {
                            Switch.getSwitch().getNamingManager().unbindObjects(wbd2);
                        }
                        catch (NamingException nameEx2) {
                            _logger.log(Level.FINEST, "[TomcatApplicationLoader]  Exception during namingManager.unbindObject", nameEx2);
                        }
                        throw throwable;
                    }
                    try {
                        Switch.getSwitch().getNamingManager().unbindObjects(wbd2);
                    }
                    catch (NamingException nameEx2) {
                        _logger.log(Level.FINEST, "[TomcatApplicationLoader]  Exception during namingManager.unbindObject", nameEx2);
                    }
                }
            }
        }
        return super.unload(jsr77);
    }
}

