/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.server.ApplicationManager;
import com.sun.enterprise.server.ManagerFactory;
import com.sun.enterprise.server.StandAloneConnectorModulesManager;
import com.sun.enterprise.server.StandAloneEJBModulesManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

class TargetFileFilter
implements FileFilter {
    private static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.core");
    String targetType = null;

    TargetFileFilter(String targetType) {
        this.targetType = targetType;
    }

    public boolean accept(File f) {
        boolean flag = false;
        String name = f.getName();
        String fileType = null;
        int lastIndex = -1;
        if (name != null && name.length() > 0) {
            lastIndex = name.lastIndexOf(46);
            try {
                if (lastIndex >= 0) {
                    fileType = name.substring(lastIndex + 1);
                }
                if (!f.isDirectory() && f.canRead() && (name = name.substring(0, lastIndex)) != null && name.length() > 0) {
                    flag = true;
                }
            }
            catch (SecurityException se) {
                sLogger.log(Level.WARNING, "SecurityException occured while accessing :" + f.getName());
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Exception occured while accessing :" + f.getName());
            }
        }
        if (flag && this.isApplicableToTarget(f) && !this.isRegistered(name, fileType)) {
            sLogger.log(Level.FINE, "Selecting file [" + f.getAbsolutePath() + "] for autodeployment");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isApplicableToTarget(File f) {
        boolean bl;
        JarFile j;
        block25: {
            block21: {
                boolean bl2;
                block24: {
                    block22: {
                        boolean bl3;
                        block23: {
                            String appType;
                            block17: {
                                boolean bl4;
                                block20: {
                                    block18: {
                                        boolean bl5;
                                        block19: {
                                            j = null;
                                            j = new JarFile(f);
                                            Manifest m = j.getManifest();
                                            Attributes a = m.getMainAttributes();
                                            appType = a.getValue("Application-Type");
                                            if (appType == null) {
                                                appType = "user";
                                            }
                                            if (!this.targetType.equals("admin")) break block17;
                                            if (!appType.equals("system-admin") && !appType.equals("system-all")) break block18;
                                            bl5 = true;
                                            Object var8_13 = null;
                                            if (j == null) break block19;
                                            try {
                                                j.close();
                                            }
                                            catch (IOException ioe) {
                                                sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                                            }
                                        }
                                        return bl5;
                                    }
                                    bl4 = false;
                                    Object var8_14 = null;
                                    if (j == null) break block20;
                                    try {
                                        j.close();
                                    }
                                    catch (IOException ioe) {
                                        sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                                    }
                                }
                                return bl4;
                            }
                            if (!this.targetType.equals("instance")) break block21;
                            if (!appType.equals("system-instance") && !appType.equals("system-all")) break block22;
                            bl3 = true;
                            Object var8_15 = null;
                            if (j == null) break block23;
                            try {
                                j.close();
                            }
                            catch (IOException ioe) {
                                sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                            }
                        }
                        return bl3;
                    }
                    bl2 = false;
                    Object var8_16 = null;
                    if (j == null) break block24;
                    try {
                        j.close();
                    }
                    catch (IOException ioe) {
                        sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                    }
                }
                return bl2;
            }
            bl = false;
            Object var8_17 = null;
            if (j == null) break block25;
            try {
                j.close();
            }
            catch (IOException ioe) {
                sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
            }
        }
        return bl;
        catch (Exception e) {
            boolean bl6;
            block26: {
                try {
                    sLogger.log(Level.WARNING, "Exception occured while accessing :" + f.getName());
                    bl6 = false;
                    Object var8_18 = null;
                    if (j == null) break block26;
                }
                catch (Throwable throwable) {
                    block27: {
                        Object var8_19 = null;
                        if (j == null) break block27;
                        try {
                            j.close();
                        }
                        catch (IOException ioe) {
                            sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                        }
                    }
                    throw throwable;
                }
                try {
                    j.close();
                }
                catch (IOException ioe) {
                    sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                }
            }
            return bl6;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRegistered(String name, String type) {
        try {
            if (type.equals("ear")) {
                ApplicationManager amgr = ManagerFactory.getApplicationManager();
                return amgr.isRegistered(name);
            }
            if (type.equals("jar")) {
                StandAloneEJBModulesManager emgr = ManagerFactory.getSAEJBModulesManager();
                return emgr.isRegistered(name);
            }
            if (type.equals("rar")) {
                StandAloneConnectorModulesManager cmgr = ManagerFactory.getSAConnectorModulesManager();
                return cmgr.isRegistered(name);
            }
            if (!type.equals("war")) return false;
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, "error_occured_in_isreg", e);
        }
        return false;
    }
}

