/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.AbstractManager;
import com.sun.enterprise.server.ConnectorModuleLoader;
import com.sun.enterprise.server.ConnectorResourcesLoader;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

public class StandAloneConnectorModulesManager
extends AbstractManager
implements ModuleDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager("com.sun.enterprise.server");

    StandAloneConnectorModulesManager(ConnectorModulesManager connectorManager, ClassLoader parentClassLoader) {
        super(parentClassLoader, connectorManager);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
    }

    protected AbstractLoader getLoader(String moduleId) {
        return new ConnectorModuleLoader(moduleId, this.parentClassLoader, (ConnectorModulesManager)this.configManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean moduleDeployed(boolean jsr77, ConfigContext config, String moduleName) throws AdminEventListenerException {
        boolean loadJSR77;
        boolean result = false;
        boolean bl = loadJSR77 = jsr77 || this.loadJSR77(moduleName, DeployableObjectType.CONN);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In connector moduleDeployed event,name=" + moduleName);
        }
        AbstractLoader modLoader = this.getLoader(moduleName);
        _logger.log(Level.FINEST, "After get loader");
        if (loadJSR77) {
            try {
                modLoader.createRootMBean();
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_creating_jsr77_root_mbean", mbe);
                throw new AdminEventListenerException(mbe.getMessage());
            }
        }
        if (!this.isEnabled(config, moduleName)) return false;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Loading enabled moduleName: " + moduleName);
        }
        try {
            modLoader.setState(0);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
        }
        boolean retSts = modLoader.load(jsr77);
        if (retSts) {
            this.id2loader.put(moduleName, modLoader);
            try {
                modLoader.setState(1);
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
            }
        } else {
            _logger.log(Level.WARNING, "core.error_while_loading_connector_module " + moduleName);
            try {
                if (loadJSR77) {
                    modLoader.deleteLeafAndRootMBeans();
                }
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_leaf_and_root_mbeans", mbe);
                throw new AdminEventListenerException(mbe.getMessage());
            }
            try {
                modLoader.setState(4);
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
            }
            String msg = localStrings.getString("connector.error_while_loading_connector_module", moduleName);
            throw new AdminEventListenerException(msg);
        }
        result = true;
        if (!_logger.isLoggable(Level.FINE)) return result;
        _logger.log(Level.FINE, "Successfully loaded moduleName: " + moduleName);
        return result;
    }

    private boolean moduleUndeployed(boolean jsr77, String moduleName, boolean cascade) {
        ConnectorModuleLoader modLoader;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In connector moduleUndeployed event,name=" + moduleName);
        }
        if ((modLoader = (ConnectorModuleLoader)this.id2loader.remove(moduleName)) == null) {
            return true;
        }
        modLoader.setCascade(cascade);
        try {
            ((AbstractLoader)modLoader).setState(2);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
        }
        boolean undeployed = ((AbstractLoader)modLoader).unload(jsr77);
        if (undeployed) {
            if (jsr77) {
                try {
                    ((AbstractLoader)modLoader).deleteRootMBean();
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_root_mbean", mbe);
                }
            } else {
                try {
                    ((AbstractLoader)modLoader).setState(3);
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                }
            }
        }
        return undeployed;
    }

    public synchronized void moduleDeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("connector")) {
            DeployEventListenerHelper.getDeployEventListenerHelper().synchronize(event);
        }
        if (event.getForceDeploy()) {
            this.moduleEnabled(event);
            return;
        }
        try {
            ConnectorResourcesLoader connectorResourcesLoader = null;
            connectorResourcesLoader = new ConnectorResourcesLoader();
            connectorResourcesLoader.loadRAConfigs(event.getModuleName());
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, "" + e.getMessage());
            AdminEventListenerException aele = new AdminEventListenerException();
            aele.initCause(e);
            throw aele;
        }
        this.realDeployed(event);
    }

    private void realDeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        boolean jsr77 = false;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleDeployed");
            _logger.log(Level.FINEST, "ModuleType=" + event.getModuleType());
        }
        if (event.getModuleType().equals("connector")) {
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "modID=" + modID);
            }
            try {
                this.configManager.refreshConfigContext(event.getConfigContext());
                String action = event.getAction();
                if (action.equals("deploy") || action.equals("redeploy")) {
                    jsr77 = true;
                }
                if (this.isEnabled(event.getConfigContext(), modID) && !this.moduleDeployed(jsr77, event.getConfigContext(), modID)) {
                    String msg = localStrings.getString("connector.connector_deployed_failed", modID);
                    throw new AdminEventListenerException(msg);
                }
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
        }
    }

    public synchronized void moduleUndeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getForceDeploy()) {
            try {
                this.moduleDisabled(event);
            }
            catch (AdminEventListenerException aele) {
                _logger.log(Level.FINEST, "Error while UnDeploying module: " + event.getModuleName());
                throw aele;
            }
        } else {
            this.realUndeployed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realUndeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        block8: {
            String action;
            boolean jsr77 = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleUndeployed");
            }
            if ((action = event.getAction()).equals("undeploy") || action.equals("redeploy")) {
                jsr77 = true;
            }
            try {
                if (!event.getModuleType().equals("connector")) break block8;
                String modID = event.getModuleName();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "UnDeploying module: " + modID);
                }
                boolean undeployed = false;
                try {
                    ResourcesUtil.setEventConfigContext(event.getConfigContext());
                    undeployed = this.moduleUndeployed(jsr77, modID, event.getCascade());
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ResourcesUtil.resetEventConfigContext();
                    throw throwable;
                }
                ResourcesUtil.resetEventConfigContext();
                if (!undeployed) {
                    String msg = localStrings.getString("connector.connector_undeployed_failed", modID);
                    throw new AdminEventListenerException(msg);
                }
                this.configManager.refreshConfigContext(event.getConfigContext());
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
        }
    }

    public synchronized void moduleRedeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleType().equals("connector")) {
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "ReDeploying module: " + modID);
            }
            this.moduleUndeployed(event);
            this.moduleDeployed(event);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void moduleEnabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleEnabled");
        }
        if (!event.getModuleType().equals("connector")) return;
        String modID = event.getModuleName();
        if (!this.isEnabled(event.getConfigContext(), event.getModuleName())) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Module : " + modID + " enabled...");
        }
        String appName = event.getModuleName();
        ConnectorResourcesLoader connectorResourcesLoader = null;
        try {
            connectorResourcesLoader = new ConnectorResourcesLoader();
        }
        catch (ConfigException ce) {
            String msg = localStrings.getString("connector.connector_enable_failed", appName);
            _logger.log(Level.SEVERE, "core.failed_to_get_connectorresourcesloader");
            throw new AdminEventListenerException(msg);
        }
        try {
            try {
                ResourcesUtil.setEventConfigContext(event.getConfigContext());
                connectorResourcesLoader.loadRAConfigs(appName);
                this.realDeployed(event);
                connectorResourcesLoader.load(appName);
            }
            catch (AdminEventListenerException ex) {
                throw ex;
            }
            catch (Throwable th) {
                AdminEventListenerException aele = new AdminEventListenerException();
                aele.initCause(th);
                throw aele;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            ResourcesUtil.resetEventConfigContext();
            throw throwable;
        }
        ResourcesUtil.resetEventConfigContext();
    }

    public synchronized void moduleDisabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneConnectorModulesManager moduleDisabled");
        }
        if (event.getModuleType().equals("connector")) {
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Module : " + modID + " disabled...");
            }
            ConnectorModuleLoader modLoader = (ConnectorModuleLoader)this.id2loader.get(modID);
            event.setCascade(true);
            this.realUndeployed(event);
        }
    }

    public void moduleReferenceAdded(ModuleDeployEvent event) throws AdminEventListenerException {
    }

    public void moduleReferenceRemoved(ModuleDeployEvent event) throws AdminEventListenerException {
    }
}

