/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.MonitorListener;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.enterprise.server.ReloadMonitor;
import com.sun.enterprise.server.ondemand.OnDemandServer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class AbstractManager
implements MonitorListener {
    protected ClassLoader parentClassLoader;
    protected ApplicationRegistry registry;
    protected BaseManager configManager;
    protected Hashtable id2loader = new Hashtable();
    protected ReloadMonitor reloadMonitor = null;
    protected boolean systemAppsLoaded = false;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    AbstractManager(ClassLoader parentClassLoader, BaseManager configMgr) {
        this.parentClassLoader = parentClassLoader;
        this.configManager = configMgr;
        this.registry = ApplicationRegistry.getInstance();
        boolean monitor = this.configManager.isDynamicReloadEnabled();
        if (monitor) {
            this.reloadMonitor = ReloadMonitor.getInstance(this.configManager.getReloadPollIntervalInMillis());
        }
    }

    void load() {
        final ClassLoader connCL = this.parentClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(connCL);
                return null;
            }
        });
        List appList = null;
        try {
            appList = this.configManager.listIds();
        }
        catch (ConfigException confEx) {
            _logger.log(Level.WARNING, "core.error_while_getting_deployed_applist", confEx);
            return;
        }
        boolean jsr77 = true;
        for (int i = 0; i < appList.size(); ++i) {
            String id = (String)appList.get(i);
            try {
                if (this.configManager.isSystem(id)) {
                    continue;
                }
            }
            catch (ConfigException confEx) {
                _logger.log(Level.WARNING, "core.error_while_loading_app", confEx);
            }
            try {
                AbstractLoader loader = this.getLoader(id);
                loader.createRootMBean();
                ConfigContext ctx = this.configManager.getConfigContext();
                if (this.isEnabled(ctx, id)) {
                    try {
                        loader.setState(0);
                    }
                    catch (MBeanException mbe) {
                        _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                    }
                    this.id2loader.put(id, loader);
                    if (loader.load(jsr77)) {
                        try {
                            loader.setState(1);
                        }
                        catch (MBeanException mbe) {
                            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                        }
                    } else {
                        try {
                            loader.setState(4);
                        }
                        catch (MBeanException mbe) {
                            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                        }
                        _logger.log(Level.WARNING, "core.application_not_loaded", id);
                    }
                    this.addToReloadMonitor(id);
                    continue;
                }
                if (this.isEnabled(ctx, id)) continue;
                try {
                    loader.setState(3);
                    loader.createLeafMBeans();
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                }
                continue;
            }
            catch (ConfigException confEx) {
                _logger.log(Level.WARNING, "core.error_while_loading_app", confEx);
                continue;
            }
            catch (Throwable t) {
                _logger.log(Level.WARNING, "core.unexpected_error_occured_while_loading_app", t);
            }
        }
    }

    void loadSystem() {
        boolean jsr77 = true;
        if (this.systemAppsLoaded) {
            return;
        }
        List appList = null;
        try {
            appList = this.configManager.listIds();
        }
        catch (ConfigException confEx) {
            _logger.log(Level.WARNING, "core.error_while_getting_deployed_applist", confEx);
            return;
        }
        ArrayList<SystemAppStarter> systemAppStarters = new ArrayList<SystemAppStarter>();
        long systemAppLoadStartTime = System.currentTimeMillis();
        boolean isSystemAppLoadLoggingOn = _logger.isLoggable(Level.FINE);
        for (int i = 0; i < appList.size(); ++i) {
            String id = (String)appList.get(i);
            if (!OnDemandServer.isOnDemandOff() && OnDemandServer.getSystemAppLoader().isOnDemandSystemApp(id)) continue;
            try {
                if (!this.configManager.isSystem(id)) continue;
                SystemAppStarter starter = new SystemAppStarter(id, jsr77);
                systemAppStarters.add(starter);
                starter.submit();
                if (!isSystemAppLoadLoggingOn) continue;
                _logger.fine(this.getClass().getName() + " submitted system app load request for " + id);
                continue;
            }
            catch (ConfigException ce) {
                // empty catch block
            }
        }
        boolean systemAppsStartedOK = true;
        for (SystemAppStarter starter : systemAppStarters) {
            if (isSystemAppLoadLoggingOn) {
                _logger.fine("About to wait for completion of load request for " + starter.getID());
            }
            boolean ok = starter.waitDone() == null;
            systemAppsStartedOK &= ok;
            if (!isSystemAppLoadLoggingOn) continue;
            _logger.fine("Completion received for " + starter.getID() + " reports " + (ok ? "success" : "failure"));
        }
        if (!systemAppsStartedOK) {
            throw new RuntimeException(_logger.getResourceBundle().getString("core.unexpected_error_occured_while_loading_app"));
        }
        if (isSystemAppLoadLoggingOn) {
            _logger.fine(this.getClass().getName() + " has started its system apps successfully after " + (System.currentTimeMillis() - systemAppLoadStartTime) + " ms");
        }
        this.systemAppsLoaded = true;
    }

    public void loadOneSystemApp(String id, boolean jsr77) {
        final ClassLoader connCL = this.parentClassLoader;
        final ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cloader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(connCL);
                return cloader;
            }
        });
        try {
            ConfigContext ctx = this.configManager.getConfigContext();
            if (ResourcesUtil.createInstance().belongToSystemRar(id) || this.configManager.isSystem(id) && this.isEnabled(ctx, id)) {
                AbstractLoader loader = this.getLoader(id);
                loader.createRootMBean();
                this.id2loader.put(id, loader);
                if (!loader.load(jsr77)) {
                    _logger.log(Level.WARNING, "core.application_not_loaded", id);
                }
            }
        }
        catch (ConfigException confEx) {
            _logger.log(Level.SEVERE, "core.error_while_loading_system_app", confEx);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_loading_system_app", t);
        }
        if (cl != connCL) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }
    }

    void shutdown() {
        try {
            if (this.reloadMonitor != null) {
                this.reloadMonitor.stop();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "core.unexpected_error_occured_while_app_shutdown", t);
        }
    }

    protected void addToReloadMonitor(String id) throws ConfigException {
        if (this.reloadMonitor != null && !this.configManager.isSystem(id)) {
            String mPath = this.configManager.getLocation(id) + File.separator + ".reload";
            MonitorableEntry entry = new MonitorableEntry(id, new File(mPath), this);
            this.reloadMonitor.addMonitorableEntry(entry);
        }
    }

    protected void removeFromReloadMonitor(String id) {
    }

    public boolean reload(MonitorableEntry entry) {
        return false;
    }

    public boolean deploy(MonitorableEntry entry, File archive) {
        return false;
    }

    protected abstract AbstractLoader getLoader(String var1);

    ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public boolean isRegistered(String id) {
        return this.configManager.isRegistered(id);
    }

    protected boolean loadJSR77(String appName, DeployableObjectType type) {
        ObjectName jsr77mBeanObjectName = null;
        try {
            ObjectName[] objNameArr;
            String domainName = null;
            AdminService adminService = AdminService.getAdminService();
            if (adminService == null) {
                return false;
            }
            domainName = adminService.getAdminContext().getDomainName();
            String j2eeType = null;
            if (type.isAPP()) {
                j2eeType = "J2EEApplication";
            } else if (type.isEJB()) {
                j2eeType = "EJBModule";
            } else if (type.isCONN()) {
                j2eeType = "ResourceAdapterModule";
            } else if (type.isCAR()) {
                j2eeType = "AppClientModule";
            } else if (type.isWEB()) {
                return false;
            }
            String instanceName = ApplicationServer.getServerContext().getInstanceName();
            StringBuffer sb = new StringBuffer("");
            sb.append(domainName + ":");
            sb.append("j2eeType=" + j2eeType + ",");
            sb.append("name=" + appName + ",");
            if (!type.isAPP()) {
                sb.append("J2EEApplication=null,");
            }
            sb.append("J2EEServer=" + instanceName + "," + "*");
            MBeanServer mbs = adminService.getAdminContext().getMBeanServer();
            ObjectName objNamePattern = new ObjectName(sb.toString());
            Set<ObjectName> s = mbs.queryNames(objNamePattern, null);
            if (s != null && s.size() > 0 && (objNameArr = s.toArray(new ObjectName[s.size()])).length > 0) {
                jsr77mBeanObjectName = objNameArr[0];
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return jsr77mBeanObjectName == null;
    }

    protected boolean isEnabled(ConfigContext config, String moduleName) {
        try {
            ConfigBean app = ApplicationHelper.findApplication(config, moduleName);
            Server server = ServerBeansFactory.getServerBean(config);
            ApplicationRef appRef = server.getApplicationRefByRef(moduleName);
            return app != null && app.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            AdminEventListenerException ex = new AdminEventListenerException();
            ex.initCause(e);
            _logger.log(Level.FINE, "Error in finding " + moduleName, e);
            return false;
        }
    }

    protected void registerException(BaseDeployEvent event, String msg) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        result.setResultCode("success");
        result.addException(event.getEffectiveDestination(), new AdminEventListenerException(msg));
    }

    private class SystemAppStarter
    extends RunnableBase {
        private final String id;
        private final boolean jsr77;

        public SystemAppStarter(String id, boolean jsr77) {
            this.id = id;
            this.jsr77 = jsr77;
        }

        protected void doRun() throws Exception {
            AbstractManager.this.loadOneSystemApp(this.id, this.jsr77);
        }

        public String getID() {
            return this.id;
        }
    }
}

