/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.clientbeans.ClientBeansResolver;
import com.sun.enterprise.config.clientbeans.ClientContainer;
import com.sun.enterprise.config.clientbeans.ProviderConfig;
import com.sun.enterprise.config.clientbeans.RequestPolicy;
import com.sun.enterprise.config.clientbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.security.jmac.AuthMessagePolicy;
import com.sun.enterprise.security.jmac.config.ConfigParser;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.MessagePolicy;
import sun.security.util.PropertyExpander;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigXMLParser
implements ConfigParser {
    private static Logger _logger = null;
    private Map configMap = new HashMap();
    private Set<String> layersWithDefault = new HashSet<String>();
    private static final String SUNACC_XML_URL = "sun-acc.xml.url";

    ConfigXMLParser() throws IOException {
    }

    @Override
    public void initialize(ConfigContext configCtx) throws IOException {
        boolean isAppClientContainer;
        boolean bl = isAppClientContainer = Switch.getSwitch().getContainerType() == 1;
        if (configCtx == null) {
            if (isAppClientContainer) {
                try {
                    configCtx = ConfigFactory.createConfigContext(System.getProperty(SUNACC_XML_URL), true, false, false, ClientContainer.class, new ClientBeansResolver());
                }
                catch (ConfigException cex) {
                    IOException iex = new IOException();
                    iex.initCause(cex);
                    throw iex;
                }
            } else {
                configCtx = ApplicationServer.getServerContext().getConfigContext();
            }
            if (configCtx == null) {
                return;
            }
        }
        if (isAppClientContainer) {
            this.processClientConfigContext(configCtx, this.configMap);
        } else {
            this.processServerConfigContext(configCtx, this.configMap);
        }
    }

    private void processServerConfigContext(ConfigContext configCtx, Map newConfig) throws IOException {
        String intercept = null;
        try {
            Server configBean = ServerBeansFactory.getServerBean(configCtx);
            SecurityService secService = ServerBeansFactory.getSecurityServiceBean(configCtx);
            MessageSecurityConfig[] msgConfigs = secService.getMessageSecurityConfig();
            for (int j = 0; msgConfigs != null && j < msgConfigs.length; ++j) {
                intercept = this.parseInterceptEntry(msgConfigs[j], newConfig);
                com.sun.enterprise.config.serverbeans.ProviderConfig[] pConfigs = msgConfigs[j].getProviderConfig();
                for (int k = 0; pConfigs != null && k < pConfigs.length; ++k) {
                    this.parseIDEntry(pConfigs[k], newConfig, intercept);
                }
            }
        }
        catch (ConfigException ce) {
            IOException ioe = new IOException();
            ioe.initCause(ce);
            throw ioe;
        }
    }

    private void processClientConfigContext(ConfigContext configCtx, Map newConfig) throws IOException {
        String intercept = null;
        try {
            ClientContainer cc = (ClientContainer)configCtx.getRootConfigBean();
            com.sun.enterprise.config.clientbeans.MessageSecurityConfig[] msgConfigs = cc.getMessageSecurityConfig();
            for (int j = 0; msgConfigs != null && j < msgConfigs.length; ++j) {
                intercept = this.parseInterceptEntry(msgConfigs[j], newConfig);
                ProviderConfig[] pConfigs = msgConfigs[j].getProviderConfig();
                for (int k = 0; pConfigs != null && k < pConfigs.length; ++k) {
                    this.parseIDEntry(pConfigs[k], newConfig, intercept);
                }
            }
        }
        catch (ConfigException ce) {
            IOException ioe = new IOException();
            ioe.initCause(ce);
            throw ioe;
        }
    }

    @Override
    public Map getConfigMap() {
        return this.configMap;
    }

    @Override
    public Set<String> getLayersWithDefault() {
        return this.layersWithDefault;
    }

    private String parseInterceptEntry(ConfigBean msgConfig, Map newConfig) throws IOException {
        GFServerConfigProvider.InterceptEntry intEntry;
        String intercept = null;
        String defaultServerID = null;
        String defaultClientID = null;
        if (msgConfig instanceof MessageSecurityConfig) {
            MessageSecurityConfig serverMsgSecConfig = (MessageSecurityConfig)msgConfig;
            intercept = serverMsgSecConfig.getAuthLayer();
            defaultServerID = serverMsgSecConfig.getDefaultProvider();
            defaultClientID = serverMsgSecConfig.getDefaultClientProvider();
        } else if (msgConfig instanceof com.sun.enterprise.config.clientbeans.MessageSecurityConfig) {
            com.sun.enterprise.config.clientbeans.MessageSecurityConfig clientMsgSecConfig = (com.sun.enterprise.config.clientbeans.MessageSecurityConfig)msgConfig;
            intercept = clientMsgSecConfig.getAuthLayer();
            defaultServerID = clientMsgSecConfig.getDefaultProvider();
            defaultClientID = clientMsgSecConfig.getDefaultClientProvider();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Intercept Entry: \n    intercept: " + intercept + "\n    defaultServerID: " + defaultServerID + "\n    defaultClientID:  " + defaultClientID);
        }
        if (defaultServerID != null || defaultClientID != null) {
            this.layersWithDefault.add(intercept);
        }
        if ((intEntry = (GFServerConfigProvider.InterceptEntry)newConfig.get(intercept)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        intEntry = new GFServerConfigProvider.InterceptEntry(defaultClientID, defaultServerID, null);
        newConfig.put(intercept, intEntry);
        return intercept;
    }

    private void parseIDEntry(ProviderConfig pConfig, Map newConfig, String intercept) throws IOException {
        String id = pConfig.getProviderId();
        String type = pConfig.getProviderType();
        String moduleClass = pConfig.getClassName();
        MessagePolicy requestPolicy = this.parsePolicy(pConfig.getRequestPolicy());
        MessagePolicy responsePolicy = this.parsePolicy(pConfig.getResponsePolicy());
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < pConfig.sizeElementProperty(); ++i) {
            try {
                options.put(pConfig.getElementProperty(i).getName(), PropertyExpander.expand(pConfig.getElementProperty(i).getValue(), false));
                continue;
            }
            catch (PropertyExpander.ExpandException ee) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning("jmac.unexpandedproperty");
                }
                options.put(pConfig.getElementProperty(i).getName(), pConfig.getElementProperty(i).getValue());
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ID Entry: \n    module class: " + moduleClass + "\n    id: " + id + "\n    type: " + type + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    options: " + options);
        }
        GFServerConfigProvider.IDEntry idEntry = new GFServerConfigProvider.IDEntry(type, moduleClass, requestPolicy, responsePolicy, options);
        GFServerConfigProvider.InterceptEntry intEntry = (GFServerConfigProvider.InterceptEntry)newConfig.get(intercept);
        if (intEntry == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (intEntry.idMap == null) {
            intEntry.idMap = new HashMap();
        }
        intEntry.idMap.put(id, idEntry);
    }

    private void parseIDEntry(com.sun.enterprise.config.serverbeans.ProviderConfig pConfig, Map newConfig, String intercept) throws IOException {
        String id = pConfig.getProviderId();
        String type = pConfig.getProviderType();
        String moduleClass = pConfig.getClassName();
        MessagePolicy requestPolicy = this.parsePolicy(pConfig.getRequestPolicy());
        MessagePolicy responsePolicy = this.parsePolicy(pConfig.getResponsePolicy());
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < pConfig.sizeElementProperty(); ++i) {
            try {
                options.put(pConfig.getElementProperty(i).getName(), PropertyExpander.expand(pConfig.getElementProperty(i).getValue(), false));
                continue;
            }
            catch (PropertyExpander.ExpandException ee) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning("jmac.unexpandedproperty");
                }
                options.put(pConfig.getElementProperty(i).getName(), pConfig.getElementProperty(i).getValue());
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ID Entry: \n    module class: " + moduleClass + "\n    id: " + id + "\n    type: " + type + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    options: " + options);
        }
        GFServerConfigProvider.IDEntry idEntry = new GFServerConfigProvider.IDEntry(type, moduleClass, requestPolicy, responsePolicy, options);
        GFServerConfigProvider.InterceptEntry intEntry = (GFServerConfigProvider.InterceptEntry)newConfig.get(intercept);
        if (intEntry == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (intEntry.idMap == null) {
            intEntry.idMap = new HashMap();
        }
        intEntry.idMap.put(id, idEntry);
    }

    private MessagePolicy parsePolicy(ConfigBean policy) {
        if (policy == null) {
            return null;
        }
        String authSource = null;
        String authRecipient = null;
        if (policy instanceof com.sun.enterprise.config.serverbeans.RequestPolicy) {
            com.sun.enterprise.config.serverbeans.RequestPolicy serverRequestPolicy = (com.sun.enterprise.config.serverbeans.RequestPolicy)policy;
            authSource = serverRequestPolicy.getAuthSource();
            authRecipient = serverRequestPolicy.getAuthRecipient();
        } else if (policy instanceof com.sun.enterprise.config.serverbeans.ResponsePolicy) {
            com.sun.enterprise.config.serverbeans.ResponsePolicy serverResponsePolicy = (com.sun.enterprise.config.serverbeans.ResponsePolicy)policy;
            authSource = serverResponsePolicy.getAuthSource();
            authRecipient = serverResponsePolicy.getAuthRecipient();
        } else if (policy instanceof RequestPolicy) {
            RequestPolicy clientRequestPolicy = (RequestPolicy)policy;
            authSource = clientRequestPolicy.getAuthSource();
            authRecipient = clientRequestPolicy.getAuthRecipient();
        } else if (policy instanceof ResponsePolicy) {
            ResponsePolicy clientResponsePolicy = (ResponsePolicy)policy;
            authSource = clientResponsePolicy.getAuthSource();
            authRecipient = clientResponsePolicy.getAuthRecipient();
        }
        return AuthMessagePolicy.getMessagePolicy(authSource, authRecipient);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

