/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesXMLParser
implements EntityResolver {
    private File resourceFile = null;
    private Document document;
    private List<Resource> vResources;
    private boolean isDoctypePresent = false;
    private static StringManager localStrings = StringManager.getManager(ResourcesXMLParser.class);
    private static final int NONCONNECTOR = 2;
    private static final int CONNECTOR = 1;

    public ResourcesXMLParser(String resourceFileName) throws Exception {
        this.resourceFile = new File(resourceFileName);
        this.initProperties();
        this.vResources = new ArrayList<Resource>();
        this.generateResourceObjects();
    }

    private void initProperties() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            AddResourcesErrorHandler errorHandler = new AddResourcesErrorHandler();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this);
            builder.setErrorHandler(errorHandler);
            if (this.resourceFile == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_resource_file");
                throw new Exception(msg);
            }
            InputSource is = new InputSource(this.resourceFile.toURI().toString());
            this.document = builder.parse(is);
        }
        catch (SAXException sxe) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser sp = spf.newSAXParser();
                sp.setProperty("http://xml.org/sax/properties/lexical-handler", new MyLexicalHandler());
                sp.getXMLReader().parse(new InputSource(this.resourceFile.toString()));
            }
            catch (ParserConfigurationException ex) {
            }
            catch (SAXException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!this.isDoctypePresent) {
                throw new Exception(localStrings.getString("doctype.not.present.xml", this.resourceFile.toString()));
            }
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new Exception(x.getLocalizedMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new Exception(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new Exception(ioe.getLocalizedMessage());
        }
    }

    private void generateResourceObjects() throws Exception {
        if (this.document != null) {
            for (Node nextKid = this.document.getDocumentElement().getFirstChild(); nextKid != null; nextKid = nextKid.getNextSibling()) {
                String nodeName = nextKid.getNodeName();
                if (nodeName.equalsIgnoreCase("custom-resource")) {
                    this.generateCustomResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("external-jndi-resource")) {
                    this.generateJNDIResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("jdbc-resource")) {
                    this.generateJDBCResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("jdbc-connection-pool")) {
                    this.generateJDBCConnectionPoolResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("mail-resource")) {
                    this.generateMailResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("persistence-manager-factory-resource")) {
                    this.generatePersistenceResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("admin-object-resource")) {
                    this.generateAdminObjectResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("connector-resource")) {
                    this.generateConnectorResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("connector-connection-pool")) {
                    this.generateConnectorConnectionPoolResource(nextKid);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("resource-adapter-config")) continue;
                this.generateResourceAdapterConfig(nextKid);
            }
        }
    }

    private static List<Resource> getResourcesOfType(List<Resource> resources, int type, boolean isResourceCreation) {
        ArrayList<Resource> nonConnectorResources = new ArrayList<Resource>();
        ArrayList<Resource> connectorResources = new ArrayList<Resource>();
        for (Resource res : resources) {
            if (ResourcesXMLParser.isConnectorResource(res)) {
                if (res.getType().equals("resource-adapter-config")) {
                    if (isResourceCreation) {
                        nonConnectorResources.add(res);
                        continue;
                    }
                    connectorResources.add(res);
                    continue;
                }
                connectorResources.add(res);
                continue;
            }
            nonConnectorResources.add(res);
        }
        List<Resource> finalSortedConnectorList = ResourcesXMLParser.sortConnectorResources(connectorResources);
        List<Resource> finalSortedNonConnectorList = ResourcesXMLParser.sortNonConnectorResources(nonConnectorResources);
        if (type == 1) {
            return finalSortedConnectorList;
        }
        return finalSortedNonConnectorList;
    }

    private static List<Resource> sortConnectorResources(List<Resource> connectorResources) {
        ArrayList<Resource> raconfigs = new ArrayList<Resource>();
        ArrayList<Resource> ccps = new ArrayList<Resource>();
        ArrayList<Resource> others = new ArrayList<Resource>();
        ArrayList<Resource> finalSortedConnectorList = new ArrayList<Resource>();
        for (Resource resource : connectorResources) {
            if (resource.getType().equals("resource-adapter-config")) {
                raconfigs.add(resource);
                continue;
            }
            if (resource.getType().equals("connector-connection-pool")) {
                ccps.add(resource);
                continue;
            }
            others.add(resource);
        }
        finalSortedConnectorList.addAll(raconfigs);
        finalSortedConnectorList.addAll(ccps);
        finalSortedConnectorList.addAll(others);
        return finalSortedConnectorList;
    }

    private static List<Resource> sortNonConnectorResources(List<Resource> nonConnectorResources) {
        ArrayList<Resource> jdbccps = new ArrayList<Resource>();
        ArrayList<Resource> pmfs = new ArrayList<Resource>();
        ArrayList<Resource> others = new ArrayList<Resource>();
        ArrayList<Resource> finalSortedNonConnectorList = new ArrayList<Resource>();
        for (Resource resource : nonConnectorResources) {
            if (resource.getType().equals("jdbc-connection-pool")) {
                jdbccps.add(resource);
                continue;
            }
            if (resource.getType().equals("persistence-manager-factory-resource")) {
                pmfs.add(resource);
                continue;
            }
            others.add(resource);
        }
        finalSortedNonConnectorList.addAll(jdbccps);
        finalSortedNonConnectorList.addAll(others);
        finalSortedNonConnectorList.addAll(pmfs);
        return finalSortedNonConnectorList;
    }

    private static boolean isConnectorResource(Resource res) {
        String type = res.getType();
        return type.equals("admin-object-resource") || type.equals("connector-connection-pool") || type.equals("connector-resource") || type.equals("security-map") || type.equals("resource-adapter-config");
    }

    private void generateCustomResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = jndiNameNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem("res-type");
        String resType = resTypeNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem("factory-class");
        String factoryClass = factoryClassNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource customResource = new Resource("custom-resource");
        customResource.setAttribute("jndi-name", jndiName);
        customResource.setAttribute("res-type", resType);
        customResource.setAttribute("factory-class", factoryClass);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            customResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(customResource, children);
        this.vResources.add(customResource);
        this.printResourceElements(customResource);
    }

    private void generateJNDIResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = jndiNameNode.getNodeValue();
        Node jndiLookupNode = attributes.getNamedItem("jndi-lookup-name");
        String jndiLookup = jndiLookupNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem("res-type");
        String resType = resTypeNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem("factory-class");
        String factoryClass = factoryClassNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource jndiResource = new Resource("external-jndi-resource");
        jndiResource.setAttribute("jndi-name", jndiName);
        jndiResource.setAttribute("jndi-lookup-name", jndiLookup);
        jndiResource.setAttribute("res-type", resType);
        jndiResource.setAttribute("factory-class", factoryClass);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            jndiResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(jndiResource, children);
        this.vResources.add(jndiResource);
        this.printResourceElements(jndiResource);
    }

    private void generateJDBCResource(Node nextKid) throws Exception {
        NodeList children;
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = jndiNameNode.getNodeValue();
        Node poolNameNode = attributes.getNamedItem("pool-name");
        String poolName = poolNameNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource jdbcResource = new Resource("jdbc-resource");
        jdbcResource.setAttribute("jndi-name", jndiName);
        jdbcResource.setAttribute("pool-name", poolName);
        if (enabledNode != null) {
            String enabledName = enabledNode.getNodeValue();
            jdbcResource.setAttribute("enabled", enabledName);
        }
        if ((children = nextKid.getChildNodes()) != null) {
            for (int ii = 0; ii < children.getLength(); ++ii) {
                if (!children.item(ii).getNodeName().equals("description") || children.item(ii).getFirstChild() == null) continue;
                jdbcResource.setDescription(children.item(ii).getFirstChild().getNodeValue());
            }
        }
        this.vResources.add(jdbcResource);
        this.printResourceElements(jdbcResource);
    }

    private void generateJDBCConnectionPoolResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        String name = nameNode.getNodeValue();
        Node nSteadyPoolSizeNode = attributes.getNamedItem("steady-pool-size");
        Node nMaxPoolSizeNode = attributes.getNamedItem("max-pool-size");
        Node nMaxWaitTimeInMillisNode = attributes.getNamedItem("max-wait-time-in-millis");
        Node nPoolSizeQuantityNode = attributes.getNamedItem("pool-resize-quantity");
        Node nIdleTimeoutInSecNode = attributes.getNamedItem("idle-timeout-in-seconds");
        Node nIsConnectionValidationRequiredNode = attributes.getNamedItem("is-connection-validation-required");
        Node nConnectionValidationMethodNode = attributes.getNamedItem("connection-validation-method");
        Node nFailAllConnectionsNode = attributes.getNamedItem("fail-all-connections");
        Node nValidationTableNameNode = attributes.getNamedItem("validation-table-name");
        Node nResType = attributes.getNamedItem("res-type");
        Node nTransIsolationLevel = attributes.getNamedItem("transaction-isolation-level");
        Node nIsIsolationLevelQuaranteed = attributes.getNamedItem("is-isolation-level-guaranteed");
        Node datasourceNode = attributes.getNamedItem("datasource-classname");
        String datasource = datasourceNode.getNodeValue();
        Node nNonTransConnections = attributes.getNamedItem("non-transactional-connections");
        Node nAllowNonCompCallers = attributes.getNamedItem("allow-non-component-callers");
        Node nValidateAtmostOncePeriod = attributes.getNamedItem("validate-atmost-once-period-in-seconds");
        Node nConnLeakTimeoutSecs = attributes.getNamedItem("connection-leak-timeout-in-seconds");
        Node nConnLeakReclaim = attributes.getNamedItem("connection-leak-reclaim");
        Node nConnCreationRetryAttempts = attributes.getNamedItem("connection-creation-retry-attempts");
        Node nConnCreationRetryInterval = attributes.getNamedItem("connection-creation-retry-interval-in-seconds");
        Node nSttTimeoutSecs = attributes.getNamedItem("statement-timeout-in-seconds");
        Node nLazyConnEnlistment = attributes.getNamedItem("lazy-connection-enlistment");
        Node nLazyConnAssociation = attributes.getNamedItem("lazy-connection-association");
        Node nAssociateWithThread = attributes.getNamedItem("associate-with-thread");
        Node nMatchConnections = attributes.getNamedItem("match-connections");
        Node nMaxConnUsageCount = attributes.getNamedItem("max-connection-usage-count");
        Node nWrapJdbcObjects = attributes.getNamedItem("wrap-jdbc-objects");
        Resource jdbcResource = new Resource("jdbc-connection-pool");
        jdbcResource.setAttribute("name", name);
        jdbcResource.setAttribute("datasource-classname", datasource);
        if (nSteadyPoolSizeNode != null) {
            String sSteadyPoolSize = nSteadyPoolSizeNode.getNodeValue();
            jdbcResource.setAttribute("steady-pool-size", sSteadyPoolSize);
        }
        if (nMaxPoolSizeNode != null) {
            String sMaxPoolSize = nMaxPoolSizeNode.getNodeValue();
            jdbcResource.setAttribute("max-pool-size", sMaxPoolSize);
        }
        if (nMaxWaitTimeInMillisNode != null) {
            String sMaxWaitTimeInMillis = nMaxWaitTimeInMillisNode.getNodeValue();
            jdbcResource.setAttribute("max-wait-time-in-millis", sMaxWaitTimeInMillis);
        }
        if (nPoolSizeQuantityNode != null) {
            String sPoolSizeQuantity = nPoolSizeQuantityNode.getNodeValue();
            jdbcResource.setAttribute("pool-resize-quantity", sPoolSizeQuantity);
        }
        if (nIdleTimeoutInSecNode != null) {
            String sIdleTimeoutInSec = nIdleTimeoutInSecNode.getNodeValue();
            jdbcResource.setAttribute("idle-timeout-in-seconds", sIdleTimeoutInSec);
        }
        if (nIsConnectionValidationRequiredNode != null) {
            String sIsConnectionValidationRequired = nIsConnectionValidationRequiredNode.getNodeValue();
            jdbcResource.setAttribute("is-connection-validation-required", sIsConnectionValidationRequired);
        }
        if (nConnectionValidationMethodNode != null) {
            String sConnectionValidationMethod = nConnectionValidationMethodNode.getNodeValue();
            jdbcResource.setAttribute("connection-validation-method", sConnectionValidationMethod);
        }
        if (nFailAllConnectionsNode != null) {
            String sFailAllConnection = nFailAllConnectionsNode.getNodeValue();
            jdbcResource.setAttribute("fail-all-connections", sFailAllConnection);
        }
        if (nValidationTableNameNode != null) {
            String sValidationTableName = nValidationTableNameNode.getNodeValue();
            jdbcResource.setAttribute("validation-table-name", sValidationTableName);
        }
        if (nResType != null) {
            String sResType = nResType.getNodeValue();
            jdbcResource.setAttribute("res-type", sResType);
        }
        if (nTransIsolationLevel != null) {
            String sTransIsolationLevel = nTransIsolationLevel.getNodeValue();
            jdbcResource.setAttribute("transaction-isolation-level", sTransIsolationLevel);
        }
        if (nIsIsolationLevelQuaranteed != null) {
            String sIsIsolationLevelQuaranteed = nIsIsolationLevelQuaranteed.getNodeValue();
            jdbcResource.setAttribute("is-isolation-level-guaranteed", sIsIsolationLevelQuaranteed);
        }
        if (nNonTransConnections != null) {
            String sNonTransConnections = nNonTransConnections.getNodeValue();
            jdbcResource.setAttribute("non-transactional-connections", sNonTransConnections);
        }
        if (nAllowNonCompCallers != null) {
            String sAllowNonCompCallers = nAllowNonCompCallers.getNodeValue();
            jdbcResource.setAttribute("allow-non-component-callers", sAllowNonCompCallers);
        }
        if (nValidateAtmostOncePeriod != null) {
            String sValidateAtmostOncePeriod = nValidateAtmostOncePeriod.getNodeValue();
            jdbcResource.setAttribute("validate-atmost-once-period-in-seconds", sValidateAtmostOncePeriod);
        }
        if (nConnLeakTimeoutSecs != null) {
            String sConnLeakTimeoutSecs = nConnLeakTimeoutSecs.getNodeValue();
            jdbcResource.setAttribute("connection-leak-timeout-in-seconds", sConnLeakTimeoutSecs);
        }
        if (nConnLeakReclaim != null) {
            String sConnLeakReclaim = nConnLeakReclaim.getNodeValue();
            jdbcResource.setAttribute("connection-leak-reclaim", sConnLeakReclaim);
        }
        if (nConnCreationRetryAttempts != null) {
            String sConnCreationRetryAttempts = nConnCreationRetryAttempts.getNodeValue();
            jdbcResource.setAttribute("connection-creation-retry-attempts", sConnCreationRetryAttempts);
        }
        if (nConnCreationRetryInterval != null) {
            String sConnCreationRetryInterval = nConnCreationRetryInterval.getNodeValue();
            jdbcResource.setAttribute("connection-creation-retry-interval-in-seconds", sConnCreationRetryInterval);
        }
        if (nSttTimeoutSecs != null) {
            String sSttTimeoutSecs = nSttTimeoutSecs.getNodeValue();
            jdbcResource.setAttribute("statement-timeout-in-seconds", sSttTimeoutSecs);
        }
        if (nLazyConnEnlistment != null) {
            String sLazyConnEnlistment = nLazyConnEnlistment.getNodeValue();
            jdbcResource.setAttribute("lazy-connection-enlistment", sLazyConnEnlistment);
        }
        if (nLazyConnAssociation != null) {
            String sLazyConnAssociation = nLazyConnAssociation.getNodeValue();
            jdbcResource.setAttribute("lazy-connection-association", sLazyConnAssociation);
        }
        if (nAssociateWithThread != null) {
            String sAssociateWithThread = nAssociateWithThread.getNodeValue();
            jdbcResource.setAttribute("associate-with-thread", sAssociateWithThread);
        }
        if (nMatchConnections != null) {
            String sMatchConnections = nMatchConnections.getNodeValue();
            jdbcResource.setAttribute("match-connections", sMatchConnections);
        }
        if (nMaxConnUsageCount != null) {
            String sMaxConnUsageCount = nMaxConnUsageCount.getNodeValue();
            jdbcResource.setAttribute("max-connection-usage-count", sMaxConnUsageCount);
        }
        if (nWrapJdbcObjects != null) {
            String sWrapJdbcObjects = nWrapJdbcObjects.getNodeValue();
            jdbcResource.setAttribute("wrap-jdbc-objects", sWrapJdbcObjects);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(jdbcResource, children);
        this.vResources.add(jdbcResource);
        this.printResourceElements(jdbcResource);
    }

    private void generateMailResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        Node hostNode = attributes.getNamedItem("host");
        Node userNode = attributes.getNamedItem("user");
        Node fromAddressNode = attributes.getNamedItem("from");
        Node storeProtoNode = attributes.getNamedItem("store-protocol");
        Node storeProtoClassNode = attributes.getNamedItem("store-protocol-class");
        Node transProtoNode = attributes.getNamedItem("transport-protocol");
        Node transProtoClassNode = attributes.getNamedItem("transport-protocol-class");
        Node debugNode = attributes.getNamedItem("debug");
        Node enabledNode = attributes.getNamedItem("enabled");
        String jndiName = jndiNameNode.getNodeValue();
        String host = hostNode.getNodeValue();
        String user = userNode.getNodeValue();
        String fromAddress = fromAddressNode.getNodeValue();
        Resource mailResource = new Resource("mail-resource");
        mailResource.setAttribute("jndi-name", jndiName);
        mailResource.setAttribute("host", host);
        mailResource.setAttribute("user", user);
        mailResource.setAttribute("from", fromAddress);
        if (storeProtoNode != null) {
            String sStoreProto = storeProtoNode.getNodeValue();
            mailResource.setAttribute("store-protocol", sStoreProto);
        }
        if (storeProtoClassNode != null) {
            String sStoreProtoClass = storeProtoClassNode.getNodeValue();
            mailResource.setAttribute("store-protocol-class", sStoreProtoClass);
        }
        if (transProtoNode != null) {
            String sTransProto = transProtoNode.getNodeValue();
            mailResource.setAttribute("transport-protocol", sTransProto);
        }
        if (transProtoClassNode != null) {
            String sTransProtoClass = transProtoClassNode.getNodeValue();
            mailResource.setAttribute("transport-protocol-class", sTransProtoClass);
        }
        if (debugNode != null) {
            String sDebug = debugNode.getNodeValue();
            mailResource.setAttribute("debug", sDebug);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            mailResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(mailResource, children);
        this.vResources.add(mailResource);
        this.printResourceElements(mailResource);
    }

    private void generatePersistenceResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = jndiNameNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem("factory-class");
        Node poolNameNode = attributes.getNamedItem("jdbc-resource-jndi-name");
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource persistenceResource = new Resource("persistence-manager-factory-resource");
        persistenceResource.setAttribute("jndi-name", jndiName);
        if (factoryClassNode != null) {
            String factoryClass = factoryClassNode.getNodeValue();
            persistenceResource.setAttribute("factory-class", factoryClass);
        }
        if (poolNameNode != null) {
            String poolName = poolNameNode.getNodeValue();
            persistenceResource.setAttribute("jdbc-resource-jndi-name", poolName);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            persistenceResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(persistenceResource, children);
        this.vResources.add(persistenceResource);
        this.printResourceElements(persistenceResource);
    }

    private void generateAdminObjectResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = jndiNameNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem("res-type");
        String resType = resTypeNode.getNodeValue();
        Node resAdapterNode = attributes.getNamedItem("res-adapter");
        String resAdapter = resAdapterNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource adminObjectResource = new Resource("admin-object-resource");
        adminObjectResource.setAttribute("jndi-name", jndiName);
        adminObjectResource.setAttribute("res-type", resType);
        adminObjectResource.setAttribute("res-adapter", resAdapter);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            adminObjectResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(adminObjectResource, children);
        this.vResources.add(adminObjectResource);
        this.printResourceElements(adminObjectResource);
    }

    private void generateConnectorResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = jndiNameNode.getNodeValue();
        Node poolNameNode = attributes.getNamedItem("pool-name");
        String poolName = poolNameNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem("resource-type");
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource connectorResource = new Resource("connector-resource");
        connectorResource.setAttribute("jndi-name", jndiName);
        connectorResource.setAttribute("pool-name", poolName);
        if (resTypeNode != null) {
            String resType = resTypeNode.getNodeValue();
            connectorResource.setAttribute("resource-type", resType);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            connectorResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(connectorResource, children);
        this.vResources.add(connectorResource);
        this.printResourceElements(connectorResource);
    }

    private void generatePropertyElement(Resource rs, NodeList children) throws Exception {
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node descNode;
                if (children.item(i).getNodeName().equals("property")) {
                    NamedNodeMap attNodeMap = children.item(i).getAttributes();
                    Node nameNode = attNodeMap.getNamedItem("name");
                    Node valueNode = attNodeMap.getNamedItem("value");
                    if (nameNode != null && valueNode != null) {
                        boolean bDescFound = false;
                        String sName = nameNode.getNodeValue();
                        String sValue = valueNode.getNodeValue();
                        for (Node descNode2 = children.item(i).getFirstChild(); descNode2 != null && !bDescFound; descNode2 = descNode2.getNextSibling()) {
                            if (!descNode2.getNodeName().equalsIgnoreCase("description")) continue;
                            try {
                                rs.setProperty(sName, sValue);
                                bDescFound = true;
                                continue;
                            }
                            catch (DOMException dome) {
                                throw new Exception(dome.getLocalizedMessage());
                            }
                        }
                        if (!bDescFound) {
                            rs.setProperty(sName, sValue);
                        }
                    }
                }
                if (!children.item(i).getNodeName().equals("description") || (descNode = children.item(i).getFirstChild()) == null) continue;
                rs.setDescription(descNode.getNodeValue());
            }
        }
    }

    private void generateConnectorConnectionPoolResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        Node raConfigNode = attributes.getNamedItem("resource-adapter-name");
        Node conDefNode = attributes.getNamedItem("connection-definition-name");
        Node steadyPoolSizeNode = attributes.getNamedItem("steady-pool-size");
        Node maxPoolSizeNode = attributes.getNamedItem("max-pool-size");
        Node poolResizeNode = attributes.getNamedItem("pool-resize-quantity");
        Node idleTimeOutNode = attributes.getNamedItem("idle-timeout-in-seconds");
        Node failAllConnNode = attributes.getNamedItem("fail-all-connections");
        Node maxWaitTimeMillisNode = attributes.getNamedItem("max-wait-time-in-millis");
        Node transactionSupportNode = attributes.getNamedItem("transaction-support");
        Node connValidationReqdNode = attributes.getNamedItem("is-connection-validation-required");
        Node validateAtmostOncePeriodNode = attributes.getNamedItem("validate-atmost-once-period-in-seconds");
        Node connLeakTimeoutNode = attributes.getNamedItem("connection-leak-timeout-in-seconds");
        Node connLeakReclaimNode = attributes.getNamedItem("connection-leak-reclaim");
        Node connCreationRetryAttemptsNode = attributes.getNamedItem("connection-creation-retry-attempts");
        Node connCreationRetryIntervalNode = attributes.getNamedItem("connection-creation-retry-interval-in-seconds");
        Node lazyConnEnlistmentNode = attributes.getNamedItem("lazy-connection-enlistment");
        Node lazyConnAssociationNode = attributes.getNamedItem("lazy-connection-association");
        Node associateWithThreadNode = attributes.getNamedItem("associate-with-thread");
        Node matchConnectionsNode = attributes.getNamedItem("match-connections");
        Node maxConnUsageCountNode = attributes.getNamedItem("max-connection-usage-count");
        String poolName = null;
        Resource connectorConnPoolResource = new Resource("connector-connection-pool");
        if (nameNode != null) {
            poolName = nameNode.getNodeValue();
            connectorConnPoolResource.setAttribute("name", poolName);
        }
        if (raConfigNode != null) {
            String raConfig = raConfigNode.getNodeValue();
            connectorConnPoolResource.setAttribute("resource-adapter-name", raConfig);
        }
        if (conDefNode != null) {
            String conDef = conDefNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-definition-name", conDef);
        }
        if (steadyPoolSizeNode != null) {
            String steadyPoolSize = steadyPoolSizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("steady-pool-size", steadyPoolSize);
        }
        if (maxPoolSizeNode != null) {
            String maxPoolSize = maxPoolSizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("max-pool-size", maxPoolSize);
        }
        if (poolResizeNode != null) {
            String poolResize = poolResizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("pool-resize-quantity", poolResize);
        }
        if (idleTimeOutNode != null) {
            String idleTimeOut = idleTimeOutNode.getNodeValue();
            connectorConnPoolResource.setAttribute("idle-timeout-in-seconds", idleTimeOut);
        }
        if (failAllConnNode != null) {
            String failAllConn = failAllConnNode.getNodeValue();
            connectorConnPoolResource.setAttribute("fail-all-connections", failAllConn);
        }
        if (maxWaitTimeMillisNode != null) {
            String maxWaitTimeMillis = maxWaitTimeMillisNode.getNodeValue();
            connectorConnPoolResource.setAttribute("max-wait-time-in-millis", maxWaitTimeMillis);
        }
        if (transactionSupportNode != null) {
            String transactionSupport = transactionSupportNode.getNodeValue();
            connectorConnPoolResource.setAttribute("transaction-support", transactionSupport);
        }
        if (connValidationReqdNode != null) {
            String connValidationReqd = connValidationReqdNode.getNodeValue();
            connectorConnPoolResource.setAttribute("is-connection-validation-required", connValidationReqd);
        }
        if (validateAtmostOncePeriodNode != null) {
            String validateAtmostOncePeriod = validateAtmostOncePeriodNode.getNodeValue();
            connectorConnPoolResource.setAttribute("validate-atmost-once-period-in-seconds", validateAtmostOncePeriod);
        }
        if (connLeakTimeoutNode != null) {
            String connLeakTimeout = connLeakTimeoutNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-leak-timeout-in-seconds", connLeakTimeout);
        }
        if (connLeakReclaimNode != null) {
            String connLeakReclaim = connLeakReclaimNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-leak-reclaim", connLeakReclaim);
        }
        if (connCreationRetryAttemptsNode != null) {
            String connCreationRetryAttempts = connCreationRetryAttemptsNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-creation-retry-attempts", connCreationRetryAttempts);
        }
        if (connCreationRetryIntervalNode != null) {
            String connCreationRetryInterval = connCreationRetryIntervalNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-creation-retry-interval-in-seconds", connCreationRetryInterval);
        }
        if (lazyConnEnlistmentNode != null) {
            String lazyConnEnlistment = lazyConnEnlistmentNode.getNodeValue();
            connectorConnPoolResource.setAttribute("lazy-connection-enlistment", lazyConnEnlistment);
        }
        if (lazyConnAssociationNode != null) {
            String lazyConnAssociation = lazyConnAssociationNode.getNodeValue();
            connectorConnPoolResource.setAttribute("lazy-connection-association", lazyConnAssociation);
        }
        if (associateWithThreadNode != null) {
            String associateWithThread = associateWithThreadNode.getNodeValue();
            connectorConnPoolResource.setAttribute("associate-with-thread", associateWithThread);
        }
        if (matchConnectionsNode != null) {
            String matchConnections = matchConnectionsNode.getNodeValue();
            connectorConnPoolResource.setAttribute("match-connections", matchConnections);
        }
        if (maxConnUsageCountNode != null) {
            String maxConnUsageCount = maxConnUsageCountNode.getNodeValue();
            connectorConnPoolResource.setAttribute("max-connection-usage-count", maxConnUsageCount);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(connectorConnPoolResource, children);
        this.vResources.add(connectorConnPoolResource);
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (!children.item(i).getNodeName().equals("security-map")) continue;
                this.generateSecurityMap(poolName, children.item(i));
            }
        }
        this.printResourceElements(connectorConnPoolResource);
    }

    private void generateSecurityMap(String poolName, Node mapNode) throws Exception {
        NamedNodeMap attributes = mapNode.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        Resource map = new Resource("security-map");
        if (nameNode != null) {
            String name = nameNode.getNodeValue();
            map.setAttribute("name", name);
        }
        if (poolName != null) {
            map.setAttribute("pool-name", poolName);
        }
        StringBuffer principal = new StringBuffer();
        StringBuffer usergroup = new StringBuffer();
        NodeList children = mapNode.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node passwordNode;
                NamedNodeMap attributes1;
                Node gChild = children.item(i);
                String strNodeName = gChild.getNodeName();
                if (strNodeName.equals("principal")) {
                    String p = gChild.getFirstChild().getNodeValue();
                    principal.append(p).append(",");
                }
                if (strNodeName.equals("user-group")) {
                    String u = gChild.getFirstChild().getNodeValue();
                    usergroup.append(u).append(",");
                }
                if (!strNodeName.equals("backend-principal") || (attributes1 = children.item(i).getAttributes()) == null) continue;
                Node userNode = attributes1.getNamedItem("user-name");
                if (userNode != null) {
                    String userName = userNode.getNodeValue();
                    map.setAttribute("user-name", userName);
                }
                if ((passwordNode = attributes1.getNamedItem("password")) == null) continue;
                String pwd = passwordNode.getNodeValue();
                map.setAttribute("password", pwd);
            }
        }
        map.setAttribute("principal", this.convertToStringArray(principal.toString()));
        map.setAttribute("user_group", this.convertToStringArray(usergroup.toString()));
        this.vResources.add(map);
    }

    private void generateResourceAdapterConfig(Node nextKid) throws Exception {
        Node resAdapNameNode;
        Node poolIdNode;
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Resource resAdapterConfigResource = new Resource("resource-adapter-config");
        Node resAdapConfigNode = attributes.getNamedItem("resource-adapter-config");
        if (resAdapConfigNode != null) {
            String resAdapConfig = resAdapConfigNode.getNodeValue();
            resAdapterConfigResource.setAttribute("resource-adapter-config", resAdapConfig);
        }
        if ((poolIdNode = attributes.getNamedItem("thread-pool-ids")) != null) {
            String threadPoolId = poolIdNode.getNodeValue();
            resAdapterConfigResource.setAttribute("thread-pool-ids", threadPoolId);
        }
        if ((resAdapNameNode = attributes.getNamedItem("resource-adapter-name")) != null) {
            String resAdapName = resAdapNameNode.getNodeValue();
            resAdapterConfigResource.setAttribute("resource-adapter-name", resAdapName);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(resAdapterConfigResource, children);
        this.vResources.add(resAdapterConfigResource);
        this.printResourceElements(resAdapterConfigResource);
    }

    public Iterator<Resource> getResources() {
        return this.vResources.iterator();
    }

    public List getResourcesList() {
        return this.vResources;
    }

    public static List getNonConnectorResourcesList(List<Resource> resources, boolean isResourceCreation) {
        return ResourcesXMLParser.getResourcesOfType(resources, 2, isResourceCreation);
    }

    public static List getConnectorResourcesList(List<Resource> resources, boolean isResourceCreation) {
        return ResourcesXMLParser.getResourcesOfType(resources, 1, isResourceCreation);
    }

    private void printResourceElements(Resource resource) {
        AttributeList attrList = resource.getAttributes();
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
            logger.log(Level.FINE, "general.print_attr_name", attr.getName());
        }
    }

    private String[] convertToStringArray(Object sOptions) {
        StringTokenizer optionTokenizer = new StringTokenizer((String)sOptions, ",");
        int size = optionTokenizer.countTokens();
        String[] sOptionsList = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            sOptionsList[ii] = optionTokenizer.nextToken();
        }
        return sOptionsList;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource is = null;
        try {
            String dtd = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "dtds" + File.separator + "sun-resources_1_3.dtd";
            is = new InputSource(new FileInputStream(dtd));
        }
        catch (Exception e) {
            throw new SAXException("cannot resolve dtd", e);
        }
        return is;
    }

    class AddResourcesErrorHandler
    implements ErrorHandler {
        AddResourcesErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    class MyLexicalHandler
    implements LexicalHandler {
        MyLexicalHandler() {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            ResourcesXMLParser.this.isDoctypePresent = true;
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }
}

