/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.management.model.J2EEEventProviderMOMdl;
import com.sun.enterprise.management.util.J2EEModuleUtil;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class J2EEDomainMdl
extends J2EEEventProviderMOMdl
implements NotificationListener {
    public static final String DOMAINNAME;
    private static final ObjectName jmImpl;
    private final boolean debug = false;
    private static final String MANAGED_OBJECT_TYPE = "J2EEDomain";
    private final String[] eventTypes = new String[]{"j2ee.object.created", "j2ee.object.deleted"};
    static final boolean REBROADCAST = true;

    public J2EEDomainMdl() {
        super(DOMAINNAME, false, false);
        try {
            this.getMBeanServer().addNotificationListener(jmImpl, this, null, (Object)MANAGED_OBJECT_TYPE);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
    }

    public J2EEDomainMdl(String domainname) {
        super(domainname == null ? DOMAINNAME : domainname, false, false);
        if (!domainname.equals(DOMAINNAME)) {
            throw new IllegalArgumentException();
        }
        try {
            this.getMBeanServer().addNotificationListener(jmImpl, this, null, (Object)MANAGED_OBJECT_TYPE);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
    }

    public J2EEDomainMdl(String domainname, String serverName) {
        super(domainname, serverName, false, false);
        try {
            this.getMBeanServer().addNotificationListener(jmImpl, this, null, (Object)MANAGED_OBJECT_TYPE);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
    }

    public J2EEDomainMdl(String[] location) {
        this(location[0]);
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            if (!this.getObjectName().getDomain().equals(DOMAINNAME)) {
                throw new IllegalArgumentException();
            }
            try {
                this.getMBeanServer().addNotificationListener(jmImpl, this, null, (Object)MANAGED_OBJECT_TYPE);
            }
            catch (Exception e) {
                this.mLogger.warning(e.toString());
                throw new RuntimeException("J2EEDomainMdl.postRegister", e);
            }
        }
    }

    public String[] getservers() {
        Set servers = this.findNames("j2eeType=J2EEServer");
        Iterator it = servers.iterator();
        String[] ret = new String[servers.size()];
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = ((ObjectName)it.next()).toString();
        }
        return ret;
    }

    public String[] geteventTypes() {
        return this.eventTypes;
    }

    public void handleNotification(Notification n, Object handback) {
        if (!(n instanceof MBeanServerNotification)) {
            return;
        }
        ObjectName selfObjectName = null;
        try {
            selfObjectName = new ObjectName(this.getobjectName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ObjectName source = ((MBeanServerNotification)n).getMBeanName();
        if (source.equals(selfObjectName)) {
            return;
        }
        if (!source.getDomain().equalsIgnoreCase(selfObjectName.getDomain())) {
            return;
        }
        String nType = n.getType();
        MBeanServerNotification jsr77N = null;
        if (nType.equals("JMX.mbean.registered")) {
            if (this.isEventProvider(source)) {
                try {
                    this.getMBeanServer().addNotificationListener(source, this, null, (Object)this.getname());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            jsr77N = new MBeanServerNotification("j2ee.object.created", (Object)selfObjectName, n.getSequenceNumber(), source);
        } else if (nType.equals("JMX.mbean.unregistered")) {
            jsr77N = new MBeanServerNotification("j2ee.object.deleted", (Object)selfObjectName, n.getSequenceNumber(), source);
        }
        if (jsr77N != null) {
            this.sendNotification(jsr77N);
            return;
        }
        this.sendNotification(n);
    }

    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }

    public final String getobjectName() {
        Set s = this.findNames("j2eeType=" + this.getj2eeType() + ",name=" + DOMAINNAME);
        Object[] objs = s.toArray();
        if (objs.length > 0) {
            String name = ((ObjectName)objs[0]).toString();
            return name;
        }
        return null;
    }

    public String getapplicationServerFullVersion() {
        return Version.getFullVersion();
    }

    public String getapplicationServerVersion() {
        return Version.getVersion();
    }

    boolean isEventProvider(ObjectName candidate) {
        boolean isEventProvider = false;
        try {
            MBeanInfo info = this.getMBeanServer().getMBeanInfo(candidate);
            if (JMXUtil.getMBeanAttributeInfo(info, "eventProvider") != null) {
                isEventProvider = (Boolean)this.getMBeanServer().getAttribute(candidate, "eventProvider");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isEventProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String domainNameTemp = null;
        ObjectName jmImplTemp = null;
        try {
            try {
                domainNameTemp = J2EEModuleUtil.getDomainName();
                jmImplTemp = JMXUtil.newObjectName("JMImplementation:type=MBeanServerDelegate");
            }
            catch (Exception e) {
                domainNameTemp = "com.sun.appserv";
                jmImplTemp = null;
                Object var4_3 = null;
                DOMAINNAME = domainNameTemp;
                jmImpl = jmImplTemp;
            }
            Object var4_2 = null;
            DOMAINNAME = domainNameTemp;
            jmImpl = jmImplTemp;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DOMAINNAME = domainNameTemp;
            jmImpl = jmImplTemp;
            throw throwable;
        }
    }
}

