/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.webservice.ServiceEngineFacade;
import com.sun.enterprise.webservice.ServiceEngineRtObjectFactory;
import com.sun.enterprise.webservice.ServiceEngineUtil;
import com.sun.enterprise.webservice.WSClientContainer;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.TransportPipeFactory;
import java.net.URL;
import javax.xml.namespace.QName;

public class JBITransportPipeFactory
extends TransportPipeFactory {
    public Pipe doCreate(ClientPipeAssemblerContext context) {
        ServiceRefPortInfo portInfo;
        ServiceEngineFacade facade = ServiceEngineRtObjectFactory.getInstance().getFacade();
        if (facade == null) {
            return null;
        }
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        ComponentInvocation inv = invmgr.getCurrentInvocation();
        if (inv == null || inv.getInstance() == null) {
            return null;
        }
        ServiceRefPortInfo serviceRefPortInfo = portInfo = context.getContainer() instanceof WSClientContainer ? ServiceEngineUtil.getPortInfo((WSClientContainer)context.getContainer(), context.getWsdlModel().getName()) : null;
        if (portInfo == null) {
            if (this.hasRegisteredEndpointInJBI(facade, context)) {
                return this.createJBITransportPipe(facade, context);
            }
            return null;
        }
        NameValuePairDescriptor stubProp = portInfo.getStubPropertyByName("jbi-enabled");
        if (stubProp == null) {
            if (this.hasRegisteredEndpointInJBI(facade, context)) {
                return this.createJBITransportPipe(facade, context);
            }
            return null;
        }
        String jbi_enabled = stubProp.getValue();
        if (jbi_enabled.equalsIgnoreCase("true")) {
            return this.createJBITransportPipe(facade, context);
        }
        return null;
    }

    private boolean hasRegisteredEndpointInJBI(ServiceEngineFacade facade, ClientPipeAssemblerContext context) {
        QName serviceName = context.getService().getServiceName();
        String endpointName = context.getWsdlModel().getName().getLocalPart();
        return facade.hasConsumerEP(serviceName, endpointName);
    }

    private Pipe createJBITransportPipe(ServiceEngineFacade facade, ClientPipeAssemblerContext context) {
        URL wsdlURL = context.getService().getWSDLDocumentLocation();
        QName service = context.getService().getServiceName();
        return facade.createJBITransportPipe(context.getBinding(), wsdlURL, service, context.getWsdlModel());
    }
}

