/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponent;
import com.sun.enterprise.iiop.AlternateIIOPAddressComponentHelper;
import com.sun.enterprise.iiop.IIOPEndpointsInfo;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;

public class FailoverIORInterceptor
extends LocalObject
implements ORBInitializer,
IORInterceptor {
    private static Logger _logger = null;
    private ORB orb;
    private static final String baseMsg;
    private static final String ORB_LISTENER = "orb-listener";
    private List currentAddressList;
    private List previousAddressList;
    private List randomizedAddressList;
    private List randomizedAndMarshaledAddressList;

    public String name() {
        return baseMsg;
    }

    public void destroy() {
    }

    public FailoverIORInterceptor() {
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        ORB orb = ((ORBInitInfoExt)info).getORB();
        try {
            info.add_ior_interceptor((IORInterceptor)new FailoverIORInterceptor(orb));
            _logger.log(Level.FINE, baseMsg + " registered.");
        }
        catch (DuplicateName ex) {
            _logger.log(Level.WARNING, "DuplicateName from " + baseMsg, ex);
        }
    }

    public FailoverIORInterceptor(ORB orb) {
        this.orb = orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establish_components(IORInfo iorInfo) {
        try {
            block17: {
                try {
                    _logger.log(Level.FINE, baseMsg + ".establish_components->:");
                    ServerRef[] servers = IIOPEndpointsInfo.getServersInCluster();
                    IiopListener[][] listeners = IIOPEndpointsInfo.getListenersInCluster();
                    this.currentAddressList = new ArrayList();
                    if (servers != null) {
                        for (int i = 0; i < servers.length; ++i) {
                            String serverName = servers[i].getRef();
                            String hostName = IIOPEndpointsInfo.getHostNameForServerInstance(serverName);
                            if (hostName == null) {
                                hostName = listeners[i][0].getAddress();
                            }
                            for (int j = 0; j < listeners[i].length; ++j) {
                                String id = listeners[i][j].getId();
                                String port = IIOPEndpointsInfo.getResolvedPort(listeners[i][j], serverName);
                                if (!id.startsWith(ORB_LISTENER)) {
                                    if (!_logger.isLoggable(Level.INFO)) continue;
                                    _logger.log(Level.INFO, baseMsg + ".establish_components:" + " ignoring SSL ports: " + id + " " + hostName + " " + port);
                                    continue;
                                }
                                if (_logger.isLoggable(Level.FINE)) {
                                    _logger.log(Level.FINE, baseMsg + ".establish_components:" + " adding AlternateIIOPAddressComponent" + " for listener id: " + id + " address/port: " + hostName + "/" + port);
                                }
                                AlternateIIOPAddressComponent address = new AlternateIIOPAddressComponent(hostName, Integer.decode(port).shortValue());
                                this.currentAddressList.add(address);
                            }
                        }
                    }
                    if (this.previousAddressList == null) {
                        this.previousAddressList = new ArrayList();
                        Iterator i = this.currentAddressList.iterator();
                        while (i.hasNext()) {
                            this.previousAddressList.add(i.next());
                        }
                        Collections.shuffle(this.currentAddressList);
                        this.randomizedAddressList = this.currentAddressList;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, baseMsg + " first call - saving randomized alternate address list: " + this.randomizedAddressList);
                        }
                        this.randomizedAndMarshaledAddressList = new ArrayList();
                        for (AlternateIIOPAddressComponent address : this.randomizedAddressList) {
                            Any any = this.orb.create_any();
                            AlternateIIOPAddressComponentHelper.insert(any, address);
                            byte[] data = FailoverIORInterceptor.getCodec(this.orb).encode_value(any);
                            TaggedComponent tc = new TaggedComponent(3, data);
                            this.randomizedAndMarshaledAddressList.add(tc);
                        }
                    } else if (!((java.lang.Object)this.currentAddressList).equals(this.previousAddressList)) {
                        throw new RuntimeException("Current address list: " + this.currentAddressList + " different from previous list: " + this.previousAddressList);
                    }
                    Iterator i = this.randomizedAndMarshaledAddressList.iterator();
                    while (i.hasNext()) {
                        iorInfo.add_ior_component((TaggedComponent)i.next());
                    }
                    if (!_logger.isLoggable(Level.FINE)) break block17;
                    _logger.log(Level.FINE, baseMsg + " adding randomized alternate addresses: " + this.randomizedAddressList);
                }
                catch (Throwable e) {
                    _logger.log(Level.WARNING, "Problem in " + baseMsg + ".establish_components", e);
                    java.lang.Object var12_17 = null;
                    _logger.log(Level.FINE, baseMsg + ".establish_components<-:");
                }
            }
            java.lang.Object var12_16 = null;
            _logger.log(Level.FINE, baseMsg + ".establish_components<-:");
        }
        catch (Throwable throwable) {
            java.lang.Object var12_18 = null;
            _logger.log(Level.FINE, baseMsg + ".establish_components<-:");
            throw throwable;
        }
    }

    public void components_established(IORInfo iorInfo) {
    }

    public void adapter_manager_state_changed(int managerId, short state) {
    }

    public void adapter_state_changed(ObjectReferenceTemplate[] templates, short state) {
    }

    static Codec getCodec(ORB orb) {
        Codec result = null;
        try {
            CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
            result = codecFactory.create_codec(new Encoding(0, 1, 2));
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Problem in " + baseMsg + ".getCodec", e);
        }
        return result;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        baseMsg = FailoverIORInterceptor.class.getName();
    }
}

