/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.report.html;

import com.sun.enterprise.diagnostics.report.html.Document;
import com.sun.enterprise.diagnostics.report.html.Element;
import com.sun.enterprise.diagnostics.report.html.Escape;
import com.sun.enterprise.diagnostics.report.html.HTMLElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class HTMLDocument
implements Document {
    private Element html = new HTMLElement("html");
    private Element head = this.html.addElement("HEAD");
    private Element body = this.html.addElement("body");
    private String doctype = "-//W3C//DTD HTML 4.01 Transitional//EN";

    public Element getBody() {
        return this.body;
    }

    public Element getHead() {
        return this.head;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String raw) {
        if (raw == null) {
            throw new NullPointerException("Doctype string is null.");
        }
        this.doctype = raw;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<!DOCTYPE html PUBLIC \"").append(Escape.getInstance().encodeEntities(this.doctype, "")).append("\">\n").append(this.html.toString());
        return buf.toString();
    }

    public void write(Writer output) throws IOException {
        output.append("<!DOCTYPE html PUBLIC \"").append(Escape.getInstance().encodeEntities(this.doctype, "")).append("\">\n").append(this.html.toString());
        output.flush();
    }

    public void write(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        this.write(fw);
        fw.close();
    }

    public void set(Element head, Element body) {
        if (head == null) {
            throw new NullPointerException("Head element is null.");
        }
        if (body == null) {
            throw new NullPointerException("Body element is null.");
        }
        if (!head.getName().equalsIgnoreCase("HEAD")) {
            new HTMLElement("HEAD").add(head);
        }
        if (!body.getName().equalsIgnoreCase("body")) {
            new HTMLElement("BODY").add(head);
        }
        List<Element> elements = this.html.getElements("BODY");
        for (Element element : elements) {
            this.html.delete(element);
        }
        elements = this.html.getElements("HEAD");
        for (Element element : elements) {
            this.html.delete(element);
        }
        this.html.add(head);
        this.html.add(body);
        this.head = head;
        this.body = body;
    }
}

