/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.ProcessExecutor;
import com.sun.enterprise.diagnostics.collect.ProcessExecutorException;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinuxSystemInfoCollector
implements Collector {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private static final String SWAP_SPACE_CMD = "/proc/meminfo";
    private static final String TCP_SETTINGS_CMD = "/proc/sys/net/ipv4/tcp_keepalive_time";
    private static final String MEMORY_INFO_CMD = "/proc/meminfo";
    private static final String PROCESSOR_INFO_CMD = "/proc/cpuinfo";
    private static final String HARD_DISK_INFO_CMD = "df -k | grep /dev | grep -v /dev/fd | awk '{print $1, $2, $6}'";
    private static final String NETWORK_SETTINGS_CMD = "/sbin/ifconfig | grep MTU";
    private static final String IP_ADDRESS_INFO_CMD = "/sbin/ifconfig | grep inet";
    private static final String OS_LEVEL_PATCH_INFO_CMD = "rpm -qai";
    private static final String HOST_NAME_CMD = "hostname";
    private static final String DOMAIN_NAME_CMD = "domainname";
    private static final String SOFT_FILE_DESC_LIMIT_CMD = "ulimit -n";
    private static final String HARD_FILE_DESC_LIMIT_CMD = "ulimit -Hn";
    private String destFolder = null;

    public LinuxSystemInfoCollector(String destFolder) {
        this.destFolder = destFolder;
    }

    public Data capture() {
        FileData data = null;
        String outputFileName = this.destFolder + File.separator + Defaults.SYSTEM_INFO_FILE;
        String ALL_CMDS = "( echo HOSTNAME  ; hostname ;echo DOMAINNAME   ; domainname;echo 'HARD DISK INFO'  ; df -k | grep /dev | grep -v /dev/fd | awk '{print $1, $2, $6}';echo 'NETWORK SETTINGS '  ; /sbin/ifconfig | grep MTU;echo 'IP ADDRESS INFO'  ; /sbin/ifconfig | grep inet;echo 'OS LEVEL PATCH'  ; rpm -qai;echo 'SOFT FILE DESCRIPTOR LIMIT';ulimit -n;echo 'HARD FILE DESCRIPTOR LIMIT';ulimit -Hn) >>  " + outputFileName;
        String[] cmd = new String[]{"sh", "-c", ALL_CMDS};
        ProcessExecutor executor = new ProcessExecutor(cmd, 0L);
        try {
            executor.execute();
            File outputFile = new File(outputFileName);
            FileWriter writer = new FileWriter(outputFile, true);
            String swapSpaceInfo = this.getSwapSpaceInfo();
            writer.write("SWAP SPACE\n");
            writer.write(swapSpaceInfo + "\n");
            String processorInfo = this.getProcessorInfo();
            writer.write("PROCESSOR INFO\n");
            writer.write(processorInfo + "\n");
            String memoryInfo = this.getMemoryInfo();
            writer.write("MEMORY INFO\n");
            writer.write(memoryInfo + "\n");
            writer.close();
            data = new FileData(outputFile.getName(), "system Info");
        }
        catch (ProcessExecutorException pee) {
            logger.log(Level.WARNING, "Exception while capturing system info : " + pee.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.WARNING, "Exception while capturing system info : " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while capturing system info : " + ioe.getMessage());
        }
        return data;
    }

    public String getSwapSpaceInfo() {
        String result = null;
        try {
            File file = new File("/proc/meminfo");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            String total = null;
            String used = null;
            String free = null;
            do {
                if ((line = reader.readLine()) == null || line.indexOf("Swap:") < 0) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, " ");
                if (tokenizer.countTokens() < 4) break;
                tokenizer.nextElement();
                total = (String)tokenizer.nextElement();
                used = (String)tokenizer.nextElement();
                free = (String)tokenizer.nextElement();
                result = "Total : " + total + " , " + " Used : " + used + " , " + "Free : " + free;
                break;
            } while (line != null);
            reader.close();
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while retrieving Swap Space Info : " + ioe.getMessage());
        }
        return result;
    }

    public String getProcessorInfo() {
        String result = null;
        try {
            File file = new File(PROCESSOR_INFO_CMD);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            do {
                if ((line = reader.readLine()) == null || line.indexOf("model name") < 0) continue;
                int index = line.indexOf(":");
                if (index < 0) break;
                result = line.substring(index + 1);
                break;
            } while (line != null);
            reader.close();
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while retrieving Processor Info : " + ioe.getMessage());
        }
        return result;
    }

    public String getMemoryInfo() {
        String result = null;
        try {
            File file = new File("/proc/meminfo");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            String total = null;
            String used = null;
            String free = null;
            do {
                if ((line = reader.readLine()) == null || line.indexOf("Mem:") < 0) continue;
                StringTokenizer tokenizer = new StringTokenizer(line, " ");
                if (tokenizer.countTokens() < 4) break;
                tokenizer.nextElement();
                total = (String)tokenizer.nextElement();
                used = (String)tokenizer.nextElement();
                free = (String)tokenizer.nextElement();
                result = "Total : " + total + "\nUsed : " + used + "\nFree : " + free;
                break;
            } while (line != null);
            reader.close();
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception while retrieving Memory Info : " + ioe.getMessage());
        }
        return result;
    }
}

