/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public class DeploymentContext {
    private ConfigContext configContext = null;
    private Hashtable<String, Application> cachedApps = new Hashtable();
    private HashMap<String, HashMap<String, SavedApplicationRefInfo>> savedAppRefsByApp = new HashMap();

    public void setConfigContext(ConfigContext configContext) {
        this.configContext = configContext;
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public void addApplication(String appID, Application app) {
        if (app != null) {
            this.cachedApps.put(appID, app);
        }
    }

    public Application getApplication(String appID) {
        return this.cachedApps.get(appID);
    }

    public Application removeApplication(String appID) {
        return this.cachedApps.remove(appID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SavedApplicationRefInfo saveAppRef(String appID, String targetName, ApplicationRef ref, DeploymentRequest req) {
        SavedApplicationRefInfo result = null;
        HashMap<String, HashMap<String, SavedApplicationRefInfo>> hashMap = this.savedAppRefsByApp;
        synchronized (hashMap) {
            HashMap<String, SavedApplicationRefInfo> refMapForApp = this.savedAppRefsByApp.get(appID);
            if (refMapForApp == null) {
                refMapForApp = new HashMap();
                this.savedAppRefsByApp.put(appID, refMapForApp);
            }
            result = new SavedApplicationRefInfo(ref, req);
            refMapForApp.put(targetName, result);
        }
        return result;
    }

    public SavedApplicationRefInfo getSavedAppRef(String appID, String targetName) {
        SavedApplicationRefInfo result = this.getSavedApplicationRefInfo(appID, targetName);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SavedApplicationRefInfo getSavedApplicationRefInfo(String appID, String targetName) {
        SavedApplicationRefInfo result = null;
        HashMap<String, HashMap<String, SavedApplicationRefInfo>> hashMap = this.savedAppRefsByApp;
        synchronized (hashMap) {
            HashMap<String, SavedApplicationRefInfo> refMapForApp = this.savedAppRefsByApp.get(appID);
            if (refMapForApp != null) {
                result = refMapForApp.get(targetName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SavedApplicationRefInfo removeSavedAppRef(String appID, String targetName) {
        SavedApplicationRefInfo result = null;
        HashMap<String, HashMap<String, SavedApplicationRefInfo>> hashMap = this.savedAppRefsByApp;
        synchronized (hashMap) {
            result = this.getSavedApplicationRefInfo(appID, targetName);
            if (result != null) {
                HashMap<String, SavedApplicationRefInfo> refMapForApp = this.savedAppRefsByApp.get(appID);
                refMapForApp.remove(targetName);
                if (refMapForApp.isEmpty()) {
                    this.savedAppRefsByApp.remove(appID);
                }
            }
        }
        return result;
    }

    public class SavedApplicationRefInfo {
        private ApplicationRef appRef;
        private boolean isChanging;

        public SavedApplicationRefInfo(ApplicationRef appRef, DeploymentRequest req) {
            this.appRef = appRef;
            this.isChanging = this.isAppRefChanging(req);
        }

        public ApplicationRef appRef() {
            return this.appRef;
        }

        public boolean isChanging() {
            return this.isChanging;
        }

        public String toString() {
            return "AppRefInfo: isChanging = " + this.isChanging + " app ref: " + this.appRef.toString();
        }

        private boolean isAppRefChanging(DeploymentRequest req) {
            boolean result = true;
            String refVirtualServers = this.appRef.getVirtualServers();
            Properties optionalAttrs = req.getOptionalAttributes();
            String reqVirtualServers = null;
            if (optionalAttrs != null) {
                reqVirtualServers = (String)optionalAttrs.get("virtual-servers");
            }
            result = this.appRef.isEnabled() != req.isStartOnDeploy() || !this.commaStringsMatch(refVirtualServers, reqVirtualServers);
            return result;
        }

        private boolean commaStringsMatch(String a, String b) {
            if (a == b || a != null && a.equals(b)) {
                return true;
            }
            if (b == null) {
                return false;
            }
            HashSet<String> aSet = new HashSet<String>(Arrays.asList(a.split(",")));
            HashSet<String> bSet = new HashSet<String>(Arrays.asList(b.split(",")));
            return ((Object)aSet).equals(bSet);
        }
    }
}

