/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.common.MessageSecurityBindingNode;
import com.sun.enterprise.deployment.node.runtime.common.RuntimeNameValuePairNode;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceEndpointRuntimeNode
extends DeploymentDescriptorNode {
    private Descriptor descriptor;

    public WebServiceEndpointRuntimeNode() {
        this.registerElementHandler(new XMLElement("message-security-binding"), MessageSecurityBindingNode.class, "setMessageSecurityBinding");
        this.registerElementHandler(new XMLElement("property"), RuntimeNameValuePairNode.class, "addProperty");
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("endpoint-address-uri", "setEndpointAddressUri");
        table.put("tie-class", "setTieClassName");
        table.put("servlet-impl-class", "setServletImplClass");
        table.put("debugging-enabled", "setDebugging");
        table.put("namespaceURI", "setServiceNamespaceUri");
        table.put("localpart", "setServiceLocalPart");
        table.put("auth-method", "setAuthMethod");
        table.put("realm", "setRealm");
        table.put("transport-guarantee", "setTransportGuarantee");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("port-component-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof EjbDescriptor) {
                EjbBundleDescriptor bundle = ((EjbDescriptor)parentDesc).getEjbBundleDescriptor();
                WebServicesDescriptor webServices = bundle.getWebServices();
                this.descriptor = webServices.getEndpointByName(value);
            } else if (parentDesc instanceof WebComponentDescriptor) {
                WebBundleDescriptor bundle = ((WebComponentDescriptor)parentDesc).getWebBundleDescriptor();
                WebServicesDescriptor webServices = bundle.getWebServices();
                this.descriptor = webServices.getEndpointByName(value);
            }
            if (this.descriptor == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.port_component_name_unknown", new Object[]{value});
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceEndpoint endpoint) {
        MessageSecurityBindingDescriptor messageSecBindingDesc;
        Node endpointNode = super.writeDescriptor(parent, nodeName, endpoint);
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "port-component-name", endpoint.getEndpointName());
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "endpoint-address-uri", endpoint.getEndpointAddressUri());
        if (endpoint.implementedByEjbComponent() && endpoint.hasAuthMethod()) {
            Element loginConfigNode = WebServiceEndpointRuntimeNode.appendChild(endpointNode, "login-config");
            WebServiceEndpointRuntimeNode.appendTextChild((Node)loginConfigNode, "auth-method", endpoint.getAuthMethod());
            WebServiceEndpointRuntimeNode.appendTextChild((Node)loginConfigNode, "realm", endpoint.getRealm());
        }
        if ((messageSecBindingDesc = endpoint.getMessageSecurityBinding()) != null) {
            MessageSecurityBindingNode messageSecBindingNode = new MessageSecurityBindingNode();
            messageSecBindingNode.writeDescriptor(endpointNode, "message-security-binding", messageSecBindingDesc);
        }
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "transport-guarantee", endpoint.getTransportGuarantee());
        QName serviceName = endpoint.getServiceName();
        if (serviceName != null) {
            Element serviceQnameNode = WebServiceEndpointRuntimeNode.appendChild(endpointNode, "service-qname");
            WebServiceEndpointRuntimeNode.appendTextChild((Node)serviceQnameNode, "namespaceURI", serviceName.getNamespaceURI());
            WebServiceEndpointRuntimeNode.appendTextChild((Node)serviceQnameNode, "localpart", serviceName.getLocalPart());
        }
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "tie-class", endpoint.getTieClassName());
        if (endpoint.implementedByWebComponent() && endpoint.getServletImplClass() != null) {
            WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "servlet-impl-class", endpoint.getServletImplClass());
        }
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "debugging-enabled", endpoint.getDebugging());
        Iterator properties = endpoint.getProperties();
        if (properties != null) {
            RuntimeNameValuePairNode propNode = new RuntimeNameValuePairNode();
            while (properties.hasNext()) {
                NameValuePairDescriptor aProp = (NameValuePairDescriptor)properties.next();
                propNode.writeDescriptor(endpointNode, "property", aProp);
            }
        }
        return endpointNode;
    }

    public void writeWebServiceEndpointInfo(Node parent, EjbDescriptor ejb) {
        EjbBundleDescriptor bundle = ejb.getEjbBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(ejb);
        for (WebServiceEndpoint next : endpoints) {
            this.writeDescriptor(parent, "webservice-endpoint", next);
        }
    }

    public void writeWebServiceEndpointInfo(Node parent, WebComponentDescriptor webComp) {
        WebBundleDescriptor bundle = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComp);
        for (WebServiceEndpoint next : endpoints) {
            this.writeDescriptor(parent, "webservice-endpoint", next);
        }
    }
}

