/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.io;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.io.AppClientDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConnectorDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.PersistenceDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.node.SaxParserHandlerFactory;
import java.io.File;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeploymentDescriptorFileFactory {
    private DeploymentDescriptorFileFactory() {
    }

    public static DeploymentDescriptorFile getDDFileFor(RootDeploymentDescriptor descriptor) {
        if (descriptor instanceof Application) {
            return new ApplicationDeploymentDescriptorFile();
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            return new EjbDeploymentDescriptorFile();
        }
        if (descriptor instanceof WebBundleDescriptor) {
            return new WebDeploymentDescriptorFile();
        }
        if (descriptor instanceof ConnectorDescriptor) {
            return new ConnectorDeploymentDescriptorFile();
        }
        if (descriptor instanceof ApplicationClientDescriptor) {
            return new AppClientDeploymentDescriptorFile();
        }
        return null;
    }

    public static DeploymentDescriptorFile getDDFileFor(ModuleType type) {
        if (type == null) {
            return null;
        }
        if (type.equals(ModuleType.EAR)) {
            return new ApplicationDeploymentDescriptorFile();
        }
        if (type.equals(ModuleType.EJB)) {
            return new EjbDeploymentDescriptorFile();
        }
        if (type.equals(ModuleType.WAR)) {
            return new WebDeploymentDescriptorFile();
        }
        if (type.equals(ModuleType.RAR)) {
            return new ConnectorDeploymentDescriptorFile();
        }
        if (type.equals(ModuleType.CAR)) {
            return new AppClientDeploymentDescriptorFile();
        }
        return null;
    }

    public static DeploymentDescriptorFile getDDFileFor(File xmlFile) throws Exception {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        System.clearProperty("javax.xml.parsers.DocumentBuilderFactory");
        factory.setValidating(false);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setEntityResolver(SaxParserHandlerFactory.newInstance());
        Document document = docBuilder.parse(xmlFile);
        Element element = document.getDocumentElement();
        if (element.getTagName().equals("application")) {
            return new ApplicationDeploymentDescriptorFile();
        }
        if (element.getTagName().equals("ejb-jar")) {
            return new EjbDeploymentDescriptorFile();
        }
        if (element.getTagName().equals("web-app")) {
            return new WebDeploymentDescriptorFile();
        }
        if (element.getTagName().equals("connector")) {
            return new ConnectorDeploymentDescriptorFile();
        }
        if (element.getTagName().equals("application-client")) {
            return new AppClientDeploymentDescriptorFile();
        }
        if (element.getTagName().equals("persistence")) {
            return new PersistenceDeploymentDescriptorFile();
        }
        return null;
    }
}

