/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import java.io.File;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class JBIDeployer {
    private String PREFIX = "com.sun.jbi:Target=server,ServiceName=";
    private String DEPLOY_SUFFIX = "DeploymentService,ServiceType=Deployment";
    private String SHUTDOWN = "ShutDown";
    private String STARTED = "Started";
    private String STOPPED = "Stopped";
    private String NOTFOUND = "NotFound";

    JBIDeployer() {
    }

    void deploy(MBeanServer mbs, File sa, String saName) throws Exception {
        if (!this.getState(mbs, saName).equals(this.NOTFOUND)) {
            this.undeploy(mbs, saName);
        }
        ObjectName deployMbean = this.getObjectName(mbs);
        mbs.invoke(deployMbean, "deploy", new Object[]{sa.getAbsolutePath()}, new String[]{"java.lang.String"});
        this.start(mbs, saName);
    }

    String getState(MBeanServer mbs, String sa) throws Exception {
        String state = this.NOTFOUND;
        try {
            ObjectName deployMbean = this.getObjectName(mbs);
            state = (String)mbs.invoke(deployMbean, "getState", new Object[]{sa}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            // empty catch block
        }
        return state;
    }

    void undeploy(MBeanServer mbs, String sa) throws Exception {
        if (this.STARTED.equals(this.getState(mbs, sa))) {
            this.stop(mbs, sa);
            this.shutdown(mbs, sa);
        }
        if (this.STOPPED.equals(this.getState(mbs, sa))) {
            this.shutdown(mbs, sa);
        }
        ObjectName deployMbean = this.getObjectName(mbs);
        mbs.invoke(deployMbean, "undeploy", new Object[]{sa}, new String[]{"java.lang.String"});
    }

    private void shutdown(MBeanServer mbs, String sa) throws Exception {
        ObjectName deployMbean = this.getObjectName(mbs);
        mbs.invoke(deployMbean, "shutDown", new Object[]{sa}, new String[]{"java.lang.String"});
    }

    private void stop(MBeanServer mbs, String sa) throws Exception {
        ObjectName deployMbean = this.getObjectName(mbs);
        mbs.invoke(deployMbean, "stop", new Object[]{sa}, new String[]{"java.lang.String"});
    }

    private void start(MBeanServer mbs, String sa) throws Exception {
        ObjectName deployMbean = this.getObjectName(mbs);
        mbs.invoke(deployMbean, "start", new Object[]{sa}, new String[]{"java.lang.String"});
    }

    private ObjectName getObjectName(MBeanServer mbs) throws Exception {
        ObjectName deployMbean = new ObjectName(this.PREFIX + this.DEPLOY_SUFFIX);
        return mbs.getObjectInstance(deployMbean).getObjectName();
    }
}

