/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.ComponentContext;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import java.lang.annotation.ElementType;
import java.util.logging.Level;

abstract class AbstractCommonAttributeHandler
extends AbstractHandler {
    AbstractCommonAttributeHandler() {
    }

    protected abstract HandlerProcessingResult processAnnotation(AnnotationInfo var1, EjbContext[] var2) throws AnnotationProcessorException;

    protected abstract HandlerProcessingResult processAnnotation(AnnotationInfo var1, WebComponentContext[] var2) throws AnnotationProcessorException;

    protected abstract HandlerProcessingResult processAnnotation(AnnotationInfo var1, WebBundleContext var2) throws AnnotationProcessorException;

    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        WebBundleContext webBundleContext;
        AnnotatedElementHandler aeHandler = ainfo.getProcessingContext().getHandler();
        if (aeHandler instanceof EjbBundleContext) {
            EjbBundleContext ejbBundleContext = (EjbBundleContext)aeHandler;
            aeHandler = ejbBundleContext.createContextForEjb();
        } else if (aeHandler instanceof WebBundleContext && (aeHandler = (webBundleContext = (WebBundleContext)aeHandler).createContextForWeb()) == null) {
            aeHandler = ainfo.getProcessingContext().getHandler();
        }
        if (aeHandler == null) {
            return this.getInvalidAnnotatedElementHandlerResult(ainfo.getProcessingContext().getHandler(), ainfo);
        }
        if (!this.supportTypeInheritance() && ElementType.TYPE.equals((Object)ainfo.getElementType()) && aeHandler instanceof ComponentContext) {
            ComponentContext context = (ComponentContext)((Object)aeHandler);
            Class clazz = (Class)ainfo.getAnnotatedElement();
            if (!clazz.getName().equals(context.getComponentClassName())) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.typeinhernotsupp", "The annotation symbol inheritance is not supported."));
                }
                return this.getDefaultProcessedResult();
            }
        }
        HandlerProcessingResult procResult = null;
        if (aeHandler instanceof EjbContext) {
            procResult = this.processAnnotation(ainfo, new EjbContext[]{(EjbContext)aeHandler});
        } else if (aeHandler instanceof EjbsContext) {
            EjbsContext ejbsContext = (EjbsContext)aeHandler;
            procResult = this.processAnnotation(ainfo, ejbsContext.getEjbContexts());
        } else if (aeHandler instanceof WebComponentContext) {
            procResult = this.processAnnotation(ainfo, new WebComponentContext[]{(WebComponentContext)aeHandler});
        } else if (aeHandler instanceof WebComponentsContext) {
            WebComponentsContext webCompsContext = (WebComponentsContext)aeHandler;
            procResult = this.processAnnotation(ainfo, webCompsContext.getWebComponentContexts());
        } else if (aeHandler instanceof WebBundleContext) {
            WebBundleContext webBundleContext2 = (WebBundleContext)aeHandler;
            procResult = this.processAnnotation(ainfo, webBundleContext2);
        } else {
            return this.getInvalidAnnotatedElementHandlerResult(aeHandler, ainfo);
        }
        return procResult;
    }

    protected boolean supportTypeInheritance() {
        return false;
    }
}

