/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.ejb.EJBException;

public final class PersistenceDescriptor
extends Descriptor {
    private Set cmpFields = new HashSet();
    private Set pkeyFields = new HashSet();
    private boolean pkeyIsOneField = false;
    private boolean pkeyFieldSpecified = true;
    private String primaryKeyClassName;
    private boolean pkeyStuffInitialized = false;
    private boolean pkeyFieldsAllPrimitive = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PersistenceDescriptor.class);
    private EjbCMPEntityDescriptor parentDesc;
    private transient Class persistentClass;
    private transient Class stateClass;
    private transient Class primaryKeyClass;
    private PersistentFieldInfo[] persFieldInfo;
    private PersistentFieldInfo[] persNoPkeyFieldInfo;
    private PersistentFieldInfo[] pkeyFieldInfo;
    private boolean fieldInfoInitialized = false;
    private PersistentFieldInfo[] fkeyFields;
    private CMRFieldInfo[] cmrFieldInfo;
    private transient Field[] pkeyClassPkeyFields;
    private Hashtable queries = new Hashtable();
    private HashSet allQueriedMethods;

    public PersistenceDescriptor() {
    }

    public PersistenceDescriptor(PersistenceDescriptor pers) {
        super(pers);
        this.getCMPFields().addAll(pers.getCMPFields());
    }

    public String getCMRFieldReturnType(String field) {
        String returnType;
        block3: {
            returnType = "java.util.Collection";
            try {
                if (!field.trim().equals("")) {
                    Class persClass = this.getPersistentClass();
                    String methodName = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
                    Method method = TypeUtil.getMethod(persClass, persClass.getClassLoader(), methodName, new String[0]);
                    returnType = method.getReturnType().getName();
                }
            }
            catch (Throwable t) {
                if (!DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) break block3;
                DOLUtils.getDefaultLogger().log(Level.FINE, t.toString(), t);
            }
        }
        return returnType;
    }

    public boolean classesChanged() {
        FieldDescriptor primKeyFieldDesc;
        FieldDescriptor next;
        Iterator iter;
        this.persistentClass = null;
        this.stateClass = null;
        Class persClass = this.getPersistentClass();
        Vector fieldDescriptors = this.parentDesc.getFieldDescriptors();
        if (this.cmpFields != null) {
            iter = this.cmpFields.iterator();
            while (iter.hasNext()) {
                next = (FieldDescriptor)iter.next();
                if (fieldDescriptors.contains(next)) continue;
                iter.remove();
            }
        }
        if (this.pkeyFields != null) {
            iter = this.pkeyFields.iterator();
            while (iter.hasNext()) {
                next = (FieldDescriptor)iter.next();
                if (fieldDescriptors.contains(next)) continue;
                iter.remove();
            }
        }
        if ((primKeyFieldDesc = this.parentDesc.getPrimaryKeyFieldDesc()) != null && !fieldDescriptors.contains(primKeyFieldDesc)) {
            this.parentDesc.setPrimaryKeyFieldDesc(null);
        }
        Hashtable queriesClone = (Hashtable)this.queries.clone();
        this.queries = new Hashtable();
        this.initializeAllQueriedMethods();
        for (Method oldMethod : queriesClone.keySet()) {
            Method newMethod = this.findEquivalentMethod(this.allQueriedMethods, oldMethod);
            if (newMethod == null) continue;
            QueryDescriptor oldQuery = (QueryDescriptor)queriesClone.get(oldMethod);
            QueryDescriptor newQuery = new QueryDescriptor(oldQuery, newMethod);
            this.queries.put(newMethod, newQuery);
        }
        this.invalidate();
        return false;
    }

    private Method findEquivalentMethod(Collection methods, Method methodToMatch) {
        Method matchedMethod = null;
        for (Object o : methods) {
            Method next;
            if (o instanceof Method) {
                next = (Method)o;
            } else {
                next = ((MethodDescriptor)o).getMethod(this.parentDesc);
                if (next == null) {
                    return null;
                }
            }
            if (!this.methodsEqual(next, methodToMatch, false)) continue;
            matchedMethod = next;
            break;
        }
        return matchedMethod;
    }

    private boolean methodsEqual(Method m1, Method m2, boolean compareDeclaringClass) {
        String m2Name;
        boolean equal = false;
        String m1Name = m1.getName();
        if (m1Name.equals(m2Name = m2.getName())) {
            Class<?>[] m2ParamTypes;
            Class<?>[] m1ParamTypes;
            String m1DeclaringClass = m1.getDeclaringClass().getName();
            String m2DeclaringClass = m2.getDeclaringClass().getName();
            if ((!compareDeclaringClass || m1DeclaringClass.equals(m2DeclaringClass)) && (m1ParamTypes = m1.getParameterTypes()).length == (m2ParamTypes = m2.getParameterTypes()).length) {
                equal = true;
                for (int pIndex = 0; pIndex < m1ParamTypes.length; ++pIndex) {
                    String m2ParamClass;
                    String m1ParamClass = m1ParamTypes[pIndex].getName();
                    if (m1ParamClass.equals(m2ParamClass = m2ParamTypes[pIndex].getName())) continue;
                    equal = false;
                    break;
                }
            }
        }
        return equal;
    }

    private boolean methodsEqual(MethodDescriptor m1, Method m2, boolean compareDeclaringClass) {
        Method m = m1.getMethod(this.parentDesc);
        return this.methodsEqual(m, m2, compareDeclaringClass);
    }

    public void setParentDescriptor(Descriptor parentDesc) {
        this.parentDesc = (EjbCMPEntityDescriptor)parentDesc;
    }

    public Descriptor getParentDescriptor() {
        return this.parentDesc;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        return this.parentDesc.getEjbBundleDescriptor();
    }

    public Set getRelationships() {
        Set allRelationships = this.getEjbBundleDescriptor().getRelationships();
        HashSet<RelationshipDescriptor> myRelationships = new HashSet<RelationshipDescriptor>();
        for (RelationshipDescriptor next : allRelationships) {
            if (!next.hasParticipant(this.parentDesc)) continue;
            myRelationships.add(next);
        }
        return myRelationships;
    }

    public CMRFieldInfo[] getCMRFieldInfo() {
        if (this.cmrFieldInfo == null) {
            try {
                this.initCMRFieldStuff();
            }
            catch (Exception ex) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{ex.toString()});
                throw new EJBException(ex);
            }
        }
        return this.cmrFieldInfo;
    }

    public CMRFieldInfo getCMRFieldInfoByName(String fieldName) {
        CMRFieldInfo[] cmrf = this.getCMRFieldInfo();
        for (int i = 0; i < cmrf.length; ++i) {
            if (!cmrf[i].name.equals(fieldName)) continue;
            return cmrf[i];
        }
        throw new EJBException("CMRFieldInfo not found for field " + fieldName);
    }

    public void invalidate() {
        this.cmrFieldInfo = null;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        this.pkeyStuffInitialized = false;
    }

    private void initCMRFieldStuff() throws Exception {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        Set relationships = this.getRelationships();
        Iterator it = relationships.iterator();
        CMRFieldInfo[] cmrFieldInfo2 = new CMRFieldInfo[relationships.size() * 2];
        int count = 0;
        while (it.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor sink = rd.getSink();
            RelationRoleDescriptor[] myroles = source.getPersistenceDescriptor() == sink.getPersistenceDescriptor() ? new RelationRoleDescriptor[]{source, sink} : new RelationRoleDescriptor[]{source.getPersistenceDescriptor() == this ? source : sink};
            for (int ii = 0; ii < myroles.length; ++ii) {
                String type;
                CMRFieldInfo finfo = new CMRFieldInfo();
                cmrFieldInfo2[count++] = finfo;
                PersistenceDescriptor partnerPers = myroles[ii].getPartner().getPersistenceDescriptor();
                EjbCMPEntityDescriptor partner = myroles[ii].getPartner().getOwner();
                if (!partner.isLocalInterfacesSupported() && myroles[ii].getCMRField() != null) {
                    throw new RuntimeException("No local interface for target bean of CMR field");
                }
                if (!myroles[ii].getPartner().getIsMany()) {
                    type = partner.isLocalInterfacesSupported() ? partner.getLocalClassName() : partner.getPrimaryKeyClassName();
                } else {
                    type = myroles[ii].getCMRFieldType();
                    if (type == null) {
                        type = "java.util.Collection";
                    }
                }
                finfo.type = this.getClass(type);
                finfo.name = myroles[ii].getCMRField();
                if (finfo.name == null) {
                    finfo.name = myroles[ii].composeReverseCmrFieldName();
                }
                finfo.role = myroles[ii];
                myroles[ii].setCMRFieldInfo(finfo);
                if (!rd.isOneOne() || this.fkeyFields == null) continue;
                PersistentFieldInfo[] partnerPkeyFields = partnerPers.getPkeyFieldInfo();
                PersistentFieldInfo[] cmrFkeyFields = new PersistentFieldInfo[partnerPkeyFields.length];
                for (int i = 0; i < partnerPkeyFields.length; ++i) {
                    String fkeyName = "_" + finfo.name + "_" + partnerPkeyFields[i].name;
                    for (int j = 0; j < this.fkeyFields.length; ++j) {
                        if (!this.fkeyFields[j].name.equals(fkeyName)) continue;
                        cmrFkeyFields[i] = this.fkeyFields[j];
                    }
                }
                finfo.fkeyFields = cmrFkeyFields;
            }
        }
        this.cmrFieldInfo = new CMRFieldInfo[count];
        System.arraycopy(cmrFieldInfo2, 0, this.cmrFieldInfo, 0, count);
        for (int i = this.cmrFieldInfo.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.cmrFieldInfo[j].name.compareTo(this.cmrFieldInfo[j + 1].name) <= 0) continue;
                CMRFieldInfo tmp = this.cmrFieldInfo[j];
                this.cmrFieldInfo[j] = this.cmrFieldInfo[j + 1];
                this.cmrFieldInfo[j + 1] = tmp;
            }
        }
    }

    public void clearCMPFields() {
        this.cmpFields.clear();
        this.setCMPFields(this.cmpFields);
    }

    public void addCMPField(String field) {
        this.addCMPField(new FieldDescriptor(field));
    }

    public void addCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.add(fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void removeCMPField(String field) {
        this.removeCMPField(new FieldDescriptor(field));
    }

    public void removeCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.remove(fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void setCMPFields(Set cmpFields) {
        this.cmpFields = cmpFields;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        super.changed();
    }

    public boolean isCMPField(String field) {
        return this.getCMPFields().contains(new FieldDescriptor(field));
    }

    public Set getCMPFields() {
        return this.cmpFields;
    }

    public void setPkeyFields(Set pkeyFields) {
        this.pkeyFields = pkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        this.pkeyStuffInitialized = false;
        super.changed();
    }

    public Set getPkeyFields() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFields;
    }

    public boolean isPkeyField(String field) {
        return this.isPkeyField(new FieldDescriptor(field));
    }

    public boolean isPkeyField(FieldDescriptor fieldDesc) {
        return this.getPkeyFields().contains(fieldDesc);
    }

    private void initPkeyInfo() {
        try {
            this.pkeyIsOneField = false;
            this.pkeyFieldSpecified = true;
            this.primaryKeyClassName = this.parentDesc.getPrimaryKeyClassName();
            FieldDescriptor fd = this.parentDesc.getPrimaryKeyFieldDesc();
            if (this.pkeyFields == null || this.pkeyFields.size() == 0) {
                this.pkeyFields = new HashSet();
                if (fd != null) {
                    this.pkeyFields.add(fd);
                } else if (!this.primaryKeyClassName.equals("java.lang.Object")) {
                    this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                    Field[] fields = this.primaryKeyClass.getFields();
                    this.pkeyFieldsAllPrimitive = true;
                    for (int i = 0; i < fields.length; ++i) {
                        int m = fields[i].getModifiers();
                        if (Modifier.isStatic(m) || Modifier.isFinal(m)) continue;
                        if (!fields[i].getType().isPrimitive()) {
                            this.pkeyFieldsAllPrimitive = false;
                        }
                        this.pkeyFields.add(new FieldDescriptor(fields[i].getName()));
                    }
                } else {
                    this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                    this.pkeyIsOneField = true;
                    this.pkeyFieldSpecified = false;
                }
            }
            if (fd != null) {
                this.pkeyIsOneField = true;
            }
            this.pkeyStuffInitialized = true;
        }
        catch (Exception ex) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{ex.toString()});
            throw new EJBException(ex);
        }
    }

    public boolean primaryKeyIsOneField() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyIsOneField;
    }

    public boolean primaryKeyIsSpecified() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldSpecified;
    }

    public boolean primaryKeyFieldsAllPrimitive() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldsAllPrimitive;
    }

    public Class getPrimaryKeyClass() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.primaryKeyClass;
    }

    public Class getPersistentClass() {
        if (this.persistentClass == null) {
            this.persistentClass = this.getClass(this.parentDesc.getEjbClassName());
        }
        return this.persistentClass;
    }

    public Class getStateClass() {
        if (this.stateClass == null) {
            this.stateClass = this.getPersistentClass();
            if (this.parentDesc.isEJB20()) {
                if (!Modifier.isAbstract(this.stateClass.getModifiers())) {
                    throw new EJBException("2.x CMP bean class " + this.stateClass.getName() + " must be decleared abstract " + "or cmp-version for the corresponding bean must be set to 1.x.");
                }
                String stateClassName = this.parentDesc.getStateImplClassName();
                this.stateClass = this.getClass(stateClassName);
            }
        }
        return this.stateClass;
    }

    private Class getClass(String className) {
        try {
            return this.getEjbBundleDescriptor().getClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void setFkeyFields(PersistentFieldInfo[] fkeyFields) {
        this.fkeyFields = fkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        super.changed();
    }

    public PersistentFieldInfo[] getFkeyFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.fkeyFields;
    }

    public PersistentFieldInfo[] getPersistentFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persFieldInfo;
    }

    public PersistentFieldInfo getPersistentFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (int i = 0; i < this.persFieldInfo.length; ++i) {
            if (!this.persFieldInfo[i].name.equals(fieldName)) continue;
            return this.persFieldInfo[i];
        }
        throw new EJBException("PersistentFieldInfo not found for field " + fieldName);
    }

    public PersistentFieldInfo[] getNonPkeyPersFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persNoPkeyFieldInfo;
    }

    public PersistentFieldInfo[] getPkeyFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyFieldInfo;
    }

    public PersistentFieldInfo getPkeyFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (int i = 0; i < this.pkeyFieldInfo.length; ++i) {
            if (!this.pkeyFieldInfo[i].name.equals(fieldName)) continue;
            return this.pkeyFieldInfo[i];
        }
        throw new EJBException("PersistentFieldInfo not found for pkey field " + fieldName);
    }

    public Field[] getPkeyClassFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyClassPkeyFields;
    }

    private void initializeFieldInfo() {
        int i;
        int i2;
        int cmpFieldCount;
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        if ((cmpFieldCount = this.cmpFields.size()) == 0) {
            throw new EJBException("No cmp field defined for CMP EJB " + this.parentDesc.getName());
        }
        int fkeyCount = 0;
        if (this.fkeyFields != null) {
            fkeyCount = this.fkeyFields.length;
        }
        this.persFieldInfo = new PersistentFieldInfo[cmpFieldCount + fkeyCount];
        int fcount = 0;
        Iterator itr = this.cmpFields.iterator();
        while (itr.hasNext()) {
            this.persFieldInfo[fcount] = new PersistentFieldInfo();
            this.persFieldInfo[fcount].name = ((FieldDescriptor)itr.next()).getName();
            ++fcount;
        }
        if (this.fkeyFields != null) {
            for (i2 = 0; i2 < this.fkeyFields.length; ++i2) {
                this.persFieldInfo[fcount] = this.fkeyFields[i2];
                ++fcount;
            }
        }
        for (i2 = this.persFieldInfo.length - 1; i2 > 0; --i2) {
            for (int j = 0; j < i2; ++j) {
                if (this.persFieldInfo[j].name.compareTo(this.persFieldInfo[j + 1].name) <= 0) continue;
                PersistentFieldInfo tmp = this.persFieldInfo[j];
                this.persFieldInfo[j] = this.persFieldInfo[j + 1];
                this.persFieldInfo[j + 1] = tmp;
            }
        }
        this.pkeyFieldInfo = new PersistentFieldInfo[this.pkeyFields.size()];
        if (this.pkeyFieldSpecified) {
            StringBuffer nonPersFieldsInPK = new StringBuffer();
            for (FieldDescriptor fd : this.pkeyFields) {
                boolean isPersistent = false;
                for (int i3 = 0; i3 < this.persFieldInfo.length; ++i3) {
                    if (!fd.getName().equals(this.persFieldInfo[i3].name)) continue;
                    isPersistent = true;
                    break;
                }
                if (isPersistent) continue;
                if (nonPersFieldsInPK.length() != 0) {
                    nonPersFieldsInPK.append(", ");
                }
                nonPersFieldsInPK.append(fd.getName());
            }
            if (nonPersFieldsInPK.length() != 0) {
                throw new EJBException(localStrings.getLocalString("enterprise.deployment.pkhasnopersistentfields", "CMP bean [{0}], primary key class [{1}] has public non-persistent field(s) [{2}].", new Object[]{this.getParentDescriptor().getName(), this.getPrimaryKeyClass().getName(), nonPersFieldsInPK.toString()}));
            }
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - this.pkeyFieldInfo.length];
            int pkeyCount = 0;
            int noPkeyCount = 0;
            for (int i4 = 0; i4 < this.persFieldInfo.length; ++i4) {
                boolean isPkey = false;
                for (FieldDescriptor fd : this.pkeyFields) {
                    if (!fd.getName().equals(this.persFieldInfo[i4].name)) continue;
                    isPkey = true;
                    break;
                }
                if (isPkey) {
                    this.pkeyFieldInfo[pkeyCount++] = this.persFieldInfo[i4];
                    continue;
                }
                this.persNoPkeyFieldInfo[noPkeyCount++] = this.persFieldInfo[i4];
            }
        }
        if (this.pkeyIsOneField && this.pkeyFieldSpecified) {
            this.pkeyFieldInfo[0].type = this.getPrimaryKeyClass();
        }
        for (i = 0; i < this.persFieldInfo.length; ++i) {
            if (this.persFieldInfo[i].type != null) continue;
            this.persFieldInfo[i].type = this.getCMPFieldType(this.persFieldInfo[i].name);
        }
        try {
            if (this.persistentClass != null && !Modifier.isAbstract(this.persistentClass.getModifiers())) {
                for (i = 0; i < this.persFieldInfo.length; ++i) {
                    this.persFieldInfo[i].field = this.getField(this.getStateClass(), this.persFieldInfo[i].name);
                }
            }
            if (!this.pkeyIsOneField && this.primaryKeyClass != null && !Modifier.isAbstract(this.primaryKeyClass.getModifiers())) {
                this.pkeyClassPkeyFields = new Field[this.pkeyFieldInfo.length];
                for (i = 0; i < this.pkeyFieldInfo.length; ++i) {
                    this.pkeyClassPkeyFields[i] = this.primaryKeyClass.getField(this.pkeyFieldInfo[i].name);
                }
            }
        }
        catch (NoSuchFieldException ex) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().log(Level.FINE, ex.toString(), ex);
            }
            throw new EJBException((Exception)ex);
        }
        this.fieldInfoInitialized = true;
    }

    private Field getField(final Class c, final String name) throws NoSuchFieldException {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return c.getDeclaredField(name);
                }
                catch (NoSuchFieldException ex) {
                    return null;
                }
            }
        });
        if (field == null) {
            field = c.getField(name);
        }
        return field;
    }

    public Class getTypeFor(String field) {
        return this.getCMPFieldType(field);
    }

    private Class getCMPFieldType(String field) {
        Class pclass = this.getPersistentClass();
        if (Modifier.isAbstract(pclass.getModifiers())) {
            String javaBeanName = PersistenceDescriptor.capitalize(field);
            String getter = "get" + javaBeanName;
            try {
                Method method = pclass.getMethod(getter, null);
                return method.getReturnType();
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot find accessor " + getter + " for CMP field " + field);
            }
        }
        try {
            Field f = this.getField(this.getStateClass(), field);
            return f.getType();
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("Cant find CMP field " + field + " in class " + this.getStateClass().getName());
        }
    }

    public static String capitalize(String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            throw new EJBException("CMP/CMR field " + name + " must start with a lower case character.");
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public void setQueryFor(MethodDescriptor method, QueryDescriptor query) {
        this.queries.put(method, query);
    }

    public QueryDescriptor getQueryFor(MethodDescriptor method) {
        return (QueryDescriptor)this.queries.get(method);
    }

    public void removeQueryFor(MethodDescriptor method) {
        this.queries.remove(method);
    }

    public void setQueryFor(Method method, QueryDescriptor query) {
        MethodDescriptor md = new MethodDescriptor(method, "");
        this.setQueryFor(md, query);
    }

    public QueryDescriptor getQueryFor(Method method) {
        MethodDescriptor md = new MethodDescriptor(method, "");
        return (QueryDescriptor)this.queries.get(md);
    }

    public Set getQueriedMethods() {
        return this.queries.keySet();
    }

    public Set getAllPossibleQueriedMethods() {
        if (this.allQueriedMethods == null) {
            this.initializeAllQueriedMethods();
        }
        return this.allQueriedMethods;
    }

    private void initializeAllQueriedMethods() {
        String name;
        int i;
        Method[] homeMethods;
        this.allQueriedMethods = new HashSet();
        Method[] beanMethods = this.getPersistentClass().getMethods();
        for (int i2 = 0; i2 < beanMethods.length; ++i2) {
            if (!beanMethods[i2].getName().startsWith("ejbSelect")) continue;
            this.allQueriedMethods.add(new MethodDescriptor(beanMethods[i2], "Bean"));
        }
        if (this.parentDesc.isRemoteInterfacesSupported()) {
            Class homeIntf = this.getClass(this.parentDesc.getHomeClassName());
            homeMethods = homeIntf.getMethods();
            for (i = 0; i < homeMethods.length; ++i) {
                name = homeMethods[i].getName();
                if (!name.startsWith("find") || name.equals("findByPrimaryKey")) continue;
                this.allQueriedMethods.add(new MethodDescriptor(homeMethods[i], "Home"));
            }
        }
        if (this.parentDesc.isLocalInterfacesSupported()) {
            Class homeIntf = this.getClass(this.parentDesc.getLocalHomeClassName());
            homeMethods = homeIntf.getMethods();
            for (i = 0; i < homeMethods.length; ++i) {
                name = homeMethods[i].getName();
                if (!name.startsWith("find") || name.equals("findByPrimaryKey")) continue;
                this.allQueriedMethods.add(new MethodDescriptor(homeMethods[i], "LocalHome"));
            }
        }
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n Entity descriptor");
        toStringBuffer.append("\n cmpFields ").append(this.cmpFields);
    }
}

