/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.connectors.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.ActiveRAFactory;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorAdminService;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorServiceImpl;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.JmsRaMapping;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.ConnectorClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import javax.naming.NamingException;

public class ResourceAdapterAdminServiceImpl
extends ConnectorServiceImpl
implements ConnectorAdminService {
    private JmsRaMapping ramap = null;
    private int resource_adapter_shutdown_timeout = 0;
    private final Hashtable raShutdownStatusTable = new Hashtable();

    public ResourceAdapterAdminServiceImpl() {
        this.ramap = new JmsRaMapping();
    }

    public void destroyActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        this.destroyActiveResourceAdapter(moduleName, false);
    }

    public void destroyActiveResourceAdapter(String moduleName, boolean cascade) throws ConnectorRuntimeException {
        ResourcesUtil resutil = ResourcesUtil.createInstance();
        if (resutil == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to get ResourcesUtil object");
            _logger.log(Level.SEVERE, "resourcesutil_get_failure", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Object[][] resources = null;
        try {
            resources = resutil.getAllConnectorResourcesForRar(moduleName);
        }
        catch (ConfigException ce) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to get Resources from domain.xml");
            ce.initCause(ce);
            _logger.log(Level.SEVERE, "rardeployment.resources_list_error", cre);
            throw cre;
        }
        boolean errrorOccured = false;
        ConnectorConnectionPool ccp = null;
        if (cascade && resources != null) {
            int i;
            for (i = 0; resources[0] != null && i < resources[0].length; ++i) {
                ccp = (ConnectorConnectionPool)resources[0][i];
                try {
                    this.getRuntime().deleteConnectorConnectionPool(ccp.getName(), cascade);
                    continue;
                }
                catch (ConnectorRuntimeException cre) {
                    errrorOccured = true;
                }
            }
            for (i = 0; resources[2] != null && i < resources[2].length; ++i) {
                try {
                    AdminObjectResource aor = (AdminObjectResource)resources[2][i];
                    this.getRuntime().deleteAdminObject(aor.getJndiName());
                    continue;
                }
                catch (ConnectorRuntimeException cre) {
                    errrorOccured = true;
                }
            }
        } else if (resources[0] != null && resources[0].length != 0 || resources[1] != null && resources[1].length != 0 || resources[2] != null && resources[2].length != 0) {
            _logger.log(Level.SEVERE, "rardeployment.pools_and_resources_exist", moduleName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error: Connector Connection Pools/resources exist.");
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        if (!this.stopAndRemoveActiveResourceAdapter(moduleName)) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to remove Active Resource Adapter");
            _logger.log(Level.SEVERE, "rardeployment.ra_removal_registry_failure", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        if (!ResourcesUtil.createInstance().belongToEmbeddedRar(moduleName)) {
            ConnectorClassLoader.getInstance().removeResourceAdapter(moduleName);
        }
        if (errrorOccured) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to remove all connector resources/pools");
            _logger.log(Level.SEVERE, "rardeployment.ra_resource_removal", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public synchronized void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir) throws ConnectorRuntimeException {
        _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir);
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        if (activeResourceAdapter != null) {
            _logger.log(Level.FINE, "rardeployment.resourceadapter.already.started", moduleName);
            return;
        }
        ClassLoader loader = null;
        try {
            loader = connectorDescriptor.getClassLoader();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "No classloader available with connector descriptor");
            loader = null;
        }
        ModuleDescriptor moduleDescriptor = null;
        Application application = null;
        _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " loader :: " + loader);
        if (loader == null) {
            if (environment == 1) {
                ConnectorClassLoader.getInstance().addResourceAdapter(moduleName, moduleDir);
                loader = ConnectorClassLoader.getInstance();
                if (loader == null) {
                    ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to obtain the class loader");
                    _logger.log(Level.SEVERE, "rardeployment.failed_toget_classloader");
                    _logger.log(Level.SEVERE, "", cre);
                    throw cre;
                }
            }
        } else {
            connectorDescriptor.setClassLoader(null);
            moduleDescriptor = connectorDescriptor.getModuleDescriptor();
            application = connectorDescriptor.getApplication();
            connectorDescriptor.setModuleDescriptor(null);
            connectorDescriptor.setApplication(null);
        }
        try {
            activeResourceAdapter = ActiveRAFactory.createActiveResourceAdapter(connectorDescriptor, moduleName, loader);
            _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " ADDING to registry " + activeResourceAdapter);
            _registry.addActiveResourceAdapter(moduleName, activeResourceAdapter);
            _logger.fine("ResourceAdapterAdminServiceImpl:: createActiveRA " + moduleName + " at " + moduleDir + " env =server ? " + (environment == 1));
            if (environment == 1) {
                activeResourceAdapter.setup();
                String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
                _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " publishing descriptor " + descriptorJNDIName);
                this.updateRAConfigInDescriptor(connectorDescriptor, moduleName);
                Switch.getSwitch().getNamingManager().publishObject(descriptorJNDIName, (Object)connectorDescriptor, true);
                String securityWarningMessage = this.getRuntime().getSecurityPermissionSpec(moduleName);
                if (securityWarningMessage != null) {
                    _logger.log(Level.WARNING, securityWarningMessage);
                }
            }
        }
        catch (NullPointerException npEx) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
            cre.initCause(npEx);
            _logger.log(Level.SEVERE, "rardeployment.nullPointerException", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
            cre.initCause(ne);
            _logger.log(Level.SEVERE, "rardeployment.jndi_publish_failure");
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        finally {
            if (moduleDescriptor != null) {
                connectorDescriptor.setModuleDescriptor(moduleDescriptor);
                connectorDescriptor.setApplication(application);
                connectorDescriptor.setClassLoader(loader);
            }
        }
    }

    private void updateRAConfigInDescriptor(ConnectorDescriptor connectorDescriptor, String moduleName) {
        ResourceAdapterConfig raConfig = ConnectorRegistry.getInstance().getResourceAdapterConfig(moduleName);
        ElementProperty[] raConfigProps = null;
        if (raConfig != null) {
            raConfigProps = raConfig.getElementProperty();
        }
        _logger.fine("current RAConfig In Descriptor " + connectorDescriptor.getConfigProperties());
        if (raConfigProps != null) {
            Set mergedProps = ConnectorDDTransformUtils.mergeProps(raConfigProps, connectorDescriptor.getConfigProperties());
            Set actualProps = connectorDescriptor.getConfigProperties();
            actualProps.clear();
            actualProps.addAll(mergedProps);
            _logger.fine("updated RAConfig In Descriptor " + connectorDescriptor.getConfigProperties());
        }
    }

    public synchronized void createActiveResourceAdapter(String moduleDir, String moduleName) throws ConnectorRuntimeException {
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        if (activeResourceAdapter != null) {
            _logger.log(Level.FINE, "rardeployment.resourceadapter.already.started", moduleName);
            return;
        }
        if (ResourcesUtil.createInstance().belongToSystemRar(moduleName)) {
            moduleDir = Switch.getSwitch().getResourceInstaller().getSystemModuleLocation(moduleName);
        }
        ConnectorDescriptor connectorDescriptor = null;
        connectorDescriptor = ConnectorDDTransformUtils.getConnectorDescriptor(moduleDir);
        if (connectorDescriptor == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to obtain the connectorDescriptor");
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        this.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir);
    }

    public void reCreateActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        String moduleDir = null;
        if (this.isRarDeployed(moduleName)) {
            this.getRuntime().killAllPools(moduleName);
            this.stopAndRemoveActiveResourceAdapter(moduleName);
            moduleDir = ResourcesUtil.createInstance().getLocation(moduleName);
            this.createActiveResourceAdapter(moduleDir, moduleName);
        } else {
            moduleDir = ResourcesUtil.createInstance().getLocation(moduleName);
            if (moduleDir != null) {
                this.createActiveResourceAdapter(moduleDir, moduleName);
            }
        }
    }

    public boolean stopAndRemoveActiveResourceAdapter(String moduleName) {
        ActiveResourceAdapter acr = null;
        if (moduleName != null) {
            acr = _registry.getActiveResourceAdapter(moduleName);
        }
        if (acr != null) {
            acr.destroy();
            boolean ret = _registry.removeActiveResourceAdapter(moduleName);
            return ret;
        }
        return false;
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) throws ConnectorRuntimeException {
        if (rarName != null && raConfig != null) {
            _registry.addResourceAdapterConfig(rarName, raConfig);
            this.reCreateActiveResourceAdapter(rarName);
        }
    }

    public void deleteResourceAdapterConfig(String rarName) {
        if (rarName != null) {
            _registry.removeResourceAdapterConfig(rarName);
        }
    }

    public static boolean isJmsRa() {
        return true;
    }

    public JmsRaMapping getJmsRaMapping() {
        return this.ramap;
    }

    public boolean isRarDeployed(String moduleName) {
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        return activeResourceAdapter != null;
    }

    public void stopAllActiveResourceAdapters() {
        try {
            this.resource_adapter_shutdown_timeout = ResourcesUtil.createInstance().getShutdownTimeout();
        }
        catch (ConnectorRuntimeException e) {
            _logger.log(Level.WARNING, "error_reading_connectorservice_elt", e);
            this.resource_adapter_shutdown_timeout = 30;
        }
        ActiveResourceAdapter[] resourceAdapters = ConnectorRegistry.getInstance().getAllActiveResourceAdapters();
        ArrayList<ActiveResourceAdapter> resourceAdaptersToStop = new ArrayList<ActiveResourceAdapter>();
        for (int i = 0; i < resourceAdapters.length; ++i) {
            if (resourceAdapters[i] instanceof ActiveInboundResourceAdapter) {
                _logger.log(Level.FINE, "Connector 1.5 spec compliant RA", resourceAdapters[i].getModuleName());
                this.raShutdownStatusTable.put(resourceAdapters[i].getModuleName(), new Boolean(false));
                resourceAdaptersToStop.add(resourceAdapters[i]);
                continue;
            }
            _logger.log(Level.FINE, "Connector 1.0 spec compliant RA", resourceAdapters[i].getModuleName());
        }
        ActiveResourceAdapter[] raToStop = resourceAdaptersToStop.toArray(new ActiveResourceAdapter[0]);
        this.sendStopToAllResourceAdapters(raToStop);
    }

    private void sendStopToAllResourceAdapters(ActiveResourceAdapter[] resourceAdaptersToStop) {
        int i;
        int numberOfResourceAdaptersToStop = 0;
        numberOfResourceAdaptersToStop = resourceAdaptersToStop.length;
        Thread[] raShutDownThreads = new Thread[numberOfResourceAdaptersToStop];
        Thread[] joinerThreads = new Thread[numberOfResourceAdaptersToStop];
        for (i = 0; i < numberOfResourceAdaptersToStop; ++i) {
            _logger.log(Level.FINE, "Starting RA shutdown thread for " + ((ActiveInboundResourceAdapter)resourceAdaptersToStop[i]).getModuleName());
            RAShutdownThread rast = new RAShutdownThread((ActiveInboundResourceAdapter)resourceAdaptersToStop[i]);
            raShutDownThreads[i] = rast;
            rast.start();
            _logger.log(Level.FINE, "Starting Thread to join time-out shutdown of " + ((ActiveInboundResourceAdapter)resourceAdaptersToStop[i]).getModuleName());
            JoinerThread joiner = new JoinerThread(raShutDownThreads[i]);
            joinerThreads[i] = joiner;
            joiner.start();
        }
        for (i = 0; i < joinerThreads.length; ++i) {
            try {
                _logger.log(Level.FINE, "Joining joiner thread of " + resourceAdaptersToStop[i].getModuleName());
                joinerThreads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        _logger.log(Level.FINE, "stop() Complete for all active 1.5 compliant RARs");
        if (resourceAdaptersToStop.length != 0) {
            _logger.log(Level.FINE, "resource_adapter_stop_status");
        }
        for (String raName : this.raShutdownStatusTable.keySet()) {
            if (((Boolean)this.raShutdownStatusTable.get(raName)).booleanValue()) {
                _logger.log(Level.INFO, "ra.stop-successful", raName);
                continue;
            }
            _logger.log(Level.WARNING, "ra.stop-unsuccessful", raName);
        }
    }

    private class JoinerThread
    extends Thread {
        private Thread threadToJoin;

        public JoinerThread(Thread threadToJoin) {
            this.threadToJoin = threadToJoin;
        }

        public void run() {
            try {
                this.threadToJoin.join(ResourceAdapterAdminServiceImpl.this.resource_adapter_shutdown_timeout * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class RAShutdownThread
    extends Thread {
        private ActiveInboundResourceAdapter ra;

        public RAShutdownThread(ActiveInboundResourceAdapter ratoBeShutDown) {
            this.ra = ratoBeShutDown;
            this.setDaemon(true);
        }

        public void run() {
            ConnectorServiceImpl._logger.log(Level.FINE, "Calling" + this.ra.getModuleName() + " shutdown ");
            this.ra.destroy();
            ResourceAdapterAdminServiceImpl.this.raShutdownStatusTable.put(this.ra.getModuleName(), new Boolean(true));
        }
    }
}

