/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.AppclientContentOrigin;
import com.sun.enterprise.appclient.jws.ApplicationContentOrigin;
import com.sun.enterprise.appclient.jws.AppserverContentOrigin;
import com.sun.enterprise.appclient.jws.NestedAppclientContentOrigin;
import com.sun.enterprise.appclient.jws.UserContentOrigin;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.runtime.JavaWebStartAccessDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.ApplicationEnvironment;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class NamingConventions {
    public static final String SYSTEM_WEBAPP_URL = "/__JWSappclients";
    public static final String APPCLIENT_CATEGORY = "__appclient";
    public static final String APPLICATION_CATEGORY = "__application";
    public static final String APPSERVER_CATEGORY = "__appserver";
    public static final String APPSERVER_SIGNED_CATEGORY = "__appserverS";
    public static final String APPSERVER_LIB_FILES = "aslib";
    public static final String APPSERVER_MQLIB_FILES = "mqlib";
    public static final String APPSERVER_JMSRALIB_FILES = "jmsralib";
    public static final String APPSERVER_EXTJAR_FILES = "extjar";
    public static final String APPSERVER_DERBY_FILES = "derby";
    public static final String APPCLIENT_MAIN_JNLP_TEMPLATE_NAME = "appclientMainDocumentTemplate.jnlp";
    public static final String APPCLIENT_CLIENT_JNLP_TEMPLATE_NAME = "appclientClientDocumentTemplate.jnlp";
    public static final String APPCLIENT_MAIN_HTML_TEMPLATE_NAME = "appclientMainDocumentTemplate.html";
    public static final String APPCLIENT_CLIENT_HTML_TEMPLATE_NAME = "appclientClientDocumentTemplate.html";
    public static final String APPCLIENT_MAIN_JNLP_EXT_TEMPLATE_NAME = "appclientMainExtDocumentTemplate.jnlp";
    private static final String MAIN_JNLP_SUFFIX = ".jnlp";
    private static final String MAIN_HTML_SUFFIX = "-jnlp.html";
    private static final String CLIENT_JNLP_SUFFIX = "-client.jnlp";
    private static final String CLIENT_HTML_SUFFIX = "-client-jnlp.html";
    private static final String MAIN_EXT_JNLP_SUFFIX = "-ext.jnlp";
    public static final String JWS_LOGGER = "javax.enterprise.system.tools.deployment";
    private AppsManager appsManager = null;
    private AppclientModulesManager appclientModulesManager = null;

    public static String pathToContentKey(String requestPath) {
        return requestPath;
    }

    public static String contentKeyToPath(String contentKey) {
        return contentKey;
    }

    public NamingConventions() throws ConfigException {
        ServerContext appServerContext = ApplicationServer.getServerContext();
        if (appServerContext == null) {
            throw new ConfigException("Error getting current app server context; ApplicationServer.getServerContext() returned null");
        }
        InstanceEnvironment instEnv = appServerContext.getInstanceEnvironment();
        if (instEnv == null) {
            throw new ConfigException("Error getting current instance environment; appServercontext.getInstanceEnvironment() returned null");
        }
        this.appsManager = new AppsManager(instEnv, false);
        this.appclientModulesManager = new AppclientModulesManager(instEnv, false);
    }

    public NamingConventions(AppsManager appsManager, AppclientModulesManager appclientModulesManager) {
        this.appsManager = appsManager;
        this.appclientModulesManager = appclientModulesManager;
    }

    public static String webAppURI() {
        return SYSTEM_WEBAPP_URL;
    }

    public static String appServerCodebasePath() {
        return "/__JWSappclients/__appserver";
    }

    public static String fullJarPath(String contentKey) {
        return SYSTEM_WEBAPP_URL + NamingConventions.contentKeyToPath(contentKey);
    }

    public static String relativeFilePath(URI instanceRootDirURI, File targetFile) {
        URI targetURI = targetFile.toURI();
        URI relativeURI = instanceRootDirURI.relativize(targetURI);
        return relativeURI.toString();
    }

    public static String extJarFilePath(int extDirNumber, File extJarFile) {
        String path = "/" + extDirNumber + "/" + extJarFile.getName();
        return path;
    }

    private static String getExplicitContextRoot(ModuleDescriptor moduleDescr) {
        ApplicationClientDescriptor acd;
        JavaWebStartAccessDescriptor jwsAD;
        String result = null;
        BundleDescriptor bd = moduleDescr.getDescriptor();
        if (bd instanceof ApplicationClientDescriptor && (jwsAD = (acd = (ApplicationClientDescriptor)bd).getJavaWebStartAccessDescriptor()) != null) {
            result = jwsAD.getContextRoot();
        }
        return result;
    }

    private static String chooseContextRoot(String explicitValue, String defaultValue) {
        return explicitValue == null ? defaultValue : explicitValue;
    }

    public static String appclientCodebasePath(AppclientContentOrigin origin) {
        String result = "/__JWSappclients/__appclient" + origin.getContextRoot();
        return result;
    }

    private static String appclientJarFilename(String regName) {
        return regName + "Client.jar";
    }

    private static String trimJarFileType(String jarURI, String replacement) {
        int startOfType = jarURI.lastIndexOf(".jar");
        if (startOfType == -1) {
            startOfType = jarURI.length();
        }
        String result = jarURI.substring(0, startOfType) + replacement;
        return result;
    }

    public String getLaunchURLPath(String appclientModuleID) {
        String result = null;
        try {
            Application app = this.appclientModulesManager.getDescriptor(appclientModuleID, Thread.currentThread().getContextClassLoader(), false);
            ModuleDescriptor[] moduleDescrs = NamingConventions.getEligibleAppclientModuleDescriptors(app);
            if (moduleDescrs.length == 1) {
                result = TopLevelAppclient.virtualContextRoot(app, moduleDescrs[0]);
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return result;
    }

    public String getLaunchURLPath(String appModuleID, String appclientArchiveURI) {
        String result = null;
        try {
            ModuleDescriptor[] moduleDescrs;
            Application app = this.appsManager.getDescriptor(appModuleID, Thread.currentThread().getContextClassLoader(), false);
            for (ModuleDescriptor m : moduleDescrs = NamingConventions.getEligibleAppclientModuleDescriptors(app)) {
                String archiveURI = m.getArchiveUri();
                if (archiveURI == null || !archiveURI.equals(appclientArchiveURI)) continue;
                result = NestedAppclient.virtualContextRoot(app, m);
                break;
            }
        }
        catch (ConfigException ce) {
            // empty catch block
        }
        return result;
    }

    public static ModuleDescriptor[] getEligibleAppclientModuleDescriptors(Application app) {
        return NamingConventions.getEligibleAppclientModuleDescriptors(app, null);
    }

    public static ModuleDescriptor[] getEligibleAppclientModuleDescriptors(Application app, Logger logger) {
        Vector<ModuleDescriptor> mds = new Vector<ModuleDescriptor>();
        Iterator it = app.getModulesByType(ModuleType.CAR);
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof ModuleDescriptor) {
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)o;
                BundleDescriptor bd = moduleDescriptor.getDescriptor();
                if (bd instanceof ApplicationClientDescriptor) {
                    ApplicationClientDescriptor appclientDescriptor = (ApplicationClientDescriptor)bd;
                    JavaWebStartAccessDescriptor jwsAD = appclientDescriptor.getJavaWebStartAccessDescriptor();
                    if (jwsAD != null && !jwsAD.isEligible()) continue;
                    mds.add(moduleDescriptor);
                    continue;
                }
                if (logger == null) continue;
                logger.warning("During app/app client loading, expected bundleDescriptor for app client module to be of type ApplicationClientDescriptor but it is " + bd.getClass().getName() + "; ignoring it and continuing");
                continue;
            }
            if (logger == null) continue;
            logger.warning("During app/app client loading, expected descriptor of type ModuleDescriptor but found " + o.getClass().getName() + " instead; ignoring it and continuing");
        }
        return mds.toArray(new ModuleDescriptor[mds.size()]);
    }

    public static class Appserver {
        public static String contentKeyPrefix(AppserverContentOrigin origin) {
            return "/__appserver/" + origin.getSubcategory();
        }
    }

    public static class Client {
        private static final String name = "client";

        public static String JNLPFilename(String regName) {
            return "client-client.jnlp";
        }

        public static String JNLPPath(String regName) {
            return "/" + Client.JNLPFilename(regName);
        }

        public static String HTMLFilename(String regName) {
            return "client-client-jnlp.html";
        }

        public static String HTMLPath(String regName) {
            return "/" + Client.HTMLFilename(regName);
        }
    }

    public static class Main {
        private static final String name = "main";

        public static String JNLPFilename(String regName) {
            return "main.jnlp";
        }

        public static String JNLPPath(String regName) {
            return "/" + Main.JNLPFilename(regName);
        }

        public static String JNLPExtFilename(String regName) {
            return "main-ext.jnlp";
        }

        public static String JNLPExtPath(String regName) {
            return "/" + Main.JNLPExtFilename(regName);
        }

        public static String HTMLPath(String regName) {
            return "/" + Main.HTMLFilename(regName);
        }

        public static String HTMLFilename(String regName) {
            return "main-jnlp.html";
        }
    }

    public static class NestedAppclient {
        public static String virtualContextRoot(Application parentApplication, ModuleDescriptor moduleDescr) {
            return NamingConventions.chooseContextRoot(NamingConventions.getExplicitContextRoot(moduleDescr), NestedAppclient.defaultVirtualContextRoot(parentApplication, moduleDescr));
        }

        public static String actualContextRoot(NestedAppclientContentOrigin origin) {
            String regName = origin.getTopLevelRegistrationName();
            String clientName = origin.getName();
            return "/__appclient/" + regName + "/" + clientName + Main.JNLPPath(clientName);
        }

        public static String defaultVirtualContextRoot(Application parentApplication, ModuleDescriptor moduleDescr) {
            return "/" + parentApplication.getRegistrationName() + "/" + NamingConventions.trimJarFileType(moduleDescr.getArchiveUri(), "");
        }

        public static String contentKeyPrefix(NestedAppclientContentOrigin origin) {
            return "/__appclient/" + origin.getTopLevelRegistrationName() + "/" + origin.getName();
        }

        public static String archiveURIToName(String archiveURI) {
            return NamingConventions.trimJarFileType(archiveURI, "");
        }
    }

    public static class SignedJar {
        private static String SIGNED_JAR_FILENAME_SUFFIX = "-signed";

        public static File signedGeneratedAppclientJarFile(UserContentOrigin origin, InstanceEnvironment instEnv, File generatedAppclientFile) {
            String regName = origin.getTopLevelRegistrationName();
            ApplicationEnvironment appEnv = instEnv.getApplicationEnvironment(regName);
            File result = new File(appEnv.getJavaWebStartPath(), SignedJar.signedJarPath(generatedAppclientFile.getName()));
            return result;
        }

        public static String signedJarPath(String unsignedJarPath) {
            return unsignedJarPath;
        }

        private static File getAppJWSDir(InstanceEnvironment instEnv, String regName) {
            ApplicationEnvironment appEnv = instEnv.getApplicationEnvironment(regName);
            String appJWSDirPath = appEnv.getJavaWebStartPath();
            File appJWSDir = new File(appJWSDirPath);
            return appJWSDir;
        }
    }

    public static class TopLevelAppclient {
        public static String virtualContextRoot(Application application, ModuleDescriptor moduleDescr) {
            return NamingConventions.chooseContextRoot(NamingConventions.getExplicitContextRoot(moduleDescr), TopLevelAppclient.defaultVirtualContextRoot(application));
        }

        public static String actualContextRoot(Application application) {
            String regName = application.getRegistrationName();
            return "/__appclient/" + regName + Main.JNLPPath(regName);
        }

        public static String defaultVirtualContextRoot(Application application) {
            return "/" + application.getRegistrationName();
        }

        public static String contentKeyPrefix(AppclientContentOrigin origin) {
            return "/__appclient/" + origin.getTopLevelRegistrationName();
        }

        public static String appclientJarPath(AppclientContentOrigin origin) {
            return "/" + NamingConventions.appclientJarFilename(origin.getTopLevelRegistrationName());
        }
    }

    public static class TopLevelApplication {
        public static String contextRoot(Application application) {
            return "/" + application.getRegistrationName();
        }

        public static String contentKeyPrefix(ApplicationContentOrigin origin) {
            return "/__application/" + origin.getTopLevelRegistrationName();
        }

        public static String appclientJarPath(ApplicationContentOrigin origin) {
            return "/" + NamingConventions.appclientJarFilename(origin.getTopLevelRegistrationName());
        }
    }
}

